/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.somnia.compat;

import dev.su5ed.somnia.compat.Compat;
import dev.su5ed.somnia.compat.CuriosCompat;
import java.util.Arrays;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public final class DarkUtilsCompat {
    private static final ResourceLocation SLEEP_CHARM = ResourceLocation.fromNamespaceAndPath((String)"darkutils", (String)"charm_sleep");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasSleepCharm(Player player) {
        if (Compat.curiosLoaded) {
            if (CuriosCompat.hasCurio(player, SLEEP_CHARM)) return true;
        }
        if (Compat.darkUtilsLoaded) {
            if (Arrays.stream(EquipmentSlot.values()).map(arg_0 -> ((Player)player).getItemBySlot(arg_0)).anyMatch(DarkUtilsCompat::isSleepCharm)) return true;
        }
        if (!player.getInventory().items.stream().anyMatch(DarkUtilsCompat::isSleepCharm)) return false;
        return true;
    }

    private static boolean isSleepCharm(ItemStack stack) {
        return !stack.isEmpty() && BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).equals((Object)SLEEP_CHARM);
    }

    private DarkUtilsCompat() {
    }
}

