/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.somnia.gui;

import dev.su5ed.somnia.capability.CapabilityFatigue;
import dev.su5ed.somnia.capability.Fatigue;
import dev.su5ed.somnia.network.SomniaNetwork;
import dev.su5ed.somnia.network.server.ActivateBlockPacket;
import dev.su5ed.somnia.network.server.WakeTimeUpdatePacket;
import dev.su5ed.somnia.util.SomniaUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class WakeTimeButton
extends Button {
    private final Component hoverMessage;
    private final Component buttonMessage;

    public WakeTimeButton(int x, int y, int widthIn, int heightIn, Component message, int wakeTime) {
        super(x, y, widthIn, heightIn, message, button -> {
            HitResult mouseOver;
            Minecraft mc = Minecraft.getInstance();
            if (mc.level == null) {
                return;
            }
            long targetWakeTime = SomniaUtil.calculateWakeTime((Level)mc.level, wakeTime);
            SomniaNetwork.sendToServer(new WakeTimeUpdatePacket(targetWakeTime));
            Fatigue fatigue = (Fatigue)mc.player.getCapability(CapabilityFatigue.INSTANCE);
            if (fatigue != null) {
                fatigue.setWakeTime(targetWakeTime);
            }
            if ((mouseOver = mc.hitResult) instanceof BlockHitResult) {
                BlockHitResult blockHit = (BlockHitResult)mouseOver;
                Vec3 hitVec = mouseOver.getLocation();
                ActivateBlockPacket packet = new ActivateBlockPacket(blockHit.getBlockPos(), blockHit.getDirection(), (float)hitVec.x, (float)hitVec.y, (float)hitVec.z);
                SomniaNetwork.sendToServer(packet);
            }
            mc.setScreen(null);
        }, DEFAULT_NARRATION);
        this.buttonMessage = message;
        this.hoverMessage = Component.literal((String)SomniaUtil.timeStringForGameTime(wakeTime));
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        this.setMessage(this.isHovered ? this.hoverMessage : this.buttonMessage);
    }
}

