/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.somnia.gui;

import dev.su5ed.somnia.gui.CancelButton;
import dev.su5ed.somnia.gui.ResetSpawnButton;
import dev.su5ed.somnia.gui.WakeTimeButton;
import dev.su5ed.somnia.util.SomniaUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;

public class WakeTimeSelectScreen
extends Screen {
    public WakeTimeSelectScreen() {
        super((Component)Component.translatable((String)"somnia.gui.select_wake_time"));
    }

    public void init() {
        int buttonWidth = 100;
        int buttonHeight = 20;
        int buttonCenterX = this.width / 2 - 50;
        int buttonCenterY = this.height / 2 - 10;
        this.addRenderableWidget((GuiEventListener)new ResetSpawnButton(buttonCenterX, buttonCenterY - 22, buttonWidth, buttonHeight));
        this.addRenderableWidget((GuiEventListener)new CancelButton(buttonCenterX, buttonCenterY + 22, buttonWidth, buttonHeight));
        this.addWakeTimeButton(buttonCenterX, buttonCenterY + 88, buttonWidth, buttonHeight, "midnight", 18000);
        this.addWakeTimeButton(buttonCenterX - 80, buttonCenterY + 66, buttonWidth, buttonHeight, "after_midnight", 20000);
        this.addWakeTimeButton(buttonCenterX - 110, buttonCenterY + 44, buttonWidth, buttonHeight, "before_sunrise", 22000);
        this.addWakeTimeButton(buttonCenterX - 130, buttonCenterY + 22, buttonWidth, buttonHeight, "mid_sunrise", 23000);
        this.addWakeTimeButton(buttonCenterX - 140, buttonCenterY, buttonWidth, buttonHeight, "after_sunrise", 0);
        this.addWakeTimeButton(buttonCenterX - 130, buttonCenterY - 22, buttonWidth, buttonHeight, "early_morning", 1500);
        this.addWakeTimeButton(buttonCenterX - 110, buttonCenterY - 44, buttonWidth, buttonHeight, "mid_morning", 3000);
        this.addWakeTimeButton(buttonCenterX - 80, buttonCenterY - 66, buttonWidth, buttonHeight, "late_morning", 4500);
        this.addWakeTimeButton(buttonCenterX, buttonCenterY - 88, buttonWidth, buttonHeight, "noon", 6000);
        this.addWakeTimeButton(buttonCenterX + 80, buttonCenterY - 66, buttonWidth, buttonHeight, "early_afternoon", 7500);
        this.addWakeTimeButton(buttonCenterX + 110, buttonCenterY - 44, buttonWidth, buttonHeight, "mid_afternoon", 9000);
        this.addWakeTimeButton(buttonCenterX + 130, buttonCenterY - 22, buttonWidth, buttonHeight, "late_afternoon", 1050);
        this.addWakeTimeButton(buttonCenterX + 140, buttonCenterY, buttonWidth, buttonHeight, "before_sunset", 12000);
        this.addWakeTimeButton(buttonCenterX + 130, buttonCenterY + 22, buttonWidth, buttonHeight, "mid_sunset", 13000);
        this.addWakeTimeButton(buttonCenterX + 100, buttonCenterY + 44, buttonWidth, buttonHeight, "after_sunset", 14000);
        this.addWakeTimeButton(buttonCenterX + 88, buttonCenterY + 66, buttonWidth, buttonHeight, "before_midnight", 16000);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, (Component)Component.translatable((String)"somnia.gui.wts_title"), this.width / 2, this.height / 2 - 5, 0xFFFFFF);
        if (this.minecraft != null && this.minecraft.player != null) {
            String time = SomniaUtil.timeStringForGameTime(SomniaUtil.getLevelDayTime((Level)this.minecraft.level));
            guiGraphics.drawCenteredString(this.font, time, this.width / 2, this.height / 2 - 66, 0xFFFFFF);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void addWakeTimeButton(int x, int y, int width, int height, String translationKey, int wakeTime) {
        this.addRenderableWidget((GuiEventListener)new WakeTimeButton(x, y, width, height, (Component)Component.translatable((String)("somnia.gui.time_" + translationKey)), wakeTime));
    }
}

