/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.somnia.network.server;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record ActivateBlockPacket(BlockPos pos, Direction side, float hitX, float hitY, float hitZ) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ActivateBlockPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"somnia", (String)"activate_block"));
    public static final StreamCodec<FriendlyByteBuf, ActivateBlockPacket> STREAM_CODEC = StreamCodec.ofMember(ActivateBlockPacket::write, ActivateBlockPacket::read);

    public static ActivateBlockPacket read(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.readBlockPos();
        Direction side = (Direction)buffer.readEnum(Direction.class);
        float hitX = buffer.readFloat();
        float hitY = buffer.readFloat();
        float hitZ = buffer.readFloat();
        return new ActivateBlockPacket(pos, side, hitX, hitY, hitZ);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeEnum((Enum)this.side);
        buffer.writeFloat(this.hitX);
        buffer.writeFloat(this.hitY);
        buffer.writeFloat(this.hitZ);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        Player player = context.player();
        BlockState state = player.level().getBlockState(this.pos);
        BlockHitResult hitResult = new BlockHitResult(new Vec3((double)this.hitX, (double)this.hitY, (double)this.hitZ), this.side, this.pos, false);
        state.useWithoutItem(player.level(), player, hitResult);
    }
}

