/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.somnia.network.server;

import dev.su5ed.somnia.capability.CapabilityFatigue;
import dev.su5ed.somnia.capability.Fatigue;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record ResetSpawnPacket(boolean resetSpawn) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ResetSpawnPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"somnia", (String)"reset_spawn"));
    public static final StreamCodec<ByteBuf, ResetSpawnPacket> STREAM_CODEC = StreamCodec.ofMember(ResetSpawnPacket::write, ResetSpawnPacket::new);

    public ResetSpawnPacket(ByteBuf buffer) {
        this(buffer.readBoolean());
    }

    public void write(ByteBuf buffer) {
        buffer.writeBoolean(this.resetSpawn);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        Player player = context.player();
        Fatigue fatigue = (Fatigue)player.getCapability(CapabilityFatigue.INSTANCE);
        if (fatigue != null) {
            fatigue.setResetSpawn(this.resetSpawn);
        }
    }
}

