/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.somnia.network.server;

import dev.su5ed.somnia.capability.CapabilityFatigue;
import dev.su5ed.somnia.capability.Fatigue;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record WakeTimeUpdatePacket(long wakeTime) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<WakeTimeUpdatePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"somnia", (String)"wake_time_update"));
    public static final StreamCodec<ByteBuf, WakeTimeUpdatePacket> STREAM_CODEC = StreamCodec.ofMember(WakeTimeUpdatePacket::write, WakeTimeUpdatePacket::new);

    public WakeTimeUpdatePacket(ByteBuf buffer) {
        this(buffer.readLong());
    }

    public void write(ByteBuf buffer) {
        buffer.writeLong(this.wakeTime);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        Player player = context.player();
        Fatigue fatigue = (Fatigue)player.getCapability(CapabilityFatigue.INSTANCE);
        if (fatigue != null) {
            fatigue.setWakeTime(this.wakeTime);
        }
    }
}

