/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.somnia.util;

import dev.su5ed.somnia.SomniaConfig;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;

public record SideEffectStage(int minFatigue, int maxFatigue, ResourceLocation effect, int duration, int amplifier) {
    private static SideEffectStage[] stages;

    public static SideEffectStage[] getSideEffectStages() {
        if (stages == null) {
            List sideEffectStages = (List)SomniaConfig.COMMON.sideEffectStages.get();
            stages = new SideEffectStage[sideEffectStages.size()];
            for (int i = 0; i < stages.length; ++i) {
                SideEffectStage.stages[i] = SideEffectStage.parseStage((List)sideEffectStages.get(i));
            }
        }
        return stages;
    }

    public static String getSideEffectStageDescription(double fatigue) {
        int stage = SideEffectStage.getForFatigue(fatigue);
        float ratio = (float)((List)SomniaConfig.COMMON.sideEffectStages.get()).size() / 4.0f;
        int desc = Math.round((float)stage / ratio);
        return I18n.get((String)("somnia.side_effect." + desc), (Object[])new Object[0]);
    }

    private static int getForFatigue(double fatigue) {
        List sideEffectStages = (List)SomniaConfig.COMMON.sideEffectStages.get();
        for (int i = 0; i < sideEffectStages.size(); ++i) {
            SideEffectStage stage = SideEffectStage.getSideEffectStages()[i];
            if (!(fatigue >= (double)stage.minFatigue) || !(fatigue <= (double)stage.maxFatigue) || stage.duration < 0 && i != sideEffectStages.size() - 1) continue;
            return i + 1;
        }
        return 0;
    }

    private static SideEffectStage parseStage(List<Object> stage) {
        return new SideEffectStage((Integer)stage.get(0), (Integer)stage.get(1), ResourceLocation.parse((String)((String)stage.get(2))), (Integer)stage.get(3), (Integer)stage.get(4));
    }

    public Holder<MobEffect> getEffect() {
        return (Holder)BuiltInRegistries.MOB_EFFECT.getHolder(this.effect).orElseThrow();
    }
}

