/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.somnia.util;

import dev.su5ed.somnia.SomniaConfig;
import dev.su5ed.somnia.capability.CapabilityFatigue;
import dev.su5ed.somnia.capability.Fatigue;
import dev.su5ed.somnia.network.SomniaNetwork;
import dev.su5ed.somnia.network.client.ClientWakeTimeUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public final class SomniaUtil {
    public static boolean hasArmor(Player player) {
        return player.getInventory().armor.stream().anyMatch(stack -> !stack.isEmpty());
    }

    public static int getLevelDayTime(Level level) {
        return (int)(level.getDayTime() % 24000L);
    }

    public static long calculateWakeTime(Level level, int target) {
        return SomniaUtil.calculateWakeTime(level.getGameTime(), SomniaUtil.getLevelDayTime(level), target);
    }

    public static long calculateWakeTime(long gameTime, long dayTime, int target) {
        long wakeTime = gameTime - dayTime + (long)target;
        return dayTime > (long)target ? wakeTime + 24000L : wakeTime;
    }

    public static boolean checkFatigue(Player player) {
        Fatigue fatigue = (Fatigue)player.getCapability(CapabilityFatigue.INSTANCE);
        return fatigue != null && (player.isCreative() || (Boolean)SomniaConfig.COMMON.enableFatigue.get() == false || fatigue.getFatigue() >= (double)((Integer)SomniaConfig.COMMON.minimumFatigueToSleep.get()).intValue());
    }

    public static String timeStringForGameTime(long gameTime) {
        long time = (gameTime + 6000L) % 24000L;
        Object hours = String.valueOf(time / 1000L);
        Object minutes = String.valueOf((int)((double)(time % 1000L) / 1000.0 * 60.0));
        if (((String)hours).length() == 1) {
            hours = "0" + (String)hours;
        }
        if (((String)minutes).length() == 1) {
            minutes = "0" + (String)minutes;
        }
        return (String)hours + ":" + (String)minutes;
    }

    public static boolean isEnterSleepTime(Level level) {
        long time = SomniaUtil.getLevelDayTime(level);
        return time >= (long)((Integer)SomniaConfig.COMMON.enterSleepStart.get()).intValue() && time <= (long)((Integer)SomniaConfig.COMMON.enterSleepEnd.get()).intValue();
    }

    public static boolean isValidSleepTime(ServerLevel level) {
        long time = SomniaUtil.getLevelDayTime((Level)level);
        return time >= (long)((Integer)SomniaConfig.COMMON.validSleepStart.get()).intValue() && time <= (long)((Integer)SomniaConfig.COMMON.validSleepEnd.get()).intValue();
    }

    public static void updateWakeTime(ServerPlayer player) {
        Fatigue fatigue = (Fatigue)player.getCapability(CapabilityFatigue.INSTANCE);
        if (fatigue != null && fatigue.getWakeTime() < 0L) {
            long dayTime = SomniaUtil.getLevelDayTime(player.level());
            long wakeTime = SomniaUtil.calculateWakeTime(player.level().getGameTime(), dayTime, dayTime > 12000L ? 0 : 12000);
            fatigue.setWakeTime(wakeTime);
            SomniaNetwork.sendToClient(new ClientWakeTimeUpdatePacket(wakeTime), player);
        }
    }

    private SomniaUtil() {
    }
}

