/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.integrations.discord;

import com.gitlab.cdagaming.craftpresence.core.integrations.discord.DiscordUtils;
import com.gitlab.cdagaming.craftpresence.core.integrations.discord.FunctionsLib;
import com.gitlab.cdagaming.unilib.ModUtils;
import com.gitlab.cdagaming.unilib.utils.ComponentUtils;
import com.gitlab.cdagaming.unilib.utils.NbtUtils;
import craftpresence.external.org.meteordev.starscript.Starscript;
import craftpresence.external.org.meteordev.starscript.value.Value;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.List;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.nbt.Tag;

public class ModFunctionsLib {
    public static void init(DiscordUtils client) {
        client.syncFunction("mcTranslate", (ss, argCount) -> ModFunctionsLib.mcTranslate(client, ss, argCount));
        client.syncFunction("getNbt", (ss, argCount) -> ModFunctionsLib.getNbt(client, ss, argCount));
        client.syncFunction("getComponent", (ss, argCount) -> ModFunctionsLib.getComponent(client, ss, argCount));
    }

    public static Value mcTranslate(DiscordUtils client, Starscript ss, int argCount) {
        if (ModUtils.RAW_TRANSLATOR == null) {
            ss.error("No available translations from game data, try again later.", new Object[0]);
        }
        return FunctionsLib.parseWith(client, ModUtils.RAW_TRANSLATOR, ss, argCount);
    }

    public static Value getComponent(DiscordUtils client, Starscript ss, int argCount) {
        if (argCount < 1 || argCount > 2) {
            ss.error("getComponent() can only be used with 1-2 arguments, got %d.", argCount);
        }
        String path = null;
        if (argCount == 2) {
            path = ss.popString("Second argument to getComponent() needs to be a string.");
        }
        Object data = ss.popObject("First argument to getComponent() needs to be a valid DataComponent object.");
        Object result = !StringUtils.isNullOrEmpty((String)path) ? ComponentUtils.parseComponent((TypedDataComponent)ComponentUtils.getComponent((Object)data, (String)path)) : ComponentUtils.getComponentMap((Object)data);
        return result != null ? client.toValue(result, true) : Value.null_();
    }

    public static Value getNbt(DiscordUtils client, Starscript ss, int argCount) {
        List args = StringUtils.newArrayList();
        if (argCount < 1) {
            ss.error("getNbt() requires one or more arguments, got %d.", argCount);
        }
        for (int i = 0; i < argCount; ++i) {
            args.add(ss.pop());
        }
        StringUtils.revlist((List)args);
        Value source = (Value)args.getFirst();
        Object data = null;
        if (source.isObject()) {
            data = source.getObject();
        }
        if (data == null) {
            ss.error("First argument to getNbt() needs to be a valid Entity or DataComponent object.", new Object[0]);
        }
        args.removeFirst();
        List path = StringUtils.newArrayList();
        for (Value info : args) {
            path.add(info.toString());
        }
        Object result = NbtUtils.parseTag((Tag)NbtUtils.getNbt((Object)data, (String[])path.toArray(new String[0])));
        return result != null ? client.toValue(result, true) : Value.null_();
    }
}

