/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.integrations.discord;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.impl.discord.DiscordStatus;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.CommandsGui;
import com.gitlab.cdagaming.unilib.utils.GameUtils;
import com.gitlab.cdagaming.unilib.utils.gui.RenderUtils;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import com.google.gson.JsonObject;
import craftpresence.external.com.jagrosh.discordipc.IPCClient;
import craftpresence.external.com.jagrosh.discordipc.IPCListener;
import craftpresence.external.com.jagrosh.discordipc.entities.Packet;
import craftpresence.external.com.jagrosh.discordipc.entities.PartyPrivacy;
import craftpresence.external.com.jagrosh.discordipc.entities.User;
import net.minecraft.client.Minecraft;

public class ModIPCListener
implements IPCListener {
    @Override
    public void onActivityJoin(IPCClient client, String secret) {
        if (CraftPresence.CLIENT.STATUS != DiscordStatus.JoinGame) {
            CraftPresence.CLIENT.STATUS = DiscordStatus.JoinGame;
            CraftPresence.SERVER.verifyAndJoin(secret);
        }
    }

    @Override
    public void onActivitySpectate(IPCClient client, String secret) {
        if (CraftPresence.CLIENT.STATUS != DiscordStatus.SpectateGame) {
            CraftPresence.CLIENT.STATUS = DiscordStatus.SpectateGame;
        }
    }

    @Override
    public void onActivityJoinRequest(IPCClient client, String secret, User user) {
        if (!(CraftPresence.CLIENT.PRESENCE.partyPrivacy() == PartyPrivacy.Public || CraftPresence.CLIENT.STATUS == DiscordStatus.JoinRequest && CraftPresence.CLIENT.REQUESTER_USER.equals(user))) {
            CraftPresence.SCHEDULER.TIMER = 30;
            CraftPresence.CLIENT.STATUS = DiscordStatus.JoinRequest;
            CraftPresence.CLIENT.REQUESTER_USER = user;
            cf cf2 = GameUtils.getCurrentScreen((Minecraft)CraftPresence.instance);
            if (!(cf2 instanceof CommandsGui)) {
                RenderUtils.openScreen((Minecraft)CraftPresence.instance, (ExtendedScreen)new CommandsGui("request"), (cf)GameUtils.getCurrentScreen((Minecraft)CraftPresence.instance));
            } else {
                CommandsGui commandScreen = (CommandsGui)cf2;
                commandScreen.executeCommand("request");
            }
        }
    }

    @Override
    public void onClose(IPCClient client, JsonObject json) {
        if (CraftPresence.CLIENT.isAvailable()) {
            CraftPresence.CLIENT.STATUS = DiscordStatus.Closed;
        }
    }

    @Override
    public void onDisconnect(IPCClient client, Throwable t) {
        if (CraftPresence.CLIENT.STATUS != DiscordStatus.Disconnected) {
            Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.rpc", new Object[]{t.getMessage()}), new Object[0]);
            CraftPresence.CLIENT.shutDown(true);
        }
    }

    @Override
    public void onPacketReceived(IPCClient client, Packet packet) {
        try {
            JsonObject data;
            JsonObject parsedData = packet.getJson();
            if (parsedData.has("cmd") && parsedData.getAsJsonPrimitive("cmd").getAsString().equals("SET_ACTIVITY") && (data = parsedData.getAsJsonObject("data")).has("name")) {
                CraftPresence.CLIENT.CURRENT_TITLE = data.getAsJsonPrimitive("name").getAsString();
            }
        }
        catch (Throwable ex) {
            Constants.LOG.debugError(ex);
        }
    }

    @Override
    public void onPacketSent(IPCClient client, Packet packet) {
    }

    @Override
    public void onReady(IPCClient client) {
        if (CraftPresence.CLIENT.STATUS != DiscordStatus.Ready) {
            CraftPresence.CLIENT.STATUS = DiscordStatus.Ready;
            CraftPresence.CLIENT.CURRENT_USER = client.getCurrentUser();
            Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.load", new Object[]{CraftPresence.CLIENT.CLIENT_ID, CraftPresence.CLIENT.CURRENT_USER != null ? CraftPresence.CLIENT.CURRENT_USER.getEffectiveName() : "null"}), new Object[0]);
        }
    }
}

