/*
 * Decompiled with CFR 0.152.
 */
package craftpresence.external.net.lenni0451.reflect.stream.field;

import craftpresence.external.net.lenni0451.reflect.Fields;
import craftpresence.external.net.lenni0451.reflect.exceptions.FieldNotFoundException;
import craftpresence.external.net.lenni0451.reflect.stream.RStream;
import craftpresence.external.net.lenni0451.reflect.stream.field.FieldWrapper;
import java.lang.annotation.Annotation;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class FieldStream {
    private final RStream parent;
    private final List<FieldWrapper> fields;

    public FieldStream(RStream parent, boolean withSuper) {
        this.parent = parent;
        this.fields = new ArrayList<FieldWrapper>();
        Class<?> clazz = parent.clazz();
        do {
            for (Field field : Fields.getDeclaredFields(clazz)) {
                this.fields.add(new FieldWrapper(this, field));
            }
        } while (withSuper && (clazz = clazz.getSuperclass()) != null);
    }

    private FieldStream(RStream parent, List<FieldWrapper> fields) {
        this.parent = parent;
        this.fields = fields;
    }

    public RStream parent() {
        return this.parent;
    }

    public int size() {
        return this.fields.size();
    }

    public Optional<FieldWrapper> opt(String name) {
        for (FieldWrapper field : this.fields) {
            if (!field.name().equals(name)) continue;
            return Optional.of(field);
        }
        return Optional.empty();
    }

    public Optional<FieldWrapper> opt(int index) {
        if (index < 0 || index > this.fields.size()) {
            return Optional.empty();
        }
        return Optional.of(this.fields.get(index));
    }

    public FieldWrapper by(String name) {
        return this.opt(name).orElseThrow((Supplier<FieldNotFoundException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$by$0(java.lang.String ), ()Lcraftpresence/external/net/lenni0451/reflect/exceptions/FieldNotFoundException;)((FieldStream)this, (String)name));
    }

    public FieldWrapper by(int index) {
        return this.opt(index).orElseThrow((Supplier<FieldNotFoundException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$by$1(int ), ()Lcraftpresence/external/net/lenni0451/reflect/exceptions/FieldNotFoundException;)((FieldStream)this, (int)index));
    }

    public FieldStream filter(Predicate<FieldWrapper> filter) {
        this.fields.removeIf(filter.negate());
        return this;
    }

    public FieldStream filter(Collection<String> names) {
        return this.filter((Predicate<FieldWrapper>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$filter$2(java.util.Collection craftpresence.external.net.lenni0451.reflect.stream.field.FieldWrapper ), (Lcraftpresence/external/net/lenni0451/reflect/stream/field/FieldWrapper;)Z)(names));
    }

    public FieldStream filter(String ... names) {
        return this.filter(Arrays.asList(names));
    }

    public FieldStream filter(Class<?> clazz) {
        return this.filter((Predicate<FieldWrapper>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$filter$3(java.lang.Class craftpresence.external.net.lenni0451.reflect.stream.field.FieldWrapper ), (Lcraftpresence/external/net/lenni0451/reflect/stream/field/FieldWrapper;)Z)(clazz));
    }

    public FieldStream filter(boolean isStatic) {
        return this.filter((Predicate<FieldWrapper>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$filter$4(boolean craftpresence.external.net.lenni0451.reflect.stream.field.FieldWrapper ), (Lcraftpresence/external/net/lenni0451/reflect/stream/field/FieldWrapper;)Z)((boolean)isStatic));
    }

    public FieldStream filterAnnotation(Class<?> annotation) {
        return this.filter((Predicate<FieldWrapper>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$filterAnnotation$6(java.lang.Class craftpresence.external.net.lenni0451.reflect.stream.field.FieldWrapper ), (Lcraftpresence/external/net/lenni0451/reflect/stream/field/FieldWrapper;)Z)(annotation));
    }

    public Iterator<FieldWrapper> iterator() {
        return this.fields.iterator();
    }

    public <T> Stream<T> map(Function<FieldWrapper, T> mapFunction) {
        return this.jstream().map(mapFunction);
    }

    public Stream<FieldWrapper> jstream() {
        return this.fields.stream();
    }

    public FieldStream forEach(Consumer<FieldWrapper> consumer) {
        this.fields.forEach(consumer);
        return this;
    }

    public FieldStream copy() {
        return new FieldStream(this.parent, new ArrayList<FieldWrapper>(this.fields));
    }

    private static /* synthetic */ boolean lambda$filterAnnotation$6(Class annotation, FieldWrapper field) {
        return field.annotations().anyMatch((Predicate<Annotation>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$null$5(java.lang.Class java.lang.annotation.Annotation ), (Ljava/lang/annotation/Annotation;)Z)((Class)annotation));
    }

    private static /* synthetic */ boolean lambda$null$5(Class annotation, Annotation a) {
        return a.annotationType().equals(annotation);
    }

    private static /* synthetic */ boolean lambda$filter$4(boolean isStatic, FieldWrapper field) {
        return field.modifier().isStatic() == isStatic;
    }

    private static /* synthetic */ boolean lambda$filter$3(Class clazz, FieldWrapper field) {
        return field.type().equals(clazz);
    }

    private static /* synthetic */ boolean lambda$filter$2(Collection names, FieldWrapper f) {
        return names.contains(f.name());
    }

    private /* synthetic */ FieldNotFoundException lambda$by$1(int index) {
        return new FieldNotFoundException(this.parent.clazz().getName(), String.valueOf(index));
    }

    private /* synthetic */ FieldNotFoundException lambda$by$0(String name) {
        return new FieldNotFoundException(this.parent.clazz().getName(), name);
    }
}

