/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.config.gui;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.config.gui.PresenceEditorGui;
import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.Config;
import com.gitlab.cdagaming.craftpresence.core.config.category.Advanced;
import com.gitlab.cdagaming.craftpresence.core.config.element.PresenceData;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.DynamicScrollableList;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.ConfigurationGui;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicSelectorGui;
import com.gitlab.cdagaming.unilib.utils.gui.controls.CheckBoxControl;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedTextControl;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.DynamicWidget;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.ScrollableTextWidget;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.TextWidget;
import io.github.cdagaming.unicore.impl.Pair;
import io.github.cdagaming.unicore.utils.StringUtils;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;

public class AdvancedSettingsGui
extends ConfigurationGui<Advanced> {
    private final Advanced INSTANCE;
    private final Advanced DEFAULTS = this.getCurrentData().getDefaults();
    private ExtendedButtonControl guiMessagesButton;
    private ExtendedButtonControl itemMessagesButton;
    private ExtendedButtonControl entityTargetMessagesButton;
    private ExtendedButtonControl entityRidingMessagesButton;
    private CheckBoxControl enablePerGuiButton;
    private CheckBoxControl enablePerItemButton;
    private CheckBoxControl enablePerEntityButton;
    private CheckBoxControl formatWordsButton;
    private CheckBoxControl debugModeButton;
    private CheckBoxControl verboseModeButton;
    private CheckBoxControl allowPlaceholderPreviewsButton;
    private CheckBoxControl allowEndpointIconsButton;
    private CheckBoxControl allowDuplicatePacketsButton;
    private CheckBoxControl enableClassGraphButton;
    private ExtendedTextControl refreshRate;
    private ExtendedTextControl maxConnectionAttempts;
    private ExtendedTextControl playerSkinEndpoint;
    private ExtendedTextControl serverIconEndpoint;

    AdvancedSettingsGui() {
        super(Constants.TRANSLATOR.translate("gui.config.title", new Object[0]), Constants.TRANSLATOR.translate("gui.config.title.advanced", new Object[0]));
        this.INSTANCE = this.getCurrentData().copy();
    }

    @Override
    protected void appendControls() {
        super.appendControls();
        int calc1 = this.getScreenWidth() / 2 - 183;
        int calc2 = this.getScreenWidth() / 2 + 3;
        this.refreshRate = (ExtendedTextControl)this.childFrame.addControl((GuiEventListener)new TextWidget(this.getFontRenderer(), this.getButtonY(0), 180, 20, () -> {
            this.getInstanceData().refreshRate = (Integer)StringUtils.getValidInteger((String)this.refreshRate.getControlMessage()).getSecond();
        }, Constants.TRANSLATOR.translate("gui.config.name.advanced.refresh_rate", new Object[0]), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.advanced.refresh_rate", new Object[0])))));
        this.refreshRate.setControlMessage(Integer.toString(this.getInstanceData().refreshRate));
        this.maxConnectionAttempts = (ExtendedTextControl)this.childFrame.addControl((GuiEventListener)new TextWidget(this.getFontRenderer(), this.getButtonY(1), 180, 20, () -> {
            this.getInstanceData().maxConnectionAttempts = (Integer)StringUtils.getValidInteger((String)this.maxConnectionAttempts.getControlMessage()).getSecond();
        }, Constants.TRANSLATOR.translate("gui.config.name.advanced.max_connection_attempts", new Object[0]), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.advanced.max_connection_attempts", new Object[0])))));
        this.maxConnectionAttempts.setControlMessage(Integer.toString(this.getInstanceData().maxConnectionAttempts));
        this.guiMessagesButton = (ExtendedButtonControl)this.childFrame.addControl((GuiEventListener)new ExtendedButtonControl(calc1, this.getButtonY(2), 180, 20, Constants.TRANSLATOR.translate("gui.config.name.advanced.gui_messages", new Object[0]), () -> this.openScreen((ExtendedScreen)new DynamicSelectorGui(Constants.TRANSLATOR.translate("gui.config.title.selector.gui", new Object[0]), CraftPresence.GUIS.GUI_NAMES, null, null, true, true, DynamicScrollableList.RenderType.None, null, (currentValue, parentScreen) -> this.openScreen(new DynamicEditorGui((String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.defaultData = this.getInstanceData().guiSettings.guiData.get("default");
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = screenInstance.originalPrimaryMessage;
        }, (attributeName, screenInstance) -> {
            screenInstance.isDefaultValue = "default".equals(attributeName);
            screenInstance.defaultData = this.getInstanceData().guiSettings.guiData.get("default");
            screenInstance.currentData = this.getInstanceData().guiSettings.guiData.get(attributeName);
            screenInstance.isPreliminaryData = screenInstance.currentData == null;
            screenInstance.setScreenTitle(Constants.TRANSLATOR.translate("gui.config.title.gui.edit_specific_gui", new Object[]{attributeName}));
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = Config.getProperty(screenInstance.currentData, "textOverride") != null ? screenInstance.currentData.getTextOverride() : screenInstance.originalPrimaryMessage;
        }, screenInstance -> {
            String attributeName = screenInstance.getSecondaryEntry();
            String inputText = screenInstance.getPrimaryEntry();
            screenInstance.currentData.setTextOverride(inputText);
            this.getInstanceData().guiSettings.guiData.put(attributeName, screenInstance.currentData);
            if (!CraftPresence.GUIS.GUI_NAMES.contains(attributeName)) {
                CraftPresence.GUIS.GUI_NAMES.add(attributeName);
            }
        }, screenInstance -> {
            String attributeName = screenInstance.getSecondaryEntry();
            this.getInstanceData().guiSettings.guiData.remove(attributeName);
            if (!CraftPresence.GUIS.DEFAULT_NAMES.contains(attributeName)) {
                CraftPresence.GUIS.GUI_NAMES.remove(attributeName);
            }
        }, (attributeName, screenInstance) -> {
            if (screenInstance.isPresenceButton) {
                PresenceData defaultPresenceData = Config.getProperty(screenInstance.defaultData, "data") != null ? screenInstance.defaultData.getData() : new PresenceData();
                PresenceData currentPresenceData = Config.getProperty(screenInstance.currentData, "data") != null ? screenInstance.currentData.getData() : defaultPresenceData;
                screenInstance.openScreen(new PresenceEditorGui(currentPresenceData, defaultPresenceData, output -> screenInstance.currentData.setData((PresenceData)output)));
            } else {
                screenInstance.currentData.setIconOverride((String)attributeName);
            }
        }, (attributeName, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.advanced.gui_messages", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("screen.")})))), (Screen)parentScreen)).setIdentifierType(DynamicScrollableList.IdentifierType.Gui)), () -> {
            if (!this.guiMessagesButton.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.hover.access", new Object[]{Constants.TRANSLATOR.translate("gui.config.name.advanced.enable_per_gui", new Object[0])})));
            } else {
                this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.advanced.gui_messages", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("screen.")})));
            }
        }, new String[0]));
        this.itemMessagesButton = (ExtendedButtonControl)this.childFrame.addControl((GuiEventListener)new ExtendedButtonControl(calc2, this.getButtonY(2), 180, 20, Constants.TRANSLATOR.translate("gui.config.name.advanced.item_messages", new Object[0]), () -> this.openScreen((ExtendedScreen)new DynamicSelectorGui(Constants.TRANSLATOR.translate("gui.config.title.selector.item", new Object[0]), CraftPresence.TILE_ENTITIES.TILE_ENTITY_NAMES, null, null, true, true, DynamicScrollableList.RenderType.ItemData, null, (currentValue, parentScreen) -> this.openScreen(new DynamicEditorGui((String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.primaryMessage = screenInstance.originalPrimaryMessage = this.getInstanceData().itemMessages.getOrDefault("default", "");
        }, (attributeName, screenInstance) -> {
            screenInstance.isDefaultValue = "default".equals(attributeName);
            screenInstance.setScreenTitle(Constants.TRANSLATOR.translate("gui.config.title.item.edit_specific_item", new Object[]{attributeName}));
            screenInstance.originalPrimaryMessage = this.getInstanceData().itemMessages.getOrDefault("default", "");
            screenInstance.primaryMessage = this.getInstanceData().itemMessages.getOrDefault(attributeName, screenInstance.originalPrimaryMessage);
        }, screenInstance -> {
            String attributeName = screenInstance.getSecondaryEntry();
            String inputText = screenInstance.getPrimaryEntry();
            this.getInstanceData().itemMessages.put(attributeName, inputText);
            if (!CraftPresence.TILE_ENTITIES.ITEM_NAMES.contains(attributeName)) {
                CraftPresence.TILE_ENTITIES.ITEM_NAMES.add(attributeName);
            }
            if (!CraftPresence.TILE_ENTITIES.BLOCK_NAMES.contains(attributeName)) {
                CraftPresence.TILE_ENTITIES.BLOCK_NAMES.add(attributeName);
            }
            CraftPresence.TILE_ENTITIES.TILE_ENTITY_NAMES.remove(attributeName);
            CraftPresence.TILE_ENTITIES.verifyEntities();
        }, screenInstance -> {
            String attributeName = screenInstance.getSecondaryEntry();
            this.getInstanceData().itemMessages.remove(attributeName);
            CraftPresence.TILE_ENTITIES.ITEM_NAMES.remove(attributeName);
            CraftPresence.TILE_ENTITIES.BLOCK_NAMES.remove(attributeName);
            CraftPresence.TILE_ENTITIES.TILE_ENTITY_NAMES.remove(attributeName);
        }, null, (attributeName, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.advanced.item_messages", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("item.")})))), (Screen)parentScreen))), () -> {
            if (!this.itemMessagesButton.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.hover.access", new Object[]{Constants.TRANSLATOR.translate("gui.config.name.advanced.enable_per_item", new Object[0])})));
            } else {
                this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.advanced.item_messages", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("item.")})));
            }
        }, new String[0]));
        this.entityTargetMessagesButton = (ExtendedButtonControl)this.childFrame.addControl((GuiEventListener)new ExtendedButtonControl(calc1, this.getButtonY(3), 180, 20, Constants.TRANSLATOR.translate("gui.config.name.advanced.entity_target_messages", new Object[0]), () -> this.openScreen((ExtendedScreen)new DynamicSelectorGui(Constants.TRANSLATOR.translate("gui.config.title.selector.entity", new Object[0]), CraftPresence.ENTITIES.ENTITY_NAMES, null, null, true, true, DynamicScrollableList.RenderType.EntityData, null, (currentValue, parentScreen) -> this.openScreen(new DynamicEditorGui((String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.defaultData = this.getInstanceData().entitySettings.targetData.get("default");
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = screenInstance.originalPrimaryMessage;
        }, (attributeName, screenInstance) -> {
            screenInstance.isDefaultValue = "default".equals(attributeName);
            screenInstance.defaultData = this.getInstanceData().entitySettings.targetData.get("default");
            screenInstance.currentData = this.getInstanceData().entitySettings.targetData.get(attributeName);
            screenInstance.isPreliminaryData = screenInstance.currentData == null;
            screenInstance.setScreenTitle(Constants.TRANSLATOR.translate("gui.config.title.entity.edit_specific_entity", new Object[]{attributeName}));
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = Config.getProperty(screenInstance.currentData, "textOverride") != null ? screenInstance.currentData.getTextOverride() : screenInstance.originalPrimaryMessage;
        }, screenInstance -> {
            String attributeName = screenInstance.getSecondaryEntry();
            String inputText = screenInstance.getPrimaryEntry();
            screenInstance.currentData.setTextOverride(inputText);
            this.getInstanceData().entitySettings.targetData.put(attributeName, screenInstance.currentData);
            if (!CraftPresence.ENTITIES.ENTITY_NAMES.contains(attributeName)) {
                CraftPresence.ENTITIES.ENTITY_NAMES.add(attributeName);
            }
        }, screenInstance -> {
            String attributeName = screenInstance.getSecondaryEntry();
            this.getInstanceData().entitySettings.targetData.remove(attributeName);
            if (!CraftPresence.ENTITIES.DEFAULT_NAMES.contains(attributeName)) {
                CraftPresence.ENTITIES.ENTITY_NAMES.remove(attributeName);
            }
        }, (attributeName, screenInstance) -> {
            if (screenInstance.isPresenceButton) {
                PresenceData defaultPresenceData = Config.getProperty(screenInstance.defaultData, "data") != null ? screenInstance.defaultData.getData() : new PresenceData();
                PresenceData currentPresenceData = Config.getProperty(screenInstance.currentData, "data") != null ? screenInstance.currentData.getData() : defaultPresenceData;
                screenInstance.openScreen(new PresenceEditorGui(currentPresenceData, defaultPresenceData, output -> screenInstance.currentData.setData((PresenceData)output)));
            } else {
                screenInstance.currentData.setIconOverride((String)attributeName);
            }
        }, (attributeName, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.advanced.entity_target_messages", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("entity.target.")})))), (Screen)parentScreen))), () -> {
            if (!this.entityTargetMessagesButton.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.hover.access", new Object[]{Constants.TRANSLATOR.translate("gui.config.name.advanced.enable_per_entity", new Object[0])})));
            } else {
                this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.advanced.entity_target_messages", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("entity.target.")})));
            }
        }, new String[0]));
        this.entityRidingMessagesButton = (ExtendedButtonControl)this.childFrame.addControl((GuiEventListener)new ExtendedButtonControl(calc2, this.getButtonY(3), 180, 20, Constants.TRANSLATOR.translate("gui.config.name.advanced.entity_riding_messages", new Object[0]), () -> this.openScreen((ExtendedScreen)new DynamicSelectorGui(Constants.TRANSLATOR.translate("gui.config.title.selector.entity", new Object[0]), CraftPresence.ENTITIES.ENTITY_NAMES, null, null, true, true, DynamicScrollableList.RenderType.EntityData, null, (currentValue, parentScreen) -> this.openScreen(new DynamicEditorGui((String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.defaultData = this.getInstanceData().entitySettings.ridingData.get("default");
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = screenInstance.originalPrimaryMessage;
        }, (attributeName, screenInstance) -> {
            screenInstance.isDefaultValue = "default".equals(attributeName);
            screenInstance.defaultData = this.getInstanceData().entitySettings.ridingData.get("default");
            screenInstance.currentData = this.getInstanceData().entitySettings.ridingData.get(attributeName);
            screenInstance.isPreliminaryData = screenInstance.currentData == null;
            screenInstance.setScreenTitle(Constants.TRANSLATOR.translate("gui.config.title.entity.edit_specific_entity", new Object[]{attributeName}));
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = Config.getProperty(screenInstance.currentData, "textOverride") != null ? screenInstance.currentData.getTextOverride() : screenInstance.originalPrimaryMessage;
        }, screenInstance -> {
            String attributeName = screenInstance.getSecondaryEntry();
            String inputText = screenInstance.getPrimaryEntry();
            screenInstance.currentData.setTextOverride(inputText);
            this.getInstanceData().entitySettings.ridingData.put(attributeName, screenInstance.currentData);
            if (!CraftPresence.ENTITIES.ENTITY_NAMES.contains(attributeName)) {
                CraftPresence.ENTITIES.ENTITY_NAMES.add(attributeName);
            }
        }, screenInstance -> {
            String attributeName = screenInstance.getSecondaryEntry();
            this.getInstanceData().entitySettings.ridingData.remove(attributeName);
            if (!CraftPresence.ENTITIES.DEFAULT_NAMES.contains(attributeName)) {
                CraftPresence.ENTITIES.ENTITY_NAMES.remove(attributeName);
            }
        }, (attributeName, screenInstance) -> {
            if (screenInstance.isPresenceButton) {
                PresenceData defaultPresenceData = Config.getProperty(screenInstance.defaultData, "data") != null ? screenInstance.defaultData.getData() : new PresenceData();
                PresenceData currentPresenceData = Config.getProperty(screenInstance.currentData, "data") != null ? screenInstance.currentData.getData() : defaultPresenceData;
                screenInstance.openScreen(new PresenceEditorGui(currentPresenceData, defaultPresenceData, output -> screenInstance.currentData.setData((PresenceData)output)));
            } else {
                screenInstance.currentData.setIconOverride((String)attributeName);
            }
        }, (attributeName, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.advanced.entity_riding_messages", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("entity.riding.")})))), (Screen)parentScreen))), () -> {
            if (!this.entityRidingMessagesButton.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.hover.access", new Object[]{Constants.TRANSLATOR.translate("gui.config.name.advanced.enable_per_entity", new Object[0])})));
            } else {
                this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.advanced.entity_riding_messages", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("entity.riding.")})));
            }
        }, new String[0]));
        this.enablePerGuiButton = (CheckBoxControl)this.childFrame.addControl((GuiEventListener)new CheckBoxControl(calc1, this.getButtonY(4), Constants.TRANSLATOR.translate("gui.config.name.advanced.enable_per_gui", new Object[0]), this.getInstanceData().enablePerGui, () -> {
            this.getInstanceData().enablePerGui = this.enablePerGuiButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.advanced.enable_per_gui", new Object[0])))));
        this.enablePerItemButton = (CheckBoxControl)this.childFrame.addControl((GuiEventListener)new CheckBoxControl(calc2, this.getButtonY(4), Constants.TRANSLATOR.translate("gui.config.name.advanced.enable_per_item", new Object[0]), this.getInstanceData().enablePerItem, () -> {
            this.getInstanceData().enablePerItem = this.enablePerItemButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.advanced.enable_per_item", new Object[0])))));
        this.enablePerEntityButton = (CheckBoxControl)this.childFrame.addControl((GuiEventListener)new CheckBoxControl(calc1, this.getButtonY(5, -10), Constants.TRANSLATOR.translate("gui.config.name.advanced.enable_per_entity", new Object[0]), this.getInstanceData().enablePerEntity, () -> {
            this.getInstanceData().enablePerEntity = this.enablePerEntityButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.advanced.enable_per_entity", new Object[0])))));
        this.debugModeButton = (CheckBoxControl)this.childFrame.addControl((GuiEventListener)new CheckBoxControl(calc2, this.getButtonY(5, -10), Constants.TRANSLATOR.translate("gui.config.name.advanced.debug_mode", new Object[0]), this.getInstanceData().debugMode, () -> {
            this.getInstanceData().debugMode = this.debugModeButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.advanced.debug_mode", new Object[0])))));
        this.formatWordsButton = (CheckBoxControl)this.childFrame.addControl((GuiEventListener)new CheckBoxControl(calc1, this.getButtonY(6, -20), Constants.TRANSLATOR.translate("gui.config.name.advanced.format_words", new Object[0]), this.getInstanceData().formatWords, () -> {
            this.getInstanceData().formatWords = this.formatWordsButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.advanced.format_words", new Object[0])))));
        this.verboseModeButton = (CheckBoxControl)this.childFrame.addControl((GuiEventListener)new CheckBoxControl(calc2, this.getButtonY(6, -20), Constants.TRANSLATOR.translate("gui.config.name.advanced.verbose_mode", new Object[0]), this.getInstanceData().verboseMode, () -> {
            this.getInstanceData().verboseMode = this.verboseModeButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.advanced.verbose_mode", new Object[0])))));
        this.allowPlaceholderPreviewsButton = (CheckBoxControl)this.childFrame.addControl((GuiEventListener)new CheckBoxControl(calc1, this.getButtonY(7, -30), Constants.TRANSLATOR.translate("gui.config.name.advanced.allow_placeholder_previews", new Object[0]), this.getInstanceData().allowPlaceholderPreviews, () -> {
            this.getInstanceData().allowPlaceholderPreviews = this.allowPlaceholderPreviewsButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.advanced.allow_placeholder_previews", new Object[0])))));
        this.allowEndpointIconsButton = (CheckBoxControl)this.childFrame.addControl((GuiEventListener)new CheckBoxControl(calc2, this.getButtonY(7, -30), Constants.TRANSLATOR.translate("gui.config.name.advanced.allow_endpoint_icons", new Object[0]), this.getInstanceData().allowEndpointIcons, () -> {
            this.getInstanceData().allowEndpointIcons = this.allowEndpointIconsButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.advanced.allow_endpoint_icons", new Object[0])))));
        this.allowDuplicatePacketsButton = (CheckBoxControl)this.childFrame.addControl((GuiEventListener)new CheckBoxControl(calc1, this.getButtonY(8, -40), Constants.TRANSLATOR.translate("gui.config.name.advanced.allow_duplicate_packets", new Object[0]), this.getInstanceData().allowDuplicatePackets, () -> {
            this.getInstanceData().allowDuplicatePackets = this.allowDuplicatePacketsButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.advanced.allow_duplicate_packets", new Object[0])))));
        this.enableClassGraphButton = (CheckBoxControl)this.childFrame.addControl((GuiEventListener)new CheckBoxControl(calc2, this.getButtonY(8, -40), Constants.TRANSLATOR.translate("gui.config.name.advanced.enable_class_graph", new Object[0]), this.getInstanceData().enableClassGraph, () -> {
            this.getInstanceData().enableClassGraph = this.enableClassGraphButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.advanced.enable_class_graph", new Object[0])))));
        this.proceedButton.setOnHover(() -> {
            if (!this.proceedButton.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.hover.empty.default", new Object[0])));
            }
        });
        this.childFrame.addWidget((DynamicWidget)new ScrollableTextWidget(calc1, this.getButtonY(7), this.childFrame.getScreenWidth() - calc1, Constants.TRANSLATOR.translate("gui.config.message.endpoints", new Object[0])));
        this.playerSkinEndpoint = (ExtendedTextControl)this.childFrame.addControl((GuiEventListener)new TextWidget(this.getFontRenderer(), this.getButtonY(8), 180, 20, () -> {
            this.getInstanceData().playerSkinEndpoint = this.playerSkinEndpoint.getControlMessage();
        }, Constants.TRANSLATOR.translate("gui.config.name.advanced.player_skin_endpoint", new Object[0]), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.advanced.player_skin_endpoint", new Object[0])))));
        this.playerSkinEndpoint.setControlMessage(this.getInstanceData().playerSkinEndpoint);
        this.serverIconEndpoint = (ExtendedTextControl)this.childFrame.addControl((GuiEventListener)new TextWidget(this.getFontRenderer(), this.getButtonY(9), 180, 20, () -> {
            this.getInstanceData().serverIconEndpoint = this.serverIconEndpoint.getControlMessage();
        }, Constants.TRANSLATOR.translate("gui.config.name.advanced.server_icon_endpoint", new Object[0]), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.advanced.server_icon_endpoint", new Object[0])))));
        this.serverIconEndpoint.setControlMessage(this.getInstanceData().serverIconEndpoint);
    }

    @Override
    protected boolean allowedToReset() {
        return true;
    }

    @Override
    protected void syncRenderStates() {
        super.syncRenderStates();
        Pair refreshRateData = StringUtils.getValidInteger((String)this.refreshRate.getControlMessage());
        this.proceedButton.setControlEnabled((Boolean)refreshRateData.getFirst() != false && (Integer)refreshRateData.getSecond() >= 2);
        this.guiMessagesButton.setControlEnabled(CraftPresence.GUIS.isEnabled());
        this.itemMessagesButton.setControlEnabled(CraftPresence.TILE_ENTITIES.isEnabled());
        this.entityTargetMessagesButton.setControlEnabled(CraftPresence.ENTITIES.isEnabled());
        this.entityRidingMessagesButton.setControlEnabled(CraftPresence.ENTITIES.isEnabled());
    }

    @Override
    protected Advanced getInstanceData() {
        return this.INSTANCE;
    }

    @Override
    protected Advanced getCurrentData() {
        return CraftPresence.CONFIG.advancedSettings;
    }

    @Override
    protected Advanced getDefaultData() {
        return this.DEFAULTS;
    }
}

