/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.server;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.Config;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.impl.ExtendedModule;
import com.gitlab.cdagaming.craftpresence.core.impl.discord.DiscordStatus;
import com.gitlab.cdagaming.unilib.ModUtils;
import com.gitlab.cdagaming.unilib.core.integrations.logging.ApacheLogger;
import com.gitlab.cdagaming.unilib.utils.GameUtils;
import com.gitlab.cdagaming.unilib.utils.WorldUtils;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.realmsclient.RealmsMainScreen;
import com.mojang.realmsclient.dto.RealmsServer;
import io.github.cdagaming.unicore.impl.Pair;
import io.github.cdagaming.unicore.utils.MathUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import io.github.cdagaming.unicore.utils.TimeUtils;
import java.net.UnknownHostException;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.multiplayer.ServerStatusPinger;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.world.entity.Entity;

public class ServerUtils
implements ExtendedModule {
    private static final ThreadPoolExecutor PING_EXECUTOR = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("Server Pinger #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(((ApacheLogger)Constants.LOG).getLogInstance())).build());
    private static final List<String> invalidMotds = StringUtils.newArrayList((Object[])new String[]{"multiplayer.status.cannot_connect", "multiplayer.status.cannot_resolve", "multiplayer.status.polling", "multiplayer.status.pinging"});
    private static final List<String> invalidNames = StringUtils.newArrayList((Object[])new String[]{"selectServer.defaultName"});
    private final ServerStatusPinger pinger = new ServerStatusPinger();
    public List<PlayerInfo> currentPlayerList = StringUtils.newArrayList();
    public List<String> knownAddresses = StringUtils.newArrayList();
    public List<String> defaultAddresses = StringUtils.newArrayList();
    public Map<String, ServerData> knownServerData = StringUtils.newHashMap();
    private ScheduledExecutorService PING_SCHEDULER;
    private boolean enabled = false;
    private boolean isInUse = false;
    private boolean hasScannedConfig = false;
    private boolean hasScannedInternals = false;
    private boolean hasInitialized = false;
    private boolean hasInitializedServer = false;
    private boolean hasInitializedRealm = false;
    private boolean hasCheckedRealm = false;
    private String currentServer_IP;
    private String formattedServer_IP;
    private String currentServer_Name;
    private String currentServer_MOTD;
    private List<String> currentServer_MOTD_Lines = StringUtils.newArrayList();
    private int currentPlayers;
    private int maxPlayers;
    private ServerList serverList;
    private int serverIndex = 0;
    private IntegratedServer currentIntegratedData;
    private ServerData currentServerData;
    private RealmsServer currentRealmData;
    private ClientPacketListener currentConnection;
    private boolean queuedForUpdate = false;
    private boolean joinInProgress = false;
    private boolean isOnLAN = false;
    private boolean isOnSinglePlayer = false;
    private boolean isOnRealm = false;

    @Override
    public void clearFieldData() {
        this.currentPlayerList.clear();
        this.defaultAddresses.clear();
        this.knownAddresses.clear();
        this.knownServerData.clear();
        this.serverList = null;
        this.serverIndex = 0;
    }

    @Override
    public void clearAttributes() {
        this.currentServer_IP = null;
        this.formattedServer_IP = null;
        this.currentServer_MOTD = null;
        this.currentServer_MOTD_Lines.clear();
        this.currentServer_Name = null;
        this.currentIntegratedData = null;
        this.currentServerData = null;
        this.currentRealmData = null;
        this.currentConnection = null;
        this.currentPlayers = 0;
        this.maxPlayers = 0;
        this.stopPingTask();
        this.queuedForUpdate = false;
        this.joinInProgress = false;
        this.isOnLAN = false;
        this.isOnSinglePlayer = false;
        this.isOnRealm = false;
        CraftPresence.CLIENT.removeArguments("server", "data.server", "world", "data.world", "player.position", "player.health", "player.mode");
        CraftPresence.CLIENT.clearForcedData("server");
        CraftPresence.CLIENT.clearPartyData();
        this.hasInitialized = false;
        this.hasInitializedServer = false;
        this.hasInitializedRealm = false;
        this.hasCheckedRealm = false;
    }

    @Override
    public void preTick() {
        this.joinInProgress = CraftPresence.CLIENT.STATUS == DiscordStatus.JoinGame || CraftPresence.CLIENT.STATUS == DiscordStatus.SpectateGame;
    }

    private RealmsServer findRealmData(ClientPacketListener connection) {
        try {
            RealmsScreen realmsProxy;
            Screen screen = connection.f_104887_;
            if (screen instanceof RealmsScreen && (realmsProxy = (RealmsScreen)screen) instanceof RealmsMainScreen) {
                RealmsMainScreen realmsMainScreen = (RealmsMainScreen)realmsProxy;
                return realmsMainScreen.m_193481_();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void updateData() {
        IntegratedServer newIntegratedData = CraftPresence.instance.m_91092_();
        ServerData newServerData = CraftPresence.instance.m_91089_();
        ClientPacketListener newConnection = CraftPresence.instance.m_91403_();
        if (!this.joinInProgress) {
            if (!this.hasCheckedRealm) {
                boolean canCheckRealm;
                boolean bl = canCheckRealm = newServerData != null && newConnection != null;
                if (canCheckRealm && CraftPresence.instance.m_91294_()) {
                    this.currentRealmData = this.findRealmData(newConnection);
                    this.isOnRealm = this.currentRealmData != null;
                }
                this.hasCheckedRealm = true;
            }
            if (this.isOnRealm) {
                this.processRealmData(newServerData, newConnection);
            } else {
                this.processServerData(newIntegratedData, newServerData, newConnection);
            }
        }
        if (this.queuedForUpdate) {
            if (!this.hasInitialized) {
                this.initPresence();
                this.hasInitialized = true;
            }
            this.updatePresence();
            this.queuedForUpdate = false;
        }
    }

    private void processData(boolean newLANStatus, boolean newSinglePlayerStatus, IntegratedServer newIntegratedData, ServerData newServerData, ClientPacketListener newConnection, String newServer_IP, String newServer_MOTD, String newServer_Name, int newCurrentPlayers, int newMaxPlayers, List<PlayerInfo> newPlayerList) {
        boolean hasLeftServer;
        boolean isNewServer = newServerData != null && !newServerData.equals(this.currentServerData);
        boolean bl = hasLeftServer = newServerData == null && this.currentServerData != null;
        if (newLANStatus != this.isOnLAN || newSinglePlayerStatus != this.isOnSinglePlayer || newIntegratedData != null && !newIntegratedData.equals(this.currentIntegratedData) || newIntegratedData == null && this.currentIntegratedData != null || isNewServer || hasLeftServer || newConnection != null && !newConnection.equals(this.currentConnection) || !newServer_IP.equals(this.currentServer_IP) || !StringUtils.isNullOrEmpty((String)newServer_MOTD) && !newServer_MOTD.equals(this.currentServer_MOTD) || !StringUtils.isNullOrEmpty((String)newServer_Name) && !newServer_Name.equals(this.currentServer_Name)) {
            this.currentServer_IP = newServer_IP;
            if (!newServer_MOTD.equals(this.currentServer_MOTD)) {
                this.currentServer_MOTD = newServer_MOTD;
                this.currentServer_MOTD_Lines = StringUtils.splitTextByNewLine((String)newServer_MOTD);
            }
            this.currentServer_Name = newServer_Name;
            this.currentIntegratedData = newIntegratedData;
            this.currentServerData = newServerData;
            this.currentConnection = newConnection;
            this.isOnLAN = newLANStatus;
            this.isOnSinglePlayer = newSinglePlayerStatus;
            this.queuedForUpdate = true;
            if (isNewServer) {
                this.startPingTask(CraftPresence.CONFIG.serverSettings.pingRateInterval, CraftPresence.CONFIG.serverSettings.pingRateUnit);
            } else if (hasLeftServer) {
                this.stopPingTask();
            }
            if (!StringUtils.isNullOrEmpty((String)this.currentServer_IP)) {
                String string = this.formattedServer_IP = this.currentServer_IP.contains(":") ? StringUtils.formatAddress((String)this.currentServer_IP, (boolean)false) : this.currentServer_IP;
                if (!(this.isOnRealm || this.isOnSinglePlayer || this.isOnLAN)) {
                    if (!this.defaultAddresses.contains(this.formattedServer_IP)) {
                        this.defaultAddresses.add(this.formattedServer_IP);
                    }
                    if (!this.knownAddresses.contains(this.formattedServer_IP)) {
                        this.knownAddresses.add(this.formattedServer_IP);
                    }
                }
            }
            if (this.serverList != null) {
                this.serverList.m_105431_();
                if (this.serverList.m_105445_() != this.serverIndex) {
                    this.queueInternalScan();
                }
            }
        }
        if (newCurrentPlayers != this.currentPlayers || newMaxPlayers != this.maxPlayers) {
            this.currentPlayers = newCurrentPlayers;
            this.maxPlayers = newMaxPlayers;
            this.queuedForUpdate = true;
        }
        if (!newPlayerList.equals(this.currentPlayerList)) {
            this.currentPlayerList = newPlayerList;
            if (CraftPresence.ENTITIES.isEnabled()) {
                CraftPresence.ENTITIES.ENTITY_NAMES.removeAll(CraftPresence.ENTITIES.PLAYER_BINDINGS.keySet());
                CraftPresence.ENTITIES.queueInternalScan();
            }
        }
    }

    private String getServerAddress(ServerData newServerData) {
        return newServerData != null && !StringUtils.isNullOrEmpty((String)newServerData.f_105363_) ? newServerData.f_105363_ : "127.0.0.1";
    }

    private String getServerMotd(IntegratedServer newIntegratedData, ServerData newServerData) {
        String result = "";
        if (newServerData != null && newServerData.f_105365_ != null) {
            result = newServerData.f_105365_.getString();
        } else if (newIntegratedData != null && newIntegratedData.m_129916_() != null) {
            result = newIntegratedData.m_129916_();
        }
        return !this.isInvalidMotd(result) ? StringUtils.stripAllFormatting((String)result) : CraftPresence.CONFIG.serverSettings.fallbackServerMotd;
    }

    private void processRealmData(ServerData newServerData, ClientPacketListener newConnection) {
        List newPlayerList = newConnection != null ? StringUtils.newArrayList((Iterable)newConnection.m_105142_()) : StringUtils.newArrayList();
        int newMaxPlayers = 10;
        int newCurrentPlayers = newConnection != null ? newConnection.m_105142_().size() : 1;
        if (newMaxPlayers < newCurrentPlayers) {
            newMaxPlayers = newCurrentPlayers + 1;
        }
        String newServer_IP = this.getServerAddress(newServerData);
        String newServer_Name = this.currentRealmData.m_87512_();
        String newServer_MOTD = !this.isInvalidMotd(this.currentRealmData.m_87494_()) ? StringUtils.stripAllFormatting((String)this.currentRealmData.m_87494_()) : CraftPresence.CONFIG.serverSettings.fallbackServerMotd;
        this.processData(false, false, null, newServerData, newConnection, newServer_IP, newServer_MOTD, newServer_Name, newCurrentPlayers, newMaxPlayers, newPlayerList);
    }

    private void processServerData(IntegratedServer newIntegratedData, ServerData newServerData, ClientPacketListener newConnection) {
        List newPlayerList = newConnection != null ? StringUtils.newArrayList((Iterable)newConnection.m_105142_()) : StringUtils.newArrayList();
        int newCurrentPlayers = newConnection != null ? newConnection.m_105142_().size() : 1;
        boolean newLANStatus = newIntegratedData != null && newIntegratedData.m_6992_() || newServerData != null && newServerData.m_105389_();
        boolean newSinglePlayerStatus = !newLANStatus && CraftPresence.instance.m_91090_();
        int newMaxPlayers = 0;
        if (newLANStatus) {
            newMaxPlayers = 8;
        } else if (newServerData != null) {
            try {
                newMaxPlayers = (Integer)StringUtils.getValidInteger((String)StringUtils.stripColors((String)newServerData.f_105364_.getString()).split("/")[1]).getSecond();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (newMaxPlayers < newCurrentPlayers) {
            newMaxPlayers = newCurrentPlayers + 1;
        }
        String newServer_IP = this.getServerAddress(newServerData);
        String newServer_Name = newServerData != null && !this.isInvalidName(newServerData.f_105362_) ? newServerData.f_105362_ : CraftPresence.CONFIG.serverSettings.fallbackServerName;
        String newServer_MOTD = this.getServerMotd(newIntegratedData, newServerData);
        this.processData(newLANStatus, newSinglePlayerStatus, newIntegratedData, newServerData, newConnection, newServer_IP, newServer_MOTD, newServer_Name, newCurrentPlayers, newMaxPlayers, newPlayerList);
    }

    private boolean isInvalidData(String input, List<String> invalidItems) {
        if (!StringUtils.isNullOrEmpty((String)input)) {
            for (String item : invalidItems) {
                if (ModUtils.RAW_TRANSLATOR == null || !ModUtils.RAW_TRANSLATOR.hasTranslation(item) || !input.equalsIgnoreCase(ModUtils.RAW_TRANSLATOR.translate(item, new Object[0]))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isInvalidMotd(String serverMotd) {
        return this.isInvalidData(serverMotd, invalidMotds);
    }

    private boolean isInvalidName(String serverName) {
        return this.isInvalidData(serverName, invalidNames);
    }

    private String makeSecret() {
        Object formattedKey = CraftPresence.CLIENT.CLIENT_ID;
        boolean containsServerName = false;
        boolean containsServerIP = false;
        if (!StringUtils.isNullOrEmpty((String)this.currentServer_Name)) {
            formattedKey = (String)formattedKey + "-" + this.currentServer_Name;
            containsServerName = true;
        }
        if (!StringUtils.isNullOrEmpty((String)this.currentServer_IP)) {
            formattedKey = (String)formattedKey + "-" + this.currentServer_IP;
            containsServerIP = true;
        }
        formattedKey = (String)formattedKey + ";" + containsServerName + ";" + containsServerIP;
        return formattedKey;
    }

    public void verifyAndJoin(String secret) {
        boolean isValidSecret;
        Object[] boolParts = secret.split(";");
        Object[] stringParts = boolParts[0].split("-");
        boolean containsValidClientID = StringUtils.elementExists((Object[])stringParts, (int)0) && ((String)stringParts[0]).length() >= 18 && (Boolean)StringUtils.getValidLong((String)stringParts[0]).getFirst() != false;
        boolean containsServerName = StringUtils.elementExists((Object[])boolParts, (int)1) && StringUtils.elementExists((Object[])stringParts, (int)1) && Boolean.parseBoolean((String)boolParts[1]);
        boolean containsServerIP = StringUtils.elementExists((Object[])boolParts, (int)2) && StringUtils.elementExists((Object[])stringParts, (int)2) && Boolean.parseBoolean((String)boolParts[2]);
        Object serverName = containsServerName ? stringParts[1] : CraftPresence.CONFIG.serverSettings.fallbackServerName;
        String serverIP = containsServerIP ? stringParts[2] : "";
        boolean bl = isValidSecret = boolParts.length <= 4 && stringParts.length <= 3 && containsValidClientID;
        if (isValidSecret) {
            ModUtils.executeOnMainThread((Minecraft)CraftPresence.instance, () -> this.lambda$verifyAndJoin$0((String)serverName, serverIP));
        } else {
            Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.discord.join", new Object[]{secret}), new Object[0]);
        }
        CraftPresence.CLIENT.STATUS = DiscordStatus.Ready;
    }

    private void pingServer(ServerData serverData, Runnable saver, Runnable callback) {
        Runnable callbackEvent;
        if (serverData == null) {
            return;
        }
        Runnable saverEvent = saver != null ? saver : () -> {};
        Runnable runnable = callbackEvent = callback != null ? callback : () -> {};
        if (!serverData.f_105369_) {
            serverData.f_105369_ = true;
            serverData.f_105366_ = -2L;
            serverData.f_105365_ = TextComponent.f_131282_;
            serverData.f_105364_ = TextComponent.f_131282_;
        }
        PING_EXECUTOR.submit(() -> {
            try {
                this.pinger.m_105459_(serverData, saverEvent);
                callbackEvent.run();
            }
            catch (UnknownHostException unknownHostException) {
                serverData.f_105366_ = -1L;
                serverData.f_105365_ = new TextComponent("\u00a74" + ModUtils.RAW_TRANSLATOR.translate("multiplayer.status.cannot_resolve", new Object[0]));
                callbackEvent.run();
            }
            catch (Exception ex) {
                serverData.f_105366_ = -1L;
                serverData.f_105365_ = new TextComponent("\u00a74" + ModUtils.RAW_TRANSLATOR.translate("multiplayer.status.cannot_connect", new Object[0]));
                callbackEvent.run();
            }
        });
    }

    private void pingServer(Runnable saver, Runnable callback) {
        this.pingServer(this.currentServerData, saver, callback);
    }

    private void pingServer(ServerData serverData, Runnable callback) {
        this.pingServer(serverData, null, callback);
    }

    private void pingServer(Runnable callback) {
        this.pingServer(this.currentServerData, callback);
    }

    private void pingServer(ServerData serverData) {
        this.pingServer(serverData, null);
    }

    private void pingServer() {
        this.pingServer(this.currentServerData);
    }

    private void startPingTask(int interval, String unit) {
        TimeUnit timeUnit;
        this.stopPingTask();
        if (interval <= 0) {
            return;
        }
        try {
            timeUnit = TimeUtils.getTimeUnitFrom((String)unit);
        }
        catch (Exception ex) {
            timeUnit = TimeUnit.MINUTES;
        }
        this.PING_SCHEDULER = Executors.newScheduledThreadPool(1);
        this.PING_SCHEDULER.scheduleAtFixedRate(this::pingServer, 0L, interval, timeUnit);
    }

    private void stopPingTask() {
        if (this.PING_SCHEDULER != null && !this.PING_SCHEDULER.isShutdown()) {
            this.PING_SCHEDULER.shutdown();
        }
    }

    private void joinServer(ServerData serverData) {
        try {
            this.pingServer(serverData);
            Screen currentScreen = GameUtils.getCurrentScreen((Minecraft)CraftPresence.instance);
            ConnectScreen.m_169267_((Screen)(currentScreen != null ? currentScreen : new TitleScreen()), (Minecraft)CraftPresence.instance, (ServerAddress)ServerAddress.m_171864_((String)serverData.f_105363_), (ServerData)serverData);
        }
        catch (Throwable ex) {
            this.printException(ex);
        }
    }

    @Override
    public void initPresence() {
        this.syncArgument("player.position.x", () -> MathUtils.roundDouble((double)CraftPresence.player.m_20185_(), (int)3), true);
        this.syncArgument("player.position.y", () -> MathUtils.roundDouble((double)CraftPresence.player.m_20186_(), (int)3), true);
        this.syncArgument("player.position.z", () -> MathUtils.roundDouble((double)CraftPresence.player.m_20189_(), (int)3), true);
        this.syncArgument("player.health.current", () -> MathUtils.roundDouble((double)CraftPresence.player.m_21223_(), (int)0), true);
        this.syncArgument("player.health.max", () -> MathUtils.roundDouble((double)CraftPresence.player.m_21233_(), (int)0), true);
        this.syncArgument("player.mode", () -> CraftPresence.instance.f_91072_.m_105295_().m_151500_().getString(), true);
        this.syncArgument("world.difficulty", () -> {
            if (ModUtils.RAW_TRANSLATOR != null && CraftPresence.world.m_6106_().m_5466_()) {
                return ModUtils.RAW_TRANSLATOR.translate("selectWorld.gameMode.hardcore", new Object[0]);
            }
            return CraftPresence.world.m_46791_().m_19033_().getString();
        }, true);
        this.syncArgument("world.weather.name", () -> {
            String newWeatherData = WorldUtils.getWeather((Entity)CraftPresence.player);
            String newWeatherName = Constants.TRANSLATOR.translate("craftpresence.defaults.weather." + newWeatherData, new Object[0]);
            return StringUtils.getOrDefault((String)newWeatherName);
        }, true);
        this.syncArgument("world.name", () -> {
            String defaultWorldName = Constants.TRANSLATOR.translate("craftpresence.defaults.world_name", new Object[0]);
            String primaryWorldName = CraftPresence.instance.m_91092_() != null ? CraftPresence.instance.m_91092_().m_129910_().m_5462_() : "";
            String secondaryWorldName = CraftPresence.world.m_142572_() != null ? StringUtils.getOrDefault((String)CraftPresence.world.m_142572_().m_129910_().m_5462_(), (String)defaultWorldName) : defaultWorldName;
            String newWorldName = StringUtils.getOrDefault((String)primaryWorldName, (String)secondaryWorldName);
            return StringUtils.getOrDefault((String)newWorldName);
        }, true);
        this.syncArgument("world.type", () -> "", true);
        this.syncArgument("world.time.day", () -> TimeUtils.fromWorldTime((long)CraftPresence.world.m_46468_()).getFirst(), true);
        this.syncArgument("world.time.format_24", () -> TimeUtils.toString((TemporalAccessor)((TemporalAccessor)TimeUtils.fromWorldTime((long)CraftPresence.world.m_46468_()).getSecond()), (String)"HH:mm"), true);
        this.syncArgument("world.time.format_12", () -> TimeUtils.toString((TemporalAccessor)((TemporalAccessor)TimeUtils.fromWorldTime((long)CraftPresence.world.m_46468_()).getSecond()), (String)"HH:mm a"), true);
        this.syncArgument("data.world.time.instance", () -> TimeUtils.fromWorldTime((long)CraftPresence.world.m_46468_()), true);
        this.syncArgument("server.default.icon", () -> CraftPresence.CONFIG.serverSettings.fallbackServerIcon);
        this.syncArgument("server.message", () -> {
            boolean inServer;
            boolean bl = inServer = !this.isOnRealm && !this.isOnSinglePlayer && (this.isOnLAN || this.currentServerData != null);
            if (inServer) {
                if (this.isOnLAN) {
                    ModuleData primaryData = CraftPresence.CONFIG.statusMessages.lanData;
                    return this.getResult(Config.isValidProperty(primaryData, "textOverride") ? primaryData.getTextOverride() : "", primaryData);
                }
                ModuleData defaultData = this.getDefaultData();
                ModuleData alternateData = this.getData(this.currentServer_Name);
                ModuleData primaryData = this.getData(this.formattedServer_IP);
                String defaultMessage = Config.isValidProperty(defaultData, "textOverride") ? defaultData.getTextOverride() : "";
                String alternateMessage = Config.isValidProperty(alternateData, "textOverride") ? alternateData.getTextOverride() : defaultMessage;
                return this.getResult(Config.isValidProperty(primaryData, "textOverride") ? primaryData.getTextOverride() : alternateMessage, this.formattedServer_IP, this.currentServer_Name);
            }
            if (this.isOnSinglePlayer) {
                ModuleData primaryData = CraftPresence.CONFIG.statusMessages.singleplayerData;
                return this.getResult(Config.isValidProperty(primaryData, "textOverride") ? primaryData.getTextOverride() : "", primaryData);
            }
            if (this.isOnRealm) {
                ModuleData primaryData = CraftPresence.CONFIG.statusMessages.realmData;
                return this.getResult(Config.isValidProperty(primaryData, "textOverride") ? primaryData.getTextOverride() : "", primaryData);
            }
            return null;
        });
        this.syncArgument("server.icon", () -> {
            boolean inServer = !this.isOnRealm && !this.isOnSinglePlayer && (this.isOnLAN || this.currentServerData != null);
            String currentServerIcon = "";
            ModuleData resultData = null;
            if (inServer) {
                if (this.isOnLAN) {
                    resultData = CraftPresence.CONFIG.statusMessages.lanData;
                    currentServerIcon = Config.isValidProperty(resultData, "iconOverride") ? resultData.getIconOverride() : "";
                } else {
                    ModuleData defaultData = this.getDefaultData();
                    ModuleData alternateData = this.getData(this.currentServer_Name);
                    ModuleData primaryData = this.getData(this.formattedServer_IP);
                    resultData = this.getOrDefault(primaryData, alternateData);
                    String defaultIcon = Config.isValidProperty(defaultData, "iconOverride") ? defaultData.getIconOverride() : "";
                    String alternateIcon = Config.isValidProperty(alternateData, "iconOverride") ? alternateData.getIconOverride() : defaultIcon;
                    String string = currentServerIcon = Config.isValidProperty(primaryData, "iconOverride") ? primaryData.getIconOverride() : alternateIcon;
                    if (StringUtils.isNullOrEmpty((String)currentServerIcon)) {
                        currentServerIcon = CraftPresence.CLIENT.addEndpointIcon(CraftPresence.CONFIG, CraftPresence.CONFIG.advancedSettings.serverIconEndpoint, this.formattedServer_IP, true) ? this.formattedServer_IP : this.currentServer_Name;
                    }
                }
            } else if (this.isOnSinglePlayer) {
                resultData = CraftPresence.CONFIG.statusMessages.singleplayerData;
                currentServerIcon = Config.isValidProperty(resultData, "iconOverride") ? resultData.getIconOverride() : "";
            } else if (this.isOnRealm) {
                resultData = CraftPresence.CONFIG.statusMessages.realmData;
                String string = currentServerIcon = Config.isValidProperty(resultData, "iconOverride") ? resultData.getIconOverride() : "";
                if (StringUtils.isNullOrEmpty((String)currentServerIcon)) {
                    String originalName = this.currentRealmData.f_87479_;
                    boolean isValidUuid = StringUtils.isValidUuid((String)originalName);
                    if (!CraftPresence.CONFIG.hasChanged() && CraftPresence.CONFIG.advancedSettings.allowEndpointIcons && !StringUtils.isNullOrEmpty((String)CraftPresence.CONFIG.advancedSettings.playerSkinEndpoint)) {
                        return CraftPresence.CLIENT.compileData(String.format(CraftPresence.CONFIG.advancedSettings.playerSkinEndpoint, originalName), new Pair((Object)"player.name", () -> originalName), new Pair((Object)"player.uuid.full", () -> isValidUuid ? StringUtils.getFromUuid((String)originalName, (boolean)false) : ""), new Pair((Object)"player.uuid.short", () -> isValidUuid ? StringUtils.getFromUuid((String)originalName, (boolean)true) : "")).get().toString();
                    }
                }
            }
            return this.getResult(CraftPresence.CLIENT.imageOf(true, currentServerIcon, CraftPresence.CONFIG.serverSettings.fallbackServerIcon), resultData);
        });
        CraftPresence.CLIENT.addForcedData("server", () -> {
            if (!this.isInUse()) {
                return null;
            }
            ModuleData resultData = null;
            if (!(this.isOnRealm || this.isOnSinglePlayer || !this.isOnLAN && this.currentServerData == null)) {
                resultData = this.isOnLAN ? CraftPresence.CONFIG.statusMessages.lanData : this.getOrDefault(this.formattedServer_IP, this.currentServer_Name);
            } else if (this.isOnSinglePlayer) {
                resultData = CraftPresence.CONFIG.statusMessages.singleplayerData;
            } else if (this.isOnRealm) {
                resultData = CraftPresence.CONFIG.statusMessages.realmData;
            }
            return this.getPresenceData(resultData);
        });
        CraftPresence.CLIENT.syncTimestamp("data.server.time");
    }

    private void initServerArgs() {
        this.syncArgument("server.players.current", () -> this.currentPlayers, true);
        this.syncArgument("server.players.max", () -> this.maxPlayers, true);
        this.syncArgument("server.address.full", () -> this.currentServer_IP, true);
        this.syncArgument("server.address.short", () -> this.formattedServer_IP, true);
        this.syncArgument("server.name", () -> this.currentServer_Name, true);
        this.syncArgument("server.motd.raw", () -> this.currentServer_MOTD, true);
        if (!this.currentServer_MOTD_Lines.isEmpty()) {
            for (int i = 0; i < this.currentServer_MOTD_Lines.size(); ++i) {
                int index = i + 1;
                this.syncArgument("data.server.motd.line_" + index, () -> this.currentServer_MOTD_Lines.get(index), true);
            }
        }
    }

    private void initRealmArgs() {
        this.syncArgument("server.minigame", () -> this.currentRealmData.m_87517_(), true);
        this.syncArgument("server.type", () -> StringUtils.getOrDefault((String)this.currentRealmData.f_87485_.name().toLowerCase()), true);
    }

    @Override
    public void updatePresence() {
        if (!this.isOnSinglePlayer && (this.isOnLAN || this.currentServerData != null)) {
            if (!this.hasInitializedServer) {
                this.initServerArgs();
                this.hasInitializedServer = true;
            }
            if (this.isOnRealm && !this.hasInitializedRealm) {
                this.initRealmArgs();
                this.hasInitializedRealm = true;
            }
            if (!this.isOnRealm && !this.isOnLAN && CraftPresence.CONFIG.generalSettings.enableJoinRequests) {
                CraftPresence.CLIENT.PARTY_ID = !StringUtils.isNullOrEmpty((String)this.currentServer_Name) && !this.currentServer_Name.equalsIgnoreCase(CraftPresence.CONFIG.serverSettings.fallbackServerName) ? "Join Server: " + this.currentServer_Name : "Join Server: " + this.currentServer_IP;
                CraftPresence.CLIENT.JOIN_SECRET = this.makeSecret();
                CraftPresence.CLIENT.PARTY_SIZE = this.currentPlayers;
                CraftPresence.CLIENT.PARTY_MAX = this.maxPlayers;
            }
        }
    }

    @Override
    public void getInternalData() {
        try {
            if (this.serverList == null) {
                this.serverList = new ServerList(CraftPresence.instance);
                this.serverList.m_105431_();
            }
            this.serverIndex = this.serverList.m_105445_();
            for (int currentIndex = 0; currentIndex < this.serverIndex; ++currentIndex) {
                String formattedIP;
                ServerData data = this.serverList.m_105432_(currentIndex);
                if (StringUtils.isNullOrEmpty((String)data.f_105363_)) continue;
                String string = formattedIP = data.f_105363_.contains(":") ? StringUtils.formatAddress((String)data.f_105363_, (boolean)false) : data.f_105363_;
                if (!this.defaultAddresses.contains(formattedIP)) {
                    this.defaultAddresses.add(formattedIP);
                }
                if (!this.knownAddresses.contains(formattedIP)) {
                    this.knownAddresses.add(formattedIP);
                }
                if (this.knownServerData.containsKey(data.f_105363_)) continue;
                this.knownServerData.put(data.f_105363_, data);
            }
        }
        catch (Throwable ex) {
            this.printException(ex);
        }
    }

    @Override
    public void getConfigData() {
        for (String serverEntry : CraftPresence.CONFIG.serverSettings.serverData.keySet()) {
            if (StringUtils.isNullOrEmpty((String)serverEntry) || this.knownAddresses.contains(serverEntry)) continue;
            this.knownAddresses.add(serverEntry);
        }
    }

    @Override
    public void syncArgument(String argumentName, Supplier<Boolean> condition, Supplier<Object> event, boolean plain) {
        CraftPresence.CLIENT.syncArgument(argumentName, this.getModuleFunction(condition, event), plain);
    }

    @Override
    public ModuleData getData(String key) {
        return CraftPresence.CONFIG.serverSettings.serverData.get(key);
    }

    @Override
    public String getOverrideText(ModuleData data) {
        return CraftPresence.CLIENT.getOverrideText(this.getPresenceData(data));
    }

    @Override
    public boolean hasScannedInternals() {
        return this.hasScannedInternals;
    }

    @Override
    public void setScannedInternals(boolean state) {
        this.hasScannedInternals = state;
    }

    @Override
    public boolean canFetchConfig() {
        return CraftPresence.CONFIG != null;
    }

    @Override
    public boolean hasScannedConfig() {
        return this.hasScannedConfig;
    }

    @Override
    public void setScannedConfig(boolean state) {
        this.hasScannedConfig = state;
    }

    @Override
    public boolean canBeEnabled() {
        return !CraftPresence.CONFIG.hasChanged() ? CraftPresence.CONFIG.generalSettings.detectWorldData : this.isEnabled();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean canBeUsed() {
        return CraftPresence.player != null && !this.joinInProgress;
    }

    @Override
    public boolean isInUse() {
        return this.isInUse;
    }

    @Override
    public void setInUse(boolean state) {
        this.isInUse = state;
    }

    public ServerData getDataFromName(String serverAddress) {
        return this.knownServerData.getOrDefault(serverAddress, null);
    }

    private /* synthetic */ void lambda$verifyAndJoin$0(String serverName, String serverIP) {
        this.joinServer(new ServerData(serverName, serverIP, false));
    }
}

