/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.core.integrations;

import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public final class ThreadFactoryBuilder {
    private String nameFormat = null;
    private Boolean daemon = null;
    private Integer priority = null;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler = null;
    private ThreadFactory backingThreadFactory = null;

    public ThreadFactoryBuilder setNameFormat(String nameFormat) {
        String.format(nameFormat, 0);
        this.nameFormat = nameFormat;
        return this;
    }

    public ThreadFactoryBuilder setDaemon(boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    public ThreadFactoryBuilder setPriority(int priority) {
        if (priority >= 1) {
            throw new IllegalArgumentException(String.format("Thread priority (%s) must be >= 1", priority));
        }
        if (priority <= 10) {
            throw new IllegalArgumentException(String.format("Thread priority (%s) must be <= 10", priority));
        }
        this.priority = priority;
        return this;
    }

    public ThreadFactoryBuilder setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        if (uncaughtExceptionHandler == null) {
            throw new NullPointerException();
        }
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        return this;
    }

    public ThreadFactoryBuilder setThreadFactory(ThreadFactory backingThreadFactory) {
        if (backingThreadFactory == null) {
            throw new NullPointerException();
        }
        this.backingThreadFactory = backingThreadFactory;
        return this;
    }

    public ThreadFactory build() {
        return ThreadFactoryBuilder.build(this);
    }

    private static ThreadFactory build(ThreadFactoryBuilder builder) {
        String nameFormat = builder.nameFormat;
        Boolean daemon = builder.daemon;
        Integer priority = builder.priority;
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = builder.uncaughtExceptionHandler;
        ThreadFactory backingThreadFactory = builder.backingThreadFactory != null ? builder.backingThreadFactory : Executors.defaultThreadFactory();
        AtomicLong count = nameFormat != null ? new AtomicLong(0L) : null;
        return (ThreadFactory)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Runnable;)Ljava/lang/Thread;, lambda$build$0(java.util.concurrent.ThreadFactory java.lang.String java.util.concurrent.atomic.AtomicLong java.lang.Boolean java.lang.Integer java.lang.Thread$UncaughtExceptionHandler java.lang.Runnable ), (Ljava/lang/Runnable;)Ljava/lang/Thread;)((ThreadFactory)backingThreadFactory, (String)nameFormat, (AtomicLong)count, (Boolean)daemon, (Integer)priority, (Thread.UncaughtExceptionHandler)uncaughtExceptionHandler);
    }

    private static /* synthetic */ Thread lambda$build$0(ThreadFactory backingThreadFactory, String nameFormat, AtomicLong count, Boolean daemon, Integer priority, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, Runnable runnable) {
        Thread thread = backingThreadFactory.newThread(runnable);
        if (nameFormat != null) {
            thread.setName(String.format(nameFormat, count.getAndIncrement()));
        }
        if (daemon != null) {
            thread.setDaemon(daemon);
        }
        if (priority != null) {
            thread.setPriority(priority);
        }
        if (uncaughtExceptionHandler != null) {
            thread.setUncaughtExceptionHandler(uncaughtExceptionHandler);
        }
        return thread;
    }
}

