/*
 * Decompiled with CFR 0.152.
 */
package craftpresence.external.net.lenni0451.reflect;

import com.sun.management.HotSpotDiagnosticMXBean;
import craftpresence.external.net.lenni0451.reflect.Fields;
import craftpresence.external.net.lenni0451.reflect.JVMConstants;
import craftpresence.external.net.lenni0451.reflect.accessor.UnsafeAccess;
import craftpresence.external.net.lenni0451.reflect.exceptions.InvalidOOPSizeException;
import craftpresence.external.net.lenni0451.reflect.utils.FieldInitializer;
import java.lang.invoke.LambdaMetafactory;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Array;
import java.util.function.Supplier;

public class Objects {
    private static final ThreadLocal<Object[]> OBJECT_ARRAY_CACHE = ThreadLocal.withInitial((Supplier<Object[]>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$static$0(), ()[Ljava/lang/Object;)());
    public static final long ARRAY_BASE_OFFSET = UnsafeAccess.arrayBaseOffset(Object[].class);
    public static final int ARRAY_INDEX_SCALE = UnsafeAccess.arrayIndexScale(Object[].class);
    public static final int ADDRESS_SIZE = UnsafeAccess.addressSize();
    public static final int OOP_SIZE = CompressedOopsClass.access$000();
    public static final int OBJECT_HEADER_SIZE = BooleanHeaderClass.access$100();
    public static final int ARRAY_HEADER_SIZE = OBJECT_HEADER_SIZE + 4;
    public static final int OBJECT_ALIGNMENT = FieldInitializer.init((FieldInitializer.ThrowingSupplier<Integer>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$static$1(), ()Ljava/lang/Integer;)());
    public static final boolean COMPRESSED_OOPS = ADDRESS_SIZE != OOP_SIZE;
    public static final int COMPRESSED_OOP_SHIFT = FieldInitializer.init((FieldInitializer.ThrowingSupplier<Integer>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$static$2(), ()Ljava/lang/Integer;)());
    public static final long COMPRESSED_OOP_BASE = Objects.toNativeAddress(null);
    public static final long KLASS_OFFSET = OBJECT_HEADER_SIZE - OOP_SIZE;

    @Deprecated
    public static long toAddress(Object o) {
        return Objects.toJVMAddress(o);
    }

    public static long toJVMAddress(Object o) {
        long jvmAddress;
        Object[] array = OBJECT_ARRAY_CACHE.get();
        array[0] = o;
        if (OOP_SIZE == 4) {
            jvmAddress = (long)UnsafeAccess.getInt(array, ARRAY_BASE_OFFSET) & 0xFFFFFFFFL;
        } else if (OOP_SIZE == 8) {
            jvmAddress = UnsafeAccess.getLong(array, ARRAY_BASE_OFFSET);
        } else {
            throw new InvalidOOPSizeException();
        }
        array[0] = null;
        return jvmAddress;
    }

    public static long toJVMAddress(long nativeAddress) {
        if (COMPRESSED_OOPS) {
            return nativeAddress - COMPRESSED_OOP_BASE >>> COMPRESSED_OOP_SHIFT;
        }
        return nativeAddress;
    }

    public static long toNativeAddress(Object o) {
        return Objects.toNativeAddress(Objects.toJVMAddress(o));
    }

    public static long toNativeAddress(long jvmAddress) {
        if (COMPRESSED_OOPS) {
            return COMPRESSED_OOP_BASE + (jvmAddress << COMPRESSED_OOP_SHIFT);
        }
        return jvmAddress;
    }

    @Deprecated
    public static <T> T fromAddress(long jvmAddress) {
        return Objects.fromJVMAddress(jvmAddress);
    }

    public static <T> T fromJVMAddress(long jvmAddress) {
        Object[] array = OBJECT_ARRAY_CACHE.get();
        if (OOP_SIZE == 4) {
            UnsafeAccess.putInt(array, ARRAY_BASE_OFFSET, (int)jvmAddress);
        } else if (OOP_SIZE == 8) {
            UnsafeAccess.putLong(array, ARRAY_BASE_OFFSET, jvmAddress);
        } else {
            throw new InvalidOOPSizeException();
        }
        Object o = array[0];
        array[0] = null;
        return (T)o;
    }

    public static void copyMemory(Object from, Object to, long size) {
        Objects.copyMemory(from, 0L, to, 0L, size);
    }

    public static void copyMemory(Object from, long fromOffset, Object to, long toOffset, long size) {
        UnsafeAccess.copyMemory(Objects.toJVMAddress(from) + fromOffset, Objects.toJVMAddress(to) + toOffset, size);
    }

    public static long getKlass(Class<?> clazz) {
        if (clazz.isArray()) {
            return Objects.getKlass(Array.newInstance(clazz.getComponentType(), 0));
        }
        return Objects.getKlass(UnsafeAccess.allocateInstance(clazz));
    }

    public static long getKlass(Object o) {
        if (OOP_SIZE == 4) {
            return (long)UnsafeAccess.getInt(o, KLASS_OFFSET) & 0xFFFFFFFFL;
        }
        if (OOP_SIZE == 8) {
            return UnsafeAccess.getLong(o, KLASS_OFFSET);
        }
        throw new InvalidOOPSizeException();
    }

    public static <T> T cast(Object o, Class<T> target) {
        return Objects.cast(o, Objects.getKlass(target));
    }

    public static <T> T cast(Object o, Object target) {
        return Objects.cast(o, Objects.getKlass(target));
    }

    public static <T> T cast(Object o, long klass) {
        if (JVMConstants.OPENJ9_RUNTIME) {
            throw new UnsupportedOperationException("OpenJ9 is not supported");
        }
        if (OOP_SIZE == 4) {
            UnsafeAccess.putInt(o, KLASS_OFFSET, (int)klass);
        } else if (OOP_SIZE == 8) {
            UnsafeAccess.putLong(o, KLASS_OFFSET, klass);
        } else {
            throw new InvalidOOPSizeException();
        }
        return (T)o;
    }

    public static <T> T allocate(Class<T> clazz) {
        return (T)UnsafeAccess.allocateInstance(clazz);
    }

    private static /* synthetic */ Integer lambda$static$2() throws Throwable {
        int i = OBJECT_ALIGNMENT;
        int result = 0;
        while ((i >>= 1) != 0) {
            ++result;
        }
        return result;
    }

    private static /* synthetic */ Integer lambda$static$1() throws Throwable {
        HotSpotDiagnosticMXBean mxBean;
        if (!JVMConstants.OPENJ9_RUNTIME && (mxBean = ManagementFactory.getPlatformMXBean(HotSpotDiagnosticMXBean.class)) != null) {
            return Integer.parseInt(mxBean.getVMOption("ObjectAlignmentInBytes").getValue());
        }
        return 8;
    }

    private static /* synthetic */ Object[] lambda$static$0() {
        return new Object[1];
    }

    private static class BooleanHeaderClass {
        public boolean b;

        private BooleanHeaderClass() {
        }

        private static int getHeaderSize() {
            long b = UnsafeAccess.objectFieldOffset(Fields.getDeclaredField(BooleanHeaderClass.class, "b"));
            return (int)b;
        }

        static /* synthetic */ int access$100() {
            return BooleanHeaderClass.getHeaderSize();
        }
    }

    private static class CompressedOopsClass {
        public Object o1;
        public Object o2;

        private CompressedOopsClass() {
        }

        private static int getOopSize() {
            long o1 = UnsafeAccess.objectFieldOffset(Fields.getDeclaredField(CompressedOopsClass.class, "o1"));
            long o2 = UnsafeAccess.objectFieldOffset(Fields.getDeclaredField(CompressedOopsClass.class, "o2"));
            return (int)Math.abs(o2 - o1);
        }

        static /* synthetic */ int access$000() {
            return CompressedOopsClass.getOopSize();
        }
    }
}

