/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.moonconfig.core.utils;

import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.hypherionmc.moonconfig.core.utils.TransformingIterator;
import me.hypherionmc.moonconfig.core.utils.TransformingSpliterator;

public class TransformingCollection<InternalV, ExternalV>
implements Collection<ExternalV> {
    protected final Function<? super InternalV, ? extends ExternalV> readTransformation;
    protected final Function<? super ExternalV, ? extends InternalV> writeTransformation;
    protected final Function<Object, Object> searchTransformation;
    protected final Collection<InternalV> internalCollection;

    public TransformingCollection(Collection<InternalV> internalCollection, Function<? super InternalV, ? extends ExternalV> readTransformation, Function<? super ExternalV, ? extends InternalV> writeTransformation, Function<Object, Object> searchTransformation) {
        this.internalCollection = internalCollection;
        this.readTransformation = readTransformation;
        this.writeTransformation = writeTransformation;
        this.searchTransformation = searchTransformation;
    }

    @Override
    public int size() {
        return this.internalCollection.size();
    }

    @Override
    public boolean isEmpty() {
        return this.internalCollection.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.internalCollection.contains(this.searchTransformation.apply(o));
    }

    @Override
    public Iterator<ExternalV> iterator() {
        return new TransformingIterator<InternalV, ExternalV>(this.internalCollection.iterator(), this.readTransformation);
    }

    @Override
    public Object[] toArray() {
        Object[] array = this.internalCollection.toArray();
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readTransformation.apply(array[i]);
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        T[] array = this.internalCollection.toArray(a);
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readTransformation.apply(array[i]);
        }
        return array;
    }

    @Override
    public boolean add(ExternalV value) {
        return this.internalCollection.add(this.writeTransformation.apply(value));
    }

    @Override
    public boolean remove(Object o) {
        return this.internalCollection.remove(this.searchTransformation.apply(o));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.internalCollection.containsAll(new TransformingCollection<Object, Object>(c, this.searchTransformation, (Function<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$containsAll$0(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)(), this.searchTransformation));
    }

    @Override
    public boolean addAll(Collection<? extends ExternalV> c) {
        return this.internalCollection.addAll(new TransformingCollection<ExternalV, InternalV>(c, this.writeTransformation, this.readTransformation, this.searchTransformation));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.internalCollection.removeAll(new TransformingCollection<Object, Object>(c, this.searchTransformation, (Function<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$removeAll$1(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)(), this.searchTransformation));
    }

    @Override
    public boolean removeIf(Predicate<? super ExternalV> filter) {
        return this.internalCollection.removeIf((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$removeIf$2(java.util.function.Predicate java.lang.Object ), (Ljava/lang/Object;)Z)((TransformingCollection)this, filter));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.internalCollection.retainAll(new TransformingCollection<Object, Object>(c, this.searchTransformation, (Function<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$retainAll$3(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)(), this.searchTransformation));
    }

    @Override
    public void clear() {
        this.internalCollection.clear();
    }

    @Override
    public Spliterator<ExternalV> spliterator() {
        return new TransformingSpliterator<InternalV, ExternalV>(this.internalCollection.spliterator(), this.readTransformation, this.writeTransformation);
    }

    @Override
    public Stream<ExternalV> stream() {
        return this.internalCollection.stream().map(this.readTransformation);
    }

    @Override
    public Stream<ExternalV> parallelStream() {
        return this.internalCollection.parallelStream().map(this.readTransformation);
    }

    @Override
    public void forEach(Consumer<? super ExternalV> action) {
        this.internalCollection.forEach((Consumer<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$forEach$4(java.util.function.Consumer java.lang.Object ), (Ljava/lang/Object;)V)((TransformingCollection)this, action));
    }

    @Override
    public int hashCode() {
        return this.internalCollection.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.internalCollection.equals(obj);
    }

    public String toString() {
        return this.internalCollection.toString();
    }

    private /* synthetic */ void lambda$forEach$4(Consumer action, Object internalV) {
        action.accept(this.readTransformation.apply(internalV));
    }

    private static /* synthetic */ Object lambda$retainAll$3(Object o) {
        return o;
    }

    private /* synthetic */ boolean lambda$removeIf$2(Predicate filter, Object internalV) {
        return filter.test(this.readTransformation.apply(internalV));
    }

    private static /* synthetic */ Object lambda$removeAll$1(Object o) {
        return o;
    }

    private static /* synthetic */ Object lambda$containsAll$0(Object o) {
        return o;
    }
}

