/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.moonconfig.toml;

import java.lang.invoke.LambdaMetafactory;
import java.time.temporal.Temporal;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.hypherionmc.moonconfig.core.Config;
import me.hypherionmc.moonconfig.core.NullObject;
import me.hypherionmc.moonconfig.core.io.CharacterOutput;
import me.hypherionmc.moonconfig.core.io.WritingException;
import me.hypherionmc.moonconfig.toml.ArrayWriter;
import me.hypherionmc.moonconfig.toml.StringWriter;
import me.hypherionmc.moonconfig.toml.TableWriter;
import me.hypherionmc.moonconfig.toml.TemporalWriter;
import me.hypherionmc.moonconfig.toml.TomlWriter;

final class ValueWriter {
    private static void writeString(String string, CharacterOutput output, TomlWriter writer) {
        if (writer.writesLiteral(string)) {
            StringWriter.writeLiteral(string, output);
        } else {
            StringWriter.writeBasic(string, output);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static void write(Object value, CharacterOutput output, TomlWriter writer) {
        if (value instanceof Config) {
            TableWriter.writeInline((Config)value, output, writer);
            return;
        }
        if (value instanceof List) {
            List list = (List)value;
            if (!list.isEmpty()) {
                Stream stream = list.stream();
                Config.class.getClass();
                if (stream.allMatch((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Ljava/lang/Object;)Z)(Config.class))) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Object table = iterator.next();
                        TableWriter.writeInline((Config)table, output, writer);
                        if (!iterator.hasNext()) continue;
                        output.write(ArrayWriter.ELEMENT_SEPARATOR);
                    }
                    return;
                }
            }
            ArrayWriter.write((List)value, output, writer);
            return;
        }
        if (value instanceof CharSequence) {
            ValueWriter.writeString(value.toString(), output, writer);
            return;
        }
        if (value instanceof Enum) {
            ValueWriter.writeString(((Enum)value).name(), output, writer);
            return;
        }
        if (value instanceof Temporal) {
            TemporalWriter.write((Temporal)value, output);
            return;
        }
        if (value instanceof Float || value instanceof Double) {
            double d = ((Number)value).doubleValue();
            if (Double.isNaN(d)) {
                output.write("nan");
                return;
            }
            if (d == Double.POSITIVE_INFINITY) {
                output.write("+inf");
                return;
            }
            if (d == Double.NEGATIVE_INFINITY) {
                output.write("-inf");
                return;
            }
            output.write(value.toString());
            return;
        }
        if (!(value instanceof Number) && !(value instanceof Boolean)) {
            if (value == null) throw new WritingException("TOML doesn't support null values");
            if (value != NullObject.NULL_OBJECT) throw new WritingException("Unsupported value type: " + value.getClass());
            throw new WritingException("TOML doesn't support null values");
        }
        output.write(value.toString());
    }

    private ValueWriter() {
    }
}

