/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.moonconfig.toml;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.hypherionmc.moonconfig.core.CommentedConfig;
import me.hypherionmc.moonconfig.core.CommentedConfig$jvmdg$StaticDefaults;
import me.hypherionmc.moonconfig.core.Config;
import me.hypherionmc.moonconfig.core.ConfigFormat;
import me.hypherionmc.moonconfig.core.file.FileNotFoundAction;
import me.hypherionmc.moonconfig.core.io.CharacterInput;
import me.hypherionmc.moonconfig.core.io.CharsWrapper;
import me.hypherionmc.moonconfig.core.io.ConfigParser;
import me.hypherionmc.moonconfig.core.io.ConfigParser$jvmdg$StaticDefaults;
import me.hypherionmc.moonconfig.core.io.ParsingException;
import me.hypherionmc.moonconfig.core.io.ParsingMode;
import me.hypherionmc.moonconfig.core.io.ReaderInput;
import me.hypherionmc.moonconfig.toml.TableParser;
import me.hypherionmc.moonconfig.toml.TomlFormat;

public final class TomlParser
implements ConfigParser<CommentedConfig> {
    private int initialStringBuilderCapacity = 16;
    private int initialListCapacity = 10;
    private boolean lenientBareKeys = false;
    private boolean lenientSeparators = false;
    private boolean configWasEmpty = false;
    private ParsingMode parsingMode;
    private final Set<Config> inlineTables = Collections.newSetFromMap(new IdentityHashMap());
    private String currentComment;

    void registerInlineTable(Config table) {
        this.inlineTables.add(table);
    }

    boolean isInlineTable(Config table) {
        return this.inlineTables.contains(table);
    }

    private void clearParsingState() {
        this.inlineTables.clear();
    }

    @Override
    public CommentedConfig parse(Reader reader) {
        this.configWasEmpty = true;
        return (CommentedConfig)this.parse(new ReaderInput(reader), TomlFormat.instance().createConfig(), ParsingMode.MERGE);
    }

    @Override
    public void parse(Reader reader, Config destination, ParsingMode parsingMode) {
        if (parsingMode == ParsingMode.REPLACE) {
            this.configWasEmpty = true;
        }
        this.parse(new ReaderInput(reader), destination, parsingMode);
    }

    private <T extends Config> T parse(CharacterInput input, T destination, ParsingMode parsingMode) {
        int next;
        this.parsingMode = parsingMode;
        parsingMode.prepareParsing(destination);
        CommentedConfig commentedConfig = CommentedConfig$jvmdg$StaticDefaults.fake(destination);
        CommentedConfig rootTable = TableParser.parseNormal(input, this, commentedConfig);
        while ((next = input.peek()) != -1) {
            Config table;
            Map<String, Object> parentMap;
            boolean isArray;
            boolean bl = isArray = next == 91;
            if (isArray) {
                input.skipPeeks();
            }
            List<String> path = TableParser.parseTableName(input, this, isArray);
            int lastIndex = path.size() - 1;
            String lastKey = path.get(lastIndex);
            List<String> parentPath = path.subList(0, lastIndex);
            Config parentConfig = this.getSubTable(rootTable, parentPath);
            Map<String, Object> map = parentMap = parentConfig != null ? parentConfig.valueMap() : null;
            if (this.hasPendingComment()) {
                String comment = this.consumeComment();
                if (parentConfig instanceof CommentedConfig) {
                    List<String> lastPath = Collections.singletonList(lastKey);
                    ((CommentedConfig)parentConfig).setComment(lastPath, comment);
                }
            }
            if (isArray) {
                if (parentMap == null) {
                    throw new ParsingException("Cannot create entry " + path + " because of an invalid parent that isn't a table.");
                }
                CommentedConfig table2 = TableParser.parseNormal(input, this);
                List<T> arrayOfTables = (List<T>)parentMap.get(lastKey);
                if (arrayOfTables == null) {
                    arrayOfTables = this.createList();
                    parentMap.put(lastKey, arrayOfTables);
                }
                arrayOfTables.add(table2);
                continue;
            }
            if (parentMap == null) {
                throw new ParsingException("Cannot create entry " + path + " because of an invalid parent that isn't a table.");
            }
            Object alreadyDeclared = parentMap.get(lastKey);
            if (alreadyDeclared == null) {
                table = TableParser.parseNormal(input, this);
                parentMap.put(lastKey, table);
                continue;
            }
            if (alreadyDeclared instanceof Config) {
                table = (Config)alreadyDeclared;
                this.checkContainsOnlySubtables(table, path);
                CommentedConfig commentedTable = CommentedConfig$jvmdg$StaticDefaults.fake(table);
                TableParser.parseNormal(input, this, commentedTable);
                continue;
            }
            if (!this.configWasEmpty) continue;
            throw new ParsingException("Entry " + path + " has been defined twice.");
        }
        this.clearParsingState();
        return destination;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Config getSubTable(Config parentTable, List<String> path) {
        if (path.isEmpty()) {
            return parentTable;
        }
        Config currentConfig = parentTable;
        for (String key : path) {
            Object value = currentConfig.valueMap().get(key);
            if (value == null) {
                Config sub = TomlFormat.instance().createConfig();
                currentConfig.valueMap().put(key, sub);
                currentConfig = sub;
            } else if (value instanceof Config) {
                currentConfig = (Config)value;
            } else {
                if (!(value instanceof List)) return null;
                List list = (List)value;
                if (list.isEmpty()) return null;
                Stream stream = list.stream();
                Config.class.getClass();
                if (!stream.allMatch((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Ljava/lang/Object;)Z)(Config.class))) return null;
                int lastIndex = list.size() - 1;
                currentConfig = (Config)list.get(lastIndex);
            }
            if (!this.isInlineTable(currentConfig)) continue;
            throw new ParsingException("Cannot modify an inline table after its creation. Key path: " + path);
        }
        return currentConfig;
    }

    private void checkContainsOnlySubtables(Config table, List<String> path) {
        for (Object value : table.valueMap().values()) {
            if (value instanceof Config) continue;
            throw new ParsingException("Table with path " + path + " has been declared twice.");
        }
    }

    public boolean isLenientWithSeparators() {
        return this.lenientSeparators;
    }

    public TomlParser setLenientWithSeparators(boolean lenientSeparators) {
        this.lenientSeparators = lenientSeparators;
        return this;
    }

    public boolean isLenientWithBareKeys() {
        return this.lenientBareKeys;
    }

    public TomlParser setLenientWithBareKeys(boolean lenientBareKeys) {
        this.lenientBareKeys = lenientBareKeys;
        return this;
    }

    public TomlParser setInitialStringBuilderCapacity(int initialStringBuilderCapacity) {
        this.initialStringBuilderCapacity = initialStringBuilderCapacity;
        return this;
    }

    public TomlParser setInitialListCapacity(int initialListCapacity) {
        this.initialListCapacity = initialListCapacity;
        return this;
    }

    @Override
    public ConfigFormat<CommentedConfig> getFormat() {
        return TomlFormat.instance();
    }

    boolean configWasEmpty() {
        return this.configWasEmpty;
    }

    ParsingMode getParsingMode() {
        return this.parsingMode;
    }

    <T> List<T> createList() {
        return new ArrayList(this.initialListCapacity);
    }

    CharsWrapper.Builder createBuilder() {
        return new CharsWrapper.Builder(this.initialStringBuilderCapacity);
    }

    boolean hasPendingComment() {
        return this.currentComment != null;
    }

    String consumeComment() {
        String comment = this.currentComment;
        this.currentComment = null;
        return comment;
    }

    void setComment(CharsWrapper comment) {
        if (comment != null) {
            this.currentComment = this.currentComment == null ? comment.toString() : this.currentComment + '\n' + comment.toString();
        }
    }

    void setComment(List<CharsWrapper> commentsList) {
        CharsWrapper.Builder builder = new CharsWrapper.Builder(32);
        if (!commentsList.isEmpty()) {
            Iterator<CharsWrapper> it = commentsList.iterator();
            builder.append(it.next());
            while (it.hasNext()) {
                builder.append('\n');
                builder.append(it.next());
            }
            this.setComment(builder.build());
        }
    }

    @Override
    public Config parse(Path path, FileNotFoundAction fileNotFoundAction, Charset charset) {
        return ConfigParser$jvmdg$StaticDefaults.parse((ConfigParser)this, path, fileNotFoundAction, charset);
    }

    @Override
    public Config parse(URL uRL) {
        return ConfigParser$jvmdg$StaticDefaults.parse((ConfigParser)this, uRL);
    }

    @Override
    public void parse(File file, Config config, ParsingMode parsingMode, FileNotFoundAction fileNotFoundAction) {
        ConfigParser$jvmdg$StaticDefaults.parse((ConfigParser)this, file, config, parsingMode, fileNotFoundAction);
    }

    @Override
    public Config parse(File file, FileNotFoundAction fileNotFoundAction, Charset charset) {
        return ConfigParser$jvmdg$StaticDefaults.parse((ConfigParser)this, file, fileNotFoundAction, charset);
    }

    @Override
    public Config parse(Path path, FileNotFoundAction fileNotFoundAction) {
        return ConfigParser$jvmdg$StaticDefaults.parse((ConfigParser)this, path, fileNotFoundAction);
    }

    @Override
    public void parse(InputStream inputStream, Config config, ParsingMode parsingMode) {
        ConfigParser$jvmdg$StaticDefaults.parse((ConfigParser)this, inputStream, config, parsingMode);
    }

    @Override
    public Config parse(String string) {
        return ConfigParser$jvmdg$StaticDefaults.parse((ConfigParser)this, string);
    }

    @Override
    public Config parse(File file, FileNotFoundAction fileNotFoundAction) {
        return ConfigParser$jvmdg$StaticDefaults.parse((ConfigParser)this, file, fileNotFoundAction);
    }

    @Override
    public void parse(String string, Config config, ParsingMode parsingMode) {
        ConfigParser$jvmdg$StaticDefaults.parse((ConfigParser)this, string, config, parsingMode);
    }

    @Override
    public Config parse(InputStream inputStream) {
        return ConfigParser$jvmdg$StaticDefaults.parse((ConfigParser)this, inputStream);
    }

    @Override
    public void parse(InputStream inputStream, Config config, ParsingMode parsingMode, Charset charset) {
        ConfigParser$jvmdg$StaticDefaults.parse((ConfigParser)this, inputStream, config, parsingMode, charset);
    }

    @Override
    public void parse(Path path, Config config, ParsingMode parsingMode, FileNotFoundAction fileNotFoundAction, Charset charset) {
        ConfigParser$jvmdg$StaticDefaults.parse((ConfigParser)this, path, config, parsingMode, fileNotFoundAction, charset);
    }

    @Override
    public void parse(Path path, Config config, ParsingMode parsingMode, FileNotFoundAction fileNotFoundAction) {
        ConfigParser$jvmdg$StaticDefaults.parse((ConfigParser)this, path, config, parsingMode, fileNotFoundAction);
    }

    @Override
    public void parse(File file, Config config, ParsingMode parsingMode, FileNotFoundAction fileNotFoundAction, Charset charset) {
        ConfigParser$jvmdg$StaticDefaults.parse((ConfigParser)this, file, config, parsingMode, fileNotFoundAction, charset);
    }

    @Override
    public void parse(URL uRL, Config config, ParsingMode parsingMode) {
        ConfigParser$jvmdg$StaticDefaults.parse((ConfigParser)this, uRL, config, parsingMode);
    }

    @Override
    public Config parse(InputStream inputStream, Charset charset) {
        return ConfigParser$jvmdg$StaticDefaults.parse((ConfigParser)this, inputStream, charset);
    }
}

