/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.config.gui;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.config.gui.PresenceEditorGui;
import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.Module;
import com.gitlab.cdagaming.craftpresence.core.config.category.Display;
import com.gitlab.cdagaming.craftpresence.core.integrations.discord.assets.DiscordAsset;
import com.gitlab.cdagaming.craftpresence.core.integrations.discord.assets.DiscordAssetUtils;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.DynamicScrollableList;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.PresenceVisualizer;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.ConfigurationGui;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicSelectorGui;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import io.github.cdagaming.unicore.utils.StringUtils;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;

public class DisplaySettingsGui
extends ConfigurationGui<Display> {
    private final Display INSTANCE;
    private final Display DEFAULTS = this.getCurrentData().getDefaults();
    private final PresenceVisualizer visualizer;

    DisplaySettingsGui() {
        super(Constants.TRANSLATOR.translate("gui.config.title", new Object[0]), Constants.TRANSLATOR.translate("gui.config.title.display_settings", new Object[0]));
        this.INSTANCE = this.getCurrentData().copy();
        this.visualizer = new PresenceVisualizer(this, true);
    }

    public void appendElements() {
        super.appendElements();
        this.childFrame.addControl((IGuiEventListener)new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getButtonY(0), 180, 20, Constants.TRANSLATOR.translate("gui.config.title.editor.presence", new Object[0]), () -> this.openScreen(new PresenceEditorGui(this.getInstanceData().presenceData, this.getDefaultData().presenceData, true, output -> this.getInstanceData().presenceData.transferFrom((Module)output))), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.hover.presence_editor", new Object[0]))), new String[0]));
        this.childFrame.addControl((IGuiEventListener)new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getButtonY(1), 180, 20, Constants.TRANSLATOR.translate("gui.config.name.display.dynamic_icons", new Object[0]), () -> this.openScreen((ExtendedScreen)new DynamicSelectorGui(Constants.TRANSLATOR.translate("gui.config.title.selector.icon", new Object[0]), DiscordAssetUtils.CUSTOM_ASSET_LIST.keySet(), null, null, true, true, DynamicScrollableList.RenderType.CustomDiscordAsset, null, (currentValue, parentScreen) -> this.openScreen(new DynamicEditorGui((String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.primaryText = Constants.TRANSLATOR.translate("gui.config.message.editor.url", new Object[0]);
            screenInstance.maxPrimaryLength = Short.MAX_VALUE;
            screenInstance.secondaryText = Constants.TRANSLATOR.translate("gui.config.message.editor.label", new Object[0]);
            screenInstance.maxSecondaryLength = 32;
            screenInstance.originalPrimaryMessage = "";
            screenInstance.primaryMessage = "";
        }, (attributeName, screenInstance) -> {
            screenInstance.primaryText = Constants.TRANSLATOR.translate("gui.config.message.editor.url", new Object[0]);
            screenInstance.maxPrimaryLength = Short.MAX_VALUE;
            screenInstance.secondaryText = Constants.TRANSLATOR.translate("gui.config.message.editor.label", new Object[0]);
            screenInstance.maxSecondaryLength = 32;
            screenInstance.setScreenTitle(Constants.TRANSLATOR.translate("gui.config.title.display.edit_specific_icon", new Object[]{attributeName}));
            screenInstance.originalPrimaryMessage = "";
            screenInstance.primaryMessage = this.getInstanceData().dynamicIcons.getOrDefault(attributeName, screenInstance.originalPrimaryMessage);
        }, screenInstance -> {
            String attributeName = screenInstance.getSecondaryEntry();
            String inputText = screenInstance.getPrimaryEntry();
            this.getInstanceData().dynamicIcons.put(attributeName, inputText);
            DiscordAsset asset = new DiscordAsset().setName(attributeName).setUrl(inputText).setType(DiscordAsset.AssetType.CUSTOM);
            if (!DiscordAssetUtils.CUSTOM_ASSET_LIST.containsKey(asset.getName())) {
                DiscordAssetUtils.CUSTOM_ASSET_LIST.put(asset.getName(), asset);
            }
            DiscordAssetUtils.ASSET_LIST.put(asset.getName(), asset);
        }, screenInstance -> {
            String attributeName = screenInstance.getSecondaryEntry();
            this.getInstanceData().dynamicIcons.remove(attributeName);
            if (DiscordAssetUtils.CUSTOM_ASSET_LIST.containsKey(attributeName)) {
                DiscordAssetUtils.CUSTOM_ASSET_LIST.remove(attributeName);
                DiscordAssetUtils.ASSET_LIST.remove(attributeName);
            }
        }, null, (attributeName, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.display.dynamic_icons", new Object[0]))), (attributeName, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.display.dynamic_icons", new Object[0])))), (Screen)parentScreen))), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.display.dynamic_icons", new Object[0]))), new String[0]));
        this.childFrame.addControl((IGuiEventListener)new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getButtonY(2), 180, 20, Constants.TRANSLATOR.translate("gui.config.name.display.dynamic_variables", new Object[0]), () -> this.openScreen((ExtendedScreen)new DynamicSelectorGui(Constants.TRANSLATOR.translate("gui.config.title.selector.item", new Object[0]), this.getInstanceData().dynamicVariables.keySet(), null, null, true, true, DynamicScrollableList.RenderType.None, null, (currentValue, parentScreen) -> this.openScreen(new DynamicEditorGui((String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.maxPrimaryLength = Short.MAX_VALUE;
            screenInstance.maxSecondaryLength = 32;
            screenInstance.originalPrimaryMessage = "";
            screenInstance.primaryMessage = "";
        }, (attributeName, screenInstance) -> {
            screenInstance.maxPrimaryLength = Short.MAX_VALUE;
            screenInstance.maxSecondaryLength = 32;
            screenInstance.setScreenTitle(Constants.TRANSLATOR.translate("gui.config.title.item.edit_specific_item", new Object[]{attributeName}));
            screenInstance.originalPrimaryMessage = "";
            screenInstance.primaryMessage = this.getInstanceData().dynamicVariables.getOrDefault(attributeName, screenInstance.originalPrimaryMessage);
        }, screenInstance -> {
            String attributeName = screenInstance.getSecondaryEntry();
            String inputText = screenInstance.getPrimaryEntry();
            this.getInstanceData().dynamicVariables.put(attributeName, inputText);
        }, screenInstance -> {
            String attributeName = screenInstance.getSecondaryEntry();
            this.getInstanceData().dynamicVariables.remove(attributeName);
        }, null, (attributeName, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.display.dynamic_variables", new Object[0]))), (attributeName, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.display.dynamic_variables", new Object[0])))), (Screen)parentScreen))), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.display.dynamic_variables", new Object[0]))), new String[0]));
        this.visualizer.setupVisualizer(3, true, (ExtendedScreen)this.childFrame, () -> CraftPresence.CLIENT.PRESENCE);
    }

    public void postRender() {
        super.postRender();
        this.visualizer.postRender((ExtendedScreen)this.childFrame);
    }

    @Override
    protected boolean allowedToReset() {
        return true;
    }

    @Override
    protected Display getInstanceData() {
        return this.INSTANCE;
    }

    @Override
    protected Display getCurrentData() {
        return CraftPresence.CONFIG.displaySettings;
    }

    @Override
    protected Display getDefaultData() {
        this.DEFAULTS.dynamicIcons = this.getCurrentData().dynamicIcons;
        return this.DEFAULTS;
    }
}

