/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.core.config.migration;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.Config;
import com.gitlab.cdagaming.craftpresence.core.config.Module;
import com.gitlab.cdagaming.craftpresence.core.config.migration.DataMigrator;
import com.google.gson.JsonElement;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class TextReplacer
implements DataMigrator {
    private static final Pattern EXPR_PATTERN = Pattern.compile("\\{[^{}]*}");
    final Map<String, String> replacers;
    final boolean placeholderMode;

    public TextReplacer(Map<String, String> replacers, boolean placeholderMode) {
        this.replacers = StringUtils.newHashMap(replacers);
        this.placeholderMode = placeholderMode;
    }

    @Override
    public Config apply(Config instance, JsonElement rawJson, Object ... args) {
        this.processElement(instance, rawJson, new String[0]);
        return instance;
    }

    private String doReplacement(String match, Map<String, String> replacers) {
        String result = match;
        if (!StringUtils.isNullOrEmpty((String)match) && !replacers.isEmpty()) {
            for (Map.Entry<String, String> entry : replacers.entrySet()) {
                result = result.replace(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    private String processReplacement(String original) {
        String result = original;
        if (this.placeholderMode) {
            List expressions = StringUtils.getMatches((Pattern)EXPR_PATTERN, (String)original);
            if (!expressions.isEmpty()) {
                for (String match : expressions) {
                    result = result.replace(match, this.doReplacement(match, this.replacers));
                }
            }
        } else {
            result = this.doReplacement(result, this.replacers);
        }
        return result;
    }

    private JsonElement processElement(Config instance, JsonElement rawJson, String ... path) {
        String pathPrefix = String.join((CharSequence)".", path);
        if (!StringUtils.isNullOrEmpty((String)pathPrefix)) {
            pathPrefix = TextReplacer.jvmdowngrader$concat$processElement$1(pathPrefix);
        }
        if (rawJson != null) {
            for (Map.Entry entry : rawJson.getAsJsonObject().entrySet()) {
                String rawName = TextReplacer.jvmdowngrader$concat$processElement$1(pathPrefix, (String)entry.getKey());
                List configPath = StringUtils.newArrayList((Object[])path);
                configPath.add((String)entry.getKey());
                String[] pathData = configPath.toArray(new String[0]);
                Object defaultValue = instance.getDefaults().findProperty(pathData);
                Object currentValue = instance.findProperty(pathData);
                boolean shouldContinue = true;
                if (defaultValue == null) {
                    if (currentValue == null) {
                        shouldContinue = false;
                    } else {
                        defaultValue = currentValue;
                    }
                }
                if (!shouldContinue) continue;
                if (Module.class.isAssignableFrom(defaultValue.getClass())) {
                    List paths = StringUtils.newArrayList((Object[])path);
                    paths.add((String)entry.getKey());
                    this.processElement(instance, (JsonElement)entry.getValue(), paths.toArray(new String[0]));
                    continue;
                }
                if (currentValue instanceof String) {
                    String originalResult = (String)currentValue;
                    String processResult = this.processReplacement(originalResult);
                    if (processResult.equals(originalResult)) continue;
                    Constants.LOG.debugInfo("Modified property \"%s\": \"%s\" => \"%s\"", new Object[]{rawName, originalResult, processResult});
                    instance.setProperty((Object)processResult, pathData);
                    continue;
                }
                if (!(currentValue instanceof Map)) continue;
                Map map = (Map)currentValue;
                Map newData = StringUtils.newHashMap((Map)map);
                if (!((JsonElement)entry.getValue()).isJsonObject()) continue;
                for (Object dataEntry : newData.keySet()) {
                    List paths = StringUtils.newArrayList((Object[])path);
                    paths.add((String)entry.getKey());
                    paths.add(dataEntry.toString());
                    JsonElement dataValue = ((JsonElement)entry.getValue()).getAsJsonObject().get(dataEntry.toString());
                    if (!dataValue.isJsonObject()) continue;
                    this.processElement(instance, dataValue, paths.toArray(new String[0]));
                }
            }
        }
        return rawJson;
    }

    private static String jvmdowngrader$concat$processElement$1(String string) {
        return string + ".";
    }

    private static String jvmdowngrader$concat$processElement$1(String string, String string2) {
        return string + string2;
    }
}

