/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.gui.controls;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.integrations.discord.assets.DiscordAssetUtils;
import com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import com.gitlab.cdagaming.unilib.utils.ImageUtils;
import com.gitlab.cdagaming.unilib.utils.ItemUtils;
import com.gitlab.cdagaming.unilib.utils.ResourceUtils;
import com.gitlab.cdagaming.unilib.utils.gui.RenderUtils;
import com.gitlab.cdagaming.unilib.utils.gui.controls.EntryListPane;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ScrollableListControl;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.cdagaming.unicore.impl.Pair;
import io.github.cdagaming.unicore.utils.MappingUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import unilib.external.io.github.classgraph.ClassInfo;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={IdentifierType.class, RenderType.class})
public class DynamicScrollableList
extends ScrollableListControl {
    private final RenderType renderType;
    public List<String> currentHoverText = StringUtils.newArrayList();
    private Map<String, String> entryAliases;
    private IdentifierType identifierType = IdentifierType.None;

    public DynamicScrollableList(@Nonnull Minecraft mc, ExtendedScreen currentScreen, int width, int height, int topIn, int bottomIn, int slotHeightIn, List<String> itemList, String currentValue) {
        this(mc, currentScreen, width, height, topIn, bottomIn, slotHeightIn, itemList, currentValue, RenderType.None);
    }

    public DynamicScrollableList(@Nonnull Minecraft mc, ExtendedScreen currentScreen, int width, int height, int topIn, int bottomIn, int slotHeightIn, List<String> itemList, String currentValue, RenderType renderType) {
        super(mc, currentScreen, width, height, topIn, bottomIn, slotHeightIn, itemList, currentValue);
        this.renderType = renderType;
    }

    public DynamicScrollableList(@Nonnull Minecraft mc, ExtendedScreen currentScreen, int width, int height, int topIn, int bottomIn, List<String> itemList, String currentValue, RenderType renderType) {
        this(mc, currentScreen, width, height, topIn, bottomIn, renderType.canRenderImage() ? 45 : 18, itemList, currentValue, renderType);
    }

    public DynamicScrollableList setIdentifierType(IdentifierType type) {
        this.identifierType = type;
        return this;
    }

    public Map<String, String> getEntryAliases() {
        if (this.entryAliases == null) {
            this.entryAliases = StringUtils.newHashMap();
        }
        return this.entryAliases;
    }

    public void syncEntries() {
        this.getEntryAliases().clear();
        this.clearEntries();
        Iterator iterator = StringUtils.newArrayList((Iterable)this.itemList).iterator();
        while (iterator.hasNext()) {
            String originalName;
            String displayName = originalName = (String)iterator.next();
            if (this.renderType == RenderType.EntityData && StringUtils.isValidUuid((String)originalName)) {
                String fullUuid = StringUtils.getFromUuid((String)originalName, (boolean)false);
                String trimmedUuid = StringUtils.getFromUuid((String)originalName, (boolean)true);
                displayName = CraftPresence.ENTITIES.PLAYER_BINDINGS.getOrDefault(fullUuid, trimmedUuid);
            }
            if (!originalName.equals(displayName)) {
                this.getEntryAliases().put(originalName, displayName);
            }
            ScrollableListControl.StringEntry dataEntry = new ScrollableListControl.StringEntry((ScrollableListControl)this, originalName);
            this.addEntry((EntryListPane.Entry)dataEntry);
            if (!originalName.equals(this.currentValue)) continue;
            this.setSelected(dataEntry);
        }
        if (this.getSelected() != null) {
            this.centerScrollOn((EntryListPane.Entry)((ScrollableListControl.StringEntry)this.getSelected()));
        }
    }

    public void renderSlotItem(@Nonnull MatrixStack matrices, String originalName, int xPos, int yPos, int widthIn, int heightIn, int mouseXIn, int mouseYIn, boolean isHovering, float partialTicks) {
        String identifierName;
        String message;
        Object data;
        List hoverText = StringUtils.newArrayList();
        String displayName = this.getEntryAliases().getOrDefault(originalName, originalName);
        int xOffset = xPos;
        ResourceLocation texture = ResourceUtils.getEmptyResource();
        if (this.renderType == RenderType.ServerData) {
            data = CraftPresence.SERVER.getDataFromName(originalName);
            if (data != null && !StringUtils.isNullOrEmpty((String)data.func_147409_e())) {
                String assetUrl = DynamicScrollableList.jvmdowngrader$concat$renderSlotItem$1(data.func_147409_e());
                texture = ImageUtils.getTextureFromUrl((Minecraft)this.getGameInstance(), (String)originalName, (Pair)new Pair((Object)ImageUtils.InputType.ByteStream, (Object)assetUrl));
            } else if (CraftPresence.CONFIG.advancedSettings.allowEndpointIcons && !StringUtils.isNullOrEmpty((String)CraftPresence.CONFIG.advancedSettings.serverIconEndpoint)) {
                String formattedIP = originalName.contains(":") ? StringUtils.formatAddress((String)originalName, (boolean)false) : originalName;
                String endpointUrl = CraftPresence.CLIENT.compileData(String.format(CraftPresence.CONFIG.advancedSettings.serverIconEndpoint, originalName), new Pair((Object)"server.address.short", () -> formattedIP), new Pair((Object)"server.address.full", () -> originalName)).get().toString();
                texture = ImageUtils.getTextureFromUrl((Minecraft)this.getGameInstance(), (String)originalName, (String)endpointUrl);
                if (CommandUtils.isDebugMode() && isHovering) {
                    hoverText.add(DynamicScrollableList.jvmdowngrader$concat$renderSlotItem$1(Constants.TRANSLATOR.translate("gui.config.message.editor.url", new Object[0]), endpointUrl));
                }
            }
        } else if (this.renderType == RenderType.DiscordAsset || this.renderType == RenderType.CustomDiscordAsset) {
            String assetUrl = DiscordAssetUtils.getUrl(this.renderType == RenderType.CustomDiscordAsset ? DiscordAssetUtils.CUSTOM_ASSET_LIST : DiscordAssetUtils.ASSET_LIST, originalName, CraftPresence.CLIENT::getResult);
            if (CommandUtils.isDebugMode() && isHovering) {
                hoverText.add(DynamicScrollableList.jvmdowngrader$concat$renderSlotItem$1(Constants.TRANSLATOR.translate("gui.config.message.editor.url", new Object[0]), assetUrl));
            }
            texture = ImageUtils.getTextureFromUrl((Minecraft)this.getGameInstance(), (String)originalName, (String)assetUrl);
        } else if (this.renderType == RenderType.EntityData) {
            boolean isPlayer = CraftPresence.ENTITIES.PLAYER_BINDINGS.containsKey(originalName);
            boolean isValidUuid = StringUtils.isValidUuid((String)originalName);
            if (isPlayer && CraftPresence.CONFIG.advancedSettings.allowEndpointIcons && !StringUtils.isNullOrEmpty((String)CraftPresence.CONFIG.advancedSettings.playerSkinEndpoint)) {
                String endpointUrl = CraftPresence.CLIENT.compileData(String.format(CraftPresence.CONFIG.advancedSettings.playerSkinEndpoint, originalName), new Pair((Object)"player.name", () -> originalName), new Pair((Object)"player.uuid.full", () -> isValidUuid ? StringUtils.getFromUuid((String)originalName, (boolean)false) : ""), new Pair((Object)"player.uuid.short", () -> isValidUuid ? StringUtils.getFromUuid((String)originalName, (boolean)true) : "")).get().toString();
                texture = ImageUtils.getTextureFromUrl((Minecraft)this.getGameInstance(), (String)originalName, (String)endpointUrl);
                if (CommandUtils.isDebugMode() && isHovering) {
                    hoverText.add(DynamicScrollableList.jvmdowngrader$concat$renderSlotItem$1(Constants.TRANSLATOR.translate("gui.config.message.editor.url", new Object[0]), endpointUrl));
                }
            }
        } else if (this.renderType == RenderType.ItemData && this.renderType.canRenderImage()) {
            ItemStack stack;
            data = CraftPresence.TILE_ENTITIES.TILE_ENTITY_RESOURCES;
            if (data.containsKey(originalName) && !ItemUtils.isItemEmpty((Object)(stack = (ItemStack)data.get(originalName)))) {
                RenderUtils.drawItemStack((Minecraft)this.getGameInstance(), (FontRenderer)this.getFontRenderer(), (int)xOffset, (int)(yPos + 4), (ItemStack)stack, (float)2.0f);
                xOffset += 35;
            }
        } else if (this.renderType == RenderType.Placeholder && isHovering && !StringUtils.isNullOrEmpty((String)(message = CraftPresence.CLIENT.generateArgumentMessage(originalName, false, false, CraftPresence.CONFIG.advancedSettings.allowPlaceholderPreviews, "")))) {
            hoverText.addAll(StringUtils.splitTextByNewLine((String)message));
        }
        if (this.renderType.canRenderImage() && ResourceUtils.isValidResource((ResourceLocation)texture)) {
            double yOffset = (double)yPos + 4.5;
            double size = 32.0;
            RenderUtils.drawTexture((Minecraft)this.getGameInstance(), (double)xOffset, (double)((double)xOffset + 32.0), (double)yOffset, (double)(yOffset + 32.0), (double)0.0, (double)0.0, (double)1.0, (double)0.0, (double)1.0, (Object)Color.white, (Object)Color.white, (ResourceLocation)texture);
            if (CommandUtils.isDebugMode() && isHovering) {
                hoverText.add(DynamicScrollableList.jvmdowngrader$concat$renderSlotItem$1(Constants.TRANSLATOR.translate("gui.config.message.editor.texture_path", new Object[0]), String.valueOf(texture)));
            }
            xOffset += 35;
        }
        if (!(identifierName = this.identifierType.getIdentifier(originalName)).equals(displayName) && isHovering) {
            hoverText.add(DynamicScrollableList.jvmdowngrader$concat$renderSlotItem$1(Constants.TRANSLATOR.translate("gui.config.message.editor.original", new Object[0]), identifierName));
        }
        super.renderSlotItem(matrices, displayName, xOffset, yPos, widthIn, heightIn, mouseXIn, mouseYIn, isHovering, partialTicks);
        if (isHovering) {
            this.currentHoverText = hoverText;
        }
    }

    private static String jvmdowngrader$concat$renderSlotItem$1(String string) {
        return "data:image/png;base64," + string;
    }

    private static String jvmdowngrader$concat$renderSlotItem$1(String string, String string2) {
        return string + " " + string2;
    }

    @NestHost(value=DynamicScrollableList.class)
    public static enum RenderType {
        DiscordAsset,
        CustomDiscordAsset,
        ServerData,
        EntityData,
        ItemData,
        Placeholder(false),
        None(false);

        private final boolean canRenderImage;

        private RenderType() {
            this.canRenderImage = true;
        }

        private RenderType(boolean canRenderImage) {
            this.canRenderImage = canRenderImage;
        }

        public boolean canRenderImage() {
            return this.canRenderImage && !CraftPresence.CONFIG.accessibilitySettings.stripExtraGuiElements;
        }
    }

    @NestHost(value=DynamicScrollableList.class)
    public static enum IdentifierType {
        Gui,
        None;


        public String getIdentifier(String originalName) {
            String identifierName;
            switch (this.ordinal()) {
                case 0: {
                    ClassInfo target = CraftPresence.GUIS.GUI_CLASSES.get(originalName);
                    identifierName = target != null ? MappingUtils.getCanonicalName((ClassInfo)target) : originalName;
                    break;
                }
                default: {
                    identifierName = originalName;
                }
            }
            return identifierName;
        }
    }
}

