/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.core.integrations.discord;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.Config;
import com.gitlab.cdagaming.craftpresence.core.config.element.Button;
import com.gitlab.cdagaming.craftpresence.core.config.element.PresenceData;
import com.gitlab.cdagaming.craftpresence.core.impl.discord.CompiledPresence;
import com.gitlab.cdagaming.craftpresence.core.impl.discord.DiscordStatus;
import com.gitlab.cdagaming.craftpresence.core.integrations.discord.FunctionsLib;
import com.gitlab.cdagaming.craftpresence.core.integrations.discord.assets.DiscordAsset;
import com.gitlab.cdagaming.craftpresence.core.integrations.discord.assets.DiscordAssetUtils;
import com.gitlab.cdagaming.unilib.core.CoreUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import craftpresence.external.com.jagrosh.discordipc.IPCClient;
import craftpresence.external.com.jagrosh.discordipc.IPCListener;
import craftpresence.external.com.jagrosh.discordipc.entities.ActivityType;
import craftpresence.external.com.jagrosh.discordipc.entities.DiscordBuild;
import craftpresence.external.com.jagrosh.discordipc.entities.PartyPrivacy;
import craftpresence.external.com.jagrosh.discordipc.entities.RichPresence;
import craftpresence.external.com.jagrosh.discordipc.entities.User;
import craftpresence.external.com.jagrosh.discordipc.entities.pipe.PipeStatus;
import craftpresence.external.com.jagrosh.discordipc.exceptions.NoDiscordClientException;
import craftpresence.external.org.meteordev.starscript.Script;
import craftpresence.external.org.meteordev.starscript.Section;
import craftpresence.external.org.meteordev.starscript.Starscript;
import craftpresence.external.org.meteordev.starscript.compiler.Compiler;
import craftpresence.external.org.meteordev.starscript.compiler.Expr;
import craftpresence.external.org.meteordev.starscript.compiler.Parser;
import craftpresence.external.org.meteordev.starscript.utils.Error;
import craftpresence.external.org.meteordev.starscript.utils.SFunction;
import craftpresence.external.org.meteordev.starscript.utils.VariableReplacementTransformer;
import craftpresence.external.org.meteordev.starscript.value.Value;
import craftpresence.external.org.meteordev.starscript.value.ValueMap;
import craftpresence.external.org.slf4j.impl.JDK14LoggerFactory;
import io.github.cdagaming.unicore.impl.Pair;
import io.github.cdagaming.unicore.utils.ScheduleUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import io.github.cdagaming.unicore.utils.TimeUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import xyz.wagyourtail.jvmdg.version.Stub;

public class DiscordUtils {
    private final Map<String, Supplier<Value>> placeholderData = StringUtils.newConcurrentHashMap();
    private final Map<String, String> cachedImageData = StringUtils.newHashMap();
    private final List<String> forcedDataOrder = StringUtils.newArrayList((Object[])new String[]{"biome", "dimension", "item", "entity.riding", "entity.target", "server", "menu", "screen"});
    private final Map<String, Supplier<PresenceData>> forcedData = StringUtils.newConcurrentMap();
    public User CURRENT_USER;
    public User REQUESTER_USER;
    public String CURRENT_TITLE = "";
    public DiscordStatus STATUS = DiscordStatus.Closed;
    public CompiledPresence PRESENCE;
    public Supplier<Boolean> canShowPreviews = (Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$new$0(), ()Ljava/lang/Boolean;)();
    public Supplier<Boolean> canFormatWords = (Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$new$1(), ()Ljava/lang/Boolean;)();
    public Supplier<PresenceData> defaultPresence;
    public Supplier<String> defaultIconSupplier;
    public ScheduleUtils SCHEDULER;
    public String CLIENT_ID;
    public DiscordBuild PREFERRED_CLIENT = DiscordBuild.ANY;
    public boolean AUTO_REGISTER;
    public boolean UPDATE_TIMESTAMP;
    public boolean ALLOW_DUPLICATE_PACKETS;
    public int MAX_CONNECTION_ATTEMPTS;
    public String PARTY_ID;
    public int PARTY_SIZE;
    public int PARTY_MAX;
    public String JOIN_SECRET;
    public String MATCH_SECRET;
    public String SPECTATE_SECRET;
    public Starscript scriptEngine = new Starscript();
    public IPCClient ipcInstance;
    private String overrideTarget = "";
    private RichPresence currentPresence;
    private long lastStartTime;
    private boolean connectThreadActive = false;
    private int attemptsRemaining = 0;

    public void setup() {
        Runtime.getRuntime().addShutdownHook(Constants.getThreadFactory().newThread((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, shutDown(), ()V)((DiscordUtils)this)));
        this.syncPlaceholders();
        this.forcedData.clear();
        for (String key : this.forcedDataOrder) {
            this.forcedData.put(key, (Supplier<PresenceData>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$setup$2(), ()Lcom/gitlab/cdagaming/craftpresence/core/config/element/PresenceData;)());
        }
    }

    public void init(boolean debugMode, boolean verboseMode, IPCListener listener, Map<String, String> dynamicIcons) {
        this.ipcInstance = new IPCClient(Long.parseLong(this.CLIENT_ID), debugMode, verboseMode, this.AUTO_REGISTER, this.CLIENT_ID);
        this.ipcInstance.setForcedLogger(new JDK14LoggerFactory().getLogger(Constants.LOG.getLogInstance().getName()));
        if (listener != null) {
            this.ipcInstance.setListener(listener);
        }
        DiscordAssetUtils.loadAssets(this.CLIENT_ID, true, dynamicIcons);
        this.STATUS = DiscordStatus.Disconnected;
    }

    public void init(boolean debugMode, boolean verboseMode, IPCListener listener) {
        this.init(debugMode, verboseMode, listener, null);
    }

    public void init(boolean debugMode, boolean verboseMode) {
        this.init(debugMode, verboseMode, null);
    }

    public void postInit() {
        this.lastStartTime = !this.UPDATE_TIMESTAMP && this.lastStartTime > 0L ? this.lastStartTime : TimeUtils.toEpochMilli();
    }

    private void attemptConnection() {
        block4: {
            try {
                int attemptCount = this.MAX_CONNECTION_ATTEMPTS - this.attemptsRemaining + 1;
                Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.connect", new Object[]{attemptCount, this.MAX_CONNECTION_ATTEMPTS}), new Object[0]);
                if (this.PREFERRED_CLIENT != DiscordBuild.ANY) {
                    this.ipcInstance.connect(this.PREFERRED_CLIENT, DiscordBuild.ANY);
                } else {
                    this.ipcInstance.connect(new DiscordBuild[0]);
                }
                this.ipcInstance.subscribe(IPCClient.Event.ACTIVITY_JOIN);
                this.ipcInstance.subscribe(IPCClient.Event.ACTIVITY_JOIN_REQUEST);
                this.ipcInstance.subscribe(IPCClient.Event.ACTIVITY_SPECTATE);
                this.postInit();
                this.connectThreadActive = false;
            }
            catch (Exception ex) {
                if (ex.getClass() == NoDiscordClientException.class) break block4;
                String messagePrefix = Constants.TRANSLATOR.translate("gui.config.message.editor.message", new Object[0]);
                String verbosePrefix = Constants.TRANSLATOR.translate("craftpresence.logger.error.verbose", new Object[0]);
                Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.connect", new Object[0]), new Object[0]);
                Constants.LOG.printStackTrace((Throwable)ex, messagePrefix, verbosePrefix, new Appendable[0]);
                this.STATUS = DiscordStatus.Closed;
                this.connectThreadActive = false;
            }
        }
    }

    public String sanitizePlaceholders(String input, int length, String fallback) {
        return ((String)StringUtils.getOrDefault((Object)input, (Object)fallback, StringUtils.NULL_OR_EMPTY.negate().and((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$sanitizePlaceholders$3(java.lang.String java.lang.String ), (Ljava/lang/String;)Z)((String)input)).and((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$sanitizePlaceholders$4(int java.lang.String ), (Ljava/lang/String;)Z)((int)length)))).trim();
    }

    public String sanitizePlaceholders(String input, int length) {
        return this.sanitizePlaceholders(input, length, "");
    }

    @SafeVarargs
    public final Supplier<Value> compileData(String input, String overrideId, boolean plain, Pair<String, Supplier<String>> ... replacements) {
        String data = StringUtils.getOrDefault((String)input);
        if (!plain) {
            Pair<String, VariableReplacementTransformer> resultData = this.generateTransformer(data, overrideId, replacements);
            return this.getCompileResult(resultData != null ? (String)resultData.getFirst() : data, null, resultData != null ? (Expr.Visitor)resultData.getSecond() : null);
        }
        return (Supplier<Value>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$compileData$5(java.lang.String ), ()Lcraftpresence/external/org/meteordev/starscript/value/Value;)((String)data);
    }

    @SafeVarargs
    public final Pair<String, VariableReplacementTransformer> generateTransformer(String input, String overrideId, Pair<String, Supplier<String>> ... replacements) {
        this.overrideTarget = overrideId;
        if (replacements == null || replacements.length == 0) {
            return null;
        }
        VariableReplacementTransformer transformer = new VariableReplacementTransformer();
        String data = StringUtils.getOrDefault((String)input);
        for (Pair<String, Supplier<String>> replacement : replacements) {
            Supplier info;
            if (replacement == null || (info = (Supplier)replacement.getSecond()) == null) continue;
            String value = (String)info.get();
            if (this.placeholderData.containsKey(value)) {
                transformer.addReplacer((String)replacement.getFirst(), info);
                continue;
            }
            data = data.replace((CharSequence)replacement.getFirst(), !StringUtils.isNullOrEmpty((String)value) ? DiscordUtils.jvmdowngrader$concat$generateTransformer$1(value) : "null");
        }
        return new Pair((Object)data, (Object)transformer);
    }

    public Supplier<Value> getCompileResult(String data, boolean showLogging, String verbosePrefix, Appendable output, Expr.Visitor ... transforms) {
        Parser.Result result = null;
        try {
            result = Parser.parse(data);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String originalPrefix = Constants.TRANSLATOR.translate("gui.config.message.editor.original", new Object[0]);
        String messagePrefix = Constants.TRANSLATOR.translate("gui.config.message.editor.message", new Object[0]);
        if (result == null || result.hasErrors()) {
            if (result != null) {
                Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.parser", new Object[0]), new Object[0]);
                Constants.LOG.error("%1$s \"%2$s\"", new Object[]{originalPrefix, data});
                Constants.LOG.error(messagePrefix, new Object[0]);
                for (Error error : result.errors) {
                    if (output != null) {
                        try {
                            output.append(error.toString()).append('\n');
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    Constants.LOG.error(DiscordUtils.jvmdowngrader$concat$getCompileResult$1(error.toString()), new Object[0]);
                }
            }
            return (Supplier<Value>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, null_(), ()Lcraftpresence/external/org/meteordev/starscript/value/Value;)();
        }
        if (transforms != null) {
            for (Expr.Visitor transformer : transforms) {
                if (transformer == null) continue;
                result.accept(transformer);
            }
        }
        Script script = Compiler.compile(result);
        return (Supplier<Value>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$getCompileResult$6(craftpresence.external.org.meteordev.starscript.Script java.lang.Appendable java.lang.String java.lang.String boolean java.lang.String java.lang.String ), ()Lcraftpresence/external/org/meteordev/starscript/value/Value;)((DiscordUtils)this, (Script)script, (Appendable)output, (String)originalPrefix, (String)data, (boolean)showLogging, (String)messagePrefix, (String)verbosePrefix);
    }

    public Supplier<Value> getCompileResult(String data, Appendable output, Expr.Visitor ... transforms) {
        return this.getCompileResult(data, Constants.LOG.isDebugMode(), Constants.TRANSLATOR.translate("craftpresence.logger.error.verbose", new Object[0]), output, transforms);
    }

    @SafeVarargs
    public final String getResult(String input, String overrideId, boolean plain, Pair<String, Supplier<String>> ... replacements) {
        Value data = this.compileData(input, overrideId, plain, replacements).get();
        return !data.isNull() ? data.toString() : "";
    }

    @SafeVarargs
    public final Supplier<Value> compileData(String input, String overrideId, Pair<String, Supplier<String>> ... replacements) {
        return this.compileData(input, overrideId, false, replacements);
    }

    @SafeVarargs
    public final String getResult(String input, String overrideId, Pair<String, Supplier<String>> ... replacements) {
        return this.getResult(input, overrideId, false, replacements);
    }

    @SafeVarargs
    public final Supplier<Value> compileData(String input, boolean plain, Pair<String, Supplier<String>> ... replacements) {
        return this.compileData(input, null, plain, replacements);
    }

    @SafeVarargs
    public final String getResult(String input, boolean plain, Pair<String, Supplier<String>> ... replacements) {
        return this.getResult(input, null, plain, replacements);
    }

    @SafeVarargs
    public final Supplier<Value> compileData(String input, Pair<String, Supplier<String>> ... replacements) {
        return this.compileData(input, false, replacements);
    }

    @SafeVarargs
    public final String getResult(String input, Pair<String, Supplier<String>> ... replacements) {
        return this.getResult(input, false, replacements);
    }

    public Supplier<Value> compileData(String input) {
        return this.compileData(input, new Pair[]{null});
    }

    public String getResult(String input) {
        return this.getResult(input, new Pair[]{null});
    }

    public void syncTimestamp(Supplier<Long> newTimestamp, String ... args) {
        for (String argumentName : args) {
            this.syncArgument(argumentName, (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$syncTimestamp$7(java.util.function.Supplier ), ()Ljava/lang/Object;)(newTimestamp), true);
        }
    }

    public void syncTimestamp(String ... args) {
        long newTimestamp = TimeUtils.toEpochMilli();
        this.syncTimestamp((Supplier<Long>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$syncTimestamp$8(long ), ()Ljava/lang/Long;)((long)newTimestamp), args);
    }

    public String getOverrideText(PresenceData presenceData) {
        if (presenceData != null && presenceData.enabled && !presenceData.useAsMain) {
            Object result;
            String field = this.getOverrideTarget();
            if (StringUtils.isNullOrEmpty((String)field)) {
                return null;
            }
            boolean isButton = field.startsWith("button_");
            if (isButton) {
                String[] buttonInfo = field.split("\\.");
                if (!presenceData.buttons.containsKey(buttonInfo[0])) {
                    return null;
                }
                result = presenceData.buttons.get(buttonInfo[0]).getProperty(buttonInfo[1]);
            } else {
                result = presenceData.getProperty(field);
            }
            return StringUtils.getOrDefault((String)result.toString());
        }
        return null;
    }

    public String getOverrideTarget() {
        return this.overrideTarget;
    }

    public void addForcedData(String key, Supplier<PresenceData> newData) {
        if (!this.forcedData.containsKey(key)) {
            this.forcedDataOrder.add(key);
        }
        this.forcedData.put(key, newData);
    }

    public void clearForcedData(String ... args) {
        for (String argumentName : args) {
            this.addForcedData(argumentName, (Supplier<PresenceData>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$clearForcedData$9(), ()Lcom/gitlab/cdagaming/craftpresence/core/config/element/PresenceData;)());
        }
    }

    public void removeForcedData(String ... args) {
        for (String argumentName : args) {
            this.forcedDataOrder.remove(argumentName);
            this.forcedData.remove(argumentName);
        }
    }

    private ValueMap setArgument(ValueMap source, String parent, String name, Supplier<Value> supplier) {
        int dotI = name.indexOf(46);
        if (dotI >= 0) {
            ValueMap map;
            String name1 = name.substring(0, dotI);
            String name2 = name.substring(dotI + 1);
            Supplier<Value> valueSupplier = source.getRaw(name1);
            if (valueSupplier == null) {
                map = new ValueMap();
                Supplier<Value> newSupplier = (Supplier<Value>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$setArgument$10(craftpresence.external.org.meteordev.starscript.value.ValueMap ), ()Lcraftpresence/external/org/meteordev/starscript/value/Value;)((ValueMap)map);
                source.setRaw(name1, newSupplier);
                this.placeholderData.put(DiscordUtils.jvmdowngrader$concat$setArgument$1(parent, name1), newSupplier);
            } else {
                Value value = valueSupplier.get();
                if (value.isMap()) {
                    map = value.getMap();
                } else {
                    map = new ValueMap();
                    Supplier<Value> newSupplier = (Supplier<Value>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$setArgument$11(craftpresence.external.org.meteordev.starscript.value.ValueMap ), ()Lcraftpresence/external/org/meteordev/starscript/value/Value;)((ValueMap)map);
                    source.setRaw(name1, newSupplier);
                    this.placeholderData.put(DiscordUtils.jvmdowngrader$concat$setArgument$1(parent, name1), newSupplier);
                }
            }
            this.setArgument(map, DiscordUtils.jvmdowngrader$concat$setArgument$2(parent, name1), name2, supplier);
        } else {
            source.setRaw(name, supplier);
            this.placeholderData.put(DiscordUtils.jvmdowngrader$concat$setArgument$1(parent, name), supplier);
        }
        return source;
    }

    private ValueMap setArgument(ValueMap source, String name, Supplier<Value> supplier) {
        return this.setArgument(source, "", name, supplier);
    }

    public ValueMap setArgument(String argumentName, Supplier<Value> data) {
        ValueMap globals = this.scriptEngine.getGlobals();
        if (!StringUtils.isNullOrEmpty((String)argumentName)) {
            return this.setArgument(globals, argumentName, data);
        }
        return globals;
    }

    private Supplier<Value> removeArgument(ValueMap source, String parent, String name) {
        int dotI = name.indexOf(46);
        if (dotI >= 0) {
            String name1 = name.substring(0, dotI);
            String name2 = name.substring(dotI + 1);
            Supplier<Value> valueSupplier = source.getRaw(name1);
            if (valueSupplier == null) {
                return null;
            }
            Value value = valueSupplier.get();
            if (!value.isMap()) {
                this.placeholderData.remove(DiscordUtils.jvmdowngrader$concat$setArgument$1(parent, name1));
                return source.removeRaw(name1);
            }
            return this.removeArgument(value.getMap(), DiscordUtils.jvmdowngrader$concat$setArgument$2(parent, name1), name2);
        }
        this.placeholderData.remove(DiscordUtils.jvmdowngrader$concat$setArgument$1(parent, name));
        return source.removeRaw(name);
    }

    private Map<String, Supplier<Value>> removeArguments(ValueMap source, String parent, Set<String> args) {
        if (args == null || args.isEmpty()) {
            return null;
        }
        boolean hasParent = !StringUtils.isNullOrEmpty((String)parent);
        String prefix = DiscordUtils.jvmdowngrader$concat$setArgument$1(parent, hasParent ? "." : "");
        Map results = StringUtils.newHashMap();
        for (String arg : args) {
            ValueMap newMap;
            Set<String> keys;
            String path = DiscordUtils.jvmdowngrader$concat$setArgument$1(prefix, arg);
            Supplier<Value> supplier = this.getArgument(path);
            if (supplier == null) continue;
            Value value = supplier.get();
            if (value.isMap() && !(keys = (newMap = value.getMap()).keys()).isEmpty()) {
                results.putAll(this.removeArguments(newMap, path, keys));
            }
            results.put(path, this.removeArgument(source, prefix, arg));
        }
        return results;
    }

    private Map<String, Supplier<Value>> removeArguments(ValueMap source, String parent, String ... args) {
        if (args == null || args.length == 0) {
            return null;
        }
        return this.removeArguments(source, parent, StringUtils.newHashSet((Object[])args));
    }

    private Map<String, Supplier<Value>> removeArguments(ValueMap source, String ... args) {
        return this.removeArguments(source, "", args);
    }

    public Map<String, Supplier<Value>> removeArguments(String ... args) {
        return this.removeArguments(this.scriptEngine.getGlobals(), args);
    }

    public ValueMap syncArgument(String argumentName, Supplier<Object> data, boolean plain) {
        return this.setArgument(argumentName, (Supplier<Value>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$syncArgument$12(java.util.function.Supplier boolean ), ()Lcraftpresence/external/org/meteordev/starscript/value/Value;)((DiscordUtils)this, data, (boolean)plain));
    }

    public ValueMap syncArgument(String argumentName, Object data, boolean plain) {
        return this.syncArgument(argumentName, (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$syncArgument$13(java.lang.Object ), ()Ljava/lang/Object;)((Object)data), plain);
    }

    public ValueMap syncArgument(String argumentName, Supplier<Object> data) {
        return this.syncArgument(argumentName, data, false);
    }

    public ValueMap syncArgument(String argumentName, Object data) {
        return this.syncArgument(argumentName, data, false);
    }

    public ValueMap syncFunction(String argumentName, SFunction data) {
        return this.syncArgument(argumentName, data);
    }

    public void syncDynamicVariables(Map<String, String> oldData, Map<String, String> newData, Function<String, Supplier<Object>> newRetriever) {
        boolean hasOldData;
        boolean bl = hasOldData = oldData != null && !oldData.isEmpty();
        if (hasOldData) {
            for (String entry : oldData.keySet()) {
                if (newData.containsKey(entry)) continue;
                this.removeArguments(DiscordUtils.jvmdowngrader$concat$syncDynamicVariables$1(entry));
            }
        }
        for (String entry : newData.keySet()) {
            if (hasOldData && oldData.containsKey(entry)) continue;
            this.syncArgument(DiscordUtils.jvmdowngrader$concat$syncDynamicVariables$1(entry), newRetriever.apply(entry));
        }
    }

    public Object fromValue(Value data) {
        if (data.isNumber()) {
            return data.getNumber();
        }
        if (data.isBool()) {
            return data.getBool();
        }
        if (data.isMap()) {
            return data.getMap();
        }
        if (data.isFunction()) {
            return data.getFunction();
        }
        if (data.isString()) {
            return data.getString();
        }
        return data.isObject() ? data.getObject() : null;
    }

    public Value toValue(Object data, boolean plain) {
        Value value;
        Object object = data;
        int n = 0;
        switch (DiscordUtils.jvmdowngrader$switch$toValue$0(object, n)) {
            case 0: {
                Number number = (Number)object;
                value = Value.number(number.doubleValue());
                break;
            }
            case 1: {
                Boolean b = (Boolean)object;
                value = Value.bool(b);
                break;
            }
            case 2: {
                ValueMap valueMap = (ValueMap)object;
                value = Value.map(valueMap);
                break;
            }
            case 3: {
                SFunction sFunction = (SFunction)object;
                value = Value.function(sFunction);
                break;
            }
            case 4: {
                String s = (String)object;
                value = this.compileData(s, plain, new Pair[0]).get();
                break;
            }
            default: {
                value = data != null ? Value.object(data) : Value.null_();
            }
        }
        return value;
    }

    public Map<String, Supplier<Value>> getArguments(String ... args) {
        TreeMap list = StringUtils.newTreeMap();
        for (Map.Entry<String, Supplier<Value>> entry : this.placeholderData.entrySet()) {
            boolean addToList;
            String item = entry.getKey();
            Supplier<Value> data = entry.getValue();
            boolean bl = addToList = args == null || args.length < 1 || args[0] == null;
            if (!addToList) {
                for (String name : args) {
                    if (!StringUtils.isNullOrEmpty((String)name)) {
                        boolean bl2 = addToList = item.startsWith(name) || name.equalsIgnoreCase("type:all") || name.equalsIgnoreCase("all") || name.startsWith("type:") && this.matchesType(name.replaceFirst("type:", "").toLowerCase(), data.get());
                    }
                    if (addToList) break;
                }
            }
            if (!addToList) continue;
            list.put(item, data);
        }
        return list;
    }

    public boolean matchesType(String type, Value data) {
        boolean bl;
        switch (type) {
            case "function": {
                bl = data.isFunction();
                break;
            }
            case "object": {
                bl = data.isObject();
                break;
            }
            case "bool": 
            case "boolean": {
                bl = data.isBool();
                break;
            }
            case "map": {
                bl = data.isMap();
                break;
            }
            case "int": 
            case "integer": 
            case "float": 
            case "double": 
            case "number": {
                bl = data.isNumber();
                break;
            }
            case "text": 
            case "string": {
                bl = data.isString();
                break;
            }
            case "empty": 
            case "null": {
                bl = data.isNull();
                break;
            }
            case "any": 
            case "all": {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public Supplier<Value> getArgument(String key) {
        return this.placeholderData.get(key);
    }

    public List<String> getArgumentEntries(boolean formatToLower, String ... args) {
        Map<String, Supplier<Value>> list = this.getArguments(args);
        List result = StringUtils.newArrayList();
        for (String item : list.keySet()) {
            result.add(formatToLower ? item.toLowerCase() : item);
        }
        return result;
    }

    public List<String> getArgumentEntries(String ... args) {
        return this.getArgumentEntries(false, args);
    }

    public String generateArgumentMessage(boolean addExtraData, Map<String, Supplier<Value>> args, String ... formats) {
        boolean hasNoFormats;
        StringBuilder resultString = new StringBuilder(Constants.TRANSLATOR.translate("craftpresence.placeholders.notes", new Object[0]));
        resultString.append("\\n\\n").append(Constants.TRANSLATOR.translate("craftpresence.placeholders.title", new Object[0]));
        boolean bl = hasNoFormats = formats == null || formats.length < 1 || formats[0] == null;
        if (!hasNoFormats) {
            resultString.append(" (").append(String.join((CharSequence)",", formats)).append(")");
        }
        resultString.append(":");
        StringBuilder placeholderString = new StringBuilder();
        if (args != null && !args.isEmpty()) {
            for (Map.Entry<String, Supplier<Value>> argData : args.entrySet()) {
                String argumentMessage = this.generateArgumentMessage(argData.getKey(), argData.getValue(), true, true, addExtraData);
                if (StringUtils.isNullOrEmpty((String)argumentMessage)) continue;
                placeholderString.append("\\n").append(argumentMessage);
            }
        }
        if (DiscordUtils.jvmdg$inlined$isEmpty(placeholderString)) {
            placeholderString.append("\\n - N/A");
        }
        resultString.append((CharSequence)placeholderString);
        return resultString.toString();
    }

    public String generateArgumentMessage(String placeholderName, Supplier<Value> suppliedInfo, boolean requireDesc, boolean includeName, boolean addExtraData, String prefix) {
        String placeholderTranslation = DiscordUtils.jvmdowngrader$concat$generateArgumentMessage$1(placeholderName);
        boolean hasDescription = Constants.TRANSLATOR.hasTranslation(placeholderTranslation);
        if (requireDesc && !hasDescription) {
            return null;
        }
        StringBuilder placeholderString = new StringBuilder();
        String placeholderUsage = DiscordUtils.jvmdowngrader$concat$generateArgumentMessage$2(placeholderName);
        String start = prefix;
        if (includeName) {
            String placeholderFormat = " - ";
            if (hasDescription) {
                String placeholderDescription = Constants.TRANSLATOR.translate(placeholderTranslation, new Object[0]);
                placeholderFormat = DiscordUtils.jvmdowngrader$concat$generateArgumentMessage$1(placeholderName, placeholderDescription);
            } else {
                placeholderFormat = DiscordUtils.jvmdowngrader$concat$setArgument$1(placeholderFormat, placeholderName);
            }
            placeholderString.append(placeholderFormat);
            start = DiscordUtils.jvmdowngrader$concat$generateArgumentMessage$3(prefix);
        } else if (hasDescription) {
            placeholderString.append(start).append(Constants.TRANSLATOR.translate("gui.config.message.editor.description", new Object[0])).append(" \"").append(Constants.TRANSLATOR.translate(placeholderTranslation, new Object[0])).append("\"");
            start = DiscordUtils.jvmdowngrader$concat$generateArgumentMessage$3(prefix);
        }
        if (Constants.TRANSLATOR.hasTranslation(placeholderUsage)) {
            placeholderString.append(start).append(Constants.TRANSLATOR.translate("gui.config.message.editor.usage", new Object[0])).append(" \"").append(Constants.TRANSLATOR.translate(placeholderUsage, new Object[0])).append("\"");
            start = DiscordUtils.jvmdowngrader$concat$generateArgumentMessage$3(prefix);
        }
        if (suppliedInfo != null && addExtraData && this.isDefaultPlaceholder(placeholderName.toLowerCase())) {
            Value rawValue = suppliedInfo.get();
            String tagValue = rawValue.toString();
            if (!(rawValue.isNull() || rawValue.isFunction() || StringUtils.isNullOrEmpty((String)tagValue))) {
                placeholderString.append(start).append(Constants.TRANSLATOR.translate("gui.config.message.editor.preview", new Object[0])).append(" \"").append(tagValue.length() >= 128 ? "<...>" : tagValue).append("\"");
            }
        }
        return placeholderString.toString();
    }

    public String generateArgumentMessage(String placeholderName, boolean requireDesc, boolean includeName, boolean addExtraData, String prefix) {
        return this.generateArgumentMessage(placeholderName, this.getArgument(placeholderName), requireDesc, includeName, addExtraData, prefix);
    }

    public String generateArgumentMessage(String placeholderName, Supplier<Value> suppliedInfo, boolean requireDesc, boolean includeName, boolean addExtraData) {
        return this.generateArgumentMessage(placeholderName, suppliedInfo, requireDesc, includeName, addExtraData, " ==> ");
    }

    public String generateArgumentMessage(String placeholderName, boolean requireDesc, boolean includeName, boolean addExtraData) {
        return this.generateArgumentMessage(placeholderName, requireDesc, includeName, addExtraData, " ==> ");
    }

    public boolean isDefaultPlaceholder(String name) {
        return !name.startsWith("custom.") && !name.endsWith(".message") && !name.endsWith(".icon");
    }

    public String generateArgumentMessage(boolean addExtraData, String ... formats) {
        return this.generateArgumentMessage(addExtraData, this.getArguments(formats), formats);
    }

    public String generateArgumentMessage(String ... formats) {
        return this.generateArgumentMessage((boolean)this.canShowPreviews.get(), formats);
    }

    public void syncPlaceholders() {
        FunctionsLib.init(this);
        this.syncArgument("general.mods", (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getModCount(), ()Ljava/lang/Object;)(), true);
        this.syncArgument("data.general.version", (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$syncPlaceholders$14(), ()Ljava/lang/Object;)(), true);
        this.syncArgument("data.general.protocol", (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$syncPlaceholders$15(), ()Ljava/lang/Object;)(), true);
        this.syncTimestamp((Supplier<Long>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$syncPlaceholders$16(), ()Ljava/lang/Long;)((DiscordUtils)this), "data.general.time");
    }

    public boolean addEndpointIcon(Config config, String endpoint, String name, String key, boolean filterToMain) {
        boolean canUseEndpointIcon;
        boolean bl = canUseEndpointIcon = !config.hasChanged() && config.advancedSettings.allowEndpointIcons && !StringUtils.isNullOrEmpty((String)endpoint);
        if (canUseEndpointIcon && !config.displaySettings.dynamicIcons.containsKey(name)) {
            config.displaySettings.dynamicIcons.put(name, this.compileData(String.format(endpoint, StringUtils.getOrDefault((String)key, (String)name))).get().toString());
            if (filterToMain) {
                DiscordAssetUtils.syncCustomAssets(config.displaySettings.dynamicIcons);
                config.save();
            }
        }
        return canUseEndpointIcon;
    }

    public boolean addEndpointIcon(Config config, String endpoint, String name, String key) {
        return this.addEndpointIcon(config, endpoint, name, key, false);
    }

    public boolean addEndpointIcon(Config config, String endpoint, String name, boolean filterToMain) {
        return this.addEndpointIcon(config, endpoint, name, "", filterToMain);
    }

    public boolean addEndpointIcon(Config config, String endpoint, String name) {
        return this.addEndpointIcon(config, endpoint, name, false);
    }

    public void updatePresence(RichPresence presence) {
        if (!(this.isConnected() || this.isClosed() || this.connectThreadActive)) {
            Constants.getThreadFactory().newThread((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$updatePresence$17(), ()V)((DiscordUtils)this)).start();
            this.connectThreadActive = true;
        }
        if (this.isConnected() && (this.ALLOW_DUPLICATE_PACKETS || !Objects.equals(presence, this.currentPresence))) {
            this.ipcInstance.sendRichPresence(presence);
            this.currentPresence = presence;
        }
    }

    public void updatePresence() {
        this.updatePresence(this.buildRichPresence());
    }

    public String imageOf(boolean allowNull, boolean showLogging, String ... evalStrings) {
        String result;
        if (!DiscordAssetUtils.ASSET_LIST.isEmpty() && !StringUtils.isNullOrEmpty((String)evalStrings[0])) {
            String primaryKey = evalStrings[0];
            if (!this.cachedImageData.containsKey(primaryKey)) {
                String defaultIcon = "";
                if (!allowNull) {
                    if (this.defaultIconSupplier != null) {
                        defaultIcon = DiscordAssetUtils.getKey(this.defaultIconSupplier.get());
                    }
                    defaultIcon = StringUtils.getOrDefault((String)defaultIcon, (String)DiscordAssetUtils.getRandomAssetName());
                }
                String finalKey = defaultIcon;
                int i = 0;
                while (i < evalStrings.length) {
                    String currentString = evalStrings[i];
                    boolean isPrimaryEntry = currentString.equals(primaryKey);
                    if (!StringUtils.isNullOrEmpty((String)currentString) && currentString.startsWith("{") && currentString.endsWith("}")) {
                        finalKey = currentString;
                        break;
                    }
                    DiscordAsset foundAsset = DiscordAssetUtils.get(currentString);
                    if (foundAsset != null) {
                        finalKey = foundAsset.getName();
                        if (!showLogging || isPrimaryEntry) break;
                        Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.discord.assets.fallback", new Object[]{primaryKey, finalKey}), new Object[0]);
                        break;
                    }
                    if (++i < evalStrings.length) {
                        if (!showLogging) continue;
                        Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.discord.assets.fallback", new Object[]{currentString, evalStrings[i]}), new Object[0]);
                        if (!isPrimaryEntry) continue;
                        Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.discord.assets.request", new Object[]{currentString}), new Object[0]);
                        continue;
                    }
                    if (showLogging) {
                        Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.error.discord.assets.default", new Object[]{primaryKey, defaultIcon}), new Object[0]);
                    }
                    finalKey = defaultIcon;
                }
                this.cachedImageData.put(primaryKey, finalKey);
                result = finalKey;
            } else {
                result = this.cachedImageData.get(primaryKey);
            }
        } else {
            result = "";
        }
        return result;
    }

    public String imageOf(boolean allowNull, String ... evalStrings) {
        return this.imageOf(allowNull, true, evalStrings);
    }

    public void acceptJoinRequest() {
        this.respondToJoinRequest(IPCClient.ApprovalMode.ACCEPT);
    }

    public void denyJoinRequest() {
        this.respondToJoinRequest(IPCClient.ApprovalMode.DENY);
    }

    public void clearPartyData() {
        this.denyJoinRequest();
        this.JOIN_SECRET = null;
        this.PARTY_ID = null;
        this.PARTY_SIZE = 0;
        this.PARTY_MAX = 0;
    }

    public void clearPresenceData() {
        this.PRESENCE = null;
        this.clearPartyData();
    }

    public void shutDown(boolean allowReconnects) {
        if (this.isAvailable()) {
            try {
                this.ipcInstance.close();
            }
            catch (Throwable ex) {
                Constants.LOG.debugError(ex);
            }
            this.currentPresence = null;
            this.clearPresenceData();
            this.STATUS = allowReconnects ? DiscordStatus.Disconnected : DiscordStatus.Closed;
            this.CURRENT_USER = null;
            this.CURRENT_TITLE = "";
            this.cachedImageData.clear();
            Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.shutdown", new Object[0]), new Object[0]);
        }
    }

    public void shutDown() {
        this.shutDown(false);
    }

    public Pair<CompiledPresence, RichPresence> compilePresence(PresenceData configData, boolean useAsMain) {
        long endTimestamp;
        long startTimestamp;
        String largeImageKey;
        if (useAsMain && (!this.isAvailable() || !this.isConnected() || this.connectThreadActive || configData == null)) {
            return null;
        }
        boolean formatWords = this.canFormatWords.get();
        ActivityType activityType = ActivityType.from(configData.activityType % ActivityType.values().length);
        PartyPrivacy partyPrivacy = PartyPrivacy.from(configData.partyPrivacy % PartyPrivacy.values().length);
        boolean isInstance = configData.isInstance;
        String details = StringUtils.formatWord((String)this.getResult(configData.details, "details", new Pair[0]), (!formatWords ? 1 : 0) != 0, (boolean)true, (int)1);
        String state = StringUtils.formatWord((String)this.getResult(configData.gameState, "gameState", new Pair[0]), (!formatWords ? 1 : 0) != 0, (boolean)true, (int)1);
        String rawLargeImage = this.getResult(configData.largeImageKey, "largeImageKey", new Pair[0]);
        String rawSmallImage = this.getResult(configData.smallImageKey, "smallImageKey", new Pair[0]);
        DiscordAsset largeAsset = DiscordAssetUtils.get(rawLargeImage);
        DiscordAsset smallAsset = DiscordAssetUtils.get(rawSmallImage);
        String string = largeAsset != null ? (largeAsset.getType().equals((Object)DiscordAsset.AssetType.CUSTOM) ? this.getResult(largeAsset.getUrl()) : largeAsset.getName()) : (largeImageKey = rawLargeImage);
        String smallImageKey = smallAsset != null ? (smallAsset.getType().equals((Object)DiscordAsset.AssetType.CUSTOM) ? this.getResult(smallAsset.getUrl()) : smallAsset.getName()) : rawSmallImage;
        String largeImageText = StringUtils.formatWord((String)this.getResult(configData.largeImageText, "largeImageText", new Pair[0]), (!formatWords ? 1 : 0) != 0, (boolean)true, (int)1);
        String smallImageText = StringUtils.formatWord((String)this.getResult(configData.smallImageText, "smallImageText", new Pair[0]), (!formatWords ? 1 : 0) != 0, (boolean)true, (int)1);
        Pair startData = StringUtils.getValidLong((String)this.getResult(configData.startTimestamp, "startTimestamp", new Pair[0]));
        if (((Boolean)startData.getFirst()).booleanValue()) {
            startTimestamp = (Long)startData.getSecond();
            Pair endData = StringUtils.getValidLong((String)this.getResult(configData.endTimestamp, "endTimestamp", new Pair[0]));
            endTimestamp = (Boolean)endData.getFirst() != false ? (Long)endData.getSecond() : 0L;
        } else {
            startTimestamp = 0L;
            endTimestamp = 0L;
        }
        JsonArray buttons = new JsonArray();
        if (!useAsMain || StringUtils.isNullOrEmpty((String)this.JOIN_SECRET) && StringUtils.isNullOrEmpty((String)this.MATCH_SECRET) && StringUtils.isNullOrEmpty((String)this.SPECTATE_SECRET)) {
            for (Map.Entry<String, Button> buttonElement : configData.buttons.entrySet()) {
                if (buttons.size() >= 2) break;
                JsonObject buttonObj = new JsonObject();
                String overrideId = buttonElement.getKey();
                Button button = buttonElement.getValue();
                if (StringUtils.isNullOrEmpty((String)overrideId) || StringUtils.isNullOrEmpty((String)button.label)) continue;
                String label = StringUtils.formatWord((String)this.getResult(button.label, DiscordUtils.jvmdowngrader$concat$compilePresence$1(overrideId), new Pair[0]), (!formatWords ? 1 : 0) != 0, (boolean)true, (int)1);
                String url = !StringUtils.isNullOrEmpty((String)button.url) ? this.getResult(button.url, DiscordUtils.jvmdowngrader$concat$compilePresence$2(overrideId), new Pair[0]) : "";
                label = this.sanitizePlaceholders(label, 32);
                url = this.sanitizePlaceholders(url, 512);
                if (StringUtils.isNullOrEmpty((String)label) || StringUtils.isNullOrEmpty((String)url)) continue;
                buttonObj.addProperty("label", label);
                buttonObj.addProperty("url", url);
                buttons.add(buttonObj);
            }
        }
        state = this.sanitizePlaceholders(state, 128);
        details = this.sanitizePlaceholders(details, 128);
        largeImageKey = this.sanitizePlaceholders(largeImageKey, 256);
        largeImageText = this.sanitizePlaceholders(largeImageText, 128);
        smallImageKey = this.sanitizePlaceholders(smallImageKey, 256);
        smallImageText = this.sanitizePlaceholders(smallImageText, 128);
        RichPresence.Builder newRPCData = new RichPresence.Builder().setActivityType(activityType).setState(state).setDetails(details).setStartTimestamp(startTimestamp).setEndTimestamp(endTimestamp).setLargeImage(largeImageKey, largeImageText).setSmallImage(smallImageKey, smallImageText).setButtons(buttons).setInstance(isInstance);
        state = StringUtils.convertString((String)state, (String)"UTF-8", (boolean)false);
        details = StringUtils.convertString((String)details, (String)"UTF-8", (boolean)false);
        largeImageKey = StringUtils.convertString((String)largeImageKey, (String)"UTF-8", (boolean)false);
        smallImageKey = StringUtils.convertString((String)smallImageKey, (String)"UTF-8", (boolean)false);
        largeImageText = StringUtils.convertString((String)largeImageText, (String)"UTF-8", (boolean)false);
        smallImageText = StringUtils.convertString((String)smallImageText, (String)"UTF-8", (boolean)false);
        CompiledPresence data = new CompiledPresence(activityType, partyPrivacy, details, state, rawLargeImage, rawSmallImage, largeAsset, smallAsset, largeImageKey, smallImageKey, largeImageText, smallImageText, startTimestamp, endTimestamp, buttons, isInstance, useAsMain);
        if (useAsMain) {
            this.PRESENCE = data;
            this.PARTY_ID = this.sanitizePlaceholders(this.PARTY_ID, 128);
            this.MATCH_SECRET = this.sanitizePlaceholders(this.MATCH_SECRET, 128);
            this.JOIN_SECRET = this.sanitizePlaceholders(this.JOIN_SECRET, 128);
            this.SPECTATE_SECRET = this.sanitizePlaceholders(this.SPECTATE_SECRET, 128);
            newRPCData.setParty(this.PARTY_ID, this.PARTY_SIZE, this.PARTY_MAX, partyPrivacy).setMatchSecret(this.MATCH_SECRET).setJoinSecret(this.JOIN_SECRET).setSpectateSecret(this.SPECTATE_SECRET);
        }
        return new Pair((Object)data, (Object)newRPCData.build());
    }

    public CompiledPresence compilePresence(PresenceData configData) {
        Pair<CompiledPresence, RichPresence> data = this.compilePresence(configData, false);
        return data == null ? null : (CompiledPresence)data.getFirst();
    }

    public CompiledPresence compilePresence() {
        return this.compilePresence(this.getPresenceData());
    }

    public RichPresence buildRichPresence(PresenceData configData) {
        Pair<CompiledPresence, RichPresence> data = this.compilePresence(configData, true);
        return data == null ? null : (RichPresence)data.getSecond();
    }

    public RichPresence buildRichPresence() {
        return this.buildRichPresence(this.getPresenceData());
    }

    public PresenceData getPresenceData() {
        if (!this.forcedDataOrder.isEmpty() && !this.forcedData.isEmpty()) {
            PresenceData forcedPresence = null;
            for (String key : this.forcedDataOrder) {
                PresenceData presenceInfo;
                if (!this.forcedData.containsKey(key) || (presenceInfo = this.forcedData.get(key).get()) == null || !presenceInfo.enabled || !presenceInfo.useAsMain) continue;
                forcedPresence = presenceInfo;
            }
            if (forcedPresence != null) {
                return forcedPresence;
            }
        }
        return this.defaultPresence != null ? this.defaultPresence.get() : null;
    }

    public void onTick() {
        if (this.isAvailable() && this.REQUESTER_USER != null && this.SCHEDULER.TIMER <= 0) {
            this.denyJoinRequest();
        }
    }

    public boolean isAvailable() {
        return this.STATUS != DiscordStatus.Disconnected && !this.isClosed() && this.STATUS != DiscordStatus.Invalid;
    }

    public boolean isClosed() {
        return this.STATUS == DiscordStatus.Closed;
    }

    public boolean isConnected() {
        return this.ipcInstance.getStatus() == PipeStatus.CONNECTED;
    }

    public void respondToJoinRequest(IPCClient.ApprovalMode mode) {
        if (this.REQUESTER_USER != null) {
            if (this.STATUS == DiscordStatus.JoinRequest) {
                if (this.isConnected()) {
                    this.ipcInstance.respondToJoinRequest(this.REQUESTER_USER, mode);
                }
                this.STATUS = DiscordStatus.Ready;
            }
            if (this.SCHEDULER != null) {
                this.SCHEDULER.TIMER = 0;
            }
            this.REQUESTER_USER = null;
        }
    }

    private /* synthetic */ void lambda$updatePresence$17() {
        this.attemptsRemaining = this.MAX_CONNECTION_ATTEMPTS;
        while (!this.isConnected() && this.attemptsRemaining > 0) {
            this.attemptConnection();
            --this.attemptsRemaining;
        }
        if (this.attemptsRemaining <= 0) {
            Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.connect", new Object[0]), new Object[0]);
            this.STATUS = DiscordStatus.Closed;
        }
    }

    private /* synthetic */ Long lambda$syncPlaceholders$16() {
        return this.lastStartTime;
    }

    private static /* synthetic */ Object lambda$syncPlaceholders$15() {
        return CoreUtils.MCBuildProtocol;
    }

    private static /* synthetic */ Object lambda$syncPlaceholders$14() {
        return "1.3.2";
    }

    private static /* synthetic */ Object lambda$syncArgument$13(Object data) {
        return data;
    }

    private /* synthetic */ Value lambda$syncArgument$12(Supplier data, boolean plain) {
        return this.toValue(data.get(), plain);
    }

    private static /* synthetic */ Value lambda$setArgument$11(ValueMap map) {
        return Value.map(map);
    }

    private static /* synthetic */ Value lambda$setArgument$10(ValueMap map) {
        return Value.map(map);
    }

    private static /* synthetic */ PresenceData lambda$clearForcedData$9() {
        return null;
    }

    private static /* synthetic */ Long lambda$syncTimestamp$8(long newTimestamp) {
        return newTimestamp;
    }

    private static /* synthetic */ Object lambda$syncTimestamp$7(Supplier newTimestamp) {
        return Long.toString((Long)newTimestamp.get());
    }

    private /* synthetic */ Value lambda$getCompileResult$6(Script script, Appendable output, String originalPrefix, String data, boolean showLogging, String messagePrefix, String verbosePrefix) {
        Section sect;
        try {
            sect = new Starscript(this.scriptEngine).run(script);
            if (output != null) {
                script.decompile(output);
            }
        }
        catch (Throwable ex) {
            Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.compiler", new Object[0]), new Object[0]);
            Constants.LOG.error("%1$s \"%2$s\"", new Object[]{originalPrefix, data});
            Constants.LOG.printStackTrace(ex, showLogging, messagePrefix, verbosePrefix, new Appendable[]{output});
            return Value.null_();
        }
        return Value.string(sect.toString());
    }

    private static /* synthetic */ Value lambda$compileData$5(String data) {
        return Value.string(data);
    }

    private static /* synthetic */ boolean lambda$sanitizePlaceholders$4(int length, String e) {
        return StringUtils.getBytes((String)e, (String)"UTF-8").length < length;
    }

    private static /* synthetic */ boolean lambda$sanitizePlaceholders$3(String input, String e) {
        return input.length() >= 2;
    }

    private static /* synthetic */ PresenceData lambda$setup$2() {
        return null;
    }

    private static /* synthetic */ Boolean lambda$new$1() {
        return false;
    }

    private static /* synthetic */ Boolean lambda$new$0() {
        return false;
    }

    private static int jvmdowngrader$switch$toValue$0(Object object, int n) {
        int n2;
        if (n < 0 || n >= 5) {
            throw new IndexOutOfBoundsException(DiscordUtils.jvmdowngrader$concat$jvmdowngrader$switch$toValue$0$1(n, 5));
        }
        if (object == null) {
            n2 = -1;
        } else {
            switch (n) {
                case 0: {
                    if (object instanceof Number) {
                        n2 = 0;
                        break;
                    }
                }
                case 1: {
                    if (object instanceof Boolean) {
                        n2 = 1;
                        break;
                    }
                }
                case 2: {
                    if (object instanceof ValueMap) {
                        n2 = 2;
                        break;
                    }
                }
                case 3: {
                    if (object instanceof SFunction) {
                        n2 = 3;
                        break;
                    }
                }
                case 4: {
                    if (object instanceof String) {
                        n2 = 4;
                        break;
                    }
                }
                default: {
                    n2 = 5;
                }
            }
        }
        return n2;
    }

    private static String jvmdowngrader$concat$generateTransformer$1(String string) {
        return "'" + string + "'";
    }

    private static String jvmdowngrader$concat$getCompileResult$1(String string) {
        return "\t" + string;
    }

    private static String jvmdowngrader$concat$setArgument$1(String string, String string2) {
        return string + string2;
    }

    private static String jvmdowngrader$concat$setArgument$2(String string, String string2) {
        return string + string2 + ".";
    }

    private static String jvmdowngrader$concat$syncDynamicVariables$1(String string) {
        return "custom." + string;
    }

    private static String jvmdowngrader$concat$generateArgumentMessage$1(String string) {
        return "craftpresence.placeholders." + string + ".description";
    }

    private static String jvmdowngrader$concat$generateArgumentMessage$2(String string) {
        return "craftpresence.placeholders." + string + ".usage";
    }

    private static String jvmdowngrader$concat$generateArgumentMessage$1(String string, String string2) {
        return " - " + string + " = " + string2;
    }

    private static String jvmdowngrader$concat$generateArgumentMessage$3(String string) {
        return "\\n" + string;
    }

    private static String jvmdowngrader$concat$compilePresence$1(String string) {
        return string + ".label";
    }

    private static String jvmdowngrader$concat$compilePresence$2(String string) {
        return string + ".url";
    }

    private static String jvmdowngrader$concat$jvmdowngrader$switch$toValue$0$1(int n, int n2) {
        return "Index " + n + " out of bounds for length " + n2;
    }

    @Stub(excludeChild={"java/lang/String"})
    private static boolean jvmdg$inlined$isEmpty(CharSequence cs) {
        return cs.length() == 0;
    }
}

