/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.config.gui.MainGui;
import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.Config;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.config.element.PresenceData;
import com.gitlab.cdagaming.craftpresence.core.impl.Module;
import com.gitlab.cdagaming.craftpresence.core.integrations.pack.Pack;
import com.gitlab.cdagaming.craftpresence.core.integrations.pack.atlauncher.ATLauncherUtils;
import com.gitlab.cdagaming.craftpresence.core.integrations.pack.curse.CurseUtils;
import com.gitlab.cdagaming.craftpresence.core.integrations.pack.mcupdater.MCUpdaterUtils;
import com.gitlab.cdagaming.craftpresence.core.integrations.pack.modrinth.ModrinthUtils;
import com.gitlab.cdagaming.craftpresence.core.integrations.pack.multimc.MultiMCUtils;
import com.gitlab.cdagaming.craftpresence.core.integrations.pack.technic.TechnicUtils;
import com.gitlab.cdagaming.craftpresence.integrations.discord.ModFunctionsLib;
import com.gitlab.cdagaming.craftpresence.integrations.discord.ModIPCListener;
import com.gitlab.cdagaming.craftpresence.integrations.replaymod.ReplayModUtils;
import com.gitlab.cdagaming.unilib.ModUtils;
import com.gitlab.cdagaming.unilib.impl.TranslationListener;
import com.gitlab.cdagaming.unilib.impl.TranslationManager;
import com.gitlab.cdagaming.unilib.utils.GameUtils;
import com.gitlab.cdagaming.unilib.utils.KeyUtils;
import com.gitlab.cdagaming.unilib.utils.gui.RenderUtils;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import craftpresence.external.com.jagrosh.discordipc.entities.DiscordBuild;
import io.github.cdagaming.unicore.impl.Pair;
import io.github.cdagaming.unicore.impl.TreeMapBuilder;
import io.github.cdagaming.unicore.utils.FileUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import io.github.cdagaming.unicore.utils.TranslationUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={MenuStatus.class})
public class CommandUtils {
    private static final Map<String, Module> modules = new TreeMapBuilder().put((Comparable)((Object)"_biome"), (Object)CraftPresence.BIOMES).put((Comparable)((Object)"_dimension"), (Object)CraftPresence.DIMENSIONS).put((Comparable)((Object)"_item"), (Object)CraftPresence.TILE_ENTITIES).put((Comparable)((Object)"_entity"), (Object)CraftPresence.ENTITIES).put((Comparable)((Object)"_server"), (Object)CraftPresence.SERVER).put((Comparable)((Object)"_screen"), (Object)CraftPresence.GUIS).build();
    private static final Map<String, Pack> packModules = new TreeMapBuilder().put((Comparable)((Object)"atlauncher"), (Object)new ATLauncherUtils((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$static$0(), ()Ljava/lang/Boolean;)())).put((Comparable)((Object)"curse"), (Object)new CurseUtils((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$static$1(), ()Ljava/lang/Boolean;)())).put((Comparable)((Object)"multimc"), (Object)new MultiMCUtils((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$static$2(), ()Ljava/lang/Boolean;)())).put((Comparable)((Object)"mcupdater"), (Object)new MCUpdaterUtils((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$static$3(), ()Ljava/lang/Boolean;)())).put((Comparable)((Object)"technic"), (Object)new TechnicUtils((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$static$4(), ()Ljava/lang/Boolean;)())).put((Comparable)((Object)"modrinth"), (Object)new ModrinthUtils((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$static$5(), ()Ljava/lang/Boolean;)())).build();
    private static Map.Entry<String, Pack> loadedPack = null;
    private static ModuleData loadedMenu = null;
    private static MenuStatus status = MenuStatus.None;

    public static MenuStatus getMenuState() {
        return status;
    }

    public static void setMenuState(MenuStatus newState) {
        MenuStatus oldState = status;
        status = newState;
        if (oldState != newState) {
            CommandUtils.updateMenuPresence();
        }
    }

    public static void clearMenuState() {
        CommandUtils.setMenuState(MenuStatus.None);
    }

    public static void updateMenuPresence() {
        switch (status.ordinal()) {
            case 1: {
                CommandUtils.syncMenuData(CraftPresence.CONFIG.statusMessages.loadingData);
                break;
            }
            case 0: {
                CommandUtils.syncMenuData(CraftPresence.CONFIG.statusMessages.mainMenuData);
                break;
            }
            default: {
                CommandUtils.clearMenuPresence();
            }
        }
    }

    public static boolean isDebugMode() {
        return CommandUtils.isVerboseMode() || CraftPresence.CONFIG != null && CraftPresence.CONFIG.advancedSettings.debugMode;
    }

    public static boolean isVerboseMode() {
        return CraftPresence.CONFIG != null && CraftPresence.CONFIG.advancedSettings.verboseMode;
    }

    public static void syncModuleArguments() {
        for (String key : modules.keySet()) {
            String name = CommandUtils.jvmdowngrader$concat$syncModuleArguments$1(key.startsWith("_") ? "" : "_", key);
            CraftPresence.CLIENT.syncArgument(CommandUtils.jvmdowngrader$concat$syncModuleArguments$1(name), (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$syncModuleArguments$6(java.lang.String ), ()Ljava/lang/Object;)((String)key), true);
        }
    }

    public static void syncPackArguments() {
        if (loadedPack == null) {
            return;
        }
        Map.Entry<String, Pack> pack = loadedPack;
        Pack data = pack.getValue();
        if (!data.hasPackType()) {
            data.setPackType(pack.getKey());
        }
        if (data.hasPackName()) {
            Pack pack2 = data;
            Objects.requireNonNull(pack2);
            CraftPresence.CLIENT.syncArgument("pack.type", (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getPackType(), ()Ljava/lang/Object;)((Pack)pack2), true);
            Pack pack3 = data;
            Objects.requireNonNull(pack3);
            CraftPresence.CLIENT.syncArgument("pack.name", (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getPackName(), ()Ljava/lang/Object;)((Pack)pack3), true);
            CraftPresence.CLIENT.syncArgument("pack.icon", (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$syncPackArguments$7(com.gitlab.cdagaming.craftpresence.core.integrations.pack.Pack ), ()Ljava/lang/Object;)((Pack)data), true);
        }
    }

    public static void addModule(String moduleId, Module instance) {
        if (!CraftPresence.isDataLoaded) {
            modules.put(moduleId, instance);
        }
    }

    public static void addModule(String moduleId, Pack instance) {
        if (!CraftPresence.isDataLoaded) {
            packModules.put(moduleId, instance);
        }
    }

    public static void addModule(String moduleId, TranslationManager instance) {
        TranslationListener.INSTANCE.addModule(moduleId, instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadData(boolean forceUpdateRPC) {
        CraftPresence.SCHEDULER.onTick();
        CraftPresence.SCHEDULER.TICK_LOCK.lock();
        try {
            for (Module module : modules.values()) {
                if (!module.canBeLoaded()) continue;
                module.onTick();
                if (!forceUpdateRPC || !module.isInUse()) continue;
                module.updatePresence();
            }
            if (forceUpdateRPC) {
                CommandUtils.updateMenuPresence();
            }
            CommandUtils.postReload();
        }
        catch (Throwable ex) {
            String messagePrefix = Constants.TRANSLATOR.translate("gui.config.message.editor.message", new Object[0]);
            String verbosePrefix = Constants.TRANSLATOR.translate("craftpresence.logger.error.verbose", new Object[0]);
            Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.module", new Object[0]), new Object[0]);
            Constants.LOG.printStackTrace(ex, messagePrefix, verbosePrefix, new Appendable[0]);
            CraftPresence.CLIENT.shutDown();
        }
        finally {
            CraftPresence.SCHEDULER.TICK_LOCK.unlock();
            CraftPresence.SCHEDULER.postTick();
        }
    }

    public static void postReload() {
        boolean isMenuActive;
        boolean bl = isMenuActive = CommandUtils.getMenuState() != MenuStatus.None;
        if (!Constants.HAS_GAME_LOADED) {
            CommandUtils.setMenuState(MenuStatus.Loading);
        } else if (CraftPresence.player == null) {
            CommandUtils.setMenuState(MenuStatus.MainMenu);
        } else if (isMenuActive) {
            CommandUtils.clearMenuState();
        }
        CraftPresence.CLIENT.onTick();
    }

    public static void applyData(Config current, Config old) {
        boolean needsReboot = false;
        if (!current.generalSettings.clientId.equals(old.generalSettings.clientId)) {
            needsReboot = true;
        } else if (current.generalSettings.preferredClientLevel != old.generalSettings.preferredClientLevel) {
            needsReboot = true;
        } else if (current.generalSettings.resetTimeOnInit != old.generalSettings.resetTimeOnInit) {
            needsReboot = true;
        } else if (current.generalSettings.autoRegister != old.generalSettings.autoRegister) {
            needsReboot = true;
        } else if (!current.accessibilitySettings.languageId.equals(old.accessibilitySettings.languageId)) {
            Constants.TRANSLATOR.syncTranslations();
        } else if (current.advancedSettings.allowDuplicatePackets != old.advancedSettings.allowDuplicatePackets) {
            needsReboot = true;
        } else if (current.advancedSettings.maxConnectionAttempts != old.advancedSettings.maxConnectionAttempts) {
            needsReboot = true;
        }
        if (current.advancedSettings.debugMode != old.advancedSettings.debugMode || current.advancedSettings.verboseMode != old.advancedSettings.verboseMode || current.advancedSettings.refreshRate != old.advancedSettings.refreshRate) {
            CommandUtils.updateModes();
        }
        if (current.advancedSettings.enableClassGraph != old.advancedSettings.enableClassGraph) {
            CommandUtils.setupClassScan(true);
        }
        if (current.displaySettings.dynamicVariables != old.displaySettings.dynamicVariables) {
            CommandUtils.syncDynamicVariables(old.displaySettings.dynamicVariables);
        }
        if (current.accessibilitySettings.stripTranslationColors != old.accessibilitySettings.stripTranslationColors) {
            Constants.TRANSLATOR.setStripColors(current.accessibilitySettings.stripTranslationColors);
        }
        if (current.accessibilitySettings.stripTranslationFormatting != old.accessibilitySettings.stripTranslationFormatting) {
            Constants.TRANSLATOR.setStripFormatting(current.accessibilitySettings.stripTranslationFormatting);
        }
        if (needsReboot) {
            CommandUtils.setupRPC();
        }
    }

    public static void setupRPC() {
        CraftPresence.CLIENT.shutDown();
        CraftPresence.CLIENT.SCHEDULER = CraftPresence.SCHEDULER;
        CraftPresence.CLIENT.canShowPreviews = (Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$setupRPC$8(), ()Ljava/lang/Boolean;)();
        CraftPresence.CLIENT.canFormatWords = (Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$setupRPC$9(), ()Ljava/lang/Boolean;)();
        CraftPresence.CLIENT.defaultPresence = (Supplier<PresenceData>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$setupRPC$10(), ()Lcom/gitlab/cdagaming/craftpresence/core/config/element/PresenceData;)();
        CraftPresence.CLIENT.defaultIconSupplier = (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$setupRPC$11(), ()Ljava/lang/String;)();
        CraftPresence.CLIENT.CLIENT_ID = CraftPresence.CONFIG.generalSettings.clientId;
        CraftPresence.CLIENT.AUTO_REGISTER = CraftPresence.CONFIG.generalSettings.autoRegister;
        CraftPresence.CLIENT.PREFERRED_CLIENT = DiscordBuild.from(CraftPresence.CONFIG.generalSettings.preferredClientLevel);
        CraftPresence.CLIENT.UPDATE_TIMESTAMP = CraftPresence.CONFIG.generalSettings.resetTimeOnInit;
        CraftPresence.CLIENT.ALLOW_DUPLICATE_PACKETS = CraftPresence.CONFIG.advancedSettings.allowDuplicatePackets;
        CraftPresence.CLIENT.MAX_CONNECTION_ATTEMPTS = CraftPresence.CONFIG.advancedSettings.maxConnectionAttempts;
        CraftPresence.CLIENT.init(CommandUtils.isDebugMode(), CommandUtils.isVerboseMode(), new ModIPCListener(), CraftPresence.CONFIG.displaySettings.dynamicIcons);
    }

    public static void syncPlaceholders() {
        ModFunctionsLib.init(CraftPresence.CLIENT);
        CraftPresence.CLIENT.syncArgument("general.title", (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$syncPlaceholders$12(), ()Ljava/lang/Object;)(), true);
        CraftPresence.CLIENT.syncArgument("general.version", (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$syncPlaceholders$13(), ()Ljava/lang/Object;)(), true);
        CraftPresence.CLIENT.syncArgument("general.protocol", (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$syncPlaceholders$14(), ()Ljava/lang/Object;)(), true);
        CraftPresence.CLIENT.syncArgument("general.brand", (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$syncPlaceholders$15(), ()Ljava/lang/Object;)(), true);
        CraftPresence.CLIENT.syncArgument("_general.instance", (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$syncPlaceholders$16(), ()Ljava/lang/Object;)(), true);
        CraftPresence.CLIENT.syncArgument("_general.player", (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$syncPlaceholders$17(), ()Ljava/lang/Object;)(), true);
        CraftPresence.CLIENT.syncArgument("_general.world", (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$syncPlaceholders$18(), ()Ljava/lang/Object;)(), true);
        CraftPresence.CLIENT.syncArgument("_config.instance", (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$syncPlaceholders$19(), ()Ljava/lang/Object;)(), true);
        CommandUtils.syncDynamicVariables();
        CraftPresence.CLIENT.syncArgument("player.name", (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$syncPlaceholders$20(), ()Ljava/lang/Object;)(), true);
        CraftPresence.CLIENT.syncArgument("player.uuid.short", (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$syncPlaceholders$21(), ()Ljava/lang/Object;)(), true);
        CraftPresence.CLIENT.syncArgument("player.uuid.full", (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$syncPlaceholders$22(), ()Ljava/lang/Object;)(), true);
        CraftPresence.CLIENT.syncArgument("player.icon", (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$syncPlaceholders$23(), ()Ljava/lang/Object;)(), true);
        CraftPresence.CLIENT.syncArgument("general.icon", (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$syncPlaceholders$24(), ()Ljava/lang/Object;)());
        CommandUtils.syncModuleArguments();
        CommandUtils.syncPackArguments();
    }

    public static Config preInit(Config config) {
        CommandUtils.setupClassScan(config, false);
        if (config.isNewFile()) {
            config.advancedSettings.guiSettings.appendReplayData();
        }
        return config;
    }

    public static void init() {
        CommandUtils.updateModes();
        CommandUtils.addModule("craftpresence", new TranslationManager(CraftPresence.instance, Constants.TRANSLATOR.setStripColors(CraftPresence.CONFIG.accessibilitySettings.stripTranslationColors).setStripFormatting(CraftPresence.CONFIG.accessibilitySettings.stripTranslationFormatting).setLanguageSupplier((Function<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$init$25(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)())));
        for (Map.Entry<String, Pack> pack : packModules.entrySet()) {
            String type = pack.getKey();
            Pack data = pack.getValue();
            if (!data.isEnabled()) continue;
            Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.pack.init", new Object[]{type}), new Object[0]);
            if (data.load()) {
                Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.pack.loaded", new Object[]{type, data.getPackName(), data.getPackIcon()}), new Object[0]);
                loadedPack = pack;
                break;
            }
            Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.pack", new Object[]{type}), new Object[0]);
        }
        CommandUtils.registerKeybinds();
        if (Constants.hasReplayMod()) {
            CommandUtils.addModule("integration.replaymod", new ReplayModUtils());
        }
    }

    public static void registerKeybinds() {
        TranslationUtils translationUtils = Constants.TRANSLATOR;
        Objects.requireNonNull(translationUtils);
        Function<String, String> function = (Function<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$registerKeybinds$26(io.github.cdagaming.unicore.utils.TranslationUtils java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((TranslationUtils)translationUtils);
        TranslationUtils translationUtils2 = Constants.TRANSLATOR;
        Objects.requireNonNull(translationUtils2);
        KeyUtils.INSTANCE.registerKey("configKeyCode", "key.craftpresence.config_keycode.name", function, "key.category.craftpresence.controls", (Function<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$registerKeybinds$27(io.github.cdagaming.unicore.utils.TranslationUtils java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((TranslationUtils)translationUtils2), CraftPresence.CONFIG.accessibilitySettings.getDefaults().configKeyCode, CraftPresence.CONFIG.accessibilitySettings.configKeyCode, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$registerKeybinds$28(), ()Ljava/lang/String;)(), (Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$registerKeybinds$29(), ()Ljava/lang/Boolean;)(), (Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$registerKeybinds$30(), ()Ljava/lang/Boolean;)(), (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$registerKeybinds$31(), ()V)(), (BiConsumer<Integer, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$registerKeybinds$32(java.lang.Integer java.lang.Boolean ), (Ljava/lang/Integer;Ljava/lang/Boolean;)V)(), (Predicate<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$registerKeybinds$33(java.lang.Integer ), (Ljava/lang/Integer;)Z)(), (BiFunction<Throwable, Pair, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$registerKeybinds$34(java.lang.Throwable io.github.cdagaming.unicore.impl.Pair ), (Ljava/lang/Throwable;Lio/github/cdagaming/unicore/impl/Pair;)Ljava/lang/Boolean;)());
    }

    public static void onTick() {
        if (!Constants.HAS_GAME_LOADED) {
            Constants.HAS_GAME_LOADED = GameUtils.isLoaded((Minecraft)CraftPresence.instance);
        }
        CraftPresence.CLIENT.updatePresence();
    }

    public static void updateModes() {
        Constants.LOG.setDebugMode(CommandUtils.isVerboseMode());
        if (CraftPresence.CLIENT.isAvailable()) {
            CraftPresence.CLIENT.ipcInstance.setDebugMode(CommandUtils.isDebugMode());
            CraftPresence.CLIENT.ipcInstance.setVerboseLogging(CommandUtils.isVerboseMode());
        }
        if (CraftPresence.CONFIG != null) {
            CraftPresence.SCHEDULER.setRefreshRate(CraftPresence.CONFIG.advancedSettings.refreshRate);
        }
    }

    public static void syncDynamicVariables(Map<String, String> oldData) {
        CraftPresence.CLIENT.syncDynamicVariables(oldData, CraftPresence.CONFIG.displaySettings.dynamicVariables, (Function<String, Supplier<Object>>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$syncDynamicVariables$36(java.lang.String ), (Ljava/lang/String;)Ljava/util/function/Supplier;)());
    }

    public static void syncDynamicVariables() {
        CommandUtils.syncDynamicVariables(null);
    }

    public static void setupClassScan(Config config, boolean postLaunch) {
        boolean newState;
        boolean oldState = FileUtils.isClassGraphEnabled();
        boolean hasStateChanged = oldState != (newState = config.advancedSettings.enableClassGraph);
        FileUtils.setClassGraphEnabled((boolean)newState);
        if (!postLaunch || hasStateChanged) {
            if (newState) {
                FileUtils.detectClasses();
                if (postLaunch) {
                    for (Module module : modules.values()) {
                        module.queueInternalScan();
                    }
                }
            } else if (FileUtils.hasScannedClasses()) {
                FileUtils.clearClassMap((boolean)true);
            }
        }
    }

    public static void setupClassScan(boolean postLaunch) {
        CommandUtils.setupClassScan(CraftPresence.CONFIG, postLaunch);
    }

    public static void syncMenuData(ModuleData currentData) {
        if (loadedMenu == null) {
            CraftPresence.CLIENT.syncArgument("menu.message", (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$syncMenuData$37(), ()Ljava/lang/Object;)());
            CraftPresence.CLIENT.syncArgument("menu.icon", (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$syncMenuData$38(), ()Ljava/lang/Object;)());
            CraftPresence.CLIENT.addForcedData("menu", (Supplier<PresenceData>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$syncMenuData$39(), ()Lcom/gitlab/cdagaming/craftpresence/core/config/element/PresenceData;)());
        }
        loadedMenu = currentData;
        CraftPresence.CLIENT.clearPartyData();
    }

    public static void clearMenuPresence() {
        if (loadedMenu != null) {
            CraftPresence.CLIENT.clearForcedData("menu");
            CraftPresence.CLIENT.removeArguments("menu");
            loadedMenu = null;
        }
    }

    private static /* synthetic */ PresenceData lambda$syncMenuData$39() {
        return (PresenceData)Config.getProperty(loadedMenu, "data");
    }

    private static /* synthetic */ Object lambda$syncMenuData$38() {
        String currentIcon = Config.isValidProperty(loadedMenu, "iconOverride") ? loadedMenu.getIconOverride() : CraftPresence.CONFIG.generalSettings.defaultIcon;
        return CraftPresence.CLIENT.imageOf(true, currentIcon);
    }

    private static /* synthetic */ Object lambda$syncMenuData$37() {
        return Config.isValidProperty(loadedMenu, "textOverride") ? loadedMenu.getTextOverride() : "";
    }

    private static /* synthetic */ Supplier lambda$syncDynamicVariables$36(String entry) {
        return (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$syncDynamicVariables$35(java.lang.String ), ()Ljava/lang/Object;)((String)entry);
    }

    private static /* synthetic */ Object lambda$syncDynamicVariables$35(String entry) {
        return CraftPresence.CONFIG.displaySettings.dynamicVariables.get(entry);
    }

    private static /* synthetic */ Boolean lambda$registerKeybinds$34(Throwable ex, Pair keyInfo) {
        Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.keycode", new Object[]{((KeyUtils.KeyBindData)keyInfo.getSecond()).description()}), new Object[0]);
        return false;
    }

    private static /* synthetic */ boolean lambda$registerKeybinds$33(Integer vanillaBind) {
        return vanillaBind != CraftPresence.CONFIG.accessibilitySettings.configKeyCode;
    }

    private static /* synthetic */ void lambda$registerKeybinds$32(Integer keyCode, Boolean shouldSave) {
        CraftPresence.CONFIG.accessibilitySettings.configKeyCode = keyCode;
        if (shouldSave.booleanValue()) {
            CraftPresence.CONFIG.save();
        }
    }

    private static /* synthetic */ void lambda$registerKeybinds$31() {
        if (!GameUtils.isFocused((Minecraft)CraftPresence.instance) && !(GameUtils.getCurrentScreen((Minecraft)CraftPresence.instance) instanceof ExtendedScreen)) {
            RenderUtils.openScreen((Minecraft)CraftPresence.instance, (ExtendedScreen)new MainGui(), (apn)GameUtils.getCurrentScreen((Minecraft)CraftPresence.instance));
        }
    }

    private static /* synthetic */ Boolean lambda$registerKeybinds$30() {
        return !CraftPresence.CONFIG.hasChanged();
    }

    private static /* synthetic */ Boolean lambda$registerKeybinds$29() {
        return CraftPresence.CONFIG != null;
    }

    private static /* synthetic */ String lambda$registerKeybinds$28() {
        return Constants.TRANSLATOR.translate("key.craftpresence.config_keycode.description", new Object[0]);
    }

    private static /* synthetic */ String lambda$registerKeybinds$27(TranslationUtils rec$, String x$0) {
        return rec$.translate(x$0, new Object[0]);
    }

    private static /* synthetic */ String lambda$registerKeybinds$26(TranslationUtils rec$, String x$0) {
        return rec$.translate(x$0, new Object[0]);
    }

    private static /* synthetic */ String lambda$init$25(String defaultLanguage) {
        return StringUtils.getOrDefault((String)ModUtils.getLanguage((String)CraftPresence.CONFIG.accessibilitySettings.languageId), (String)defaultLanguage);
    }

    private static /* synthetic */ Object lambda$syncPlaceholders$24() {
        return CraftPresence.CONFIG.generalSettings.defaultIcon;
    }

    private static /* synthetic */ Object lambda$syncPlaceholders$23() {
        if (CraftPresence.CLIENT.addEndpointIcon(CraftPresence.CONFIG, CraftPresence.CONFIG.advancedSettings.playerSkinEndpoint, CraftPresence.username, CraftPresence.uuid, true)) {
            return CraftPresence.username;
        }
        return null;
    }

    private static /* synthetic */ Object lambda$syncPlaceholders$22() {
        String uniqueId = CraftPresence.uuid;
        return StringUtils.isValidUuid((String)uniqueId) ? StringUtils.getFromUuid((String)uniqueId, (boolean)false) : null;
    }

    private static /* synthetic */ Object lambda$syncPlaceholders$21() {
        String uniqueId = CraftPresence.uuid;
        return StringUtils.isValidUuid((String)uniqueId) ? StringUtils.getFromUuid((String)uniqueId, (boolean)true) : null;
    }

    private static /* synthetic */ Object lambda$syncPlaceholders$20() {
        return CraftPresence.username;
    }

    private static /* synthetic */ Object lambda$syncPlaceholders$19() {
        return CraftPresence.CONFIG;
    }

    private static /* synthetic */ Object lambda$syncPlaceholders$18() {
        return CraftPresence.world;
    }

    private static /* synthetic */ Object lambda$syncPlaceholders$17() {
        return CraftPresence.player;
    }

    private static /* synthetic */ Object lambda$syncPlaceholders$16() {
        return CraftPresence.instance;
    }

    private static /* synthetic */ Object lambda$syncPlaceholders$15() {
        return ModUtils.BRAND;
    }

    private static /* synthetic */ Object lambda$syncPlaceholders$14() {
        return ModUtils.MCProtocolID;
    }

    private static /* synthetic */ Object lambda$syncPlaceholders$13() {
        return "1.3.2";
    }

    private static /* synthetic */ Object lambda$syncPlaceholders$12() {
        return Constants.TRANSLATOR.translate("craftpresence.defaults.state.mc.version", new Object[]{"1.3.2"});
    }

    private static /* synthetic */ String lambda$setupRPC$11() {
        return CraftPresence.CONFIG.generalSettings.defaultIcon;
    }

    private static /* synthetic */ PresenceData lambda$setupRPC$10() {
        return CraftPresence.CONFIG.displaySettings.presenceData;
    }

    private static /* synthetic */ Boolean lambda$setupRPC$9() {
        return CraftPresence.CONFIG.advancedSettings.formatWords;
    }

    private static /* synthetic */ Boolean lambda$setupRPC$8() {
        return CraftPresence.CONFIG.advancedSettings.allowPlaceholderPreviews;
    }

    private static /* synthetic */ Object lambda$syncPackArguments$7(Pack data) {
        return CraftPresence.CLIENT.imageOf(true, data.getPackIcon(), data.getPackType());
    }

    private static /* synthetic */ Object lambda$syncModuleArguments$6(String key) {
        return modules.get(key);
    }

    private static /* synthetic */ Boolean lambda$static$5() {
        return CraftPresence.CONFIG.generalSettings.detectModrinthPack;
    }

    private static /* synthetic */ Boolean lambda$static$4() {
        return CraftPresence.CONFIG.generalSettings.detectTechnicPack;
    }

    private static /* synthetic */ Boolean lambda$static$3() {
        return CraftPresence.CONFIG.generalSettings.detectMCUpdaterInstance;
    }

    private static /* synthetic */ Boolean lambda$static$2() {
        return CraftPresence.CONFIG.generalSettings.detectMultiMCManifest;
    }

    private static /* synthetic */ Boolean lambda$static$1() {
        return CraftPresence.CONFIG.generalSettings.detectCurseManifest;
    }

    private static /* synthetic */ Boolean lambda$static$0() {
        return CraftPresence.CONFIG.generalSettings.detectATLauncherInstance;
    }

    private static String jvmdowngrader$concat$syncModuleArguments$1(String string, String string2) {
        return string + string2;
    }

    private static String jvmdowngrader$concat$syncModuleArguments$1(String string) {
        return string + ".instance";
    }

    @NestHost(value=CommandUtils.class)
    public static enum MenuStatus {
        MainMenu,
        Loading,
        None;

    }
}

