/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.core.config;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.Module;
import com.gitlab.cdagaming.craftpresence.core.config.category.Accessibility;
import com.gitlab.cdagaming.craftpresence.core.config.category.Advanced;
import com.gitlab.cdagaming.craftpresence.core.config.category.Biome;
import com.gitlab.cdagaming.craftpresence.core.config.category.Dimension;
import com.gitlab.cdagaming.craftpresence.core.config.category.Display;
import com.gitlab.cdagaming.craftpresence.core.config.category.General;
import com.gitlab.cdagaming.craftpresence.core.config.category.Server;
import com.gitlab.cdagaming.craftpresence.core.config.category.Status;
import com.gitlab.cdagaming.craftpresence.core.config.element.Button;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.config.element.PresenceData;
import com.gitlab.cdagaming.craftpresence.core.config.migration.HypherConverter;
import com.gitlab.cdagaming.craftpresence.core.config.migration.Legacy2Modern;
import com.gitlab.cdagaming.craftpresence.core.config.migration.TextReplacer;
import com.gitlab.cdagaming.unilib.core.CoreUtils;
import com.gitlab.cdagaming.unilib.core.impl.KeyConverter;
import com.gitlab.cdagaming.unilib.core.impl.TranslationConverter;
import com.google.gson.JsonElement;
import io.github.cdagaming.unicore.impl.HashMapBuilder;
import io.github.cdagaming.unicore.impl.Pair;
import io.github.cdagaming.unicore.impl.Tuple;
import io.github.cdagaming.unicore.utils.FileUtils;
import io.github.cdagaming.unicore.utils.MathUtils;
import io.github.cdagaming.unicore.utils.OSUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public final class Config
extends Module
implements Serializable {
    private static final long serialVersionUID = -4853238501768086595L;
    private static final int MC_VERSION = CoreUtils.MCBuildProtocol;
    private static final int VERSION = 6;
    private static final List<String> keyCodeTriggers = StringUtils.newArrayList((Object[])new String[]{"keycode", "keybinding"});
    private static final List<String> languageTriggers = StringUtils.newArrayList((Object[])new String[]{"language", "lang", "langId", "languageId"});
    private static final Config DEFAULT = new Config().applyDefaults();
    public int _schemaVersion = 0;
    public int _lastMCVersionId = 0;
    public General generalSettings = new General();
    public Biome biomeSettings = new Biome();
    public Dimension dimensionSettings = new Dimension();
    public Server serverSettings = new Server();
    public Status statusMessages = new Status();
    public Advanced advancedSettings = new Advanced();
    public Accessibility accessibilitySettings = new Accessibility();
    public Display displaySettings = new Display();
    private transient boolean hasChanged = false;
    private transient boolean isNewFile = false;
    private transient Consumer<Config> onApplySettings;
    private transient BiConsumer<Config, Config> onApplyFrom;
    private transient int gameVersion = MC_VERSION;

    public Config(Config other) {
        this.transferFrom(other);
    }

    public Config() {
    }

    public static Config getDefaultData() {
        return new Config(DEFAULT);
    }

    public static String getConfigPath() {
        return Config.jvmdowngrader$concat$getConfigPath$1(Constants.configDir, File.separator);
    }

    public static File getConfigFile() {
        return new File(Config.getConfigPath());
    }

    public static Pair<Config, JsonElement> read() {
        JsonElement rawJson;
        Config config;
        block2: {
            config = null;
            rawJson = null;
            try {
                config = (Config)FileUtils.getJsonData((File)Config.getConfigFile(), Config.class, (FileUtils.Modifiers[])new FileUtils.Modifiers[]{FileUtils.Modifiers.DISABLE_ESCAPES, FileUtils.Modifiers.PRETTY_PRINT});
                rawJson = (JsonElement)FileUtils.getJsonData((File)Config.getConfigFile(), JsonElement.class, (FileUtils.Modifiers[])new FileUtils.Modifiers[0]);
            }
            catch (Throwable ex) {
                if (ex.getClass() == FileNotFoundException.class || ex.getClass() == NoSuchFileException.class) break block2;
                Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.config.save", new Object[0]), new Object[0]);
                Constants.LOG.debugError(ex);
                if (Config.getConfigFile().renameTo(new File(Config.jvmdowngrader$concat$read$1(Config.getConfigPath())))) break block2;
                Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.config.backup", new Object[0]), new Object[0]);
            }
        }
        return new Pair(config, rawJson);
    }

    public static Config loadOrCreate(Function<Config, Config> onPreInit, boolean forceCreate) {
        boolean isInvalidData;
        Pair<Config, JsonElement> data = Config.read();
        Config config = (Config)data.getFirst();
        JsonElement rawJson = (JsonElement)data.getSecond();
        boolean hasNoData = config == null;
        boolean bl = isInvalidData = !hasNoData && (forceCreate || config._schemaVersion <= 0 || config._lastMCVersionId <= 0);
        if (hasNoData || isInvalidData) {
            config = hasNoData ? Config.getDefaultData() : config.getDefaults();
            config.isNewFile = true;
            config.setChanged(isInvalidData);
        }
        if (onPreInit != null) {
            config = onPreInit.apply(config);
        }
        boolean wasNewFile = config.isNewFile;
        config.handleSync(rawJson);
        if (!forceCreate) {
            config.save();
        }
        if (wasNewFile) {
            Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.config.new", new Object[0]), new Object[0]);
        } else {
            Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.config.save", new Object[0]), new Object[0]);
        }
        return config;
    }

    public static Config loadOrCreate(Function<Config, Config> onPreInit) {
        return Config.loadOrCreate(onPreInit, false);
    }

    public static Config loadOrCreate() {
        return Config.loadOrCreate(null);
    }

    public static Object getProperty(Config instance, String ... path) {
        if (instance == null) {
            return null;
        }
        return instance.findProperty(path);
    }

    public static Object getProperty(Module instance, String name) {
        if (instance == null) {
            return null;
        }
        return instance.getProperty(name);
    }

    public static boolean isValidProperty(Config instance, String ... path) {
        Object property = Config.getProperty(instance, path);
        return property != null && !StringUtils.isNullOrEmpty((String)property.toString());
    }

    public static boolean isValidProperty(Config instance, String name) {
        return Config.isValidProperty(instance, name.split("\\."));
    }

    public static boolean isValidProperty(Module instance, String name) {
        Object property = Config.getProperty(instance, name);
        return property != null && !StringUtils.isNullOrEmpty((String)property.toString());
    }

    public static int getGameVersion(Config config) {
        return config != null ? config.gameVersion : MC_VERSION;
    }

    public static int getSchemaVersion() {
        return 6;
    }

    public static Config applyDefaults(Config config, int protocol) {
        config._schemaVersion = Config.getSchemaVersion();
        config._lastMCVersionId = protocol;
        return config;
    }

    public static Config applyDefaults(Config config) {
        return Config.applyDefaults(config, MC_VERSION);
    }

    public static Config applyEvents(Config config, Consumer<Config> onApplySettings, BiConsumer<Config, Config> onApplyFrom) {
        config.onApplySettings = onApplySettings;
        config.onApplyFrom = onApplyFrom;
        return config;
    }

    public static Config setGameVersion(Config config, int version) {
        config.gameVersion = version;
        return config;
    }

    public int getGameVersion() {
        return Config.getGameVersion(this);
    }

    public Config setGameVersion(int version) {
        return Config.setGameVersion(this, version);
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void setChanged(boolean hasChanged) {
        this.hasChanged = hasChanged;
    }

    public Config applyDefaults(int protocol) {
        return Config.applyDefaults(this, protocol);
    }

    public Config applyDefaults() {
        return this.applyDefaults(MC_VERSION);
    }

    public Config applyEvents(Consumer<Config> onApplySettings, BiConsumer<Config, Config> onApplyFrom) {
        return Config.applyEvents(this, onApplySettings, onApplyFrom);
    }

    @Override
    public Config getDefaults() {
        return Config.getDefaultData();
    }

    @Override
    public Config copy() {
        return new Config(this);
    }

    @Override
    public void transferFrom(Module target) {
        if (target instanceof Config) {
            Config data = (Config)target;
            this.transferFlags(data);
            this.transferSettings(data);
        }
    }

    public void transferFlags(Config data) {
        if (!this.areFlagsEqual(data)) {
            this.hasChanged = data.hasChanged;
            this.isNewFile = data.isNewFile;
            this.onApplySettings = data.onApplySettings;
            this.onApplyFrom = data.onApplyFrom;
            this.gameVersion = data.gameVersion;
            this._schemaVersion = data._schemaVersion;
            this._lastMCVersionId = data._lastMCVersionId;
        }
    }

    public void transferSettings(Config data) {
        if (!this.areSettingsEqual(data)) {
            this.generalSettings = new General(data.generalSettings);
            this.biomeSettings = new Biome(data.biomeSettings);
            this.dimensionSettings = new Dimension(data.dimensionSettings);
            this.serverSettings = new Server(data.serverSettings);
            this.statusMessages = new Status(data.statusMessages);
            this.advancedSettings = new Advanced(data.advancedSettings);
            this.accessibilitySettings = new Accessibility(data.accessibilitySettings);
            this.displaySettings = new Display(data.displaySettings);
        }
    }

    public void applySettings() {
        if (this.hasChanged()) {
            if (this.onApplySettings != null) {
                this.onApplySettings.accept(this);
            }
            this.setChanged(false);
        }
        this.isNewFile = false;
    }

    public void applyFrom(Config old) {
        if (this.onApplyFrom != null) {
            this.onApplyFrom.accept(this, old);
        }
    }

    public JsonElement handleMigrations(JsonElement rawJson, int oldVer, int newVer) {
        if (this.isNewFile) {
            File legacyFile = new File(Config.jvmdowngrader$concat$handleMigrations$1(Constants.configDir, File.separator));
            if (legacyFile.exists()) {
                new Legacy2Modern(legacyFile, "UTF-8").apply(this, rawJson, new Object[0]);
            } else {
                Map hypherionFiles = new HashMapBuilder().put((Object)0, (Object)Config.jvmdowngrader$concat$handleMigrations$2(Constants.configDir, File.separator)).put((Object)31, (Object)Config.jvmdowngrader$concat$handleMigrations$1(OSUtils.USER_DIR, File.separator, File.separator)).put((Object)32, (Object)Config.jvmdowngrader$concat$handleMigrations$1(Constants.configDir, File.separator, File.separator)).build();
                for (Map.Entry<Integer, String> entry : hypherionFiles.entrySet()) {
                    File hypherionFile = new File(Config.jvmdowngrader$concat$handleMigrations$1((String)entry.getValue()));
                    if (!hypherionFile.exists()) continue;
                    new HypherConverter(entry).apply(this, rawJson, new Object[0]);
                    break;
                }
            }
        }
        if (!this.isNewFile) {
            int currentVer = oldVer;
            if (currentVer < newVer) {
                Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.config.outdated", new Object[]{currentVer, newVer}), new Object[0]);
                if (MathUtils.isWithinValue((double)currentVer, (double)1.0, (double)2.0, (boolean)true, (boolean)false)) {
                    boolean showTime = rawJson.getAsJsonObject().getAsJsonObject("generalSettings").getAsJsonPrimitive("showTime").getAsBoolean();
                    this.displaySettings.presenceData.startTimestamp = showTime ? "{data.general.time}" : "";
                    currentVer = 2;
                }
                if (MathUtils.isWithinValue((double)currentVer, (double)2.0, (double)3.0, (boolean)true, (boolean)false)) {
                    new TextReplacer(new HashMapBuilder().put((Object)"world.time24", (Object)"world.time.format_24").put((Object)"world.time12", (Object)"world.time.format_12").put((Object)"world.day", (Object)"world.time.day").build(), true).apply(this, rawJson, new Object[0]);
                    currentVer = 3;
                }
                if (MathUtils.isWithinValue((double)currentVer, (double)3.0, (double)4.0, (boolean)true, (boolean)false)) {
                    currentVer = 4;
                }
                if (MathUtils.isWithinValue((double)currentVer, (double)4.0, (double)5.0, (boolean)true, (boolean)false)) {
                    new TextReplacer(new HashMapBuilder().put((Object)"data.screen.class", (Object)"getClass(data.screen.instance)").build(), true).apply(this, rawJson, new Object[0]);
                    currentVer = 5;
                }
                if (MathUtils.isWithinValue((double)currentVer, (double)5.0, (double)6.0, (boolean)true, (boolean)false)) {
                    currentVer = 6;
                }
                this.save();
            }
            rawJson = (JsonElement)Config.read().getSecond();
        }
        return rawJson;
    }

    public JsonElement handleVerification(JsonElement rawJson, KeyConverter.ConversionMode keyCodeMigrationId, TranslationConverter.ConversionMode languageMigrationId, String ... path) {
        String pathPrefix = String.join((CharSequence)".", path);
        if (!StringUtils.isNullOrEmpty((String)pathPrefix)) {
            pathPrefix = Config.jvmdowngrader$concat$handleVerification$1(pathPrefix);
        }
        if (rawJson != null) {
            Object parentValue = this.findProperty(path);
            for (Map.Entry<String, JsonElement> entry : rawJson.getAsJsonObject().entrySet()) {
                String rawName = Config.jvmdowngrader$concat$handleMigrations$2(pathPrefix, entry.getKey());
                List configPath = StringUtils.newArrayList((Object[])path);
                configPath.add(entry.getKey());
                String[] pathData = configPath.toArray(new String[0]);
                JsonElement rawValue = entry.getValue();
                Object defaultValue = this.getDefaults().findProperty(pathData);
                Object currentValue = this.findProperty(pathData);
                boolean shouldReset = false;
                boolean shouldContinue = true;
                if (defaultValue == null) {
                    if (currentValue == null || !(parentValue instanceof PresenceData) && !(parentValue instanceof ModuleData) && !(parentValue instanceof Button)) {
                        Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.config.prop.invalid", new Object[]{rawName}), new Object[0]);
                        shouldContinue = false;
                    } else {
                        defaultValue = currentValue;
                    }
                }
                if (!shouldContinue) continue;
                if (Module.class.isAssignableFrom(defaultValue.getClass())) {
                    List paths = StringUtils.newArrayList((Object[])path);
                    paths.add(entry.getKey());
                    this.handleVerification(entry.getValue(), keyCodeMigrationId, languageMigrationId, paths.toArray(new String[0]));
                    continue;
                }
                if (rawName.contains("presence")) continue;
                if (!StringUtils.isNullOrEmpty((String)defaultValue.toString()) && StringUtils.isNullOrEmpty((String)currentValue.toString())) {
                    shouldReset = true;
                } else {
                    Class<?> expectedClass = currentValue.getClass();
                    if (expectedClass == Boolean.class && !StringUtils.isValidBoolean((String)rawValue.getAsString())) {
                        shouldReset = true;
                    } else if (expectedClass == Integer.class) {
                        Pair boolData = StringUtils.getValidInteger((String)rawValue.getAsString());
                        if (((Boolean)boolData.getFirst()).booleanValue()) {
                            for (String string : keyCodeTriggers) {
                                int migratedKeyCode;
                                if (!rawName.toLowerCase().contains(string.toLowerCase())) continue;
                                if (!KeyConverter.isValidKeyCode((int)((Integer)boolData.getSecond()), (int)this.getGameVersion())) {
                                    shouldReset = true;
                                    break;
                                }
                                if (keyCodeMigrationId == KeyConverter.ConversionMode.Unknown || (migratedKeyCode = KeyConverter.convertKey((int)((Integer)boolData.getSecond()), (int)this.getGameVersion(), (KeyConverter.ConversionMode)keyCodeMigrationId)) == (Integer)boolData.getSecond()) break;
                                Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.migration.apply", new Object[]{"KEYCODE", keyCodeMigrationId.name(), rawName, boolData.getSecond(), migratedKeyCode}), new Object[0]);
                                this.setProperty(migratedKeyCode, pathData);
                                break;
                            }
                        } else {
                            shouldReset = true;
                        }
                    } else if (currentValue instanceof Map) {
                        Map newData = StringUtils.newHashMap((Map)((Map)currentValue));
                        Map defaultData = StringUtils.newHashMap((Map)((Map)defaultValue));
                        if (!newData.containsKey("default")) {
                            Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.config.missing.default", new Object[]{rawName}), new Object[0]);
                            newData.putAll(defaultData);
                            this.setProperty(newData, pathData);
                        } else if (entry.getValue().isJsonObject()) {
                            for (Object dataEntry : newData.keySet()) {
                                List paths = StringUtils.newArrayList((Object[])path);
                                paths.add(entry.getKey());
                                paths.add(dataEntry.toString());
                                JsonElement dataValue = entry.getValue().getAsJsonObject().get(dataEntry.toString());
                                if (!dataValue.isJsonObject()) continue;
                                this.handleVerification(dataValue, keyCodeMigrationId, languageMigrationId, paths.toArray(new String[0]));
                            }
                        }
                    } else if (rawValue.isJsonPrimitive()) {
                        String rawStringValue = rawValue.getAsString();
                        for (String string : languageTriggers) {
                            String migratedLanguageId;
                            if (!rawName.toLowerCase().contains(string.toLowerCase())) continue;
                            if (languageMigrationId == TranslationConverter.ConversionMode.Unknown || (migratedLanguageId = TranslationConverter.convertId((String)rawStringValue, (int)this.getGameVersion(), (TranslationConverter.ConversionMode)languageMigrationId)).equals(rawStringValue)) break;
                            Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.migration.apply", new Object[]{"LANGUAGE", languageMigrationId.name(), rawName, rawStringValue, migratedLanguageId}), new Object[0]);
                            this.setProperty((Object)migratedLanguageId, pathData);
                            break;
                        }
                    }
                }
                if (!shouldReset) continue;
                Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.config.prop.empty", new Object[]{rawName}), new Object[0]);
                this.resetProperty(pathData);
            }
        }
        return rawJson;
    }

    public JsonElement handleSync(JsonElement rawJson) {
        int newMCVer;
        int oldMCVer;
        int newSchemaVer = Config.getSchemaVersion();
        if (this.isNewFile || this._schemaVersion != newSchemaVer) {
            int oldVer = this._schemaVersion;
            rawJson = this.handleMigrations(rawJson, oldVer, newSchemaVer);
            this._schemaVersion = newSchemaVer;
        }
        if ((oldMCVer = this._lastMCVersionId) != (newMCVer = this.getGameVersion())) {
            this._lastMCVersionId = newMCVer;
            this.advancedSettings.useClassLoader = Constants.USE_CLASS_LOADER;
        }
        if (CoreUtils.isTextFormattingBlocked()) {
            this.accessibilitySettings.stripTranslationFormatting = true;
        }
        KeyConverter.ConversionMode keyCodeMigrationId = oldMCVer < 341 && newMCVer >= 341 ? KeyConverter.ConversionMode.Lwjgl3 : (oldMCVer >= 341 && newMCVer < 341 ? KeyConverter.ConversionMode.Lwjgl2 : (oldMCVer >= 0 && newMCVer >= 0 ? KeyConverter.ConversionMode.None : KeyConverter.ConversionMode.Unknown));
        TranslationConverter.ConversionMode languageMigrationId = oldMCVer < 301 && newMCVer >= 301 ? TranslationConverter.ConversionMode.PackFormat3 : (oldMCVer >= 301 && newMCVer < 301 ? TranslationConverter.ConversionMode.PackFormat2 : (oldMCVer >= 0 && newMCVer >= 0 ? TranslationConverter.ConversionMode.None : TranslationConverter.ConversionMode.Unknown));
        Constants.LOG.debugInfo(Constants.TRANSLATOR.translate("craftpresence.logger.info.migration.add", new Object[]{keyCodeTriggers.toString(), keyCodeMigrationId, keyCodeMigrationId.equals((Object)KeyConverter.ConversionMode.None) ? "Verification" : "Setting Change"}), new Object[0]);
        Constants.LOG.debugInfo(Constants.TRANSLATOR.translate("craftpresence.logger.info.migration.add", new Object[]{languageTriggers.toString(), languageMigrationId, languageMigrationId.equals((Object)TranslationConverter.ConversionMode.None) ? "Verification" : "Setting Change"}), new Object[0]);
        return !this.isNewFile ? this.handleVerification(rawJson, keyCodeMigrationId, languageMigrationId, new String[0]) : rawJson;
    }

    public void save(boolean shouldApply) {
        FileUtils.writeJsonData((Object)this, (File)Config.getConfigFile(), (String)"UTF-8", (FileUtils.Modifiers[])new FileUtils.Modifiers[]{FileUtils.Modifiers.DISABLE_ESCAPES, FileUtils.Modifiers.PRETTY_PRINT});
        if (shouldApply) {
            this.applySettings();
        }
    }

    public void save() {
        this.save(true);
    }

    public Pair<Object, Tuple<Class<?>, Object, String>> lookupProperty(String ... path) {
        Class classObj = Config.class;
        Object instance = this;
        Object result = null;
        String name = null;
        for (int i = 0; i < path.length; ++i) {
            if (StringUtils.isNullOrEmpty((String)path[i])) continue;
            name = path[i];
            if (instance instanceof Map) {
                Map map = (Map)instance;
                result = StringUtils.newHashMap((Map)map).get(name);
            } else if (instance instanceof Module) {
                Module module = (Module)instance;
                result = module.getProperty(name);
            } else {
                result = StringUtils.getField(classObj, (Object)instance, (String[])new String[]{name});
            }
            if (result == null) break;
            if (i >= path.length - 1) continue;
            classObj = result.getClass();
            instance = result;
        }
        return new Pair(result, (Object)new Tuple(classObj, instance, (Object)name));
    }

    public Object findProperty(String ... path) {
        return this.lookupProperty(path).getFirst();
    }

    @Override
    public Object getProperty(String name) {
        Object object;
        switch (name) {
            case "hasChanged": {
                object = this.hasChanged;
                break;
            }
            case "isNewFile": {
                object = this.isNewFile;
                break;
            }
            case "onApplySettings": {
                object = this.onApplySettings;
                break;
            }
            case "onApplyFrom": {
                object = this.onApplyFrom;
                break;
            }
            case "gameVersion": {
                object = this.gameVersion;
                break;
            }
            case "_schemaVersion": {
                object = this._schemaVersion;
                break;
            }
            case "_lastMCVersionId": {
                object = this._lastMCVersionId;
                break;
            }
            case "generalSettings": {
                object = this.generalSettings;
                break;
            }
            case "biomeSettings": {
                object = this.biomeSettings;
                break;
            }
            case "dimensionSettings": {
                object = this.dimensionSettings;
                break;
            }
            case "serverSettings": {
                object = this.serverSettings;
                break;
            }
            case "statusMessages": {
                object = this.statusMessages;
                break;
            }
            case "advancedSettings": {
                object = this.advancedSettings;
                break;
            }
            case "accessibilitySettings": {
                object = this.accessibilitySettings;
                break;
            }
            case "displaySettings": {
                object = this.displaySettings;
                break;
            }
            default: {
                object = null;
            }
        }
        return object;
    }

    public void setProperty(Object value, String ... path) {
        Pair<Object, Tuple<Class<?>, Object, String>> propertyData = this.lookupProperty(path);
        if (propertyData.getFirst() != null) {
            Tuple fieldData = (Tuple)propertyData.getSecond();
            Object object = fieldData.getSecond();
            if (object instanceof Map) {
                Map map = (Map)object;
                String[] parentPath = Arrays.copyOf(path, path.length - 1);
                Tuple parentData = (Tuple)this.lookupProperty(parentPath).getSecond();
                Map data = StringUtils.newHashMap((Map)map);
                data.put(fieldData.getThird(), value);
                Object object2 = parentData.getSecond();
                if (object2 instanceof Module) {
                    Module module = (Module)object2;
                    module.setProperty((String)parentData.getThird(), data);
                } else {
                    StringUtils.updateField((Class)((Class)parentData.getFirst()), (Object)parentData.getSecond(), (Object)data, (String[])new String[]{(String)parentData.getThird()});
                }
            } else {
                Object object3 = fieldData.getSecond();
                if (object3 instanceof Module) {
                    Module module = (Module)object3;
                    module.setProperty((String)fieldData.getThird(), value);
                } else {
                    StringUtils.updateField((Class)((Class)fieldData.getFirst()), (Object)fieldData.getSecond(), (Object)value, (String[])new String[]{(String)fieldData.getThird()});
                }
            }
        }
    }

    @Override
    public void setProperty(String name, Object value) {
        try {
            switch (name) {
                case "hasChanged": {
                    this.hasChanged = (Boolean)value;
                    break;
                }
                case "isNewFile": {
                    this.isNewFile = (Boolean)value;
                    break;
                }
                case "onApplySettings": {
                    this.onApplySettings = (Consumer)value;
                    break;
                }
                case "onApplyFrom": {
                    this.onApplyFrom = (BiConsumer)value;
                    break;
                }
                case "gameVersion": {
                    this.gameVersion = (Integer)value;
                    break;
                }
                case "_schemaVersion": {
                    this._schemaVersion = (Integer)value;
                    break;
                }
                case "_lastMCVersionId": {
                    this._lastMCVersionId = (Integer)value;
                    break;
                }
                case "generalSettings": {
                    this.generalSettings = (General)value;
                    break;
                }
                case "biomeSettings": {
                    this.biomeSettings = (Biome)value;
                    break;
                }
                case "dimensionSettings": {
                    this.dimensionSettings = (Dimension)value;
                    break;
                }
                case "serverSettings": {
                    this.serverSettings = (Server)value;
                    break;
                }
                case "statusMessages": {
                    this.statusMessages = (Status)value;
                    break;
                }
                case "advancedSettings": {
                    this.advancedSettings = (Advanced)value;
                    break;
                }
                case "accessibilitySettings": {
                    this.accessibilitySettings = (Accessibility)value;
                    break;
                }
                case "displaySettings": {
                    this.displaySettings = (Display)value;
                    break;
                }
            }
        }
        catch (Throwable ex) {
            this.printException(ex);
        }
    }

    public void resetProperty(String ... path) {
        this.setProperty(this.getDefaults().findProperty(path), path);
    }

    public boolean areFlagsEqual(Config other) {
        return Objects.equals(other.hasChanged, this.hasChanged) && Objects.equals(other.isNewFile, this.isNewFile) && Objects.equals(other.onApplySettings, this.onApplySettings) && Objects.equals(other.onApplyFrom, this.onApplyFrom) && Objects.equals(other.gameVersion, this.gameVersion) && Objects.equals(other._schemaVersion, this._schemaVersion) && Objects.equals(other._lastMCVersionId, this._lastMCVersionId);
    }

    public boolean areSettingsEqual(Config other) {
        return Objects.equals(other.generalSettings, this.generalSettings) && Objects.equals(other.biomeSettings, this.biomeSettings) && Objects.equals(other.dimensionSettings, this.dimensionSettings) && Objects.equals(other.serverSettings, this.serverSettings) && Objects.equals(other.statusMessages, this.statusMessages) && Objects.equals(other.advancedSettings, this.advancedSettings) && Objects.equals(other.accessibilitySettings, this.accessibilitySettings) && Objects.equals(other.displaySettings, this.displaySettings);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Config)) {
            return false;
        }
        Config other = (Config)obj;
        return this.areFlagsEqual(other) && this.areSettingsEqual(other);
    }

    public int hashCode() {
        return Objects.hash(this.hasChanged, this.isNewFile, this.onApplySettings, this.onApplyFrom, this.gameVersion, this._schemaVersion, this._lastMCVersionId, this.generalSettings, this.biomeSettings, this.dimensionSettings, this.serverSettings, this.statusMessages, this.advancedSettings, this.accessibilitySettings, this.displaySettings);
    }

    private static String jvmdowngrader$concat$getConfigPath$1(String string, String string2) {
        return string + string2 + "craftpresence.json";
    }

    private static String jvmdowngrader$concat$read$1(String string) {
        return string + ".bak";
    }

    private static String jvmdowngrader$concat$handleMigrations$1(String string, String string2) {
        return string + string2 + "craftpresence.properties";
    }

    private static String jvmdowngrader$concat$handleMigrations$2(String string, String string2) {
        return string + string2;
    }

    private static String jvmdowngrader$concat$handleMigrations$1(String string, String string2, String string3) {
        return string + string2 + "simple-rpc" + string3;
    }

    private static String jvmdowngrader$concat$handleMigrations$1(String string) {
        return string + "simple-rpc.toml";
    }

    private static String jvmdowngrader$concat$handleVerification$1(String string) {
        return string + ".";
    }
}

