/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.core.config.migration;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.Config;
import com.gitlab.cdagaming.craftpresence.core.config.element.Button;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.config.migration.DataMigrator;
import com.google.gson.JsonElement;
import io.github.cdagaming.unicore.impl.HashMapBuilder;
import io.github.cdagaming.unicore.impl.Pair;
import io.github.cdagaming.unicore.impl.Tuple;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.io.File;
import java.io.InputStreamReader;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class Legacy2Modern
implements DataMigrator {
    private static final Pattern OPERATOR_PATTERN = Pattern.compile("\\{[^{}]*}[|]\\{[^{}]*}");
    private static final Pattern ARRAY_PATTERN = Pattern.compile("\\[(\\S+?)]");
    private final File configFile;
    private final String encoding;
    private final Properties properties = new Properties();
    private final Predicate<String> IS_TEXT = (Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$new$0(java.lang.String ), (Ljava/lang/String;)Z)();
    private final Predicate<String> IS_ICON = (Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$new$1(java.lang.String ), (Ljava/lang/String;)Z)();
    private final Predicate<String> IS_DIM_MODULE = (Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$new$2(java.lang.String ), (Ljava/lang/String;)Z)();
    private final Predicate<String> IS_BIOME_MODULE = (Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$new$3(java.lang.String ), (Ljava/lang/String;)Z)();
    private final Predicate<String> IS_SERVER_MODULE = (Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$new$4(java.lang.String ), (Ljava/lang/String;)Z)();
    private final Predicate<String> IS_SCREEN_MODULE = (Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$new$5(java.lang.String ), (Ljava/lang/String;)Z)();
    private final Predicate<String> IS_ITEM_MODULE = (Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$new$6(java.lang.String ), (Ljava/lang/String;)Z)();
    private final Predicate<String> IS_ENTITY_TARGET_MODULE = (Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$new$7(java.lang.String ), (Ljava/lang/String;)Z)();
    private final Predicate<String> IS_ENTITY_RIDING_MODULE = (Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$new$8(java.lang.String ), (Ljava/lang/String;)Z)();
    private final Predicate<String> IS_PLAYER_OUTER_INFO_PLACEHOLDER = (Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$new$9(java.lang.String ), (Ljava/lang/String;)Z)();
    private final Predicate<String> IS_MODS_PLACEHOLDER = (Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$new$10(java.lang.String ), (Ljava/lang/String;)Z)();
    private final Predicate<String> IS_MODPACK_PLACEHOLDER = (Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$new$11(java.lang.String ), (Ljava/lang/String;)Z)();
    private final Predicate<String> IS_PLAYER_INNER_INFO_PLACEHOLDER = (Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$new$12(java.lang.String ), (Ljava/lang/String;)Z)();
    private final Predicate<String> IS_PLAYER_COORDINATE_PLACEHOLDER = (Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$new$13(java.lang.String ), (Ljava/lang/String;)Z)();
    private final Predicate<String> IS_PLAYER_HEALTH_PLACEHOLDER = (Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$new$14(java.lang.String ), (Ljava/lang/String;)Z)();
    private final Predicate<String> IS_PLAYER_LIST_PLACEHOLDER = (Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$new$15(java.lang.String ), (Ljava/lang/String;)Z)();
    private final Predicate<String> IS_WORLD_DATA_PLACEHOLDER = (Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$new$16(java.lang.String ), (Ljava/lang/String;)Z)();
    private final Predicate<String> IS_PLAYER_ITEMS_PLACEHOLDER = (Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$new$17(java.lang.String ), (Ljava/lang/String;)Z)();
    private final List<Tuple<Pair<String, String>, Predicate<String>, Predicate<String>>> placeholderMappings = Arrays.asList(this.generatePair("&DEFAULT&", "{general.icon}", this.IS_ICON), this.generatePair("&MAINMENU&", "{menu.message}", this.IS_TEXT), this.generatePair("&MAINMENU&", "{menu.icon}", this.IS_ICON), this.generatePair("&BRAND&", "{general.brand}", this.IS_TEXT), this.generatePair("&MCVERSION&", "{general.title}", this.IS_TEXT), this.generatePair("&IGN&", "{custom.player_info_out}", this.IS_TEXT), this.generatePair("&IGN&", "{player.icon}", this.IS_ICON), this.generatePair("&IGN:NAME&", "{player.name}", this.IS_TEXT), this.generatePair("&NAME&", "{player.name}", this.IS_TEXT, this.IS_PLAYER_OUTER_INFO_PLACEHOLDER), this.generatePair("&IGN:UUID&", "{player.uuid.short}", this.IS_TEXT), this.generatePair("&UUID&", "{player.uuid.short}", this.IS_TEXT, this.IS_PLAYER_OUTER_INFO_PLACEHOLDER), this.generatePair("&IGN:UUID_FULL&", "{player.uuid.full}", this.IS_TEXT), this.generatePair("&UUID_FULL&", "{player.uuid.full}", this.IS_TEXT, this.IS_PLAYER_OUTER_INFO_PLACEHOLDER), this.generatePair("&MODS&", "{custom.mods}", this.IS_TEXT), this.generatePair("&MODS:MODCOUNT&", "{general.mods}", this.IS_TEXT), this.generatePair("&MODCOUNT&", "{general.mods}", this.IS_TEXT, this.IS_MODS_PLACEHOLDER), this.generatePair("&PACK&", "{custom.pack}", this.IS_TEXT), this.generatePair("&PACK&", "{pack.icon}", this.IS_ICON), this.generatePair("&PACK:NAME&", "{pack.name}", this.IS_TEXT), this.generatePair("&NAME&", "{pack.name}", this.IS_TEXT, this.IS_MODPACK_PLACEHOLDER), this.generatePair("&DIMENSION:DIMENSION&", "{dimension.name}", this.IS_TEXT), this.generatePair("&DIMENSION&", "{dimension.name}", this.IS_TEXT, this.IS_DIM_MODULE), this.generatePair("&DIMENSION&", "{dimension.message}", this.IS_TEXT), this.generatePair("&DIMENSION:ICON&", "{dimension.icon}", this.IS_ICON), this.generatePair("&ICON&", "{dimension.icon}", this.IS_ICON, this.IS_DIM_MODULE), this.generatePair("&DIMENSION&", "{dimension.icon}", this.IS_ICON), this.generatePair("&BIOME:BIOME&", "{biome.name}", this.IS_TEXT), this.generatePair("&BIOME&", "{biome.name}", this.IS_TEXT, this.IS_BIOME_MODULE), this.generatePair("&BIOME&", "{biome.message}", this.IS_TEXT), this.generatePair("&BIOME:ICON&", "{biome.icon}", this.IS_ICON), this.generatePair("&ICON&", "{biome.icon}", this.IS_ICON, this.IS_BIOME_MODULE), this.generatePair("&BIOME&", "{biome.icon}", this.IS_ICON), this.generatePair("&SERVER:IP&", "{server.address.short}", this.IS_TEXT), this.generatePair("&IP&", "{server.address.short}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&SERVER:NAME&", "{server.name}", this.IS_TEXT), this.generatePair("&NAME&", "{server.name}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&SERVER:MOTD&", "{server.motd.raw}", this.IS_TEXT), this.generatePair("&MOTD&", "{server.motd.raw}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&SERVER&", "{server.message}", this.IS_TEXT), this.generatePair("&SERVER:ICON&", "{server.icon}", this.IS_ICON), this.generatePair("&ICON&", "{server.icon}", this.IS_ICON, this.IS_SERVER_MODULE), this.generatePair("&SERVER&", "{server.icon}", this.IS_ICON), this.generatePair("&SERVER:PLAYERS&", "{custom.players}", this.IS_TEXT), this.generatePair("&PLAYERS&", "{custom.players}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&SERVER:WORLDINFO&", "{custom.world_info}", this.IS_TEXT), this.generatePair("&WORLDINFO&", "{custom.world_info}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&SERVER:PLAYERINFO&", "{custom.player_info_in}", this.IS_TEXT), this.generatePair("&PLAYERINFO&", "{custom.player_info_in}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&SERVER:PLAYERINFO:COORDS&", "{custom.player_info_coordinate}", this.IS_TEXT), this.generatePair("&PLAYERINFO:COORDS&", "{custom.player_info_coordinate}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&COORDS&", "{custom.player_info_coordinate}", this.IS_TEXT, this.IS_PLAYER_INNER_INFO_PLACEHOLDER), this.generatePair("&SERVER:PLAYERINFO:HEALTH&", "{custom.player_info_health}", this.IS_TEXT), this.generatePair("&PLAYERINFO:HEALTH&", "{custom.player_info_health}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&HEALTH&", "{custom.player_info_health}", this.IS_TEXT, this.IS_PLAYER_INNER_INFO_PLACEHOLDER), this.generatePair("&SERVER:PLAYERINFO:COORDS:xPosition&", "{player.position.x}", this.IS_TEXT), this.generatePair("&PLAYERINFO:COORDS:xPosition&", "{player.position.x}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&COORDS:xPosition&", "{player.position.x}", this.IS_TEXT, this.IS_PLAYER_INNER_INFO_PLACEHOLDER), this.generatePair("&xPosition&", "{player.position.x}", this.IS_TEXT, this.IS_PLAYER_COORDINATE_PLACEHOLDER), this.generatePair("&SERVER:PLAYERINFO:COORDS:yPosition&", "{player.position.y}", this.IS_TEXT), this.generatePair("&PLAYERINFO:COORDS:yPosition&", "{player.position.y}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&COORDS:yPosition&", "{player.position.y}", this.IS_TEXT, this.IS_PLAYER_INNER_INFO_PLACEHOLDER), this.generatePair("&yPosition&", "{player.position.y}", this.IS_TEXT, this.IS_PLAYER_COORDINATE_PLACEHOLDER), this.generatePair("&SERVER:PLAYERINFO:COORDS:zPosition&", "{player.position.z}", this.IS_TEXT), this.generatePair("&PLAYERINFO:COORDS:zPosition&", "{player.position.z}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&COORDS:zPosition&", "{player.position.z}", this.IS_TEXT, this.IS_PLAYER_INNER_INFO_PLACEHOLDER), this.generatePair("&zPosition&", "{player.position.z}", this.IS_TEXT, this.IS_PLAYER_COORDINATE_PLACEHOLDER), this.generatePair("&SERVER:PLAYERINFO:HEALTH:CURRENT&", "{player.health.current}", this.IS_TEXT), this.generatePair("&PLAYERINFO:HEALTH:CURRENT&", "{player.health.current}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&HEALTH:CURRENT&", "{player.health.current}", this.IS_TEXT, this.IS_PLAYER_INNER_INFO_PLACEHOLDER), this.generatePair("&CURRENT&", "{player.health.current}", this.IS_TEXT, this.IS_PLAYER_HEALTH_PLACEHOLDER), this.generatePair("&SERVER:PLAYERINFO:HEALTH:MAX&", "{player.health.max}", this.IS_TEXT), this.generatePair("&PLAYERINFO:HEALTH:MAX&", "{player.health.max}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&HEALTH:MAX&", "{player.health.max}", this.IS_TEXT, this.IS_PLAYER_INNER_INFO_PLACEHOLDER), this.generatePair("&MAX&", "{player.health.max}", this.IS_TEXT, this.IS_PLAYER_HEALTH_PLACEHOLDER), this.generatePair("&SERVER:PLAYERS:CURRENT&", "{server.players.current}", this.IS_TEXT), this.generatePair("&PLAYERS:CURRENT&", "{server.players.current}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&CURRENT&", "{server.players.current}", this.IS_TEXT, this.IS_PLAYER_LIST_PLACEHOLDER), this.generatePair("&SERVER:PLAYERS:MAX&", "{server.players.max}", this.IS_TEXT), this.generatePair("&PLAYERS:MAX&", "{server.players.max}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&MAX&", "{server.players.max}", this.IS_TEXT, this.IS_PLAYER_LIST_PLACEHOLDER), this.generatePair("&SERVER:WORLDINFO:DIFFICULTY&", "{world.difficulty}", this.IS_TEXT), this.generatePair("&WORLDINFO:DIFFICULTY&", "{world.difficulty}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&DIFFICULTY&", "{world.difficulty}", this.IS_TEXT, this.IS_WORLD_DATA_PLACEHOLDER), this.generatePair("&SERVER:WORLDINFO:WORLDNAME&", "{world.name}", this.IS_TEXT), this.generatePair("&WORLDINFO:WORLDNAME&", "{world.name}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&WORLDNAME&", "{world.name}", this.IS_TEXT, this.IS_WORLD_DATA_PLACEHOLDER), this.generatePair("&SERVER:WORLDINFO:WORLDTIME&", "{world.time.format_24}", this.IS_TEXT), this.generatePair("&WORLDINFO:WORLDTIME&", "{world.time.format_24}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&WORLDTIME&", "{world.time.format_24}", this.IS_TEXT, this.IS_WORLD_DATA_PLACEHOLDER), this.generatePair("&SERVER:WORLDINFO:WORLDTIME12&", "{world.time.format_12}", this.IS_TEXT), this.generatePair("&WORLDINFO:WORLDTIME12&", "{world.time.format_12}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&WORLDTIME12&", "{world.time.format_12}", this.IS_TEXT, this.IS_WORLD_DATA_PLACEHOLDER), this.generatePair("&SERVER:WORLDINFO:WORLDDAY&", "{world.time.day}", this.IS_TEXT), this.generatePair("&WORLDINFO:WORLDDAY&", "{world.time.day}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&WORLDDAY&", "{world.time.day}", this.IS_TEXT, this.IS_WORLD_DATA_PLACEHOLDER), this.generatePair("&SCREEN:SCREEN&", "{screen.name}", this.IS_TEXT), this.generatePair("&SCREEN&", "{screen.name}", this.IS_TEXT, this.IS_SCREEN_MODULE), this.generatePair("&SCREEN&", "{screen.message}", this.IS_TEXT), this.generatePair("&SCREEN:ICON&", "{screen.icon}", this.IS_ICON), this.generatePair("&ICON&", "{screen.icon}", this.IS_ICON, this.IS_SCREEN_MODULE), this.generatePair("&SCREEN&", "{screen.icon}", this.IS_ICON), this.generatePair("&SCREEN:CLASS&", "{getClass(data.screen.instance)}", this.IS_TEXT), this.generatePair("&CLASS&", "{getClass(data.screen.instance)}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&TARGETENTITY:ENTITY&", "{entity.target.name}", this.IS_TEXT), this.generatePair("&ENTITY&", "{entity.target.name}", this.IS_TEXT, this.IS_ENTITY_TARGET_MODULE), this.generatePair("&TARGETENTITY&", "{entity.target.message}", this.IS_TEXT), this.generatePair("&TARGETENTITY:ICON&", "{entity.target.icon}", this.IS_ICON), this.generatePair("&ICON&", "{entity.target.icon}", this.IS_ICON, this.IS_ENTITY_TARGET_MODULE), this.generatePair("&TARGETENTITY&", "{entity.target.icon}", this.IS_ICON), this.generatePair("&RIDINGENTITY:ENTITY&", "{entity.riding.name}", this.IS_TEXT), this.generatePair("&ENTITY&", "{entity.riding.name}", this.IS_TEXT, this.IS_ENTITY_RIDING_MODULE), this.generatePair("&RIDINGENTITY&", "{entity.riding.message}", this.IS_TEXT), this.generatePair("&RIDINGENTITY:ICON&", "{entity.riding.icon}", this.IS_ICON), this.generatePair("&ICON&", "{entity.riding.icon}", this.IS_ICON, this.IS_ENTITY_RIDING_MODULE), this.generatePair("&RIDINGENTITY&", "{entity.riding.icon}", this.IS_ICON), this.generatePair("&TILEENTITY:MAIN&", "{item.main_hand.message}", this.IS_TEXT), this.generatePair("&MAIN&", "{item.main_hand.message}", this.IS_TEXT, this.IS_PLAYER_ITEMS_PLACEHOLDER), this.generatePair("&TILEENTITY:OFFHAND&", "{item.off_hand.message}", this.IS_TEXT), this.generatePair("&OFFHAND&", "{item.off_hand.message}", this.IS_TEXT, this.IS_PLAYER_ITEMS_PLACEHOLDER), this.generatePair("&TILEENTITY:HELMET&", "{item.helmet.message}", this.IS_TEXT), this.generatePair("&HELMET&", "{item.helmet.message}", this.IS_TEXT, this.IS_PLAYER_ITEMS_PLACEHOLDER), this.generatePair("&TILEENTITY:CHEST&", "{item.chestplate.message}", this.IS_TEXT), this.generatePair("&CHEST&", "{item.chestplate.message}", this.IS_TEXT, this.IS_PLAYER_ITEMS_PLACEHOLDER), this.generatePair("&TILEENTITY:CHEST&", "{item.chestplate.message}", this.IS_TEXT), this.generatePair("&CHEST&", "{item.chestplate.message}", this.IS_TEXT, this.IS_PLAYER_ITEMS_PLACEHOLDER), this.generatePair("&TILEENTITY:LEGS&", "{item.leggings.message}", this.IS_TEXT), this.generatePair("&LEGS&", "{item.leggings.message}", this.IS_TEXT, this.IS_PLAYER_ITEMS_PLACEHOLDER), this.generatePair("&TILEENTITY:BOOTS&", "{item.boots.message}", this.IS_TEXT), this.generatePair("&BOOTS&", "{item.boots.message}", this.IS_TEXT, this.IS_PLAYER_ITEMS_PLACEHOLDER), this.generatePair("&TILEENTITY&", "{item.message.default}", this.IS_TEXT), this.generatePair("&ITEM&", "{item.message.holding}", this.IS_TEXT, this.IS_ITEM_MODULE));
    private final Map<String, String> configNameMappings = new HashMapBuilder().put((Object)"lastMcVersionId", (Object)"_lastMCVersionId").put((Object)"detectCurseManifest", (Object)"generalSettings.detectCurseManifest").put((Object)"detectMultimcInstance", (Object)"generalSettings.detectMultiMCManifest").put((Object)"detectMcupdaterInstance", (Object)"generalSettings.detectMCUpdaterInstance").put((Object)"detectTechnicPack", (Object)"generalSettings.detectTechnicPack").put((Object)"detectBiomeData", (Object)"generalSettings.detectBiomeData").put((Object)"detectDimensionData", (Object)"generalSettings.detectDimensionData").put((Object)"detectWorldData", (Object)"generalSettings.detectWorldData").put((Object)"clientId", (Object)"generalSettings.clientId").put((Object)"defaultIcon", (Object)"generalSettings.defaultIcon").put((Object)"enableJoinRequests", (Object)"generalSettings.enableJoinRequests").put((Object)"partyPrivacy", (Object)"generalSettings.partyPrivacyLevel").put((Object)"preferredClient", (Object)"generalSettings.preferredClientLevel").put((Object)"resetTimeOnInit", (Object)"generalSettings.resetTimeOnInit").put((Object)"autoRegister", (Object)"generalSettings.autoRegister").put((Object)"defaultBiomeIcon", (Object)"biomeSettings.fallbackBiomeIcon").put((Object)"biomeMessages", (Object)"biomeSettings.biomeData").put((Object)"defaultDimensionIcon", (Object)"dimensionSettings.fallbackDimensionIcon").put((Object)"dimensionMessages", (Object)"dimensionSettings.dimensionData").put((Object)"defaultServerIcon", (Object)"serverSettings.fallbackServerIcon").put((Object)"defaultServerName", (Object)"serverSettings.fallbackServerName").put((Object)"defaultServerMotd", (Object)"serverSettings.fallbackServerMotd").put((Object)"serverMessages", (Object)"serverSettings.serverData").put((Object)"mainMenuMessage", (Object)"statusMessages.mainMenuData.textOverride").put((Object)"loadingMessage", (Object)"statusMessages.loadingData.textOverride").put((Object)"lanGameMessage", (Object)"statusMessages.lanData.textOverride").put((Object)"singleplayerGameMessage", (Object)"statusMessages.singleplayerData.textOverride").put((Object)"modpackMessage", (Object)"displaySettings.dynamicVariables.pack").put((Object)"playerOuterInfoPlaceholder", (Object)"displaySettings.dynamicVariables.player_info_out").put((Object)"playerInnerInfoPlaceholder", (Object)"displaySettings.dynamicVariables.player_info_in").put((Object)"playerCoordinatePlaceholder", (Object)"displaySettings.dynamicVariables.player_info_coordinate").put((Object)"playerHealthPlaceholder", (Object)"displaySettings.dynamicVariables.player_info_health").put((Object)"playerListPlaceholder", (Object)"displaySettings.dynamicVariables.players").put((Object)"playerItemsPlaceholder", (Object)"displaySettings.dynamicVariables.player_info_items").put((Object)"worldDataPlaceholder", (Object)"displaySettings.dynamicVariables.world_info").put((Object)"modsPlaceholder", (Object)"displaySettings.dynamicVariables.mods").put((Object)"enablePerGuiSystem", (Object)"advancedSettings.enablePerGui").put((Object)"enablePerItemSystem", (Object)"advancedSettings.enablePerItem").put((Object)"enablePerEntitySystem", (Object)"advancedSettings.enablePerEntity").put((Object)"formatWords", (Object)"advancedSettings.formatWords").put((Object)"debugMode", (Object)"advancedSettings.debugMode").put((Object)"verboseMode", (Object)"advancedSettings.verboseMode").put((Object)"refreshRate", (Object)"advancedSettings.refreshRate").put((Object)"allowPlaceholderPreviews", (Object)"advancedSettings.allowPlaceholderPreviews").put((Object)"allowPlaceholderOperators", (Object)"advancedSettings.allowPlaceholderOperators").put((Object)"guiMessages", (Object)"advancedSettings.guiSettings.guiData").put((Object)"itemMessages", (Object)"advancedSettings.itemMessages").put((Object)"entityTargetMessages", (Object)"advancedSettings.entitySettings.targetData").put((Object)"entityRidingMessages", (Object)"advancedSettings.entitySettings.ridingData").put((Object)"playerSkinEndpoint", (Object)"advancedSettings.playerSkinEndpoint").put((Object)"languageId", (Object)"accessibilitySettings.languageId").put((Object)"stripTranslationColors", (Object)"accessibilitySettings.stripTranslationColors").put((Object)"stripExtraGuiElements", (Object)"accessibilitySettings.stripExtraGuiElements").put((Object)"configGuiKeybind", (Object)"accessibilitySettings.configKeyCode").put((Object)"gameStateMessageFormat", (Object)"displaySettings.presenceData.gameState").put((Object)"detailsMessageFormat", (Object)"displaySettings.presenceData.details").put((Object)"largeImageTextFormat", (Object)"displaySettings.presenceData.largeImageText").put((Object)"smallImageTextFormat", (Object)"displaySettings.presenceData.smallImageText").put((Object)"largeImageKeyFormat", (Object)"displaySettings.presenceData.largeImageKey").put((Object)"smallImageKeyFormat", (Object)"displaySettings.presenceData.smallImageKey").put((Object)"extraButtonMessages", (Object)"displaySettings.presenceData.buttons").put((Object)"dynamicIcons", (Object)"displaySettings.dynamicIcons").build();
    private final List<String> excludedOptions = StringUtils.newArrayList((Object[])new String[]{"schemaVersion", "splitCharacter", "renderTooltips", "guiBackgroundColor", "tooltipBackgroundColor", "tooltipBorderColor"});

    public Legacy2Modern(File configFile, String encoding) {
        this.configFile = configFile;
        this.encoding = encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Config apply(Config instance, JsonElement rawJson, Object ... args) {
        String splitCharacter;
        try {
            try (InputStreamReader configReader = new InputStreamReader(Files.newInputStream(this.configFile.toPath(), new OpenOption[0]), Charset.forName(this.encoding));){
                this.properties.load(configReader);
            }
            splitCharacter = this.properties.getProperty("splitCharacter", ";");
        }
        catch (Throwable ex) {
            String splitCharacter2;
            try {
                Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.config.save", new Object[0]), new Object[0]);
                Constants.LOG.debugError(ex);
                splitCharacter2 = this.properties.getProperty("splitCharacter", ";");
            }
            catch (Throwable throwable) {
                String splitCharacter3 = this.properties.getProperty("splitCharacter", ";");
                for (String property : this.properties.stringPropertyNames()) {
                    Object currentValue;
                    String originalName = StringUtils.formatToCamel((String)property);
                    if (this.excludedOptions.contains(originalName)) continue;
                    String newName = this.configNameMappings.getOrDefault(originalName, originalName);
                    Object originalValue = this.properties.get(property);
                    Object newValue = currentValue = instance.getProperty(newName);
                    if (currentValue == null) continue;
                    Class<?> expectedClass = currentValue.getClass();
                    if (expectedClass == Boolean.class && StringUtils.isValidBoolean((Object)originalValue)) {
                        newValue = Boolean.parseBoolean(originalValue.toString());
                    } else if (expectedClass == Integer.class && ((Boolean)StringUtils.getValidInteger((Object)originalValue).getFirst()).booleanValue()) {
                        Pair boolData = StringUtils.getValidInteger((Object)originalValue);
                        if (((Boolean)boolData.getFirst()).booleanValue()) {
                            newValue = boolData.getSecond();
                        }
                    } else if (currentValue instanceof Map) {
                        String preArrayString;
                        Map map = (Map)currentValue;
                        String convertedString = StringUtils.getMatch((Pattern)ARRAY_PATTERN, (String)originalValue.toString());
                        Map newData = StringUtils.newHashMap((Map)map);
                        Class<?> expectedSecondaryClass = newData.get("default").getClass();
                        String[] oldArray = !StringUtils.isNullOrEmpty((String)convertedString) && convertedString.startsWith("[") && convertedString.endsWith("]") ? ((preArrayString = convertedString.replace("[", "").replace("]", "")).contains(", ") ? preArrayString.split(", ") : (preArrayString.contains(",") ? preArrayString.split(",") : new String[]{preArrayString})) : null;
                        if (oldArray != null) {
                            newData.clear();
                            for (void var41_57 : oldArray) {
                                String[] part;
                                if (StringUtils.isNullOrEmpty((String)var41_57) || StringUtils.isNullOrEmpty((String)(part = var41_57.split(splitCharacter3))[0])) continue;
                                if (expectedSecondaryClass == Pair.class) {
                                    newData.put(part[0], new Pair((Object)(part.length >= 2 ? this.process(part[1], originalName, "text") : null), part.length >= 3 ? this.process(part[2], originalName, "icon") : null));
                                    continue;
                                }
                                if (expectedSecondaryClass == Tuple.class) {
                                    newData.put(part[0], new Tuple((Object)(part.length >= 2 ? this.process(part[1], originalName, "text") : null), (Object)(part.length >= 3 ? this.process(part[2], originalName, "text") : null), part.length >= 4 ? this.process(part[3], originalName, "text") : null));
                                    continue;
                                }
                                if (expectedSecondaryClass == ModuleData.class) {
                                    newData.put(part[0], new ModuleData(part.length >= 2 ? this.process(part[1], originalName, "text") : null, part.length >= 3 ? this.process(part[2], originalName, "icon") : null));
                                    continue;
                                }
                                if (expectedSecondaryClass == Button.class) {
                                    newData.put(part[0], new Button(part.length >= 2 ? this.process(part[1], originalName, "text") : null, part.length >= 3 ? this.process(part[2], originalName, "text") : null));
                                    continue;
                                }
                                newData.put(part[0], part.length >= 2 ? this.process(part[1], originalName, "text") : null);
                            }
                            newValue = newData;
                        }
                    } else {
                        newValue = this.process(originalValue.toString(), originalName, originalName.contains("ImageKey") ? "icon" : "text");
                    }
                    if (currentValue.equals(newValue)) continue;
                    Constants.LOG.debugInfo(Legacy2Modern.jvmdowngrader$concat$apply$1(originalName, newName), new Object[0]);
                    instance.setProperty(newName, newValue);
                }
                throw throwable;
            }
            for (String property : this.properties.stringPropertyNames()) {
                Object currentValue;
                String originalName = StringUtils.formatToCamel((String)property);
                if (this.excludedOptions.contains(originalName)) continue;
                String newName = this.configNameMappings.getOrDefault(originalName, originalName);
                Object originalValue = this.properties.get(property);
                Object newValue = currentValue = instance.getProperty(newName);
                if (currentValue == null) continue;
                Class<?> expectedClass = currentValue.getClass();
                if (expectedClass == Boolean.class && StringUtils.isValidBoolean((Object)originalValue)) {
                    newValue = Boolean.parseBoolean(originalValue.toString());
                } else if (expectedClass == Integer.class && ((Boolean)StringUtils.getValidInteger((Object)originalValue).getFirst()).booleanValue()) {
                    Pair boolData = StringUtils.getValidInteger((Object)originalValue);
                    if (((Boolean)boolData.getFirst()).booleanValue()) {
                        newValue = boolData.getSecond();
                    }
                } else if (currentValue instanceof Map) {
                    String preArrayString;
                    Map map = (Map)currentValue;
                    String convertedString = StringUtils.getMatch((Pattern)ARRAY_PATTERN, (String)originalValue.toString());
                    Map newData = StringUtils.newHashMap((Map)map);
                    Class<?> expectedSecondaryClass = newData.get("default").getClass();
                    String[] oldArray = !StringUtils.isNullOrEmpty((String)convertedString) && convertedString.startsWith("[") && convertedString.endsWith("]") ? ((preArrayString = convertedString.replace("[", "").replace("]", "")).contains(", ") ? preArrayString.split(", ") : (preArrayString.contains(",") ? preArrayString.split(",") : new String[]{preArrayString})) : null;
                    if (oldArray != null) {
                        newData.clear();
                        for (void var21_42 : oldArray) {
                            String[] part;
                            if (StringUtils.isNullOrEmpty((String)var21_42) || StringUtils.isNullOrEmpty((String)(part = var21_42.split(splitCharacter2))[0])) continue;
                            if (expectedSecondaryClass == Pair.class) {
                                newData.put(part[0], new Pair((Object)(part.length >= 2 ? this.process(part[1], originalName, "text") : null), part.length >= 3 ? this.process(part[2], originalName, "icon") : null));
                                continue;
                            }
                            if (expectedSecondaryClass == Tuple.class) {
                                newData.put(part[0], new Tuple((Object)(part.length >= 2 ? this.process(part[1], originalName, "text") : null), (Object)(part.length >= 3 ? this.process(part[2], originalName, "text") : null), part.length >= 4 ? this.process(part[3], originalName, "text") : null));
                                continue;
                            }
                            if (expectedSecondaryClass == ModuleData.class) {
                                newData.put(part[0], new ModuleData(part.length >= 2 ? this.process(part[1], originalName, "text") : null, part.length >= 3 ? this.process(part[2], originalName, "icon") : null));
                                continue;
                            }
                            if (expectedSecondaryClass == Button.class) {
                                newData.put(part[0], new Button(part.length >= 2 ? this.process(part[1], originalName, "text") : null, part.length >= 3 ? this.process(part[2], originalName, "text") : null));
                                continue;
                            }
                            newData.put(part[0], part.length >= 2 ? this.process(part[1], originalName, "text") : null);
                        }
                        newValue = newData;
                    }
                } else {
                    newValue = this.process(originalValue.toString(), originalName, originalName.contains("ImageKey") ? "icon" : "text");
                }
                if (currentValue.equals(newValue)) continue;
                Constants.LOG.debugInfo(Legacy2Modern.jvmdowngrader$concat$apply$1(originalName, newName), new Object[0]);
                instance.setProperty(newName, newValue);
            }
        }
        for (String property : this.properties.stringPropertyNames()) {
            Object currentValue;
            String originalName = StringUtils.formatToCamel((String)property);
            if (this.excludedOptions.contains(originalName)) continue;
            String newName = this.configNameMappings.getOrDefault(originalName, originalName);
            Object originalValue = this.properties.get(property);
            Object newValue = currentValue = instance.getProperty(newName);
            if (currentValue == null) continue;
            Class<?> expectedClass = currentValue.getClass();
            if (expectedClass == Boolean.class && StringUtils.isValidBoolean((Object)originalValue)) {
                newValue = Boolean.parseBoolean(originalValue.toString());
            } else if (expectedClass == Integer.class && ((Boolean)StringUtils.getValidInteger((Object)originalValue).getFirst()).booleanValue()) {
                Pair boolData = StringUtils.getValidInteger((Object)originalValue);
                if (((Boolean)boolData.getFirst()).booleanValue()) {
                    newValue = boolData.getSecond();
                }
            } else if (currentValue instanceof Map) {
                String[] preArrayString;
                Map map = (Map)currentValue;
                String convertedString = StringUtils.getMatch((Pattern)ARRAY_PATTERN, (String)originalValue.toString());
                Map newData = StringUtils.newHashMap((Map)map);
                Class<?> expectedSecondaryClass = newData.get("default").getClass();
                String[] oldArray = !StringUtils.isNullOrEmpty((String)convertedString) && convertedString.startsWith("[") && convertedString.endsWith("]") ? ((preArrayString = convertedString.replace("[", "").replace("]", "")).contains(", ") ? preArrayString.split(", ") : (preArrayString.contains(",") ? preArrayString.split(",") : new String[]{preArrayString})) : null;
                if (oldArray != null) {
                    newData.clear();
                    preArrayString = oldArray;
                    int n = preArrayString.length;
                    for (int i = 0; i < n; ++i) {
                        String[] part;
                        String string = preArrayString[i];
                        if (StringUtils.isNullOrEmpty((String)string) || StringUtils.isNullOrEmpty((String)(part = string.split(splitCharacter))[0])) continue;
                        if (expectedSecondaryClass == Pair.class) {
                            newData.put(part[0], new Pair((Object)(part.length >= 2 ? this.process(part[1], originalName, "text") : null), part.length >= 3 ? this.process(part[2], originalName, "icon") : null));
                            continue;
                        }
                        if (expectedSecondaryClass == Tuple.class) {
                            newData.put(part[0], new Tuple((Object)(part.length >= 2 ? this.process(part[1], originalName, "text") : null), (Object)(part.length >= 3 ? this.process(part[2], originalName, "text") : null), part.length >= 4 ? this.process(part[3], originalName, "text") : null));
                            continue;
                        }
                        if (expectedSecondaryClass == ModuleData.class) {
                            newData.put(part[0], new ModuleData(part.length >= 2 ? this.process(part[1], originalName, "text") : null, part.length >= 3 ? this.process(part[2], originalName, "icon") : null));
                            continue;
                        }
                        if (expectedSecondaryClass == Button.class) {
                            newData.put(part[0], new Button(part.length >= 2 ? this.process(part[1], originalName, "text") : null, part.length >= 3 ? this.process(part[2], originalName, "text") : null));
                            continue;
                        }
                        newData.put(part[0], part.length >= 2 ? this.process(part[1], originalName, "text") : null);
                    }
                    newValue = newData;
                }
            } else {
                newValue = this.process(originalValue.toString(), originalName, originalName.contains("ImageKey") ? "icon" : "text");
            }
            if (currentValue.equals(newValue)) continue;
            Constants.LOG.debugInfo(Legacy2Modern.jvmdowngrader$concat$apply$1(originalName, newName), new Object[0]);
            instance.setProperty(newName, newValue);
        }
        if (!this.configFile.delete()) {
            Constants.LOG.error(Legacy2Modern.jvmdowngrader$concat$apply$1(this.configFile.getName()), new Object[0]);
        }
        instance._schemaVersion = Config.getSchemaVersion();
        instance.save();
        return instance;
    }

    private String process(String input, String originalName, String argumentType) {
        String result = input;
        for (Tuple<Pair<String, String>, Predicate<String>, Predicate<String>> entry : this.placeholderMappings) {
            Pair replacer = (Pair)entry.getFirst();
            String original = (String)replacer.getFirst();
            String newValue = (String)replacer.getSecond();
            Predicate typeCheck = (Predicate)entry.getSecond();
            Predicate optionCheck = (Predicate)entry.getThird();
            if (!typeCheck.test(argumentType) || !optionCheck.test(originalName) || !result.toLowerCase().contains(original.toLowerCase())) continue;
            Constants.LOG.debugInfo("Replacing statement in property \"%1$s\" (%2$s): \"%3$s\" => \"%4$s\"", new Object[]{originalName, argumentType, original, newValue});
            result = result.replace(original, newValue);
        }
        List operatorMatches = StringUtils.getMatches((Pattern)OPERATOR_PATTERN, (String)result);
        if (!operatorMatches.isEmpty()) {
            for (String match : operatorMatches) {
                String[] split = match.split("\\|");
                split[0] = split[0].replaceAll("[{}]", "");
                split[1] = split[1].replaceAll("[{}]", "");
                String replacement = String.format("{getOrDefault(%1$s, %2$s)}", split[0], split[1]);
                Constants.LOG.debugInfo("Replacing statement in property \"%1$s\" (%2$s): \"%3$s\" => \"%4$s\"", new Object[]{originalName, argumentType, match, replacement});
                result = result.replace(match, replacement);
            }
        }
        return result;
    }

    private Tuple<Pair<String, String>, Predicate<String>, Predicate<String>> generatePair(String original, String name, Predicate<String> typeCheck, Predicate<String> optionCheck) {
        return new Tuple((Object)new Pair((Object)original, (Object)name), typeCheck, optionCheck);
    }

    private Tuple<Pair<String, String>, Predicate<String>, Predicate<String>> generatePair(String original, String name, Predicate<String> typeCheck) {
        return this.generatePair(original, name, typeCheck, (Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$generatePair$18(java.lang.String ), (Ljava/lang/String;)Z)());
    }

    private static /* synthetic */ boolean lambda$generatePair$18(String e) {
        return true;
    }

    private static /* synthetic */ boolean lambda$new$17(String e) {
        return e.equalsIgnoreCase("playerItemsPlaceholder");
    }

    private static /* synthetic */ boolean lambda$new$16(String e) {
        return e.equalsIgnoreCase("worldDataPlaceholder");
    }

    private static /* synthetic */ boolean lambda$new$15(String e) {
        return e.equalsIgnoreCase("playerListPlaceholder");
    }

    private static /* synthetic */ boolean lambda$new$14(String e) {
        return e.equalsIgnoreCase("playerHealthPlaceholder");
    }

    private static /* synthetic */ boolean lambda$new$13(String e) {
        return e.equalsIgnoreCase("playerCoordinatePlaceholder");
    }

    private static /* synthetic */ boolean lambda$new$12(String e) {
        return e.equalsIgnoreCase("playerInnerInfoPlaceholder");
    }

    private static /* synthetic */ boolean lambda$new$11(String e) {
        return e.equalsIgnoreCase("modpackMessage");
    }

    private static /* synthetic */ boolean lambda$new$10(String e) {
        return e.equalsIgnoreCase("modsPlaceholder");
    }

    private static /* synthetic */ boolean lambda$new$9(String e) {
        return e.equalsIgnoreCase("playerOuterInfoPlaceholder");
    }

    private static /* synthetic */ boolean lambda$new$8(String e) {
        return e.equals("entityRidingMessages");
    }

    private static /* synthetic */ boolean lambda$new$7(String e) {
        return e.equals("entityTargetMessages");
    }

    private static /* synthetic */ boolean lambda$new$6(String e) {
        return e.equals("itemMessages");
    }

    private static /* synthetic */ boolean lambda$new$5(String e) {
        return e.equals("guiMessages");
    }

    private static /* synthetic */ boolean lambda$new$4(String e) {
        return e.equals("serverMessages");
    }

    private static /* synthetic */ boolean lambda$new$3(String e) {
        return e.equals("biomeMessages");
    }

    private static /* synthetic */ boolean lambda$new$2(String e) {
        return e.equals("dimensionMessages");
    }

    private static /* synthetic */ boolean lambda$new$1(String id) {
        return id.equalsIgnoreCase("icon");
    }

    private static /* synthetic */ boolean lambda$new$0(String id) {
        return id.equalsIgnoreCase("text");
    }

    private static String jvmdowngrader$concat$apply$1(String string, String string2) {
        return "Migrating modified legacy property " + string + " to JSON property " + string2;
    }

    private static String jvmdowngrader$concat$apply$1(String string) {
        return "Failed to remove: " + string;
    }
}

