/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.moonconfig.core.conversion;

import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import me.hypherionmc.moonconfig.core.Config;
import me.hypherionmc.moonconfig.core.Config$jvmdg$StaticDefaults;
import me.hypherionmc.moonconfig.core.ConfigFormat;
import me.hypherionmc.moonconfig.core.EnumGetMethod;
import me.hypherionmc.moonconfig.core.InMemoryFormat;
import me.hypherionmc.moonconfig.core.UnmodifiableConfig;
import me.hypherionmc.moonconfig.core.UnmodifiableConfig$Entry$jvmdg$StaticDefaults;
import me.hypherionmc.moonconfig.core.UnmodifiableConfig$jvmdg$StaticDefaults;
import me.hypherionmc.moonconfig.core.conversion.AnnotationUtils;
import me.hypherionmc.moonconfig.core.conversion.Converter;
import me.hypherionmc.moonconfig.core.conversion.ReflectionException;
import me.hypherionmc.moonconfig.core.conversion.SpecEnum;
import me.hypherionmc.moonconfig.core.utils.TransformingMap;
import me.hypherionmc.moonconfig.core.utils.TransformingSet;

public final class ObjectBinder {
    private final boolean bypassTransient;
    private final boolean bypassFinal;

    public ObjectBinder(boolean bypassTransient, boolean bypassFinal) {
        this.bypassTransient = bypassTransient;
        this.bypassFinal = bypassFinal;
    }

    public ObjectBinder() {
        this(false, true);
    }

    public Config bind(Class<?> clazz) {
        return this.bind(clazz, InMemoryFormat.defaultInstance());
    }

    public Config bind(Class<?> clazz, ConfigFormat<?> configFormat) {
        return this.bind(null, clazz, configFormat);
    }

    public Config bind(Object object) {
        return this.bind(object, InMemoryFormat.defaultInstance());
    }

    public Config bind(Object object, ConfigFormat<?> configFormat) {
        return this.bind(object, object.getClass(), configFormat);
    }

    private Config bind(Object object, Class<?> clazz, ConfigFormat<?> configFormat) {
        BoundConfig boundConfig = this.createBoundConfig(object, clazz, configFormat);
        List<String> annotatedPath = AnnotationUtils.getPath(clazz);
        if (annotatedPath != null) {
            Object parentConfig = configFormat.createConfig();
            parentConfig.set(annotatedPath, (Object)boundConfig);
            return parentConfig;
        }
        return boundConfig;
    }

    private BoundConfig createBoundConfig(Object object, Class<?> clazz, ConfigFormat<?> configFormat) {
        BoundConfig boundConfig = new BoundConfig(object, configFormat, this.bypassFinal);
        for (Field field : clazz.getDeclaredFields()) {
            FieldInfos fieldInfos;
            int fieldModifiers = field.getModifiers();
            if (object == null && Modifier.isStatic(fieldModifiers) || !this.bypassTransient && Modifier.isTransient(fieldModifiers)) continue;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            List<String> path = AnnotationUtils.getPath(field);
            Converter<Object, Object> converter = AnnotationUtils.getConverter(field);
            boolean isEnum = Enum.class.isAssignableFrom(field.getType());
            if (converter == null) {
                if (isEnum) {
                    SpecEnum spec = field.getAnnotation(SpecEnum.class);
                    EnumGetMethod method = spec == null ? EnumGetMethod.NAME_IGNORECASE : spec.method();
                    converter = new EnumValueConverter(field.getType(), method);
                } else {
                    converter = NoOpConverter.INSTANCE;
                }
            }
            try {
                Object value = converter.convertFromField(field.get(object));
                if (value == null || isEnum || configFormat.supportsType(value.getClass())) {
                    fieldInfos = new FieldInfos(field, null, converter);
                } else {
                    BoundConfig subConfig = this.createBoundConfig(value, field.getType(), configFormat);
                    fieldInfos = new FieldInfos(field, subConfig, converter);
                }
            }
            catch (IllegalAccessException e) {
                throw new ReflectionException("Failed to bind field " + field, e);
            }
            boundConfig.registerField(fieldInfos, path);
        }
        return boundConfig;
    }

    private static final class EnumValueConverter<T extends Enum<T>>
    implements Converter<T, Object> {
        private final Class<T> enumType;
        private final EnumGetMethod method;

        EnumValueConverter(Class<T> enumType, EnumGetMethod method) {
            this.enumType = enumType;
            this.method = method;
        }

        @Override
        public T convertToField(Object value) {
            return this.method.get(value, this.enumType);
        }

        @Override
        public String convertFromField(T value) {
            return value == null ? null : ((Enum)value).toString();
        }
    }

    private static final class NoOpConverter
    implements Converter<Object, Object> {
        static final NoOpConverter INSTANCE = new NoOpConverter();

        private NoOpConverter() {
        }

        @Override
        public Object convertToField(Object value) {
            return value;
        }

        @Override
        public Object convertFromField(Object value) {
            return value;
        }
    }

    private static final class FieldInfos {
        final Field field;
        final BoundConfig boundConfig;
        final Converter<Object, Object> converter;

        FieldInfos(Field field, BoundConfig boundConfig, Converter<Object, Object> converter) {
            this.field = field;
            this.boundConfig = boundConfig;
            this.converter = converter;
        }

        Object setValue(Object fieldObject, Object value, boolean bypassFinal) {
            if (!bypassFinal && Modifier.isFinal(this.field.getModifiers())) {
                throw new UnsupportedOperationException("Cannot modify the field " + this.field);
            }
            try {
                Object previousValue = this.converter.convertFromField(this.field.get(fieldObject));
                Object newValue = this.converter.convertToField(value);
                AnnotationUtils.checkField(this.field, newValue);
                this.field.set(fieldObject, newValue);
                return previousValue;
            }
            catch (IllegalAccessException e) {
                throw new ReflectionException("Failed to set field " + this.field, e);
            }
        }

        Object removeValue(Object fieldObject, boolean bypassFinal) {
            Object previousValue = this.getValue(fieldObject);
            if (this.field.getType().isPrimitive()) {
                this.setValue(fieldObject, (byte)0, bypassFinal);
            } else {
                this.setValue(fieldObject, null, bypassFinal);
                if (this.boundConfig != null) {
                    this.boundConfig.clear();
                }
            }
            return previousValue;
        }

        Object getValue(Object fieldObject) {
            try {
                return this.converter.convertFromField(this.field.get(fieldObject));
            }
            catch (IllegalAccessException e) {
                throw new ReflectionException("Failed to get field " + this.field, e);
            }
        }

        BoundConfig getUpdatedConfig(Object fieldObject) {
            this.boundConfig.object = this.getValue(fieldObject);
            return this.boundConfig;
        }

        public String toString() {
            return "FieldInfos{field=" + this.field + ", boundConfig=" + this.boundConfig + '}';
        }
    }

    private static final class BoundSearchResult {
        final BoundConfig parentConfig;
        final FieldInfos fieldInfos;
        final BoundConfig subConfig;

        BoundSearchResult(BoundConfig parentConfig, Object data) {
            this.parentConfig = parentConfig;
            if (data instanceof FieldInfos) {
                this.fieldInfos = (FieldInfos)data;
                this.subConfig = this.fieldInfos.boundConfig == null ? null : this.fieldInfos.getUpdatedConfig(parentConfig.object);
            } else {
                this.fieldInfos = null;
                this.subConfig = (BoundConfig)data;
            }
        }

        boolean hasFieldInfos() {
            return this.fieldInfos != null;
        }

        boolean hasSubConfig() {
            return this.subConfig != null;
        }
    }

    private static final class BoundConfig
    implements Config {
        private Object object;
        private final Map<String, Object> dataMap;
        private final ConfigFormat<?> configFormat;
        private final boolean bypassFinal;

        private BoundConfig(Object object, Map<String, Object> dataMap, ConfigFormat<?> configFormat, boolean bypassFinal) {
            this.object = object;
            this.dataMap = dataMap;
            this.configFormat = configFormat;
            this.bypassFinal = bypassFinal;
        }

        private BoundConfig(Object object, ConfigFormat<?> configFormat, boolean bypassFinal) {
            this(object, new HashMap<String, Object>(), configFormat, bypassFinal);
        }

        private void registerField(FieldInfos fieldInfos, List<String> path) {
            int lastIndex = path.size() - 1;
            Map<String, Object> currentMap = this.dataMap;
            for (String currentKey : path.subList(0, lastIndex)) {
                BoundConfig config;
                Object currentValue = currentMap.get(currentKey);
                if (currentValue == null) {
                    config = new BoundConfig(null, new HashMap<String, Object>(1), this.configFormat, this.bypassFinal);
                    currentMap.put(currentKey, config);
                } else {
                    if (!(currentValue instanceof BoundConfig)) {
                        throw new IllegalArgumentException("Cannot add an element to an intermediary value of type: " + currentValue.getClass());
                    }
                    config = (BoundConfig)currentValue;
                }
                currentMap = config.dataMap;
            }
            String lastKey = path.get(lastIndex);
            currentMap.put(lastKey, fieldInfos);
        }

        private BoundSearchResult searchInfosOrConfig(List<String> path) {
            int lastIndex = path.size() - 1;
            BoundConfig currentConfig = this;
            for (String key : path.subList(0, lastIndex)) {
                Object v = currentConfig.dataMap.get(key);
                if (v == null) {
                    return null;
                }
                if (v instanceof BoundConfig) {
                    currentConfig = (BoundConfig)v;
                    continue;
                }
                FieldInfos fieldInfos = (FieldInfos)v;
                currentConfig = fieldInfos.getUpdatedConfig(currentConfig.object);
            }
            String lastKey = path.get(lastIndex);
            Object data = currentConfig.dataMap.get(lastKey);
            return new BoundSearchResult(currentConfig, data);
        }

        @Override
        public <T> T getRaw(List<String> path) {
            BoundSearchResult searchResult = this.searchInfosOrConfig(path);
            if (searchResult == null) {
                return null;
            }
            if (searchResult.hasSubConfig()) {
                return (T)searchResult.subConfig;
            }
            return (T)searchResult.fieldInfos.getValue(searchResult.parentConfig.object);
        }

        @Override
        public boolean contains(List<String> path) {
            return this.searchInfosOrConfig(path) != null;
        }

        @Override
        public <T> T set(List<String> path, Object value) {
            BoundSearchResult searchResult = this.searchInfosOrConfig(path);
            if (searchResult == null) {
                throw new UnsupportedOperationException("Cannot add elements to a bound config");
            }
            if (searchResult.hasFieldInfos()) {
                return (T)searchResult.fieldInfos.setValue(searchResult.parentConfig.object, value, this.bypassFinal);
            }
            throw new UnsupportedOperationException("Cannot modify non-field elements of a bound config");
        }

        @Override
        public boolean add(List<String> path, Object value) {
            throw new UnsupportedOperationException("Cannot add elements to a bound config");
        }

        @Override
        public <T> T remove(List<String> path) {
            BoundSearchResult searchResult = this.searchInfosOrConfig(path);
            if (searchResult == null) {
                return null;
            }
            if (searchResult.hasFieldInfos()) {
                return (T)searchResult.fieldInfos.removeValue(searchResult.parentConfig.object, this.bypassFinal);
            }
            Config copy = Config$jvmdg$StaticDefaults.copy(searchResult.subConfig);
            searchResult.subConfig.clear();
            return (T)copy;
        }

        @Override
        public void clear() {
            for (Map.Entry<String, Object> dataEntry : this.dataMap.entrySet()) {
                Object value = dataEntry.getValue();
                if (value instanceof FieldInfos) {
                    ((FieldInfos)value).removeValue(this.object, this.bypassFinal);
                    continue;
                }
                if (!(value instanceof BoundConfig)) continue;
                ((BoundConfig)value).clear();
            }
            this.dataMap.clear();
        }

        @Override
        public ConfigFormat<?> configFormat() {
            return this.configFormat;
        }

        @Override
        public Config createSubConfig() {
            return new BoundConfig(null, new HashMap<String, Object>(1), this.configFormat, this.bypassFinal);
        }

        @Override
        public Map<String, Object> valueMap() {
            Function<Object, Object> readConversion = (Function<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$valueMap$0(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)((BoundConfig)this);
            return new TransformingMap<String, Object, Object>(this.dataMap, readConversion, (Function<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$valueMap$1(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)(), (Function<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$valueMap$2(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)());
        }

        @Override
        public Set<? extends Config.Entry> entrySet() {
            Function<Map.Entry, Config.Entry> readTransfo = (Function<Map.Entry, Config.Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$entrySet$3(java.util.Map$Entry ), (Ljava/util/Map$Entry;)Lme/hypherionmc/moonconfig/core/Config$Entry;)((BoundConfig)this);
            return new TransformingSet<Map.Entry, Config.Entry>(this.dataMap.entrySet(), readTransfo, (Function<Config.Entry, Map.Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$entrySet$4(me.hypherionmc.moonconfig.core.Config$Entry ), (Lme/hypherionmc/moonconfig/core/Config$Entry;)Ljava/util/Map$Entry;)(), (Function<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$entrySet$5(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)());
        }

        @Override
        public int size() {
            return this.dataMap.size();
        }

        public String toString() {
            return "BoundConfig{object=" + this.object + ", dataMap=" + this.dataMap + '}';
        }

        private static /* synthetic */ Object lambda$entrySet$5(Object o) {
            return o;
        }

        private static /* synthetic */ Map.Entry lambda$entrySet$4(Config.Entry o) {
            return null;
        }

        private /* synthetic */ Config.Entry lambda$entrySet$3(final Map.Entry entry) {
            return new Config.Entry(){

                @Override
                public <T> T setValue(Object value) {
                    return (T)BoundConfig.this.set((String)entry.getKey(), value);
                }

                @Override
                public String getKey() {
                    return (String)entry.getKey();
                }

                @Override
                public <T> T getRawValue() {
                    return (T)entry.getValue();
                }

                public Optional getOptional() {
                    return UnmodifiableConfig$Entry$jvmdg$StaticDefaults.getOptional(this);
                }

                @Override
                public OptionalInt getOptionalInt() {
                    return UnmodifiableConfig$Entry$jvmdg$StaticDefaults.getOptionalInt(this);
                }

                @Override
                public short getShortOrElse(short s) {
                    return UnmodifiableConfig$Entry$jvmdg$StaticDefaults.getShortOrElse(this, s);
                }

                @Override
                public int getIntOrElse(int n) {
                    return UnmodifiableConfig$Entry$jvmdg$StaticDefaults.getIntOrElse(this, n);
                }

                public Object getOrElse(Object object) {
                    return UnmodifiableConfig$Entry$jvmdg$StaticDefaults.getOrElse(this, object);
                }

                @Override
                public int getInt() {
                    return UnmodifiableConfig$Entry$jvmdg$StaticDefaults.getInt(this);
                }

                @Override
                public byte getByteOrElse(byte by2) {
                    return UnmodifiableConfig$Entry$jvmdg$StaticDefaults.getByteOrElse(this, by2);
                }

                @Override
                public OptionalLong getOptionalLong() {
                    return UnmodifiableConfig$Entry$jvmdg$StaticDefaults.getOptionalLong(this);
                }

                @Override
                public long getLong() {
                    return UnmodifiableConfig$Entry$jvmdg$StaticDefaults.getLong(this);
                }

                @Override
                public long getLongOrElse(long l) {
                    return UnmodifiableConfig$Entry$jvmdg$StaticDefaults.getLongOrElse(this, l);
                }

                @Override
                public char getChar() {
                    return UnmodifiableConfig$Entry$jvmdg$StaticDefaults.getChar(this);
                }

                @Override
                public char getCharOrElse(char c) {
                    return UnmodifiableConfig$Entry$jvmdg$StaticDefaults.getCharOrElse(this, c);
                }

                public Object getValue() {
                    return UnmodifiableConfig$Entry$jvmdg$StaticDefaults.getValue(this);
                }

                @Override
                public boolean isNull() {
                    return UnmodifiableConfig$Entry$jvmdg$StaticDefaults.isNull(this);
                }

                @Override
                public short getShort() {
                    return UnmodifiableConfig$Entry$jvmdg$StaticDefaults.getShort(this);
                }

                @Override
                public byte getByte() {
                    return UnmodifiableConfig$Entry$jvmdg$StaticDefaults.getByte(this);
                }
            };
        }

        private static /* synthetic */ Object lambda$valueMap$2(Object o) {
            return o;
        }

        private static /* synthetic */ Object lambda$valueMap$1(Object o) {
            return o;
        }

        private /* synthetic */ Object lambda$valueMap$0(Object o) {
            if (o instanceof FieldInfos) {
                FieldInfos fieldInfos = (FieldInfos)o;
                if (fieldInfos.boundConfig != null) {
                    return fieldInfos.getUpdatedConfig(this.object);
                }
                return fieldInfos.getValue(this.object);
            }
            return o;
        }

        public Config of(ConfigFormat configFormat) {
            return Config$jvmdg$StaticDefaults.of((Config)this, (ConfigFormat)configFormat);
        }

        @Override
        public void putAll(UnmodifiableConfig unmodifiableConfig) {
            Config$jvmdg$StaticDefaults.putAll(this, unmodifiableConfig);
        }

        public OptionalInt getOptionalInt(List list) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getOptionalInt((UnmodifiableConfig)this, list);
        }

        public Optional getOptionalEnum(List list, Class clazz) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getOptionalEnum((UnmodifiableConfig)this, list, clazz);
        }

        public Config inMemoryConcurrent() {
            return Config$jvmdg$StaticDefaults.inMemoryConcurrent((Config)this);
        }

        public long getLongOrElse(List list, LongSupplier longSupplier) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getLongOrElse((UnmodifiableConfig)this, (List<String>)list, longSupplier);
        }

        public Enum getEnumOrElse(List list, Class clazz, EnumGetMethod enumGetMethod, Supplier supplier) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getEnumOrElse((UnmodifiableConfig)this, list, clazz, enumGetMethod, supplier);
        }

        public Enum getEnum(List list, Class clazz, EnumGetMethod enumGetMethod) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getEnum((UnmodifiableConfig)this, list, clazz, enumGetMethod);
        }

        public Enum getEnumOrElse(String string, Enum enum_, EnumGetMethod enumGetMethod) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getEnumOrElse((UnmodifiableConfig)this, string, enum_, enumGetMethod);
        }

        @Override
        public boolean isNull(String string) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.isNull((UnmodifiableConfig)this, string);
        }

        public Config copy(UnmodifiableConfig unmodifiableConfig, Supplier supplier) {
            return Config$jvmdg$StaticDefaults.copy((Config)this, (UnmodifiableConfig)unmodifiableConfig, (Supplier)supplier);
        }

        public Object apply(List list) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.apply((UnmodifiableConfig)this, list);
        }

        @Override
        public void addAll(UnmodifiableConfig unmodifiableConfig) {
            Config$jvmdg$StaticDefaults.addAll(this, unmodifiableConfig);
        }

        public Config concurrentCopy(UnmodifiableConfig unmodifiableConfig) {
            return Config$jvmdg$StaticDefaults.concurrentCopy((Config)this, (UnmodifiableConfig)unmodifiableConfig);
        }

        public OptionalLong getOptionalLong(List list) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getOptionalLong((UnmodifiableConfig)this, list);
        }

        public Supplier getDefaultMapCreator(boolean bl) {
            return Config$jvmdg$StaticDefaults.getDefaultMapCreator((Config)this, (boolean)bl);
        }

        public Enum getEnumOrElse(List list, Class clazz, Supplier supplier) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getEnumOrElse((UnmodifiableConfig)this, (List<String>)list, clazz, supplier);
        }

        public Config concurrentCopy(UnmodifiableConfig unmodifiableConfig, ConfigFormat configFormat) {
            return Config$jvmdg$StaticDefaults.concurrentCopy((Config)this, (UnmodifiableConfig)unmodifiableConfig, (ConfigFormat)configFormat);
        }

        public int getIntOrElse(List list, int n) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getIntOrElse((UnmodifiableConfig)this, (List<String>)list, n);
        }

        public boolean isInsertionOrderPreserved() {
            return Config$jvmdg$StaticDefaults.isInsertionOrderPreserved((Config)this);
        }

        public Enum getEnumOrElse(List list, Enum enum_, EnumGetMethod enumGetMethod) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getEnumOrElse((UnmodifiableConfig)this, (List<String>)list, enum_, enumGetMethod);
        }

        @Override
        public void removeAll(UnmodifiableConfig unmodifiableConfig) {
            Config$jvmdg$StaticDefaults.removeAll(this, unmodifiableConfig);
        }

        public Object getOrElse(List list, Supplier supplier) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getOrElse((UnmodifiableConfig)this, (List<String>)list, supplier);
        }

        @Override
        public byte getByte(String string) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getByte((UnmodifiableConfig)this, string);
        }

        public short getShort(List list) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getShort((UnmodifiableConfig)this, list);
        }

        public Object get(List list) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.get((UnmodifiableConfig)this, list);
        }

        public long getLong(List list) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getLong((UnmodifiableConfig)this, list);
        }

        public Object set(String string, Object object) {
            return Config$jvmdg$StaticDefaults.set(this, string, object);
        }

        public Config inMemoryUniversal() {
            return Config$jvmdg$StaticDefaults.inMemoryUniversal((Config)this);
        }

        @Override
        public short getShortOrElse(String string, short s) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getShortOrElse((UnmodifiableConfig)this, string, s);
        }

        public Object get(String string) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.get((UnmodifiableConfig)this, string);
        }

        @Override
        public int getIntOrElse(String string, int n) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getIntOrElse((UnmodifiableConfig)this, string, n);
        }

        public Config inMemoryUniversalConcurrent() {
            return Config$jvmdg$StaticDefaults.inMemoryUniversalConcurrent((Config)this);
        }

        @Override
        public long getLong(String string) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getLong((UnmodifiableConfig)this, string);
        }

        public Enum getEnum(String string, Class clazz) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getEnum((UnmodifiableConfig)this, string, clazz);
        }

        public Object remove(String string) {
            return Config$jvmdg$StaticDefaults.remove(this, string);
        }

        public Enum getEnum(String string, Class clazz, EnumGetMethod enumGetMethod) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getEnum((UnmodifiableConfig)this, string, clazz, enumGetMethod);
        }

        public short getShortOrElse(List list, short s) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getShortOrElse((UnmodifiableConfig)this, list, s);
        }

        public Config of(Supplier supplier, ConfigFormat configFormat) {
            return Config$jvmdg$StaticDefaults.of((Config)this, (Supplier)supplier, (ConfigFormat)configFormat);
        }

        public Enum getEnumOrElse(String string, Class clazz, Supplier supplier) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getEnumOrElse((UnmodifiableConfig)this, string, clazz, supplier);
        }

        public Config copy(UnmodifiableConfig unmodifiableConfig, ConfigFormat configFormat) {
            return Config$jvmdg$StaticDefaults.copy((Config)this, (UnmodifiableConfig)unmodifiableConfig, (ConfigFormat)configFormat);
        }

        public boolean isNull(List list) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.isNull((UnmodifiableConfig)this, list);
        }

        @Override
        public void update(String string, Object object) {
            Config$jvmdg$StaticDefaults.update((Config)this, string, object);
        }

        @Override
        public boolean add(String string, Object object) {
            return Config$jvmdg$StaticDefaults.add(this, string, object);
        }

        @Override
        public OptionalInt getOptionalInt(String string) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getOptionalInt((UnmodifiableConfig)this, string);
        }

        public byte getByteOrElse(List list, byte by2) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getByteOrElse((UnmodifiableConfig)this, list, by2);
        }

        public Config copy(UnmodifiableConfig unmodifiableConfig, Supplier supplier, ConfigFormat configFormat) {
            return Config$jvmdg$StaticDefaults.copy((Config)this, (UnmodifiableConfig)unmodifiableConfig, (Supplier)supplier, (ConfigFormat)configFormat);
        }

        public Enum getEnumOrElse(String string, Class clazz, EnumGetMethod enumGetMethod, Supplier supplier) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getEnumOrElse((UnmodifiableConfig)this, string, clazz, enumGetMethod, supplier);
        }

        @Override
        public long getLongOrElse(String string, long l) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getLongOrElse((UnmodifiableConfig)this, string, l);
        }

        public Supplier getDefaultMapCreator(boolean bl, boolean bl2) {
            return Config$jvmdg$StaticDefaults.getDefaultMapCreator((Config)this, (boolean)bl, (boolean)bl2);
        }

        public Config ofConcurrent(ConfigFormat configFormat) {
            return Config$jvmdg$StaticDefaults.ofConcurrent((Config)this, (ConfigFormat)configFormat);
        }

        public char getCharOrElse(List list, char c) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getCharOrElse((UnmodifiableConfig)this, list, c);
        }

        public Optional getOptionalEnum(List list, Class clazz, EnumGetMethod enumGetMethod) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getOptionalEnum((UnmodifiableConfig)this, list, clazz, enumGetMethod);
        }

        @Override
        public byte getByteOrElse(String string, byte by2) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getByteOrElse((UnmodifiableConfig)this, string, by2);
        }

        public Object apply(String string) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.apply((UnmodifiableConfig)this, string);
        }

        public void setInsertionOrderPreserved(boolean bl) {
            Config$jvmdg$StaticDefaults.setInsertionOrderPreserved((Config)this, (boolean)bl);
        }

        @Override
        public char getChar(String string) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getChar((UnmodifiableConfig)this, string);
        }

        public void update(List list, Object object) {
            Config$jvmdg$StaticDefaults.update((Config)this, list, object);
        }

        public Config copy(UnmodifiableConfig unmodifiableConfig) {
            return Config$jvmdg$StaticDefaults.copy((Config)this, (UnmodifiableConfig)unmodifiableConfig);
        }

        @Override
        public int getInt(String string) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getInt((UnmodifiableConfig)this, string);
        }

        public Enum getEnum(List list, Class clazz) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getEnum((UnmodifiableConfig)this, list, clazz);
        }

        public Object getOrElse(String string, Supplier supplier) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getOrElse((UnmodifiableConfig)this, string, supplier);
        }

        public Config inMemory() {
            return Config$jvmdg$StaticDefaults.inMemory((Config)this);
        }

        public Enum getEnumOrElse(String string, Enum enum_) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getEnumOrElse((UnmodifiableConfig)this, string, enum_);
        }

        public long getLongOrElse(List list, long l) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getLongOrElse((UnmodifiableConfig)this, (List<String>)list, l);
        }

        @Override
        public char getCharOrElse(String string, char c) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getCharOrElse((UnmodifiableConfig)this, string, c);
        }

        @Override
        public Config checked() {
            return Config$jvmdg$StaticDefaults.checked(this);
        }

        public Optional getOptionalEnum(String string, Class clazz, EnumGetMethod enumGetMethod) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getOptionalEnum((UnmodifiableConfig)this, string, clazz, enumGetMethod);
        }

        public Optional getOptional(String string) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getOptional((UnmodifiableConfig)this, string);
        }

        @Override
        public boolean isEmpty() {
            return UnmodifiableConfig$jvmdg$StaticDefaults.isEmpty(this);
        }

        @Override
        public boolean contains(String string) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.contains(this, string);
        }

        public byte getByte(List list) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getByte((UnmodifiableConfig)this, list);
        }

        public Enum getEnumOrElse(List list, Enum enum_) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getEnumOrElse((UnmodifiableConfig)this, list, enum_);
        }

        public char getChar(List list) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getChar((UnmodifiableConfig)this, list);
        }

        public Optional getOptional(List list) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getOptional((UnmodifiableConfig)this, list);
        }

        @Override
        public int getIntOrElse(String string, IntSupplier intSupplier) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getIntOrElse((UnmodifiableConfig)this, string, intSupplier);
        }

        @Override
        public short getShort(String string) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getShort((UnmodifiableConfig)this, string);
        }

        public Object getOrElse(String string, Object object) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getOrElse((UnmodifiableConfig)this, string, object);
        }

        @Override
        public OptionalLong getOptionalLong(String string) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getOptionalLong((UnmodifiableConfig)this, string);
        }

        public Config wrap(Map map, ConfigFormat configFormat) {
            return Config$jvmdg$StaticDefaults.wrap((Config)this, (Map)map, (ConfigFormat)configFormat);
        }

        @Override
        public UnmodifiableConfig unmodifiable() {
            return Config$jvmdg$StaticDefaults.unmodifiable(this);
        }

        public Optional getOptionalEnum(String string, Class clazz) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getOptionalEnum((UnmodifiableConfig)this, string, clazz);
        }

        public Object getRaw(String string) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getRaw(this, string);
        }

        @Override
        public long getLongOrElse(String string, LongSupplier longSupplier) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getLongOrElse((UnmodifiableConfig)this, string, longSupplier);
        }

        public int getIntOrElse(List list, IntSupplier intSupplier) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getIntOrElse((UnmodifiableConfig)this, (List<String>)list, intSupplier);
        }

        public int getInt(List list) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getInt((UnmodifiableConfig)this, list);
        }

        public Object getOrElse(List list, Object object) {
            return UnmodifiableConfig$jvmdg$StaticDefaults.getOrElse((UnmodifiableConfig)this, (List<String>)list, object);
        }
    }
}

