/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.config.gui;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.config.gui.PresenceEditorGui;
import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.Config;
import com.gitlab.cdagaming.craftpresence.core.config.category.Server;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.config.element.PresenceData;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.DynamicScrollableList;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.ConfigurationGui;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicSelectorGui;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.TextWidget;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_372;
import net.minecraft.class_388;

public class ServerSettingsGui
extends ConfigurationGui<Server> {
    private final Server INSTANCE;
    private final Server DEFAULTS = this.getCurrentData().getDefaults();
    private ExtendedButtonControl serverMessagesButton;
    private TextWidget defaultMOTD;
    private TextWidget defaultName;
    private TextWidget defaultMessage;
    private TextWidget defaultIcon;
    private TextWidget pingRateInterval;
    private TextWidget pingRateUnit;

    ServerSettingsGui() {
        super(Constants.TRANSLATOR.translate("gui.config.title", new Object[0]), Constants.TRANSLATOR.translate("gui.config.title.server_messages", new Object[0]));
        this.INSTANCE = this.getCurrentData().copy();
    }

    @Override
    public void constructElements() {
        super.constructElements();
        this.proceedButton.setOnHover((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$constructElements$0(), ()V)((ServerSettingsGui)this));
    }

    public void appendElements() {
        super.appendElements();
        ModuleData defaultData = this.getInstanceData().serverData.get("default");
        String defaultServerMessage = Config.getProperty(defaultData, "textOverride") != null ? defaultData.getTextOverride() : "";
        this.defaultName = (TextWidget)this.childFrame.addControl((class_372)new TextWidget(this.getFontRenderer(), this.getButtonY(0), 180, 20, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$appendElements$1(), ()V)((ServerSettingsGui)this), Constants.TRANSLATOR.translate("gui.config.name.server_messages.server_name", new Object[0]), (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$appendElements$2(), ()V)((ServerSettingsGui)this)));
        this.defaultName.setControlMessage(this.getInstanceData().fallbackServerName);
        this.defaultMOTD = (TextWidget)this.childFrame.addControl((class_372)new TextWidget(this.getFontRenderer(), this.getButtonY(1), 180, 20, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$appendElements$3(), ()V)((ServerSettingsGui)this), Constants.TRANSLATOR.translate("gui.config.name.server_messages.server_motd", new Object[0]), (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$appendElements$4(), ()V)((ServerSettingsGui)this)));
        this.defaultMOTD.setControlMessage(this.getInstanceData().fallbackServerMotd);
        this.defaultMessage = (TextWidget)this.childFrame.addControl((class_372)new TextWidget(this.getFontRenderer(), this.getButtonY(2), 180, 20, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$appendElements$5(), ()V)((ServerSettingsGui)this), Constants.TRANSLATOR.translate("gui.config.message.default.server", new Object[0]), (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$appendElements$6(), ()V)((ServerSettingsGui)this)));
        this.defaultMessage.setControlMessage(defaultServerMessage);
        this.defaultIcon = (TextWidget)this.childFrame.addControl((class_372)new TextWidget(this.getFontRenderer(), this.getButtonY(3), 147, 20, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$appendElements$7(), ()V)((ServerSettingsGui)this), Constants.TRANSLATOR.translate("gui.config.name.server_messages.server_icon", new Object[0]), (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$appendElements$8(), ()V)((ServerSettingsGui)this)));
        this.addIconSelector((ExtendedScreen)this.childFrame, (Supplier<TextWidget>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$appendElements$9(), ()Lcom/gitlab/cdagaming/unilib/utils/gui/widgets/TextWidget;)((ServerSettingsGui)this), (BiConsumer<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$appendElements$10(java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)V)((ServerSettingsGui)this));
        this.defaultIcon.setControlMessage(this.getInstanceData().fallbackServerIcon);
        this.serverMessagesButton = (ExtendedButtonControl)this.childFrame.addControl((class_372)new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getButtonY(4), 180, 20, Constants.TRANSLATOR.translate("gui.config.name.server_messages.server_messages", new Object[0]), (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$appendElements$20(), ()V)((ServerSettingsGui)this), (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$appendElements$21(), ()V)((ServerSettingsGui)this), new String[0]));
        this.pingRateInterval = (TextWidget)this.childFrame.addControl((class_372)new TextWidget(this.getFontRenderer(), this.getButtonY(5), 180, 20, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$appendElements$22(), ()V)((ServerSettingsGui)this), Constants.TRANSLATOR.translate("gui.config.name.server_messages.ping_rate_interval", new Object[0]), (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$appendElements$23(), ()V)((ServerSettingsGui)this)));
        this.pingRateInterval.setControlMessage(Integer.toString(this.getInstanceData().pingRateInterval));
        this.pingRateUnit = (TextWidget)this.childFrame.addControl((class_372)new TextWidget(this.getFontRenderer(), this.getButtonY(6), 180, 20, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$appendElements$24(), ()V)((ServerSettingsGui)this), Constants.TRANSLATOR.translate("gui.config.name.server_messages.ping_rate_unit", new Object[0]), (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$appendElements$25(), ()V)((ServerSettingsGui)this)));
        this.pingRateUnit.setControlMessage(this.getInstanceData().pingRateUnit);
    }

    @Override
    protected boolean allowedToReset() {
        return true;
    }

    @Override
    protected void syncRenderStates() {
        super.syncRenderStates();
        this.proceedButton.setControlEnabled(!StringUtils.isNullOrEmpty((String)this.defaultMessage.getControlMessage()) || !StringUtils.isNullOrEmpty((String)this.defaultName.getControlMessage()) || !StringUtils.isNullOrEmpty((String)this.defaultMOTD.getControlMessage()));
        this.serverMessagesButton.setControlEnabled(CraftPresence.SERVER.isEnabled());
    }

    @Override
    protected Server getInstanceData() {
        return this.INSTANCE;
    }

    @Override
    protected Server getCurrentData() {
        return CraftPresence.CONFIG.serverSettings;
    }

    @Override
    protected Server getDefaultData() {
        return this.DEFAULTS;
    }

    private /* synthetic */ void lambda$appendElements$25() {
        this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.server_messages.ping_rate_unit", new Object[0])));
    }

    private /* synthetic */ void lambda$appendElements$24() {
        this.getInstanceData().pingRateUnit = this.pingRateUnit.getControlMessage();
    }

    private /* synthetic */ void lambda$appendElements$23() {
        this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.server_messages.ping_rate_interval", new Object[0])));
    }

    private /* synthetic */ void lambda$appendElements$22() {
        this.getInstanceData().pingRateInterval = (Integer)StringUtils.getValidInteger((String)this.pingRateInterval.getControlMessage()).getSecond();
    }

    private /* synthetic */ void lambda$appendElements$21() {
        if (!this.serverMessagesButton.isControlEnabled()) {
            this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.hover.access", new Object[]{Constants.TRANSLATOR.translate("gui.config.name.server_messages.server_messages", new Object[0])})));
        } else {
            this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.server_messages.server_messages", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("server.", "world.", "player.")})));
        }
    }

    private /* synthetic */ void lambda$appendElements$20() {
        this.openScreen((ExtendedScreen)new DynamicSelectorGui(Constants.TRANSLATOR.translate("gui.config.title.selector.server", new Object[0]), CraftPresence.SERVER.knownAddresses, null, null, true, true, DynamicScrollableList.RenderType.ServerData, (BiConsumer<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$appendElements$11(java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)V)((ServerSettingsGui)this), (BiConsumer<String, class_388>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$appendElements$19(java.lang.String net.minecraft.class_388 ), (Ljava/lang/String;Lnet/minecraft/class_388;)V)((ServerSettingsGui)this)));
    }

    private /* synthetic */ void lambda$appendElements$19(String currentValue, class_388 parentScreen) {
        this.openScreen(new DynamicEditorGui(currentValue, (BiConsumer<String, DynamicEditorGui>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$appendElements$12(java.lang.String com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui ), (Ljava/lang/String;Lcom/gitlab/cdagaming/craftpresence/utils/gui/impl/DynamicEditorGui;)V)((ServerSettingsGui)this), (BiConsumer<String, DynamicEditorGui>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$appendElements$13(java.lang.String com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui ), (Ljava/lang/String;Lcom/gitlab/cdagaming/craftpresence/utils/gui/impl/DynamicEditorGui;)V)((ServerSettingsGui)this), (Consumer<DynamicEditorGui>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$appendElements$14(com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui ), (Lcom/gitlab/cdagaming/craftpresence/utils/gui/impl/DynamicEditorGui;)V)((ServerSettingsGui)this), (Consumer<DynamicEditorGui>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$appendElements$15(com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui ), (Lcom/gitlab/cdagaming/craftpresence/utils/gui/impl/DynamicEditorGui;)V)((ServerSettingsGui)this), (BiConsumer<String, DynamicEditorGui>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$appendElements$17(java.lang.String com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui ), (Ljava/lang/String;Lcom/gitlab/cdagaming/craftpresence/utils/gui/impl/DynamicEditorGui;)V)(), (BiConsumer<String, DynamicEditorGui>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$appendElements$18(java.lang.String com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui ), (Ljava/lang/String;Lcom/gitlab/cdagaming/craftpresence/utils/gui/impl/DynamicEditorGui;)V)()), parentScreen);
    }

    private static /* synthetic */ void lambda$appendElements$18(String attributeName, DynamicEditorGui screenInstance) {
        screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.server_messages.server_messages", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("server.", "world.", "player.")})));
    }

    private static /* synthetic */ void lambda$appendElements$17(String attributeName, DynamicEditorGui screenInstance) {
        if (screenInstance.isPresenceButton) {
            PresenceData defaultPresenceData = Config.getProperty(screenInstance.defaultData, "data") != null ? screenInstance.defaultData.getData() : new PresenceData();
            PresenceData currentPresenceData = Config.getProperty(screenInstance.currentData, "data") != null ? screenInstance.currentData.getData() : defaultPresenceData;
            screenInstance.openScreen(new PresenceEditorGui(currentPresenceData, defaultPresenceData, (Consumer<PresenceData>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$appendElements$16(com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui com.gitlab.cdagaming.craftpresence.core.config.element.PresenceData ), (Lcom/gitlab/cdagaming/craftpresence/core/config/element/PresenceData;)V)((DynamicEditorGui)screenInstance)));
        } else {
            screenInstance.currentData.setIconOverride(attributeName);
        }
    }

    private static /* synthetic */ void lambda$appendElements$16(DynamicEditorGui screenInstance, PresenceData output) {
        screenInstance.currentData.setData(output);
    }

    private /* synthetic */ void lambda$appendElements$15(DynamicEditorGui screenInstance) {
        String attributeName = screenInstance.getSecondaryEntry();
        this.getInstanceData().serverData.remove(attributeName);
        if (!CraftPresence.SERVER.defaultAddresses.contains(attributeName)) {
            CraftPresence.SERVER.knownAddresses.remove(attributeName);
        }
    }

    private /* synthetic */ void lambda$appendElements$14(DynamicEditorGui screenInstance) {
        String attributeName = screenInstance.getSecondaryEntry();
        String inputText = screenInstance.getPrimaryEntry();
        screenInstance.currentData.setTextOverride(inputText);
        this.getInstanceData().serverData.put(attributeName, screenInstance.currentData);
        if (!CraftPresence.SERVER.knownAddresses.contains(attributeName)) {
            CraftPresence.SERVER.knownAddresses.add(attributeName);
        }
    }

    private /* synthetic */ void lambda$appendElements$13(String attributeName, DynamicEditorGui screenInstance) {
        screenInstance.isDefaultValue = "default".equals(attributeName);
        screenInstance.defaultData = this.getInstanceData().serverData.get("default");
        screenInstance.currentData = this.getInstanceData().serverData.get(attributeName);
        screenInstance.isPreliminaryData = screenInstance.currentData == null;
        screenInstance.setScreenTitle(Constants.TRANSLATOR.translate("gui.config.title.server.edit_specific_server", new Object[]{attributeName}));
        screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
        screenInstance.primaryMessage = Config.getProperty(screenInstance.currentData, "textOverride") != null ? screenInstance.currentData.getTextOverride() : screenInstance.originalPrimaryMessage;
    }

    private /* synthetic */ void lambda$appendElements$12(String attributeName, DynamicEditorGui screenInstance) {
        screenInstance.defaultData = this.getInstanceData().serverData.get("default");
        screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
        screenInstance.primaryMessage = screenInstance.originalPrimaryMessage;
    }

    private /* synthetic */ void lambda$appendElements$11(String attributeName, String currentValue) {
        ModuleData defaultServerData = this.getInstanceData().serverData.get("default");
        ModuleData currentServerData = this.getInstanceData().serverData.get(attributeName);
        String defaultMessage = Config.getProperty(defaultServerData, "textOverride") != null ? defaultServerData.getTextOverride() : "";
        String currentMessage = Config.getProperty(currentServerData, "textOverride") != null ? currentServerData.getTextOverride() : "";
        ModuleData newData = new ModuleData();
        if (StringUtils.isNullOrEmpty((String)currentMessage) || currentMessage.equals(defaultMessage)) {
            newData.setTextOverride(defaultMessage);
        }
        newData.setIconOverride(currentValue);
        this.getInstanceData().serverData.put(attributeName, newData);
    }

    private /* synthetic */ void lambda$appendElements$10(String attributeName, String currentValue) {
        this.getInstanceData().fallbackServerIcon = currentValue;
    }

    private /* synthetic */ TextWidget lambda$appendElements$9() {
        return this.defaultIcon;
    }

    private /* synthetic */ void lambda$appendElements$8() {
        this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.server_messages.server_icon", new Object[0])));
    }

    private /* synthetic */ void lambda$appendElements$7() {
        this.getInstanceData().fallbackServerIcon = this.defaultIcon.getControlMessage();
    }

    private /* synthetic */ void lambda$appendElements$6() {
        this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.server_messages.server_messages", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("server.", "world.", "player.")})));
    }

    private /* synthetic */ void lambda$appendElements$5() {
        ModuleData defaultServerData = this.getInstanceData().serverData.getOrDefault("default", new ModuleData());
        defaultServerData.setTextOverride(this.defaultMessage.getControlMessage());
        this.getInstanceData().serverData.put("default", defaultServerData);
    }

    private /* synthetic */ void lambda$appendElements$4() {
        this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.server_messages.server_motd", new Object[0])));
    }

    private /* synthetic */ void lambda$appendElements$3() {
        this.getInstanceData().fallbackServerMotd = this.defaultMOTD.getControlMessage();
    }

    private /* synthetic */ void lambda$appendElements$2() {
        this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.server_messages.server_name", new Object[0])));
    }

    private /* synthetic */ void lambda$appendElements$1() {
        this.getInstanceData().fallbackServerName = this.defaultName.getControlMessage();
    }

    private /* synthetic */ void lambda$constructElements$0() {
        if (!this.proceedButton.isControlEnabled()) {
            this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.hover.empty.default", new Object[0])));
        }
    }
}

