/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.core.impl.discord;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.integrations.discord.assets.DiscordAsset;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import craftpresence.external.com.jagrosh.discordipc.entities.ActivityType;
import craftpresence.external.com.jagrosh.discordipc.entities.PartyPrivacy;
import craftpresence.jvmdg.api.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import io.github.cdagaming.unicore.utils.StringUtils;
import io.github.cdagaming.unicore.utils.TimeUtils;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

@RecordComponents(value={@RecordComponents.Value(name="activityType", type=ActivityType.class), @RecordComponents.Value(name="partyPrivacy", type=PartyPrivacy.class), @RecordComponents.Value(name="details", type=String.class), @RecordComponents.Value(name="state", type=String.class), @RecordComponents.Value(name="rawLargeImage", type=String.class), @RecordComponents.Value(name="rawSmallImage", type=String.class), @RecordComponents.Value(name="largeAsset", type=DiscordAsset.class), @RecordComponents.Value(name="smallAsset", type=DiscordAsset.class), @RecordComponents.Value(name="largeImageKey", type=String.class), @RecordComponents.Value(name="smallImageKey", type=String.class), @RecordComponents.Value(name="largeImageText", type=String.class), @RecordComponents.Value(name="smallImageText", type=String.class), @RecordComponents.Value(name="startTimestamp", type=long.class), @RecordComponents.Value(name="endTimestamp", type=long.class), @RecordComponents.Value(name="buttons", type=JsonArray.class), @RecordComponents.Value(name="instance", type=boolean.class), @RecordComponents.Value(name="isMain", type=boolean.class)})
public final class CompiledPresence
extends J_L_Record {
    private final ActivityType activityType;
    private final PartyPrivacy partyPrivacy;
    private final String details;
    private final String state;
    private final String rawLargeImage;
    private final String rawSmallImage;
    private final DiscordAsset largeAsset;
    private final DiscordAsset smallAsset;
    private final String largeImageKey;
    private final String smallImageKey;
    private final String largeImageText;
    private final String smallImageText;
    private final long startTimestamp;
    private final long endTimestamp;
    private final JsonArray buttons;
    private final boolean instance;
    private final boolean isMain;

    public CompiledPresence(ActivityType activityType, PartyPrivacy partyPrivacy, String details, String state, String rawLargeImage, String rawSmallImage, DiscordAsset largeAsset, DiscordAsset smallAsset, String largeImageKey, String smallImageKey, String largeImageText, String smallImageText, long startTimestamp, long endTimestamp, JsonArray buttons, boolean instance, boolean isMain) {
        this.activityType = activityType;
        this.partyPrivacy = partyPrivacy;
        this.details = details;
        this.state = state;
        this.rawLargeImage = rawLargeImage;
        this.rawSmallImage = rawSmallImage;
        this.largeAsset = largeAsset;
        this.smallAsset = smallAsset;
        this.largeImageKey = largeImageKey;
        this.smallImageKey = smallImageKey;
        this.largeImageText = largeImageText;
        this.smallImageText = smallImageText;
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        this.buttons = buttons;
        this.instance = instance;
        this.isMain = isMain;
    }

    public String getTimeString() {
        boolean isElapsed = this.endTimestamp <= 0L;
        long seconds = TimeUtils.getDuration((Temporal)TimeUtils.fromEpochMilli((long)this.startTimestamp), (Temporal)(isElapsed ? TimeUtils.getCurrentTime() : TimeUtils.fromEpochMilli((long)this.endTimestamp))).getSeconds();
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        long remainingSeconds = seconds % 60L;
        StringBuilder timeStringBuilder = new StringBuilder();
        if (hours > 0L) {
            if (hours < 10L) {
                timeStringBuilder.append('0');
            }
            timeStringBuilder.append(hours).append(':');
        }
        if (minutes < 10L) {
            timeStringBuilder.append('0');
        }
        timeStringBuilder.append(minutes).append(':');
        if (remainingSeconds < 10L) {
            timeStringBuilder.append('0');
        }
        timeStringBuilder.append(remainingSeconds);
        if (isElapsed) {
            timeStringBuilder.append(" elapsed");
        } else {
            timeStringBuilder.append(" left");
        }
        return timeStringBuilder.toString();
    }

    public Map<String, String> getButtonData() {
        Map results = StringUtils.newLinkedHashMap();
        if (this.buttons != null) {
            for (JsonElement button : this.buttons) {
                try {
                    JsonObject buttonObj;
                    if (!button.isJsonObject() || !(buttonObj = button.getAsJsonObject()).has("label") || !buttonObj.has("url")) continue;
                    results.put(buttonObj.get("label").getAsString(), buttonObj.get("url").getAsString());
                }
                catch (Throwable ex) {
                    Constants.LOG.debugError(ex);
                }
            }
        }
        return results;
    }

    public String state(int minPlayers, int maxPlayers) {
        String original = this.state();
        return StringUtils.isNullOrEmpty((String)original) ? original : CompiledPresence.jvmdowngrader$concat$state$1(original, minPlayers, maxPlayers);
    }

    @Override
    public final String toString() {
        return CompiledPresence.jvmdowngrader$toString$toString(this);
    }

    @Override
    public final int hashCode() {
        return CompiledPresence.jvmdowngrader$hashCode$hashCode(this);
    }

    @Override
    public final boolean equals(Object o) {
        return CompiledPresence.jvmdowngrader$equals$equals(this, o);
    }

    public ActivityType activityType() {
        return this.activityType;
    }

    public PartyPrivacy partyPrivacy() {
        return this.partyPrivacy;
    }

    public String details() {
        return this.details;
    }

    public String state() {
        return this.state;
    }

    public String rawLargeImage() {
        return this.rawLargeImage;
    }

    public String rawSmallImage() {
        return this.rawSmallImage;
    }

    public DiscordAsset largeAsset() {
        return this.largeAsset;
    }

    public DiscordAsset smallAsset() {
        return this.smallAsset;
    }

    public String largeImageKey() {
        return this.largeImageKey;
    }

    public String smallImageKey() {
        return this.smallImageKey;
    }

    public String largeImageText() {
        return this.largeImageText;
    }

    public String smallImageText() {
        return this.smallImageText;
    }

    public long startTimestamp() {
        return this.startTimestamp;
    }

    public long endTimestamp() {
        return this.endTimestamp;
    }

    public JsonArray buttons() {
        return this.buttons;
    }

    public boolean instance() {
        return this.instance;
    }

    public boolean isMain() {
        return this.isMain;
    }

    private static String jvmdowngrader$toString$toString(CompiledPresence compiledPresence) {
        CompiledPresence compiledPresence2 = compiledPresence;
        return "CompiledPresence[" + "activityType=" + (Object)((Object)compiledPresence.activityType) + ", " + "partyPrivacy=" + (Object)((Object)compiledPresence.partyPrivacy) + ", " + "details=" + compiledPresence.details + ", " + "state=" + compiledPresence.state + ", " + "rawLargeImage=" + compiledPresence.rawLargeImage + ", " + "rawSmallImage=" + compiledPresence.rawSmallImage + ", " + "largeAsset=" + compiledPresence.largeAsset + ", " + "smallAsset=" + compiledPresence.smallAsset + ", " + "largeImageKey=" + compiledPresence.largeImageKey + ", " + "smallImageKey=" + compiledPresence.smallImageKey + ", " + "largeImageText=" + compiledPresence.largeImageText + ", " + "smallImageText=" + compiledPresence.smallImageText + ", " + "startTimestamp=" + compiledPresence.startTimestamp + ", " + "endTimestamp=" + compiledPresence.endTimestamp + ", " + "buttons=" + compiledPresence.buttons + ", " + "instance=" + compiledPresence.instance + ", " + "isMain=" + compiledPresence.isMain + "]";
    }

    private static int jvmdowngrader$hashCode$hashCode(CompiledPresence compiledPresence) {
        Object[] objectArray = new Object[]{compiledPresence.activityType, compiledPresence.partyPrivacy, compiledPresence.details, compiledPresence.state, compiledPresence.rawLargeImage, compiledPresence.rawSmallImage, compiledPresence.largeAsset, compiledPresence.smallAsset, compiledPresence.largeImageKey, compiledPresence.smallImageKey, compiledPresence.largeImageText, compiledPresence.smallImageText, compiledPresence.startTimestamp, compiledPresence.endTimestamp, compiledPresence.buttons, compiledPresence.instance, compiledPresence.isMain};
        return Arrays.hashCode(objectArray);
    }

    private static boolean jvmdowngrader$equals$equals(CompiledPresence compiledPresence, Object object) {
        if (compiledPresence == object) {
            return true;
        }
        if (object != null && object instanceof CompiledPresence) {
            CompiledPresence compiledPresence2 = (CompiledPresence)object;
            if (Objects.equals((Object)compiledPresence.activityType, (Object)compiledPresence2.activityType) && Objects.equals((Object)compiledPresence.partyPrivacy, (Object)compiledPresence2.partyPrivacy) && Objects.equals(compiledPresence.details, compiledPresence2.details) && Objects.equals(compiledPresence.state, compiledPresence2.state) && Objects.equals(compiledPresence.rawLargeImage, compiledPresence2.rawLargeImage) && Objects.equals(compiledPresence.rawSmallImage, compiledPresence2.rawSmallImage) && Objects.equals(compiledPresence.largeAsset, compiledPresence2.largeAsset) && Objects.equals(compiledPresence.smallAsset, compiledPresence2.smallAsset) && Objects.equals(compiledPresence.largeImageKey, compiledPresence2.largeImageKey) && Objects.equals(compiledPresence.smallImageKey, compiledPresence2.smallImageKey) && Objects.equals(compiledPresence.largeImageText, compiledPresence2.largeImageText) && Objects.equals(compiledPresence.smallImageText, compiledPresence2.smallImageText) && compiledPresence.startTimestamp == compiledPresence2.startTimestamp && compiledPresence.endTimestamp == compiledPresence2.endTimestamp && Objects.equals(compiledPresence.buttons, compiledPresence2.buttons) && compiledPresence.instance == compiledPresence2.instance && compiledPresence.isMain == compiledPresence2.isMain) {
                return true;
            }
        }
        return false;
    }

    private static String jvmdowngrader$concat$state$1(String string, int n, int n2) {
        return string + " (" + n + " of " + n2 + ")";
    }
}

