/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.LockSupport;
import org.eclipse.jdt.annotation.Nullable;
import org.newsclub.net.unix.AFFuture;
import org.newsclub.net.unix.AFFuture$;
import org.newsclub.net.unix.AFSelector;
import org.newsclub.net.unix.AFSupplier;
import org.newsclub.net.unix.Java7Util;
import org.newsclub.net.unix.NativeUnixSocket;
import org.newsclub.net.unix.SocketClosedByInterruptException;
import org.newsclub.net.unix.VirtualThreadPoller;
import org.newsclub.net.unix.VirtualThreadPollerNaive$$Lambda$1;
import org.newsclub.net.unix.VirtualThreadPollerNaive$PollJob$$Lambda$1;
import org.newsclub.net.unix.VirtualThreadPollerNaive$PollJob$$Lambda$2;

final class VirtualThreadPollerNaive
implements VirtualThreadPoller {
    private static final int POLL_INTERVAL_MILLIS = 1000;
    private static final Map<FileDescriptor, PollJob> POLL_JOBS = new ConcurrentHashMap<FileDescriptor, PollJob>();
    private static final InterruptedIOException POLL_INTERRUPTED_SENTINEL = new InterruptedIOException();

    VirtualThreadPollerNaive() {
    }

    @Override
    public void parkThreadUntilReady(FileDescriptor fd2, int mode, long now, AFSupplier<Integer> timeout, Closeable closeOnInterrupt) throws IOException {
        Thread virtualThread = Thread.currentThread();
        PollJob job = Java7Util.computeIfAbsent(POLL_JOBS, fd2, VirtualThreadPollerNaive$$Lambda$1.lambdaFactory$(fd2, mode, now, timeout));
        AFFuture<@Nullable IOException> future = job.trigger(virtualThread);
        LockSupport.park();
        if (virtualThread.isInterrupted()) {
            throw SocketClosedByInterruptException.newInstanceAndClose(closeOnInterrupt);
        }
        try {
            IOException ex = future.get();
            if (ex != null) {
                if (ex == POLL_INTERRUPTED_SENTINEL) {
                    throw SocketClosedByInterruptException.newInstanceAndClose(closeOnInterrupt);
                }
                throw ex;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw SocketClosedByInterruptException.newInstanceAndClose(closeOnInterrupt);
        }
        int timeoutMillis = timeout.get();
        if (timeoutMillis > 0 && System.currentTimeMillis() - now >= (long)timeoutMillis) {
            throw new SocketTimeoutException();
        }
    }

    static /* synthetic */ PollJob lambda$parkThreadUntilReady$0(FileDescriptor fd2, int mode, long now, AFSupplier timeout, FileDescriptor k) {
        return new PollJob(fd2, mode, now, timeout);
    }

    private static final class PollJob {
        private final List<Thread> waitingThreads = new LinkedList<Thread>();
        private final FileDescriptor fd;
        private final int mode;
        private final long now;
        private final AFSupplier<Integer> timeout;

        PollJob(FileDescriptor fd2, int mode, long now, AFSupplier<Integer> timeout) {
            this.fd = fd2;
            this.mode = mode;
            this.now = now;
            this.timeout = timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AFFuture<@Nullable IOException> trigger(Thread waitingThread) {
            FileDescriptor fileDescriptor = this.fd;
            synchronized (fileDescriptor) {
                this.waitingThreads.add(waitingThread);
            }
            AFFuture aFFuture = AFFuture$.supplyAsync(VirtualThreadPollerNaive$PollJob$$Lambda$1.lambdaFactory$(this));
            Objects.requireNonNull(aFFuture);
            return VirtualThreadPollerNaive$PollJob$$Lambda$2.lambdaFactory$(aFFuture);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static /* synthetic */ IOException lambda$trigger$0(PollJob this_) {
            try {
                int timeoutMillis;
                Thread thread = Thread.currentThread();
                AFSelector.PollFd pfd = new AFSelector.PollFd(new FileDescriptor[]{this_.fd}, new int[]{this_.mode});
                do {
                    if (thread.isInterrupted() || !this_.fd.valid()) {
                        InterruptedIOException interruptedIOException = POLL_INTERRUPTED_SENTINEL;
                        return interruptedIOException;
                    }
                    try {
                        NativeUnixSocket.poll(pfd, 1000);
                    }
                    catch (IOException e) {
                        IOException threadToWake = e;
                        Thread threadToWake2 = null;
                        try {
                            FileDescriptor fileDescriptor = this_.fd;
                            synchronized (fileDescriptor) {
                                threadToWake2 = this_.waitingThreads.remove(0);
                                if (this_.waitingThreads.isEmpty()) {
                                    POLL_JOBS.remove(this_.fd);
                                }
                            }
                            if (threadToWake2 == null) return threadToWake;
                        }
                        catch (Throwable throwable) {
                            if (threadToWake2 == null) throw throwable;
                            LockSupport.unpark(threadToWake2);
                            throw throwable;
                        }
                        LockSupport.unpark(threadToWake2);
                        return threadToWake;
                    }
                    if (thread.isInterrupted() || !this_.fd.valid()) {
                        InterruptedIOException e = POLL_INTERRUPTED_SENTINEL;
                        return e;
                    }
                    if (pfd.rops[0] == 0) continue;
                    return null;
                } while ((timeoutMillis = this_.timeout.get().intValue()) <= 0 || System.currentTimeMillis() - this_.now < (long)timeoutMillis);
                return null;
            }
            finally {
                block33: {
                    Thread threadToWake = null;
                    try {
                        FileDescriptor fileDescriptor = this_.fd;
                        synchronized (fileDescriptor) {
                            threadToWake = this_.waitingThreads.remove(0);
                            if (this_.waitingThreads.isEmpty()) {
                                POLL_JOBS.remove(this_.fd);
                            }
                            if (threadToWake == null) break block33;
                        }
                    }
                    catch (Throwable throwable) {
                        if (threadToWake == null) throw throwable;
                        LockSupport.unpark(threadToWake);
                        throw throwable;
                    }
                    LockSupport.unpark(threadToWake);
                }
            }
        }
    }
}

