/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.pool;

import org.eclipse.jdt.annotation.NonNull;
import org.newsclub.net.unix.ThreadUtil;
import org.newsclub.net.unix.pool.ConcurrentQueueObjectPool;
import org.newsclub.net.unix.pool.ObjectPool;
import org.newsclub.net.unix.pool.ThreadLocalObjectPool;

final class VirtualAwareThreadLocalObjectPool<O>
implements ObjectPool<O> {
    private final ThreadLocalObjectPool<O> tlPool;
    private final ConcurrentQueueObjectPool<O> cqPool;

    public VirtualAwareThreadLocalObjectPool(ObjectPool.ObjectSupplier<@NonNull O> supplier, ObjectPool.ObjectSanitizer<@NonNull O> sanitizer) {
        this.tlPool = new ThreadLocalObjectPool<O>(supplier, sanitizer);
        this.cqPool = new ConcurrentQueueObjectPool<O>(supplier, sanitizer, Runtime.getRuntime().availableProcessors() * 2);
    }

    @Override
    public ObjectPool.Lease<O> take() {
        if (ThreadUtil.isVirtualThread()) {
            return this.cqPool.take();
        }
        return this.tlPool.take();
    }
}

