/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.config.gui;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.config.gui.PresenceEditorGui;
import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.Config;
import com.gitlab.cdagaming.craftpresence.core.config.category.Status;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.config.element.PresenceData;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.ConfigurationGui;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedButtonControl;
import io.github.cdagaming.unicore.impl.HashMapBuilder;
import io.github.cdagaming.unicore.impl.Pair;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.Map;
import net.minecraft.client.gui.IGuiEventListener;

public class StatusMessagesGui
extends ConfigurationGui<Status> {
    private final Status INSTANCE;
    private final Status DEFAULTS;
    private final Map<String, Pair<String, Runnable>> eventMappings = new HashMapBuilder().put((Object)"gui.config.name.status_messages.main_menu_message", (Object)new Pair((Object)"mainMenuData", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.status_messages.main_menu_message", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("general.")}))))).put((Object)"gui.config.name.status_messages.loading_message", (Object)new Pair((Object)"loadingData", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.status_messages.loading_message", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("general.")}))))).put((Object)"gui.config.name.status_messages.lan_message", (Object)new Pair((Object)"lanData", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.status_messages.lan_message", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("server.", "world.", "player.")}))))).put((Object)"gui.config.name.status_messages.single_player_message", (Object)new Pair((Object)"singleplayerData", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.status_messages.single_player_message", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("server.", "world.", "player.")}))))).put((Object)"gui.config.name.status_messages.realm_message", (Object)new Pair((Object)"realmData", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.status_messages.realm_message", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("server.", "world.", "player.")}))))).build();

    StatusMessagesGui() {
        super(Constants.TRANSLATOR.translate("gui.config.title", new Object[0]), Constants.TRANSLATOR.translate("gui.config.title.status_messages", new Object[0]));
        this.DEFAULTS = this.getCurrentData().getDefaults();
        this.INSTANCE = this.getCurrentData().copy();
    }

    public void appendElements() {
        super.appendElements();
        int calc1 = this.getScreenWidth() / 2 - 183;
        int calc2 = this.getScreenWidth() / 2 + 3;
        int midCalc = this.getScreenWidth() / 2 - 90;
        int buttonRow = 0;
        int index = 1;
        for (Map.Entry<String, Pair<String, Runnable>> entry : this.eventMappings.entrySet()) {
            int startX;
            boolean isEven = index % 2 == 0;
            int n = startX = isEven ? calc2 : calc1;
            if (index >= this.eventMappings.size() && startX == calc1) {
                startX = midCalc;
            }
            this.childFrame.addControl((IGuiEventListener)new ExtendedButtonControl(startX, this.getButtonY(buttonRow), 180, 20, Constants.TRANSLATOR.getLocalizedMessage(entry.getKey()), () -> this.openScreen(new DynamicEditorGui((String)((Pair)entry.getValue()).getFirst(), (attributeName, screenInstance) -> {
                screenInstance.defaultData = (ModuleData)this.getInstanceData().getDefaults().getProperty((String)attributeName);
                screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
                screenInstance.primaryMessage = screenInstance.originalPrimaryMessage;
                screenInstance.isDefaultValue = true;
                screenInstance.resetText = Constants.TRANSLATOR.translate("gui.config.message.button.reset_to_default", new Object[0]);
            }, (attributeName, screenInstance) -> {
                screenInstance.defaultData = (ModuleData)this.getInstanceData().getDefaults().getProperty((String)attributeName);
                screenInstance.currentData = (ModuleData)this.getInstanceData().getProperty((String)attributeName);
                screenInstance.isPreliminaryData = screenInstance.currentData == null;
                screenInstance.setScreenTitle(Constants.TRANSLATOR.translate("gui.config.title.status.edit_specific_status", new Object[]{attributeName}));
                screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
                screenInstance.primaryMessage = Config.getProperty(screenInstance.currentData, "textOverride") != null ? screenInstance.currentData.getTextOverride() : screenInstance.originalPrimaryMessage;
                screenInstance.isDefaultValue = screenInstance.isPreliminaryData || screenInstance.currentData.equals(screenInstance.defaultData);
                screenInstance.resetText = Constants.TRANSLATOR.translate("gui.config.message.button.reset_to_default", new Object[0]);
            }, screenInstance -> {
                String attributeName = screenInstance.getSecondaryEntry();
                String inputText = screenInstance.getPrimaryEntry();
                screenInstance.currentData.setTextOverride(inputText);
                this.getInstanceData().setProperty(attributeName, screenInstance.currentData);
            }, screenInstance -> {
                String attributeName = screenInstance.getSecondaryEntry();
                this.getInstanceData().resetProperty(attributeName);
            }, (attributeName, screenInstance) -> {
                if (screenInstance.isPresenceButton) {
                    PresenceData defaultPresenceData = Config.getProperty(screenInstance.defaultData, "data") != null ? screenInstance.defaultData.getData() : new PresenceData();
                    PresenceData currentPresenceData = Config.getProperty(screenInstance.currentData, "data") != null ? screenInstance.currentData.getData() : defaultPresenceData;
                    screenInstance.openScreen(new PresenceEditorGui(currentPresenceData, defaultPresenceData, output -> screenInstance.currentData.setData((PresenceData)output)));
                } else {
                    screenInstance.currentData.setIconOverride((String)attributeName);
                }
            })), (Runnable)entry.getValue().getSecond(), new String[0]));
            if (isEven) {
                ++buttonRow;
            }
            ++index;
        }
    }

    @Override
    protected boolean allowedToReset() {
        return true;
    }

    @Override
    protected Status getInstanceData() {
        return this.INSTANCE;
    }

    @Override
    protected Status getCurrentData() {
        return CraftPresence.CONFIG.statusMessages;
    }

    @Override
    protected Status getDefaultData() {
        return this.DEFAULTS;
    }
}

