/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.entity;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.core.config.Config;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.config.element.PresenceData;
import com.gitlab.cdagaming.craftpresence.core.impl.ExtendedModule;
import com.gitlab.cdagaming.craftpresence.core.impl.ExtendedModule$jvmdg$StaticDefaults;
import com.gitlab.cdagaming.craftpresence.core.impl.Module;
import com.gitlab.cdagaming.craftpresence.core.impl.Module$jvmdg$StaticDefaults;
import com.gitlab.cdagaming.unilib.utils.WorldUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiPlayerInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;

public class EntityUtils
implements ExtendedModule {
    public List<String> ENTITY_NAMES = StringUtils.newArrayList();
    public List<String> DEFAULT_NAMES = StringUtils.newArrayList();
    public Map<String, String> PLAYER_BINDINGS = StringUtils.newHashMap();
    private boolean enabled = false;
    private boolean isInUse = false;
    private boolean hasScannedConfig = false;
    private boolean hasScannedInternals = false;
    private boolean hasInitialized = false;
    private boolean hasInitializedTarget = false;
    private boolean hasInitializedRiding = false;
    private String CURRENT_TARGET_NAME;
    private String CURRENT_RIDING_NAME;
    private Entity CURRENT_TARGET;
    private Entity CURRENT_RIDING;

    @Override
    public void clearFieldData() {
        this.DEFAULT_NAMES.clear();
        this.ENTITY_NAMES.clear();
        this.PLAYER_BINDINGS.clear();
    }

    @Override
    public void clearAttributes() {
        this.CURRENT_TARGET = null;
        this.CURRENT_RIDING = null;
        this.CURRENT_TARGET_NAME = null;
        this.CURRENT_RIDING_NAME = null;
        CraftPresence.CLIENT.removeArguments("entity", "data.entity");
        CraftPresence.CLIENT.clearForcedData("entity.target", "entity.riding");
        this.hasInitialized = false;
        this.hasInitializedTarget = false;
        this.hasInitializedRiding = false;
    }

    @Override
    public void updateData() {
        boolean hasRidingChanged;
        Entity NEW_CURRENT_TARGET = CraftPresence.instance.field_71476_x != null && CraftPresence.instance.field_71476_x.field_72308_g != null ? CraftPresence.instance.field_71476_x.field_72308_g : null;
        Entity NEW_CURRENT_RIDING = CraftPresence.player.field_70154_o;
        boolean hasTargetChanged = !Objects.equals(NEW_CURRENT_TARGET, this.CURRENT_TARGET);
        boolean bl = hasRidingChanged = !Objects.equals(NEW_CURRENT_RIDING, this.CURRENT_RIDING);
        if (hasTargetChanged) {
            this.CURRENT_TARGET = NEW_CURRENT_TARGET;
            this.CURRENT_TARGET_NAME = WorldUtils.getEntityName((Entity)this.CURRENT_TARGET);
            if (this.CURRENT_TARGET != null) {
                CraftPresence.CLIENT.syncTimestamp("data.entity.target.time");
                if (!this.DEFAULT_NAMES.contains(this.CURRENT_TARGET_NAME)) {
                    this.DEFAULT_NAMES.add(this.CURRENT_TARGET_NAME);
                }
                if (!this.ENTITY_NAMES.contains(this.CURRENT_TARGET_NAME)) {
                    this.ENTITY_NAMES.add(this.CURRENT_TARGET_NAME);
                }
            }
        }
        if (hasRidingChanged) {
            this.CURRENT_RIDING = NEW_CURRENT_RIDING;
            this.CURRENT_RIDING_NAME = WorldUtils.getEntityName((Entity)this.CURRENT_RIDING);
            if (this.CURRENT_RIDING != null) {
                CraftPresence.CLIENT.syncTimestamp("data.entity.riding.time");
                if (!this.DEFAULT_NAMES.contains(this.CURRENT_RIDING_NAME)) {
                    this.DEFAULT_NAMES.add(this.CURRENT_RIDING_NAME);
                }
                if (!this.ENTITY_NAMES.contains(this.CURRENT_RIDING_NAME)) {
                    this.ENTITY_NAMES.add(this.CURRENT_RIDING_NAME);
                }
            }
        }
        if (hasTargetChanged || hasRidingChanged) {
            if (!this.hasInitialized) {
                this.initPresence();
                this.hasInitialized = true;
            }
            this.updatePresence();
        }
    }

    @Override
    public void initPresence() {
        this.syncArgument("entity.default.icon", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$0(), ()Ljava/lang/Object;)());
    }

    @Override
    public void updatePresence() {
        if (this.CURRENT_TARGET != null) {
            if (!this.hasInitializedTarget) {
                this.syncArgument("data.entity.target.instance", (Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$1(), ()Ljava/lang/Boolean;)((EntityUtils)this), (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$2(), ()Ljava/lang/Object;)((EntityUtils)this), true);
                this.syncArgument("data.entity.target.class", (Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$3(), ()Ljava/lang/Boolean;)((EntityUtils)this), (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$4(), ()Ljava/lang/Object;)((EntityUtils)this), true);
                this.syncArgument("entity.target.name", (Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$5(), ()Ljava/lang/Boolean;)((EntityUtils)this), (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$6(), ()Ljava/lang/Object;)((EntityUtils)this), true);
                this.syncArgument("entity.target.message", (Supplier)(Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$7(), ()Ljava/lang/Boolean;)((EntityUtils)this), (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$8(), ()Ljava/lang/Object;)((EntityUtils)this));
                this.syncArgument("entity.target.icon", (Supplier)(Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$9(), ()Ljava/lang/Boolean;)((EntityUtils)this), (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$10(), ()Ljava/lang/Object;)((EntityUtils)this));
                CraftPresence.CLIENT.addForcedData("entity.target", (Supplier<PresenceData>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$11(), ()Lcom/gitlab/cdagaming/craftpresence/core/config/element/PresenceData;)((EntityUtils)this));
                this.hasInitializedTarget = true;
            }
        } else if (this.hasInitializedTarget) {
            CraftPresence.CLIENT.removeArguments("entity.target", "data.entity.target");
            CraftPresence.CLIENT.clearForcedData("entity.target");
            this.hasInitializedTarget = false;
        }
        if (this.CURRENT_RIDING != null) {
            if (!this.hasInitializedRiding) {
                this.syncArgument("data.entity.riding.instance", (Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$12(), ()Ljava/lang/Boolean;)((EntityUtils)this), (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$13(), ()Ljava/lang/Object;)((EntityUtils)this), true);
                this.syncArgument("data.entity.riding.class", (Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$14(), ()Ljava/lang/Boolean;)((EntityUtils)this), (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$15(), ()Ljava/lang/Object;)((EntityUtils)this), true);
                this.syncArgument("entity.riding.name", (Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$16(), ()Ljava/lang/Boolean;)((EntityUtils)this), (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$17(), ()Ljava/lang/Object;)((EntityUtils)this), true);
                this.syncArgument("entity.riding.message", (Supplier)(Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$18(), ()Ljava/lang/Boolean;)((EntityUtils)this), (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$19(), ()Ljava/lang/Object;)((EntityUtils)this));
                this.syncArgument("entity.riding.icon", (Supplier)(Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$20(), ()Ljava/lang/Boolean;)((EntityUtils)this), (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$21(), ()Ljava/lang/Object;)((EntityUtils)this));
                CraftPresence.CLIENT.addForcedData("entity.riding", (Supplier<PresenceData>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$22(), ()Lcom/gitlab/cdagaming/craftpresence/core/config/element/PresenceData;)((EntityUtils)this));
                this.hasInitializedRiding = true;
            }
        } else if (this.hasInitializedRiding) {
            CraftPresence.CLIENT.removeArguments("entity.riding", "data.entity.riding");
            CraftPresence.CLIENT.clearForcedData("entity.riding");
            this.hasInitializedRiding = false;
        }
    }

    @Override
    public void getInternalData() {
        Map mappings = (Map)StringUtils.getField(EntityList.class, null, (String[])new String[]{"classToStringMapping", "field_75626_c", "field_3269", "c"});
        if (!mappings.values().isEmpty()) {
            for (Object entityLocationObj : mappings.values()) {
                String entityLocation = (String)entityLocationObj;
                if (entityLocation == null) continue;
                String entityName = StringUtils.getOrDefault((String)entityLocation, (String)"generic");
                if (!this.DEFAULT_NAMES.contains(entityName)) {
                    this.DEFAULT_NAMES.add(entityName);
                }
                if (this.ENTITY_NAMES.contains(entityName)) continue;
                this.ENTITY_NAMES.add(entityName);
            }
        }
        if (CraftPresence.SERVER.isEnabled()) {
            for (GuiPlayerInfo playerInfo : CraftPresence.SERVER.currentPlayerList) {
                String uuidString;
                if (playerInfo == null || StringUtils.isNullOrEmpty((String)(uuidString = playerInfo.field_78831_a))) continue;
                if (!this.ENTITY_NAMES.contains(uuidString)) {
                    this.ENTITY_NAMES.add(uuidString);
                }
                if (this.PLAYER_BINDINGS.containsKey(uuidString)) continue;
                this.PLAYER_BINDINGS.put(uuidString, uuidString);
            }
        }
    }

    @Override
    public void getConfigData() {
        for (String entityTargetEntry : CraftPresence.CONFIG.advancedSettings.entitySettings.targetData.keySet()) {
            if (StringUtils.isNullOrEmpty((String)entityTargetEntry) || this.ENTITY_NAMES.contains(entityTargetEntry)) continue;
            this.ENTITY_NAMES.add(entityTargetEntry);
        }
        for (String entityRidingEntry : CraftPresence.CONFIG.advancedSettings.entitySettings.ridingData.keySet()) {
            if (StringUtils.isNullOrEmpty((String)entityRidingEntry) || this.ENTITY_NAMES.contains(entityRidingEntry)) continue;
            this.ENTITY_NAMES.add(entityRidingEntry);
        }
    }

    @Override
    public void syncArgument(String argumentName, Supplier<Boolean> condition, Supplier<Object> event, boolean plain) {
        CraftPresence.CLIENT.syncArgument(argumentName, this.getModuleFunction((Supplier)condition, (Supplier)event), plain);
    }

    @Override
    public String getOverrideText(ModuleData data) {
        return CraftPresence.CLIENT.getOverrideText(this.getPresenceData(data));
    }

    @Override
    public boolean hasScannedInternals() {
        return this.hasScannedInternals;
    }

    @Override
    public void setScannedInternals(boolean state) {
        this.hasScannedInternals = state;
    }

    @Override
    public boolean canFetchConfig() {
        return CraftPresence.CONFIG != null;
    }

    @Override
    public boolean hasScannedConfig() {
        return this.hasScannedConfig;
    }

    @Override
    public void setScannedConfig(boolean state) {
        this.hasScannedConfig = state;
    }

    @Override
    public boolean canBeEnabled() {
        return !CraftPresence.CONFIG.hasChanged() ? CraftPresence.CONFIG.advancedSettings.enablePerEntity : this.isEnabled();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean canBeUsed() {
        return CraftPresence.player != null;
    }

    @Override
    public boolean isInUse() {
        return this.isInUse;
    }

    @Override
    public void setInUse(boolean state) {
        this.isInUse = state;
    }

    private /* synthetic */ PresenceData lambda$updatePresence$22() {
        if (!this.isInUse() || this.CURRENT_RIDING == null) {
            return null;
        }
        ModuleData defaultData = CraftPresence.CONFIG.advancedSettings.entitySettings.ridingData.get("default");
        ModuleData currentData = CraftPresence.CONFIG.advancedSettings.entitySettings.ridingData.get(this.CURRENT_RIDING_NAME);
        return this.getPresenceData(currentData != null ? currentData : defaultData);
    }

    private /* synthetic */ Object lambda$updatePresence$21() {
        ModuleData defaultData = CraftPresence.CONFIG.advancedSettings.entitySettings.ridingData.get("default");
        ModuleData currentData = CraftPresence.CONFIG.advancedSettings.entitySettings.ridingData.get(this.CURRENT_RIDING_NAME);
        String defaultIcon = Config.isValidProperty(defaultData, "iconOverride") ? defaultData.getIconOverride() : this.CURRENT_RIDING_NAME;
        String currentIcon = Config.isValidProperty(currentData, "iconOverride") ? currentData.getIconOverride() : defaultIcon;
        return this.getResult(CraftPresence.CLIENT.imageOf(true, currentIcon, CraftPresence.CONFIG.advancedSettings.entitySettings.fallbackEntityIcon), currentData != null ? currentData : defaultData);
    }

    private /* synthetic */ Boolean lambda$updatePresence$20() {
        return this.CURRENT_RIDING != null;
    }

    private /* synthetic */ Object lambda$updatePresence$19() {
        ModuleData defaultData = CraftPresence.CONFIG.advancedSettings.entitySettings.ridingData.get("default");
        ModuleData currentData = CraftPresence.CONFIG.advancedSettings.entitySettings.ridingData.get(this.CURRENT_RIDING_NAME);
        String defaultMessage = Config.isValidProperty(defaultData, "textOverride") ? defaultData.getTextOverride() : "";
        return this.getResult(Config.isValidProperty(currentData, "textOverride") ? currentData.getTextOverride() : defaultMessage, currentData != null ? currentData : defaultData);
    }

    private /* synthetic */ Boolean lambda$updatePresence$18() {
        return this.CURRENT_RIDING != null;
    }

    private /* synthetic */ Object lambda$updatePresence$17() {
        return this.CURRENT_RIDING_NAME;
    }

    private /* synthetic */ Boolean lambda$updatePresence$16() {
        return this.CURRENT_RIDING != null;
    }

    private /* synthetic */ Object lambda$updatePresence$15() {
        return this.CURRENT_RIDING.getClass();
    }

    private /* synthetic */ Boolean lambda$updatePresence$14() {
        return this.CURRENT_RIDING != null;
    }

    private /* synthetic */ Object lambda$updatePresence$13() {
        return this.CURRENT_RIDING;
    }

    private /* synthetic */ Boolean lambda$updatePresence$12() {
        return this.CURRENT_RIDING != null;
    }

    private /* synthetic */ PresenceData lambda$updatePresence$11() {
        if (!this.isInUse() || this.CURRENT_TARGET == null) {
            return null;
        }
        ModuleData defaultData = CraftPresence.CONFIG.advancedSettings.entitySettings.targetData.get("default");
        ModuleData currentData = CraftPresence.CONFIG.advancedSettings.entitySettings.targetData.get(this.CURRENT_TARGET_NAME);
        return this.getPresenceData(currentData != null ? currentData : defaultData);
    }

    private /* synthetic */ Object lambda$updatePresence$10() {
        ModuleData defaultData = CraftPresence.CONFIG.advancedSettings.entitySettings.targetData.get("default");
        ModuleData currentData = CraftPresence.CONFIG.advancedSettings.entitySettings.targetData.get(this.CURRENT_TARGET_NAME);
        String defaultIcon = Config.isValidProperty(defaultData, "iconOverride") ? defaultData.getIconOverride() : this.CURRENT_TARGET_NAME;
        String currentIcon = Config.isValidProperty(currentData, "iconOverride") ? currentData.getIconOverride() : defaultIcon;
        return this.getResult(CraftPresence.CLIENT.imageOf(true, currentIcon, CraftPresence.CONFIG.advancedSettings.entitySettings.fallbackEntityIcon), currentData != null ? currentData : defaultData);
    }

    private /* synthetic */ Boolean lambda$updatePresence$9() {
        return this.CURRENT_TARGET != null;
    }

    private /* synthetic */ Object lambda$updatePresence$8() {
        ModuleData defaultData = CraftPresence.CONFIG.advancedSettings.entitySettings.targetData.get("default");
        ModuleData currentData = CraftPresence.CONFIG.advancedSettings.entitySettings.targetData.get(this.CURRENT_TARGET_NAME);
        String defaultMessage = Config.isValidProperty(defaultData, "textOverride") ? defaultData.getTextOverride() : "";
        return this.getResult(Config.isValidProperty(currentData, "textOverride") ? currentData.getTextOverride() : defaultMessage, currentData != null ? currentData : defaultData);
    }

    private /* synthetic */ Boolean lambda$updatePresence$7() {
        return this.CURRENT_TARGET != null;
    }

    private /* synthetic */ Object lambda$updatePresence$6() {
        return this.CURRENT_TARGET_NAME;
    }

    private /* synthetic */ Boolean lambda$updatePresence$5() {
        return this.CURRENT_TARGET != null;
    }

    private /* synthetic */ Object lambda$updatePresence$4() {
        return this.CURRENT_TARGET.getClass();
    }

    private /* synthetic */ Boolean lambda$updatePresence$3() {
        return this.CURRENT_TARGET != null;
    }

    private /* synthetic */ Object lambda$updatePresence$2() {
        return this.CURRENT_TARGET;
    }

    private /* synthetic */ Boolean lambda$updatePresence$1() {
        return this.CURRENT_TARGET != null;
    }

    private static /* synthetic */ Object lambda$initPresence$0() {
        return CraftPresence.CONFIG.advancedSettings.entitySettings.fallbackEntityIcon;
    }

    @Override
    public boolean canBeLoaded() {
        return Module$jvmdg$StaticDefaults.canBeLoaded(this);
    }

    @Override
    public ModuleData getOrDefault(ModuleData[] moduleDataArray) {
        return ExtendedModule$jvmdg$StaticDefaults.getOrDefault((ExtendedModule)this, moduleDataArray);
    }

    @Override
    public void clearClientData() {
        Module$jvmdg$StaticDefaults.clearClientData(this);
    }

    @Override
    public void postTick() {
        Module$jvmdg$StaticDefaults.postTick(this);
    }

    @Override
    public void markInternalsScanned() {
        Module$jvmdg$StaticDefaults.markInternalsScanned(this);
    }

    public void syncArgument(String string, Supplier supplier, Supplier supplier2) {
        Module$jvmdg$StaticDefaults.syncArgument((Module)this, string, supplier, supplier2);
    }

    @Override
    public String getResult(String string, ModuleData moduleData) {
        return ExtendedModule$jvmdg$StaticDefaults.getResult((ExtendedModule)this, string, moduleData);
    }

    @Override
    public void markConfigScanned() {
        Module$jvmdg$StaticDefaults.markConfigScanned(this);
    }

    @Override
    public String getDefaultId() {
        return ExtendedModule$jvmdg$StaticDefaults.getDefaultId(this);
    }

    @Override
    public void clearActiveData() {
        Module$jvmdg$StaticDefaults.clearActiveData(this);
    }

    @Override
    public ModuleData getOrDefault(String[] stringArray) {
        return ExtendedModule$jvmdg$StaticDefaults.getOrDefault((ExtendedModule)this, stringArray);
    }

    @Override
    public void emptyData() {
        Module$jvmdg$StaticDefaults.emptyData(this);
    }

    public void syncArgument(String string, Supplier supplier, boolean bl) {
        Module$jvmdg$StaticDefaults.syncArgument((Module)this, string, supplier, bl);
    }

    @Override
    public void queueConfigScan() {
        Module$jvmdg$StaticDefaults.queueConfigScan(this);
    }

    @Override
    public void preTick() {
        Module$jvmdg$StaticDefaults.preTick(this);
    }

    @Override
    public String getResult(String string, String[] stringArray) {
        return ExtendedModule$jvmdg$StaticDefaults.getResult((ExtendedModule)this, string, stringArray);
    }

    @Override
    public ModuleData getData(String string) {
        return ExtendedModule$jvmdg$StaticDefaults.getData(this, string);
    }

    @Override
    public PresenceData getPresenceData(ModuleData moduleData) {
        return ExtendedModule$jvmdg$StaticDefaults.getPresenceData((ExtendedModule)this, moduleData);
    }

    public void syncArgument(String string, Supplier supplier) {
        Module$jvmdg$StaticDefaults.syncArgument(this, string, supplier);
    }

    @Override
    public void printException(Throwable throwable) {
        Module$jvmdg$StaticDefaults.printException(this, throwable);
    }

    @Override
    public ModuleData getDefaultData() {
        return ExtendedModule$jvmdg$StaticDefaults.getDefaultData(this);
    }

    @Override
    public PresenceData getPresenceData(String[] stringArray) {
        return ExtendedModule$jvmdg$StaticDefaults.getPresenceData((ExtendedModule)this, stringArray);
    }

    @Override
    public String getOverrideText(String[] stringArray) {
        return ExtendedModule$jvmdg$StaticDefaults.getOverrideText(this, stringArray);
    }

    public Supplier getModuleFunction(Supplier supplier) {
        return Module$jvmdg$StaticDefaults.getModuleFunction(this, supplier);
    }

    @Override
    public void scanConfigData() {
        Module$jvmdg$StaticDefaults.scanConfigData(this);
    }

    @Override
    public void scanInternalData() {
        Module$jvmdg$StaticDefaults.scanInternalData(this);
    }

    @Override
    public void queueInternalScan() {
        Module$jvmdg$StaticDefaults.queueInternalScan(this);
    }

    public Supplier getModuleFunction(Supplier supplier, Supplier supplier2) {
        return Module$jvmdg$StaticDefaults.getModuleFunction(this, supplier, supplier2);
    }

    @Override
    public void onTick() {
        Module$jvmdg$StaticDefaults.onTick(this);
    }

    @Override
    public boolean canFetchInternals() {
        return Module$jvmdg$StaticDefaults.canFetchInternals(this);
    }
}

