/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.moonconfig.core.file;

import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import me.hypherionmc.moonconfig.core.ConfigFormat;
import me.hypherionmc.moonconfig.core.utils.StringUtils;

public final class FormatDetector {
    private static final Map<String, Supplier<ConfigFormat<?>>> registry = new ConcurrentHashMap();

    public static void registerExtension(String fileExtension, ConfigFormat<?> format) {
        registry.put(fileExtension, (Supplier<ConfigFormat>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$registerExtension$0(me.hypherionmc.moonconfig.core.ConfigFormat ), ()Lme/hypherionmc/moonconfig/core/ConfigFormat;)(format));
    }

    public static void registerExtension(String fileExtension, Supplier<ConfigFormat<?>> formatSupplier) {
        registry.put(fileExtension, formatSupplier);
    }

    public static ConfigFormat<?> detect(File file) {
        return FormatDetector.detectByName(file.getName());
    }

    public static ConfigFormat<?> detect(Path file) {
        return FormatDetector.detectByName(file.getFileName().toString());
    }

    public static ConfigFormat<?> detectByName(String fileName) {
        List<String> splitted = StringUtils.split(fileName, '.');
        String fileExtension = splitted.get(splitted.size() - 1);
        Supplier<ConfigFormat<?>> supplier = registry.get(fileExtension);
        return supplier == null ? null : supplier.get();
    }

    private static void tryLoad(String className) {
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private FormatDetector() {
    }

    private static /* synthetic */ ConfigFormat lambda$registerExtension$0(ConfigFormat format) {
        return format;
    }

    static {
        FormatDetector.tryLoad("me.hypherionmc.moonconfig.toml.TomlFormat");
        FormatDetector.tryLoad("me.hypherionmc.moonconfig.hocon.HoconFormat");
        FormatDetector.tryLoad("me.hypherionmc.moonconfig.json.JsonFormat");
        FormatDetector.tryLoad("me.hypherionmc.moonconfig.yaml.YamlFormat");
    }
}

