/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.config.gui;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.category.Accessibility;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.ConfigurationGui;
import com.gitlab.cdagaming.unilib.core.CoreUtils;
import com.gitlab.cdagaming.unilib.utils.KeyUtils;
import com.gitlab.cdagaming.unilib.utils.gui.controls.CheckBoxControl;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedTextControl;
import com.gitlab.cdagaming.unilib.utils.gui.impl.ControlsGui;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.TextWidget;
import io.github.cdagaming.unicore.utils.StringUtils;
import net.minecraft.client.gui.Gui;

public class AccessibilitySettingsGui
extends ConfigurationGui<Accessibility> {
    private final Accessibility INSTANCE;
    private final Accessibility DEFAULTS = this.getCurrentData().getDefaults();
    private final boolean isTextFormattingBlocked;
    private ExtendedTextControl languageIdText;
    private CheckBoxControl stripTranslationColorsButton;
    private CheckBoxControl stripTranslationFormattingButton;
    private CheckBoxControl stripExtraGuiElementsButton;
    private ExtendedButtonControl controlsButton;

    AccessibilitySettingsGui() {
        super(Constants.TRANSLATOR.translate("gui.config.title", new Object[0]), Constants.TRANSLATOR.translate("gui.config.title.accessibility", new Object[0]));
        this.INSTANCE = this.getCurrentData().copy();
        this.isTextFormattingBlocked = CoreUtils.isTextFormattingBlocked((int)AccessibilitySettingsGui.getProtocol());
    }

    public void appendElements() {
        super.appendElements();
        int calc1 = this.getScreenWidth() / 2 - 183;
        int calc2 = this.getScreenWidth() / 2 + 3;
        this.languageIdText = (ExtendedTextControl)this.childFrame.addControl((Gui)new TextWidget(this.getFontRenderer(), this.getButtonY(0), 180, 20, () -> {
            this.getInstanceData().languageId = this.languageIdText.getControlMessage();
        }, Constants.TRANSLATOR.translate("gui.config.name.accessibility.language_id", new Object[0]), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.accessibility.language_id", new Object[0])))));
        this.languageIdText.setControlMessage(this.getInstanceData().languageId);
        this.stripTranslationColorsButton = (CheckBoxControl)this.childFrame.addControl((Gui)new CheckBoxControl(calc1, this.getButtonY(1), Constants.TRANSLATOR.translate("gui.config.name.accessibility.strip_translation_colors", new Object[0]), this.getInstanceData().stripTranslationColors, () -> {
            this.getInstanceData().stripTranslationColors = this.stripTranslationColorsButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.accessibility.strip_translation_colors", new Object[0])))));
        this.stripTranslationFormattingButton = (CheckBoxControl)this.childFrame.addControl((Gui)new CheckBoxControl(calc1, this.getButtonY(2, -10), Constants.TRANSLATOR.translate("gui.config.name.accessibility.strip_translation_formatting", new Object[0]), this.getInstanceData().stripTranslationFormatting, () -> {
            this.getInstanceData().stripTranslationFormatting = this.stripTranslationFormattingButton.isChecked();
        }, () -> {
            if (this.stripTranslationFormattingButton.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.accessibility.strip_translation_formatting", new Object[0])));
            } else if (this.isTextFormattingBlocked) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("craftpresence.message.unsupported", new Object[0])));
            }
        }));
        this.stripTranslationFormattingButton.setControlEnabled(!this.isTextFormattingBlocked);
        this.stripExtraGuiElementsButton = (CheckBoxControl)this.childFrame.addControl((Gui)new CheckBoxControl(calc1, this.getButtonY(3, -20), Constants.TRANSLATOR.translate("gui.config.name.accessibility.strip_extra_gui_elements", new Object[0]), this.getInstanceData().stripExtraGuiElements, () -> {
            this.getInstanceData().stripExtraGuiElements = this.stripExtraGuiElementsButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.accessibility.strip_extra_gui_elements", new Object[0])))));
        this.controlsButton = (ExtendedButtonControl)this.childFrame.addControl((Gui)new ExtendedButtonControl(calc2, this.getButtonY(1), 180, 20, "Controls", () -> this.openScreen((ExtendedScreen)new ControlsGui(KeyUtils.INSTANCE, () -> this.markAsChanged(), new String[]{"key.craftpresence.category"})), new String[0]));
    }

    @Override
    protected boolean allowedToReset() {
        return true;
    }

    @Override
    protected void syncRenderStates() {
        super.syncRenderStates();
        this.controlsButton.setControlEnabled(KeyUtils.INSTANCE.areKeysRegistered());
        this.proceedButton.setControlEnabled(!StringUtils.isNullOrEmpty((String)this.languageIdText.getControlMessage()));
    }

    @Override
    protected Accessibility getInstanceData() {
        return this.INSTANCE;
    }

    @Override
    protected Accessibility getCurrentData() {
        return CraftPresence.CONFIG.accessibilitySettings;
    }

    @Override
    protected Accessibility getDefaultData() {
        return this.DEFAULTS;
    }
}

