/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.config.gui;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.config.gui.PresenceEditorGui;
import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.Config;
import com.gitlab.cdagaming.craftpresence.core.config.category.Biome;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.config.element.PresenceData;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.DynamicScrollableList;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.ConfigurationGui;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicSelectorGui;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.TextWidget;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class BiomeSettingsGui
extends ConfigurationGui<Biome> {
    private final Biome INSTANCE;
    private final Biome DEFAULTS = this.getCurrentData().getDefaults();
    private ExtendedButtonControl biomeMessagesButton;
    private TextWidget defaultMessage;
    private TextWidget defaultIcon;

    BiomeSettingsGui() {
        super(Constants.TRANSLATOR.translate("gui.config.title", new Object[0]), Constants.TRANSLATOR.translate("gui.config.title.biome_messages", new Object[0]));
        this.INSTANCE = this.getCurrentData().copy();
    }

    @Override
    protected void appendControls() {
        super.appendControls();
        ModuleData defaultData = this.getInstanceData().biomeData.get("default");
        String defaultBiomeMessage = Config.getProperty(defaultData, "textOverride") != null ? defaultData.getTextOverride() : "";
        this.defaultMessage = (TextWidget)this.childFrame.addControl((nq)new TextWidget(this.getFontRenderer(), this.getButtonY(0), 180, 20, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$appendControls$0(), ()V)((BiomeSettingsGui)this), Constants.TRANSLATOR.translate("gui.config.message.default.biome", new Object[0]), (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$appendControls$1(), ()V)((BiomeSettingsGui)this)));
        this.defaultMessage.setControlMessage(defaultBiomeMessage);
        this.defaultIcon = (TextWidget)this.childFrame.addControl((nq)new TextWidget(this.getFontRenderer(), this.getButtonY(1), 147, 20, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$appendControls$2(), ()V)((BiomeSettingsGui)this), Constants.TRANSLATOR.translate("gui.config.name.biome_messages.biome_icon", new Object[0]), (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$appendControls$3(), ()V)((BiomeSettingsGui)this)));
        this.addIconSelector((ExtendedScreen)this.childFrame, (Supplier<TextWidget>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$appendControls$4(), ()Lcom/gitlab/cdagaming/unilib/utils/gui/widgets/TextWidget;)((BiomeSettingsGui)this), (BiConsumer<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$appendControls$5(java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)V)((BiomeSettingsGui)this));
        this.defaultIcon.setControlMessage(this.getInstanceData().fallbackBiomeIcon);
        this.biomeMessagesButton = (ExtendedButtonControl)this.childFrame.addControl((nq)new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getButtonY(2), 180, 20, Constants.TRANSLATOR.translate("gui.config.name.biome_messages.biome_messages", new Object[0]), (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$appendControls$15(), ()V)((BiomeSettingsGui)this), (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$appendControls$16(), ()V)((BiomeSettingsGui)this), new String[0]));
        this.proceedButton.setOnHover((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$appendControls$17(), ()V)((BiomeSettingsGui)this));
    }

    @Override
    protected boolean allowedToReset() {
        return true;
    }

    @Override
    protected void syncRenderStates() {
        super.syncRenderStates();
        this.proceedButton.setControlEnabled(!StringUtils.isNullOrEmpty((String)this.defaultMessage.getControlMessage()));
        this.biomeMessagesButton.setControlEnabled(CraftPresence.BIOMES.isEnabled());
    }

    @Override
    protected Biome getInstanceData() {
        return this.INSTANCE;
    }

    @Override
    protected Biome getCurrentData() {
        return CraftPresence.CONFIG.biomeSettings;
    }

    @Override
    protected Biome getDefaultData() {
        return this.DEFAULTS;
    }

    private /* synthetic */ void lambda$appendControls$17() {
        if (!this.proceedButton.isControlEnabled()) {
            this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.hover.empty.default", new Object[0])));
        }
    }

    private /* synthetic */ void lambda$appendControls$16() {
        if (!this.biomeMessagesButton.isControlEnabled()) {
            this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.hover.access", new Object[]{Constants.TRANSLATOR.translate("gui.config.name.general.detect_biome_data", new Object[0])})));
        } else {
            this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.biome_messages.biome_messages", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("biome.")})));
        }
    }

    private /* synthetic */ void lambda$appendControls$15() {
        this.openScreen((ExtendedScreen)new DynamicSelectorGui(Constants.TRANSLATOR.translate("gui.config.title.selector.biome", new Object[0]), CraftPresence.BIOMES.BIOME_NAMES, null, null, true, true, DynamicScrollableList.RenderType.None, (BiConsumer<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$appendControls$6(java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)V)((BiomeSettingsGui)this), (BiConsumer<String, br>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$appendControls$14(java.lang.String br ), (Ljava/lang/String;Lbr;)V)((BiomeSettingsGui)this)));
    }

    private /* synthetic */ void lambda$appendControls$14(String currentValue, br parentScreen) {
        this.openScreen(new DynamicEditorGui(currentValue, (BiConsumer<String, DynamicEditorGui>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$appendControls$7(java.lang.String com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui ), (Ljava/lang/String;Lcom/gitlab/cdagaming/craftpresence/utils/gui/impl/DynamicEditorGui;)V)((BiomeSettingsGui)this), (BiConsumer<String, DynamicEditorGui>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$appendControls$8(java.lang.String com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui ), (Ljava/lang/String;Lcom/gitlab/cdagaming/craftpresence/utils/gui/impl/DynamicEditorGui;)V)((BiomeSettingsGui)this), (Consumer<DynamicEditorGui>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$appendControls$9(com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui ), (Lcom/gitlab/cdagaming/craftpresence/utils/gui/impl/DynamicEditorGui;)V)((BiomeSettingsGui)this), (Consumer<DynamicEditorGui>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$appendControls$10(com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui ), (Lcom/gitlab/cdagaming/craftpresence/utils/gui/impl/DynamicEditorGui;)V)((BiomeSettingsGui)this), (BiConsumer<String, DynamicEditorGui>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$appendControls$12(java.lang.String com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui ), (Ljava/lang/String;Lcom/gitlab/cdagaming/craftpresence/utils/gui/impl/DynamicEditorGui;)V)(), (BiConsumer<String, DynamicEditorGui>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$appendControls$13(java.lang.String com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui ), (Ljava/lang/String;Lcom/gitlab/cdagaming/craftpresence/utils/gui/impl/DynamicEditorGui;)V)()), parentScreen);
    }

    private static /* synthetic */ void lambda$appendControls$13(String attributeName, DynamicEditorGui screenInstance) {
        screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.biome_messages.biome_messages", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("biome.")})));
    }

    private static /* synthetic */ void lambda$appendControls$12(String attributeName, DynamicEditorGui screenInstance) {
        if (screenInstance.isPresenceButton) {
            PresenceData defaultPresenceData = Config.getProperty(screenInstance.defaultData, "data") != null ? screenInstance.defaultData.getData() : new PresenceData();
            PresenceData currentPresenceData = Config.getProperty(screenInstance.currentData, "data") != null ? screenInstance.currentData.getData() : defaultPresenceData;
            screenInstance.openScreen(new PresenceEditorGui(currentPresenceData, defaultPresenceData, (Consumer<PresenceData>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$appendControls$11(com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui com.gitlab.cdagaming.craftpresence.core.config.element.PresenceData ), (Lcom/gitlab/cdagaming/craftpresence/core/config/element/PresenceData;)V)((DynamicEditorGui)screenInstance)));
        } else {
            screenInstance.currentData.setIconOverride(attributeName);
        }
    }

    private static /* synthetic */ void lambda$appendControls$11(DynamicEditorGui screenInstance, PresenceData output) {
        screenInstance.currentData.setData(output);
    }

    private /* synthetic */ void lambda$appendControls$10(DynamicEditorGui screenInstance) {
        String attributeName = screenInstance.getSecondaryEntry();
        this.getInstanceData().biomeData.remove(attributeName);
        if (!CraftPresence.BIOMES.DEFAULT_NAMES.contains(attributeName)) {
            CraftPresence.BIOMES.BIOME_NAMES.remove(attributeName);
        }
    }

    private /* synthetic */ void lambda$appendControls$9(DynamicEditorGui screenInstance) {
        String attributeName = screenInstance.getSecondaryEntry();
        String inputText = screenInstance.getPrimaryEntry();
        screenInstance.currentData.setTextOverride(inputText);
        this.getInstanceData().biomeData.put(attributeName, screenInstance.currentData);
        if (!CraftPresence.BIOMES.BIOME_NAMES.contains(attributeName)) {
            CraftPresence.BIOMES.BIOME_NAMES.add(attributeName);
        }
    }

    private /* synthetic */ void lambda$appendControls$8(String attributeName, DynamicEditorGui screenInstance) {
        screenInstance.defaultData = this.getInstanceData().biomeData.get("default");
        screenInstance.currentData = this.getInstanceData().biomeData.get(attributeName);
        screenInstance.isPreliminaryData = screenInstance.currentData == null;
        screenInstance.setScreenTitle(Constants.TRANSLATOR.translate("gui.config.title.biome.edit_specific_biome", new Object[]{attributeName}));
        screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
        screenInstance.primaryMessage = Config.getProperty(screenInstance.currentData, "textOverride") != null ? screenInstance.currentData.getTextOverride() : screenInstance.originalPrimaryMessage;
    }

    private /* synthetic */ void lambda$appendControls$7(String attributeName, DynamicEditorGui screenInstance) {
        screenInstance.defaultData = this.getInstanceData().biomeData.get("default");
        screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
        screenInstance.primaryMessage = screenInstance.originalPrimaryMessage;
    }

    private /* synthetic */ void lambda$appendControls$6(String attributeName, String currentValue) {
        ModuleData defaultBiomeData = this.getInstanceData().biomeData.get("default");
        ModuleData currentBiomeData = this.getInstanceData().biomeData.get(attributeName);
        String defaultMessage = Config.getProperty(defaultBiomeData, "textOverride") != null ? defaultBiomeData.getTextOverride() : "";
        String currentMessage = Config.getProperty(currentBiomeData, "textOverride") != null ? currentBiomeData.getTextOverride() : "";
        ModuleData newData = new ModuleData();
        if (StringUtils.isNullOrEmpty((String)currentMessage) || currentMessage.equals(defaultMessage)) {
            newData.setTextOverride(defaultMessage);
        }
        newData.setIconOverride(currentValue);
        this.getInstanceData().biomeData.put(attributeName, newData);
    }

    private /* synthetic */ void lambda$appendControls$5(String attributeName, String currentValue) {
        this.getInstanceData().fallbackBiomeIcon = currentValue;
    }

    private /* synthetic */ TextWidget lambda$appendControls$4() {
        return this.defaultIcon;
    }

    private /* synthetic */ void lambda$appendControls$3() {
        this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.biome_messages.biome_icon", new Object[0])));
    }

    private /* synthetic */ void lambda$appendControls$2() {
        this.getInstanceData().fallbackBiomeIcon = this.defaultIcon.getControlMessage();
    }

    private /* synthetic */ void lambda$appendControls$1() {
        this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.biome_messages.biome_messages", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("biome.")})));
    }

    private /* synthetic */ void lambda$appendControls$0() {
        ModuleData defaultBiomeData = this.getInstanceData().biomeData.getOrDefault("default", new ModuleData());
        defaultBiomeData.setTextOverride(this.defaultMessage.getControlMessage());
        this.getInstanceData().biomeData.put("default", defaultBiomeData);
    }
}

