/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.gui.controls;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.impl.discord.CompiledPresence;
import com.gitlab.cdagaming.unilib.core.impl.screen.ScreenConstants;
import com.gitlab.cdagaming.unilib.utils.gui.RenderUtils;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.DynamicWidget;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.ScrollableTextWidget;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.TexturedWidget;
import craftpresence.external.com.jagrosh.discordipc.entities.ActivityType;
import io.github.cdagaming.unicore.utils.StringUtils;
import io.github.cdagaming.unicore.utils.UrlUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class PresenceVisualizer {
    private final List<ExtendedButtonControl> buttons = StringUtils.newArrayList();
    private final List<ScrollableTextWidget> lines = StringUtils.newArrayList();
    private final ExtendedScreen screen;
    private final boolean showPartyToggle;
    private final boolean autoRefresh;
    private boolean showPartyData;
    private ScreenConstants.ColorData largeImageData;
    private ScreenConstants.ColorData smallImageData;
    private TexturedWidget largeWidget;
    private TexturedWidget smallWidget;
    private Supplier<CompiledPresence> presenceSupplier;
    private CompiledPresence lastCompiledPresence;

    public PresenceVisualizer(ExtendedScreen screen, boolean autoRefresh) {
        this.screen = screen;
        this.autoRefresh = autoRefresh;
        this.showPartyToggle = !autoRefresh;
    }

    public PresenceVisualizer(ExtendedScreen screen) {
        this(screen, false);
    }

    public void setupVisualizer(int calc1, int calc2, int controlIndex, boolean canLoad, ExtendedScreen childFrame, Supplier<CompiledPresence> richPresence) {
        this.largeWidget = null;
        this.smallWidget = null;
        this.lines.clear();
        this.buttons.clear();
        this.lastCompiledPresence = null;
        this.largeImageData = null;
        this.smallImageData = null;
        this.presenceSupplier = richPresence;
        if (canLoad) {
            this.loadVisualizer(calc1, calc2, controlIndex, childFrame, this.presenceSupplier);
        }
    }

    public void setupVisualizer(int controlIndex, boolean canLoad, ExtendedScreen childFrame, Supplier<CompiledPresence> richPresence) {
        int calc1 = this.screen.getScreenWidth() / 2 - 183;
        int calc2 = this.screen.getScreenWidth() / 2 + 3;
        this.setupVisualizer(calc1, calc2, controlIndex, canLoad, childFrame, richPresence);
    }

    private void loadVisualizer(int calc1, int calc2, int controlIndex, ExtendedScreen childFrame, Supplier<CompiledPresence> richPresence) {
        int i;
        if (CraftPresence.CONFIG.accessibilitySettings.stripExtraGuiElements) {
            return;
        }
        int rightButtonPos = calc2 + 110;
        childFrame.addWidget((DynamicWidget)new ScrollableTextWidget(calc1, this.screen.getButtonY(controlIndex), calc2 - calc1, Constants.TRANSLATOR.translate("gui.config.message.visualizer", new Object[0])));
        if (this.showPartyToggle) {
            childFrame.addControl((nq)new ExtendedButtonControl(calc2, this.screen.getButtonY(controlIndex), 95, 20, Constants.TRANSLATOR.translate("gui.config.message.visualizer.toggle_party", new Object[0]), (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$loadVisualizer$0(), ()V)((PresenceVisualizer)this), (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$loadVisualizer$1(), ()V)((PresenceVisualizer)this), new String[0]));
        }
        if (!this.autoRefresh) {
            childFrame.addControl((nq)new ExtendedButtonControl(rightButtonPos, this.screen.getButtonY(controlIndex), 70, 20, Constants.TRANSLATOR.translate("gui.config.message.button.refresh", new Object[0]), (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$loadVisualizer$2(java.util.function.Supplier ), ()V)((PresenceVisualizer)this, richPresence), new String[0]));
        }
        this.largeWidget = (TexturedWidget)childFrame.addWidget((DynamicWidget)new TexturedWidget(calc1, this.screen.getButtonY(++controlIndex, 1), 45, 45, 0.0, (Supplier<Float>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$loadVisualizer$3(), ()Ljava/lang/Float;)(), (Supplier<ScreenConstants.ColorData>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$loadVisualizer$4(), ()Lcom/gitlab/cdagaming/unilib/core/impl/screen/ScreenConstants$ColorData;)((PresenceVisualizer)this), false));
        this.smallWidget = (TexturedWidget)childFrame.addWidget((DynamicWidget)new TexturedWidget(this.largeWidget.getRight() - 13, this.screen.getButtonY(controlIndex, 32), 16, 16, 0.0, (Supplier<Float>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$loadVisualizer$5(), ()Ljava/lang/Float;)(), (Supplier<ScreenConstants.ColorData>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$loadVisualizer$6(), ()Lcom/gitlab/cdagaming/unilib/core/impl/screen/ScreenConstants$ColorData;)((PresenceVisualizer)this), false));
        int textOffset = this.largeWidget.getRight() + 8;
        int textWidth = rightButtonPos - textOffset;
        for (i = 0; i < 4; ++i) {
            this.lines.add((ScrollableTextWidget)childFrame.addWidget((DynamicWidget)new ScrollableTextWidget(textOffset, this.screen.getButtonY(controlIndex, -4 + (this.screen.getFontHeight() + 2) * i), textWidth, "")));
        }
        for (i = 0; i < 2; ++i) {
            this.buttons.add((ExtendedButtonControl)childFrame.addControl((nq)new ExtendedButtonControl(rightButtonPos, this.screen.getButtonY(controlIndex++), 95, 20, "", new String[0])));
        }
        this.refreshVisualizer(richPresence);
    }

    private void refreshVisualizer(Supplier<CompiledPresence> richPresence) {
        if (richPresence == null) {
            return;
        }
        this.lastCompiledPresence = richPresence.get();
        if (this.lastCompiledPresence == null) {
            return;
        }
        if (this.lastCompiledPresence.largeAsset() != null) {
            this.largeImageData = new ScreenConstants.ColorData(this.lastCompiledPresence.largeAsset().getUrl());
            this.smallImageData = this.lastCompiledPresence.smallAsset() != null ? new ScreenConstants.ColorData(this.lastCompiledPresence.smallAsset().getUrl()) : null;
        } else {
            this.largeImageData = null;
            this.smallImageData = null;
        }
        boolean isMain = this.lastCompiledPresence.isMain();
        String details = this.lastCompiledPresence.details();
        String state = this.lastCompiledPresence.state();
        if (this.showPartyData || isMain) {
            int max;
            int size = isMain ? CraftPresence.CLIENT.PARTY_SIZE : 1;
            int n = max = isMain ? CraftPresence.CLIENT.PARTY_MAX : 5;
            if (size > 0 && max >= size) {
                state = this.lastCompiledPresence.state(size, max);
            }
        }
        if (this.lastCompiledPresence.activityType() == ActivityType.Listening || this.lastCompiledPresence.activityType() == ActivityType.Watching || this.lastCompiledPresence.activityType() == ActivityType.Competing) {
            this.updateLineTexts(details, state, this.lastCompiledPresence.largeImageText());
        } else {
            this.updateLineTexts(CraftPresence.CLIENT.CURRENT_TITLE, details, state, this.lastCompiledPresence.getTimeString());
        }
        this.updateButtonTexts(this.lastCompiledPresence.getButtonData());
    }

    private void updateButtonTexts(Map<String, String> validButtons) {
        Iterator<Map.Entry<String, String>> iterator = validButtons.entrySet().iterator();
        for (int i = 0; i < this.buttons.size(); ++i) {
            boolean hasData;
            ExtendedButtonControl button = this.buttons.get(i);
            boolean bl = hasData = i < validButtons.size();
            if (hasData) {
                Map.Entry<String, String> entry = iterator.next();
                button.setControlMessage(entry.getKey());
                button.setOnClick((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$updateButtonTexts$7(java.util.Map$Entry ), ()V)(entry));
            } else {
                button.setControlMessage("");
                button.setOnClick(null);
            }
            button.setControlEnabled(hasData);
            button.setControlVisible(hasData);
        }
    }

    private String getTitlePrefix() {
        return !CraftPresence.CONFIG.accessibilitySettings.stripTranslationFormatting ? "\u00a7l" : "";
    }

    private void updateLineTexts(String ... strings) {
        List validStrings = StringUtils.newArrayList();
        for (String string : strings) {
            if (StringUtils.isNullOrEmpty((String)string)) continue;
            validStrings.add(string);
        }
        boolean isTitleBar = true;
        for (int i = 0; i < this.lines.size(); ++i) {
            ScrollableTextWidget lineWidget = this.lines.get(i);
            if (i < validStrings.size()) {
                String prefix = isTitleBar ? this.getTitlePrefix() : "";
                lineWidget.setMessage(PresenceVisualizer.jvmdowngrader$concat$updateLineTexts$1(prefix, (String)validStrings.get(i)));
                isTitleBar = false;
                continue;
            }
            lineWidget.setMessage("");
        }
    }

    public void postRender(ExtendedScreen childFrame) {
        if (this.autoRefresh) {
            this.refreshVisualizer(this.presenceSupplier);
        }
        if (this.lastCompiledPresence != null && childFrame.isOverScreen()) {
            int mouseX = this.screen.getMouseX();
            int mouseY = this.screen.getMouseY();
            if (this.smallImageData != null && RenderUtils.isMouseOver((double)mouseX, (double)mouseY, (DynamicWidget)this.smallWidget) && !StringUtils.isNullOrEmpty((String)this.lastCompiledPresence.smallImageText())) {
                this.screen.drawMultiLineString(StringUtils.splitTextByNewLine((String)this.lastCompiledPresence.smallImageText()));
            } else if (this.largeImageData != null && RenderUtils.isMouseOver((double)mouseX, (double)mouseY, (DynamicWidget)this.largeWidget) && !StringUtils.isNullOrEmpty((String)this.lastCompiledPresence.largeImageText())) {
                this.screen.drawMultiLineString(StringUtils.splitTextByNewLine((String)this.lastCompiledPresence.largeImageText()));
            }
        }
    }

    private static /* synthetic */ void lambda$updateButtonTexts$7(Map.Entry entry) {
        UrlUtils.openUrl((String)((String)entry.getValue()));
    }

    private /* synthetic */ ScreenConstants.ColorData lambda$loadVisualizer$6() {
        return this.smallImageData;
    }

    private static /* synthetic */ Float lambda$loadVisualizer$5() {
        return Float.valueOf(1.0f);
    }

    private /* synthetic */ ScreenConstants.ColorData lambda$loadVisualizer$4() {
        return this.largeImageData;
    }

    private static /* synthetic */ Float lambda$loadVisualizer$3() {
        return Float.valueOf(1.0f);
    }

    private /* synthetic */ void lambda$loadVisualizer$2(Supplier richPresence) {
        this.refreshVisualizer(richPresence);
    }

    private /* synthetic */ void lambda$loadVisualizer$1() {
        this.screen.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.hover.visualizer.toggle_party", new Object[0])));
    }

    private /* synthetic */ void lambda$loadVisualizer$0() {
        this.showPartyData = !this.showPartyData;
    }

    private static String jvmdowngrader$concat$updateLineTexts$1(String string, String string2) {
        return string + string2;
    }
}

