/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.world;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.core.config.Config;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.impl.ExtendedModule;
import io.github.cdagaming.unicore.utils.MappingUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class DimensionUtils
implements ExtendedModule {
    public List<String> DIMENSION_NAMES = StringUtils.newArrayList();
    public List<String> DEFAULT_NAMES = StringUtils.newArrayList();
    private boolean enabled = false;
    private boolean isInUse = false;
    private boolean hasScannedConfig = false;
    private boolean hasScannedInternals = false;
    private boolean hasInitialized = false;
    private String RAW_DIMENSION_NAME;
    private String CURRENT_DIMENSION_NAME;
    private String RAW_DIMENSION_IDENTIFIER;
    private String CURRENT_DIMENSION_IDENTIFIER;
    private Level CURRENT_DIMENSION;

    @Override
    public void clearFieldData() {
        this.DEFAULT_NAMES.clear();
        this.DIMENSION_NAMES.clear();
    }

    @Override
    public void clearActiveData() {
        this.queueInternalScan();
        this.DIMENSION_NAMES.removeIf(entry -> this.DEFAULT_NAMES.contains(entry) && !CraftPresence.CONFIG.dimensionSettings.dimensionData.containsKey(entry));
        this.DEFAULT_NAMES.clear();
        ExtendedModule.super.clearActiveData();
    }

    @Override
    public void clearAttributes() {
        this.CURRENT_DIMENSION = null;
        this.RAW_DIMENSION_NAME = null;
        this.RAW_DIMENSION_IDENTIFIER = null;
        this.CURRENT_DIMENSION_NAME = null;
        this.CURRENT_DIMENSION_IDENTIFIER = null;
        CraftPresence.CLIENT.removeArguments("dimension", "data.dimension");
        CraftPresence.CLIENT.clearForcedData("dimension");
        this.hasInitialized = false;
    }

    @Override
    public void updateData() {
        Level newProvider = CraftPresence.world;
        ResourceLocation newDimensionType = newProvider.dimension().location();
        String newDimensionName = newDimensionType.toString();
        String newDimensionIdentifier = StringUtils.getOrDefault((String)newDimensionName, (String)MappingUtils.getClassName((Object)newDimensionType));
        if (!newDimensionName.equals(this.RAW_DIMENSION_NAME) || !newDimensionIdentifier.equals(this.RAW_DIMENSION_IDENTIFIER)) {
            this.CURRENT_DIMENSION = newProvider;
            this.RAW_DIMENSION_NAME = StringUtils.getOrDefault((String)newDimensionName, (String)newDimensionIdentifier);
            this.RAW_DIMENSION_IDENTIFIER = newDimensionIdentifier;
            this.CURRENT_DIMENSION_NAME = StringUtils.formatIdentifier((String)this.RAW_DIMENSION_NAME, (boolean)false, (!CraftPresence.CONFIG.advancedSettings.formatWords ? 1 : 0) != 0);
            this.CURRENT_DIMENSION_IDENTIFIER = StringUtils.formatIdentifier((String)this.RAW_DIMENSION_IDENTIFIER, (boolean)true, (!CraftPresence.CONFIG.advancedSettings.formatWords ? 1 : 0) != 0);
            if (!this.DEFAULT_NAMES.contains(this.CURRENT_DIMENSION_IDENTIFIER)) {
                this.DEFAULT_NAMES.add(this.CURRENT_DIMENSION_IDENTIFIER);
            }
            if (!this.DIMENSION_NAMES.contains(this.CURRENT_DIMENSION_IDENTIFIER)) {
                this.DIMENSION_NAMES.add(this.CURRENT_DIMENSION_IDENTIFIER);
            }
            if (!this.hasInitialized) {
                this.initPresence();
                this.hasInitialized = true;
            }
            this.updatePresence();
        }
    }

    @Override
    public void initPresence() {
        this.syncArgument("dimension.default.icon", () -> CraftPresence.CONFIG.dimensionSettings.fallbackDimensionIcon);
        this.syncArgument("data.dimension.instance", () -> this.CURRENT_DIMENSION, true);
        this.syncArgument("data.dimension.class", () -> this.CURRENT_DIMENSION.getClass(), true);
        this.syncArgument("data.dimension.name", () -> this.RAW_DIMENSION_NAME, true);
        this.syncArgument("data.dimension.identifier", () -> this.RAW_DIMENSION_IDENTIFIER, true);
        this.syncArgument("dimension.identifier", () -> this.CURRENT_DIMENSION_IDENTIFIER, true);
        this.syncArgument("dimension.name", () -> this.CURRENT_DIMENSION_NAME, true);
        this.syncArgument("dimension.message", () -> {
            ModuleData defaultData = this.getDefaultData();
            ModuleData currentData = this.getData(this.CURRENT_DIMENSION_IDENTIFIER);
            String defaultMessage = Config.isValidProperty(defaultData, "textOverride") ? defaultData.getTextOverride() : "";
            return this.getResult(Config.isValidProperty(currentData, "textOverride") ? currentData.getTextOverride() : defaultMessage, this.CURRENT_DIMENSION_IDENTIFIER);
        });
        this.syncArgument("dimension.icon", () -> {
            ModuleData defaultData = this.getDefaultData();
            ModuleData currentData = this.getData(this.CURRENT_DIMENSION_IDENTIFIER);
            String defaultIcon = Config.isValidProperty(defaultData, "iconOverride") ? defaultData.getIconOverride() : this.CURRENT_DIMENSION_IDENTIFIER;
            String currentIcon = Config.isValidProperty(currentData, "iconOverride") ? currentData.getIconOverride() : defaultIcon;
            return this.getResult(CraftPresence.CLIENT.imageOf(true, currentIcon, CraftPresence.CONFIG.dimensionSettings.fallbackDimensionIcon), this.CURRENT_DIMENSION_IDENTIFIER);
        });
        CraftPresence.CLIENT.addForcedData("dimension", () -> this.isInUse() ? this.getPresenceData(this.CURRENT_DIMENSION_IDENTIFIER) : null);
        CraftPresence.CLIENT.syncTimestamp("data.dimension.time");
    }

    @Override
    public void updatePresence() {
    }

    private List<ResourceLocation> getDimensionTypes() {
        List defaultDimensionTypes;
        List dimensionTypes = StringUtils.newArrayList();
        Optional dimensionRegistry = CraftPresence.world.registryAccess().lookup(Registries.DIMENSION_TYPE);
        if (dimensionRegistry.isPresent() && !(defaultDimensionTypes = StringUtils.newArrayList(((HolderLookup.RegistryLookup)dimensionRegistry.get()).listElements().toList())).isEmpty()) {
            for (Holder.Reference type : defaultDimensionTypes) {
                if (type == null) continue;
                dimensionTypes.add(type.key().location());
            }
        }
        return dimensionTypes;
    }

    @Override
    public void getInternalData() {
        for (ResourceLocation TYPE : this.getDimensionTypes()) {
            if (TYPE == null) continue;
            String dimensionName = StringUtils.getOrDefault((String)TYPE.toString(), (String)MappingUtils.getClassName((Object)TYPE));
            String name = StringUtils.formatIdentifier((String)dimensionName, (boolean)true, (!CraftPresence.CONFIG.advancedSettings.formatWords ? 1 : 0) != 0);
            if (!this.DEFAULT_NAMES.contains(name)) {
                this.DEFAULT_NAMES.add(name);
            }
            if (this.DIMENSION_NAMES.contains(name)) continue;
            this.DIMENSION_NAMES.add(name);
        }
    }

    @Override
    public void getConfigData() {
        for (String dimensionEntry : CraftPresence.CONFIG.dimensionSettings.dimensionData.keySet()) {
            String name;
            if (StringUtils.isNullOrEmpty((String)dimensionEntry) || this.DIMENSION_NAMES.contains(name = StringUtils.formatIdentifier((String)dimensionEntry, (boolean)true, (!CraftPresence.CONFIG.advancedSettings.formatWords ? 1 : 0) != 0))) continue;
            this.DIMENSION_NAMES.add(name);
        }
    }

    @Override
    public void syncArgument(String argumentName, Supplier<Boolean> condition, Supplier<Object> event, boolean plain) {
        CraftPresence.CLIENT.syncArgument(argumentName, this.getModuleFunction(condition, event), plain);
    }

    @Override
    public ModuleData getData(String key) {
        return CraftPresence.CONFIG.dimensionSettings.dimensionData.get(key);
    }

    @Override
    public String getOverrideText(ModuleData data) {
        return CraftPresence.CLIENT.getOverrideText(this.getPresenceData(data));
    }

    @Override
    public boolean canFetchInternals() {
        return MappingUtils.areMappingsLoaded() && CraftPresence.player != null;
    }

    @Override
    public boolean hasScannedInternals() {
        return this.hasScannedInternals;
    }

    @Override
    public void setScannedInternals(boolean state) {
        this.hasScannedInternals = state;
    }

    @Override
    public boolean canFetchConfig() {
        return CraftPresence.CONFIG != null;
    }

    @Override
    public boolean hasScannedConfig() {
        return this.hasScannedConfig;
    }

    @Override
    public void setScannedConfig(boolean state) {
        this.hasScannedConfig = state;
    }

    @Override
    public boolean canBeEnabled() {
        return !CraftPresence.CONFIG.hasChanged() ? CraftPresence.CONFIG.generalSettings.detectDimensionData : this.isEnabled();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean canBeUsed() {
        return CraftPresence.player != null;
    }

    @Override
    public boolean isInUse() {
        return this.isInUse;
    }

    @Override
    public void setInUse(boolean state) {
        this.isInUse = state;
    }
}

