/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.core.config.category;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.Module;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import io.github.cdagaming.unicore.impl.HashMapBuilder;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public class Server
extends Module
implements Serializable {
    private static final long serialVersionUID = -3687928791637101400L;
    private static final Server DEFAULT = new Server();
    public String fallbackServerIcon = "default";
    public String fallbackServerName = Constants.TRANSLATOR.translate("craftpresence.defaults.server_messages.server_name", new Object[0]);
    public String fallbackServerMotd = Constants.TRANSLATOR.translate("craftpresence.defaults.server_messages.server_motd", new Object[0]);
    public Map<String, ModuleData> serverData = new HashMapBuilder().put((Object)"default", (Object)new ModuleData(Constants.TRANSLATOR.translate("craftpresence.defaults.server_messages.server_messages", new Object[0]), null)).build();
    public int pingRateInterval = 5;
    public String pingRateUnit = "minutes";

    public Server(Server other) {
        this.transferFrom(other);
    }

    public Server() {
    }

    @Override
    public Server getDefaults() {
        return new Server(DEFAULT);
    }

    @Override
    public Server copy() {
        return new Server(this);
    }

    @Override
    public void transferFrom(Module target) {
        if (target instanceof Server) {
            Server data = (Server)target;
            if (!this.equals(target)) {
                this.fallbackServerIcon = data.fallbackServerIcon;
                this.fallbackServerName = data.fallbackServerName;
                this.fallbackServerMotd = data.fallbackServerMotd;
                this.serverData.clear();
                for (Map.Entry<String, ModuleData> entry : data.serverData.entrySet()) {
                    this.serverData.put(entry.getKey(), new ModuleData(entry.getValue()));
                }
                this.pingRateInterval = data.pingRateInterval;
                this.pingRateUnit = data.pingRateUnit;
            }
        }
    }

    @Override
    public Object getProperty(String name) {
        return switch (name) {
            case "fallbackServerIcon" -> this.fallbackServerIcon;
            case "fallbackServerName" -> this.fallbackServerName;
            case "fallbackServerMotd" -> this.fallbackServerMotd;
            case "serverData" -> this.serverData;
            case "pingRateInterval" -> this.pingRateInterval;
            case "pingRateUnit" -> this.pingRateUnit;
            default -> null;
        };
    }

    @Override
    public void setProperty(String name, Object value) {
        try {
            switch (name) {
                case "fallbackServerIcon": {
                    this.fallbackServerIcon = (String)value;
                    break;
                }
                case "fallbackServerName": {
                    this.fallbackServerName = (String)value;
                    break;
                }
                case "fallbackServerMotd": {
                    this.fallbackServerMotd = (String)value;
                    break;
                }
                case "serverData": {
                    this.serverData = (Map)value;
                    break;
                }
                case "pingRateInterval": {
                    this.pingRateInterval = (Integer)value;
                    break;
                }
                case "pingRateUnit": {
                    this.pingRateUnit = (String)value;
                    break;
                }
            }
        }
        catch (Throwable ex) {
            this.printException(ex);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Server)) {
            return false;
        }
        Server other = (Server)obj;
        return Objects.equals(other.fallbackServerIcon, this.fallbackServerIcon) && Objects.equals(other.fallbackServerName, this.fallbackServerName) && Objects.equals(other.fallbackServerMotd, this.fallbackServerMotd) && Objects.equals(other.serverData, this.serverData) && Objects.equals(other.pingRateInterval, this.pingRateInterval) && Objects.equals(other.pingRateUnit, this.pingRateUnit);
    }

    public int hashCode() {
        return Objects.hash(this.fallbackServerIcon, this.fallbackServerName, this.fallbackServerMotd, this.serverData, this.pingRateInterval, this.pingRateUnit);
    }
}

