/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.entity;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.core.config.Config;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.impl.ExtendedModule;
import com.gitlab.cdagaming.unilib.utils.WorldUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class EntityUtils
implements ExtendedModule {
    public List<String> ENTITY_NAMES = StringUtils.newArrayList();
    public List<String> DEFAULT_NAMES = StringUtils.newArrayList();
    public Map<String, String> PLAYER_BINDINGS = StringUtils.newHashMap();
    private boolean enabled = false;
    private boolean isInUse = false;
    private boolean hasScannedConfig = false;
    private boolean hasScannedInternals = false;
    private boolean hasInitialized = false;
    private boolean hasInitializedTarget = false;
    private boolean hasInitializedRiding = false;
    private String CURRENT_TARGET_NAME;
    private String CURRENT_RIDING_NAME;
    private Entity CURRENT_TARGET;
    private Entity CURRENT_RIDING;

    @Override
    public void clearFieldData() {
        this.DEFAULT_NAMES.clear();
        this.ENTITY_NAMES.clear();
        this.PLAYER_BINDINGS.clear();
    }

    @Override
    public void clearAttributes() {
        this.CURRENT_TARGET = null;
        this.CURRENT_RIDING = null;
        this.CURRENT_TARGET_NAME = null;
        this.CURRENT_RIDING_NAME = null;
        CraftPresence.CLIENT.removeArguments("entity", "data.entity");
        CraftPresence.CLIENT.clearForcedData("entity.target", "entity.riding");
        this.hasInitialized = false;
        this.hasInitializedTarget = false;
        this.hasInitializedRiding = false;
    }

    @Override
    public void updateData() {
        boolean hasRidingChanged;
        Entity entity;
        HitResult hitResult = CraftPresence.instance.hitResult;
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHit = (EntityHitResult)hitResult;
            entity = entityHit.getEntity();
        } else {
            entity = null;
        }
        Entity NEW_CURRENT_TARGET = entity;
        Entity NEW_CURRENT_RIDING = CraftPresence.player.getVehicle();
        boolean hasTargetChanged = !Objects.equals(NEW_CURRENT_TARGET, this.CURRENT_TARGET);
        boolean bl = hasRidingChanged = !Objects.equals(NEW_CURRENT_RIDING, this.CURRENT_RIDING);
        if (hasTargetChanged) {
            this.CURRENT_TARGET = NEW_CURRENT_TARGET;
            this.CURRENT_TARGET_NAME = WorldUtils.getEntityName((Entity)this.CURRENT_TARGET);
            if (this.CURRENT_TARGET != null) {
                CraftPresence.CLIENT.syncTimestamp("data.entity.target.time");
                if (!this.DEFAULT_NAMES.contains(this.CURRENT_TARGET_NAME)) {
                    this.DEFAULT_NAMES.add(this.CURRENT_TARGET_NAME);
                }
                if (!this.ENTITY_NAMES.contains(this.CURRENT_TARGET_NAME)) {
                    this.ENTITY_NAMES.add(this.CURRENT_TARGET_NAME);
                }
            }
        }
        if (hasRidingChanged) {
            this.CURRENT_RIDING = NEW_CURRENT_RIDING;
            this.CURRENT_RIDING_NAME = WorldUtils.getEntityName((Entity)this.CURRENT_RIDING);
            if (this.CURRENT_RIDING != null) {
                CraftPresence.CLIENT.syncTimestamp("data.entity.riding.time");
                if (!this.DEFAULT_NAMES.contains(this.CURRENT_RIDING_NAME)) {
                    this.DEFAULT_NAMES.add(this.CURRENT_RIDING_NAME);
                }
                if (!this.ENTITY_NAMES.contains(this.CURRENT_RIDING_NAME)) {
                    this.ENTITY_NAMES.add(this.CURRENT_RIDING_NAME);
                }
            }
        }
        if (hasTargetChanged || hasRidingChanged) {
            if (!this.hasInitialized) {
                this.initPresence();
                this.hasInitialized = true;
            }
            this.updatePresence();
        }
    }

    @Override
    public void initPresence() {
        this.syncArgument("entity.default.icon", () -> CraftPresence.CONFIG.advancedSettings.entitySettings.fallbackEntityIcon);
    }

    @Override
    public void updatePresence() {
        if (this.CURRENT_TARGET != null) {
            if (!this.hasInitializedTarget) {
                this.syncArgument("data.entity.target.instance", () -> this.CURRENT_TARGET != null, () -> this.CURRENT_TARGET, true);
                this.syncArgument("data.entity.target.class", () -> this.CURRENT_TARGET != null, () -> this.CURRENT_TARGET.getClass(), true);
                this.syncArgument("entity.target.name", () -> this.CURRENT_TARGET != null, () -> this.CURRENT_TARGET_NAME, true);
                this.syncArgument("entity.target.message", () -> this.CURRENT_TARGET != null, () -> {
                    ModuleData defaultData = CraftPresence.CONFIG.advancedSettings.entitySettings.targetData.get("default");
                    ModuleData currentData = CraftPresence.CONFIG.advancedSettings.entitySettings.targetData.get(this.CURRENT_TARGET_NAME);
                    String defaultMessage = Config.isValidProperty(defaultData, "textOverride") ? defaultData.getTextOverride() : "";
                    return this.getResult(Config.isValidProperty(currentData, "textOverride") ? currentData.getTextOverride() : defaultMessage, currentData != null ? currentData : defaultData);
                });
                this.syncArgument("entity.target.icon", () -> this.CURRENT_TARGET != null, () -> {
                    ModuleData defaultData = CraftPresence.CONFIG.advancedSettings.entitySettings.targetData.get("default");
                    ModuleData currentData = CraftPresence.CONFIG.advancedSettings.entitySettings.targetData.get(this.CURRENT_TARGET_NAME);
                    String defaultIcon = Config.isValidProperty(defaultData, "iconOverride") ? defaultData.getIconOverride() : this.CURRENT_TARGET_NAME;
                    String currentIcon = Config.isValidProperty(currentData, "iconOverride") ? currentData.getIconOverride() : defaultIcon;
                    return this.getResult(CraftPresence.CLIENT.imageOf(true, currentIcon, CraftPresence.CONFIG.advancedSettings.entitySettings.fallbackEntityIcon), currentData != null ? currentData : defaultData);
                });
                CraftPresence.CLIENT.addForcedData("entity.target", () -> {
                    if (!this.isInUse() || this.CURRENT_TARGET == null) {
                        return null;
                    }
                    ModuleData defaultData = CraftPresence.CONFIG.advancedSettings.entitySettings.targetData.get("default");
                    ModuleData currentData = CraftPresence.CONFIG.advancedSettings.entitySettings.targetData.get(this.CURRENT_TARGET_NAME);
                    return this.getPresenceData(currentData != null ? currentData : defaultData);
                });
                this.hasInitializedTarget = true;
            }
        } else if (this.hasInitializedTarget) {
            CraftPresence.CLIENT.removeArguments("entity.target", "data.entity.target");
            CraftPresence.CLIENT.clearForcedData("entity.target");
            this.hasInitializedTarget = false;
        }
        if (this.CURRENT_RIDING != null) {
            if (!this.hasInitializedRiding) {
                this.syncArgument("data.entity.riding.instance", () -> this.CURRENT_RIDING != null, () -> this.CURRENT_RIDING, true);
                this.syncArgument("data.entity.riding.class", () -> this.CURRENT_RIDING != null, () -> this.CURRENT_RIDING.getClass(), true);
                this.syncArgument("entity.riding.name", () -> this.CURRENT_RIDING != null, () -> this.CURRENT_RIDING_NAME, true);
                this.syncArgument("entity.riding.message", () -> this.CURRENT_RIDING != null, () -> {
                    ModuleData defaultData = CraftPresence.CONFIG.advancedSettings.entitySettings.ridingData.get("default");
                    ModuleData currentData = CraftPresence.CONFIG.advancedSettings.entitySettings.ridingData.get(this.CURRENT_RIDING_NAME);
                    String defaultMessage = Config.isValidProperty(defaultData, "textOverride") ? defaultData.getTextOverride() : "";
                    return this.getResult(Config.isValidProperty(currentData, "textOverride") ? currentData.getTextOverride() : defaultMessage, currentData != null ? currentData : defaultData);
                });
                this.syncArgument("entity.riding.icon", () -> this.CURRENT_RIDING != null, () -> {
                    ModuleData defaultData = CraftPresence.CONFIG.advancedSettings.entitySettings.ridingData.get("default");
                    ModuleData currentData = CraftPresence.CONFIG.advancedSettings.entitySettings.ridingData.get(this.CURRENT_RIDING_NAME);
                    String defaultIcon = Config.isValidProperty(defaultData, "iconOverride") ? defaultData.getIconOverride() : this.CURRENT_RIDING_NAME;
                    String currentIcon = Config.isValidProperty(currentData, "iconOverride") ? currentData.getIconOverride() : defaultIcon;
                    return this.getResult(CraftPresence.CLIENT.imageOf(true, currentIcon, CraftPresence.CONFIG.advancedSettings.entitySettings.fallbackEntityIcon), currentData != null ? currentData : defaultData);
                });
                CraftPresence.CLIENT.addForcedData("entity.riding", () -> {
                    if (!this.isInUse() || this.CURRENT_RIDING == null) {
                        return null;
                    }
                    ModuleData defaultData = CraftPresence.CONFIG.advancedSettings.entitySettings.ridingData.get("default");
                    ModuleData currentData = CraftPresence.CONFIG.advancedSettings.entitySettings.ridingData.get(this.CURRENT_RIDING_NAME);
                    return this.getPresenceData(currentData != null ? currentData : defaultData);
                });
                this.hasInitializedRiding = true;
            }
        } else if (this.hasInitializedRiding) {
            CraftPresence.CLIENT.removeArguments("entity.riding", "data.entity.riding");
            CraftPresence.CLIENT.clearForcedData("entity.riding");
            this.hasInitializedRiding = false;
        }
    }

    @Override
    public void getInternalData() {
        List defaultEntityTypes = StringUtils.newArrayList((Iterator)BuiltInRegistries.ENTITY_TYPE.iterator());
        if (!defaultEntityTypes.isEmpty()) {
            for (EntityType entityLocation : defaultEntityTypes) {
                if (entityLocation == null) continue;
                String entityName = entityLocation.getDescription().getString();
                if (!this.DEFAULT_NAMES.contains(entityName)) {
                    this.DEFAULT_NAMES.add(entityName);
                }
                if (this.ENTITY_NAMES.contains(entityName)) continue;
                this.ENTITY_NAMES.add(entityName);
            }
        }
        if (CraftPresence.SERVER.isEnabled()) {
            for (PlayerInfo playerInfo : CraftPresence.SERVER.currentPlayerList) {
                String uuidString;
                if (playerInfo == null || StringUtils.isNullOrEmpty((String)(uuidString = playerInfo.getProfile().getId().toString()))) continue;
                if (!this.ENTITY_NAMES.contains(uuidString)) {
                    this.ENTITY_NAMES.add(uuidString);
                }
                if (this.PLAYER_BINDINGS.containsKey(uuidString)) continue;
                this.PLAYER_BINDINGS.put(uuidString, playerInfo.getProfile().getName());
            }
        }
    }

    @Override
    public void getConfigData() {
        for (String entityTargetEntry : CraftPresence.CONFIG.advancedSettings.entitySettings.targetData.keySet()) {
            if (StringUtils.isNullOrEmpty((String)entityTargetEntry) || this.ENTITY_NAMES.contains(entityTargetEntry)) continue;
            this.ENTITY_NAMES.add(entityTargetEntry);
        }
        for (String entityRidingEntry : CraftPresence.CONFIG.advancedSettings.entitySettings.ridingData.keySet()) {
            if (StringUtils.isNullOrEmpty((String)entityRidingEntry) || this.ENTITY_NAMES.contains(entityRidingEntry)) continue;
            this.ENTITY_NAMES.add(entityRidingEntry);
        }
    }

    @Override
    public void syncArgument(String argumentName, Supplier<Boolean> condition, Supplier<Object> event, boolean plain) {
        CraftPresence.CLIENT.syncArgument(argumentName, this.getModuleFunction(condition, event), plain);
    }

    @Override
    public String getOverrideText(ModuleData data) {
        return CraftPresence.CLIENT.getOverrideText(this.getPresenceData(data));
    }

    @Override
    public boolean hasScannedInternals() {
        return this.hasScannedInternals;
    }

    @Override
    public void setScannedInternals(boolean state) {
        this.hasScannedInternals = state;
    }

    @Override
    public boolean canFetchConfig() {
        return CraftPresence.CONFIG != null;
    }

    @Override
    public boolean hasScannedConfig() {
        return this.hasScannedConfig;
    }

    @Override
    public void setScannedConfig(boolean state) {
        this.hasScannedConfig = state;
    }

    @Override
    public boolean canBeEnabled() {
        return !CraftPresence.CONFIG.hasChanged() ? CraftPresence.CONFIG.advancedSettings.enablePerEntity : this.isEnabled();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean canBeUsed() {
        return CraftPresence.player != null;
    }

    @Override
    public boolean isInUse() {
        return this.isInUse;
    }

    @Override
    public void setInUse(boolean state) {
        this.isInUse = state;
    }
}

