/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.integrations.replaymod;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.core.config.Config;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.config.element.PresenceData;
import com.gitlab.cdagaming.craftpresence.core.impl.ExtendedModule;
import com.gitlab.cdagaming.craftpresence.core.impl.ExtendedModule$jvmdg$StaticDefaults;
import com.gitlab.cdagaming.craftpresence.core.impl.Module;
import com.gitlab.cdagaming.craftpresence.core.impl.Module$jvmdg$StaticDefaults;
import io.github.cdagaming.unicore.utils.FileUtils;
import io.github.cdagaming.unicore.utils.MappingUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.function.Supplier;
import unilib.external.io.github.classgraph.ClassInfo;

public class ReplayModUtils
implements ExtendedModule {
    private boolean enabled = false;
    private boolean isInUse = false;
    private boolean hasScannedInternals = false;
    private boolean hasInitialized = false;
    private boolean hasInitializedMain = false;
    private boolean hasInitializedSub = false;
    private boolean otherModuleState = false;
    private String CURRENT_GUI_NAME;
    private Object CURRENT_SCREEN;

    @Override
    public void clearAttributes() {
        this.CURRENT_GUI_NAME = null;
        this.CURRENT_SCREEN = null;
        this.clearMainPlaceholders();
        this.clearSubPlaceholders();
        this.hasInitialized = false;
        this.hasInitializedMain = false;
        this.hasInitializedSub = false;
        this.otherModuleState = false;
    }

    @Override
    public void updateData() {
        if (CraftPresence.GUIS.CURRENT_SCREEN == null) {
            Object replayOverlay;
            Class replayClass = FileUtils.loadClass((String[])new String[]{"com.replaymod.replay.ReplayModReplay"});
            Class replayHandlerClass = FileUtils.loadClass((String[])new String[]{"com.replaymod.replay.ReplayHandler"});
            Object replayInstance = StringUtils.getField((Class)replayClass, null, (String[])new String[]{"instance"});
            Object replayHandler = replayInstance != null ? StringUtils.executeMethod((Class)replayClass, (Object)replayInstance, null, null, (String[])new String[]{"getReplayHandler"}) : null;
            Object object = replayOverlay = replayHandler != null ? StringUtils.executeMethod((Class)replayHandlerClass, (Object)replayHandler, null, null, (String[])new String[]{"getOverlay"}) : null;
            if (replayOverlay == null) {
                this.clearClientData();
            } else {
                this.processScreen(replayOverlay);
            }
        } else {
            Class screenClass = FileUtils.loadClass((String[])new String[]{"com.replaymod.lib.de.johni0702.minecraft.gui.container.GuiScreen"});
            Class overlayClass = FileUtils.loadClass((String[])new String[]{"com.replaymod.lib.de.johni0702.minecraft.gui.container.GuiOverlay"});
            Object possibleScreen = StringUtils.executeMethod((Class)screenClass, null, (Class[])new Class[]{bp.class}, (Object[])new Object[]{CraftPresence.GUIS.CURRENT_SCREEN}, (String[])new String[]{"from"});
            Object possibleOverlay = StringUtils.executeMethod((Class)overlayClass, null, (Class[])new Class[]{bp.class}, (Object[])new Object[]{CraftPresence.GUIS.CURRENT_SCREEN}, (String[])new String[]{"from"});
            if (possibleScreen == null && possibleOverlay == null) {
                this.clearClientData();
            } else {
                this.processScreen(possibleOverlay != null ? possibleOverlay : possibleScreen);
            }
        }
    }

    private void processScreen(Object newScreen) {
        boolean moduleStateChanged;
        String newScreenName = MappingUtils.getClassName((Object)newScreen);
        boolean newModuleState = CraftPresence.GUIS.isInUse();
        boolean bl = moduleStateChanged = newModuleState != this.otherModuleState;
        if (!newScreen.equals(this.CURRENT_SCREEN) || !newScreenName.equals(this.CURRENT_GUI_NAME) || moduleStateChanged) {
            this.CURRENT_SCREEN = newScreen;
            this.CURRENT_GUI_NAME = newScreenName;
            this.otherModuleState = newModuleState;
            if (!CraftPresence.GUIS.GUI_NAMES.contains(newScreenName)) {
                CraftPresence.GUIS.GUI_NAMES.add(newScreenName);
            }
            if (!this.hasInitialized || moduleStateChanged) {
                this.initPresence();
                this.hasInitialized = true;
            }
            this.updatePresence();
        }
        this.syncPlaceholders();
    }

    @Override
    public void getInternalData() {
        List searchClasses = StringUtils.newArrayList((Object[])new Class[]{FileUtils.findClass((String[])new String[]{"com.replaymod.lib.de.johni0702.minecraft.gui.container.AbstractGuiContainer"}), FileUtils.findClass((String[])new String[]{"com.replaymod.lib.de.johni0702.minecraft.gui.container.AbstractGuiScreen"}), FileUtils.findClass((String[])new String[]{"com.replaymod.lib.de.johni0702.minecraft.gui.container.AbstractGuiOverlay"})});
        for (ClassInfo classObj : FileUtils.getClassNamesMatchingSuperType((List)searchClasses, (String[])new String[0]).values()) {
            String screenName = MappingUtils.getClassName((ClassInfo)classObj);
            if (!CraftPresence.GUIS.GUI_NAMES.contains(screenName)) {
                CraftPresence.GUIS.GUI_NAMES.add(screenName);
            }
            if (CraftPresence.GUIS.GUI_CLASSES.containsKey(screenName)) continue;
            CraftPresence.GUIS.GUI_CLASSES.put(screenName, classObj);
        }
    }

    @Override
    public void getConfigData() {
    }

    @Override
    public void syncArgument(String argumentName, Supplier<Boolean> condition, Supplier<Object> event, boolean plain) {
        CraftPresence.CLIENT.syncArgument(argumentName, this.getModuleFunction((Supplier)condition, (Supplier)event), plain);
    }

    @Override
    public ModuleData getData(String key) {
        return CraftPresence.GUIS.getData(key);
    }

    @Override
    public String getOverrideText(ModuleData data) {
        return CraftPresence.GUIS.getOverrideText(data);
    }

    @Override
    public boolean canFetchInternals() {
        return CraftPresence.GUIS.canFetchInternals();
    }

    @Override
    public boolean hasScannedInternals() {
        return this.hasScannedInternals;
    }

    @Override
    public void setScannedInternals(boolean state) {
        this.hasScannedInternals = state;
    }

    @Override
    public boolean canBeEnabled() {
        return CraftPresence.GUIS.canBeEnabled();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean canBeUsed() {
        return CraftPresence.GUIS.canBeUsed() || CraftPresence.player != null;
    }

    @Override
    public boolean isInUse() {
        return this.isInUse;
    }

    @Override
    public void setInUse(boolean state) {
        this.isInUse = state;
    }

    @Override
    public void initPresence() {
        this.syncArgument("screen.default.icon", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$0(), ()Ljava/lang/Object;)());
        this.syncArgument("data.screen.instance", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$1(), ()Ljava/lang/Object;)((ReplayModUtils)this), true);
        this.syncArgument("screen.name", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$2(), ()Ljava/lang/Object;)((ReplayModUtils)this), true);
        this.syncArgument("screen.message", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$3(), ()Ljava/lang/Object;)((ReplayModUtils)this));
        this.syncArgument("screen.icon", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$4(), ()Ljava/lang/Object;)((ReplayModUtils)this));
        CraftPresence.CLIENT.addForcedData("screen", (Supplier<PresenceData>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$5(), ()Lcom/gitlab/cdagaming/craftpresence/core/config/element/PresenceData;)((ReplayModUtils)this));
        CraftPresence.CLIENT.syncTimestamp("data.screen.time");
    }

    @Override
    public void updatePresence() {
    }

    private void clearMainPlaceholders() {
        CraftPresence.CLIENT.removeArguments("replaymod.time", "data.replaymod.time");
    }

    private void clearSubPlaceholders() {
        CraftPresence.CLIENT.removeArguments("replaymod.frames");
    }

    private void syncPlaceholders() {
        Class videoRendererScreen = FileUtils.loadClass((String[])new String[]{"com.replaymod.render.gui.GuiVideoRenderer"});
        if (this.CURRENT_SCREEN != null && this.CURRENT_SCREEN.getClass() == videoRendererScreen) {
            if (!this.hasInitializedMain) {
                this.syncArgument("data.replaymod.time.current", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$syncPlaceholders$6(java.lang.Class ), ()Ljava/lang/Object;)((ReplayModUtils)this, (Class)videoRendererScreen), true);
                this.syncArgument("replaymod.time.current", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$syncPlaceholders$7(java.lang.Class ), ()Ljava/lang/Object;)((ReplayModUtils)this, (Class)videoRendererScreen), true);
                this.syncArgument("data.replaymod.time.remaining", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$syncPlaceholders$8(java.lang.Class ), ()Ljava/lang/Object;)((ReplayModUtils)this, (Class)videoRendererScreen), true);
                this.syncArgument("replaymod.time.remaining", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$syncPlaceholders$9(java.lang.Class ), ()Ljava/lang/Object;)((ReplayModUtils)this, (Class)videoRendererScreen), true);
                this.hasInitializedMain = true;
            }
            Object rendererObj = StringUtils.getField((Class)videoRendererScreen, (Object)this.CURRENT_SCREEN, (String[])new String[]{"renderer"});
            Class videoRendererInfo = FileUtils.loadClass((String[])new String[]{"com.replaymod.render.rendering.VideoRenderer"});
            if (rendererObj != null && rendererObj.getClass() == videoRendererInfo) {
                if (!this.hasInitializedSub) {
                    this.syncArgument("replaymod.frames.current", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$syncPlaceholders$10(java.lang.Class java.lang.Object ), ()Ljava/lang/Object;)((Class)videoRendererInfo, (Object)rendererObj), true);
                    this.syncArgument("replaymod.frames.total", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$syncPlaceholders$11(java.lang.Class java.lang.Object ), ()Ljava/lang/Object;)((Class)videoRendererInfo, (Object)rendererObj), true);
                    this.hasInitializedSub = true;
                }
            } else if (this.hasInitializedSub) {
                this.clearSubPlaceholders();
                this.hasInitializedSub = false;
            }
        } else if (this.hasInitializedMain) {
            this.clearMainPlaceholders();
            this.hasInitializedMain = false;
        }
    }

    private String secToString(int seconds) {
        int hours = seconds / 3600;
        int min = seconds / 60 - hours * 60;
        int sec = seconds - (min * 60 + hours * 60 * 60);
        StringBuilder builder = new StringBuilder();
        if (hours > 0) {
            builder.append(hours).append("hour(s)");
        }
        if (min > 0 || hours > 0) {
            builder.append(min).append("minute(s)");
        }
        builder.append(sec).append("second(s)");
        return builder.toString();
    }

    private static /* synthetic */ Object lambda$syncPlaceholders$11(Class videoRendererInfo, Object rendererObj) {
        return StringUtils.executeMethod((Class)videoRendererInfo, (Object)rendererObj, null, null, (String[])new String[]{"getTotalFrames"});
    }

    private static /* synthetic */ Object lambda$syncPlaceholders$10(Class videoRendererInfo, Object rendererObj) {
        return StringUtils.executeMethod((Class)videoRendererInfo, (Object)rendererObj, null, null, (String[])new String[]{"getFramesDone"});
    }

    private /* synthetic */ Object lambda$syncPlaceholders$9(Class videoRendererScreen) {
        return this.secToString((Integer)StringUtils.getValidInteger((Object)StringUtils.getField((Class)videoRendererScreen, (Object)this.CURRENT_SCREEN, (String[])new String[]{"renderTimeLeft"})).getSecond());
    }

    private /* synthetic */ Object lambda$syncPlaceholders$8(Class videoRendererScreen) {
        return StringUtils.getValidInteger((Object)StringUtils.getField((Class)videoRendererScreen, (Object)this.CURRENT_SCREEN, (String[])new String[]{"renderTimeLeft"})).getSecond();
    }

    private /* synthetic */ Object lambda$syncPlaceholders$7(Class videoRendererScreen) {
        return this.secToString((Integer)StringUtils.getValidInteger((Object)StringUtils.getField((Class)videoRendererScreen, (Object)this.CURRENT_SCREEN, (String[])new String[]{"renderTimeTaken"})).getSecond() / 1000);
    }

    private /* synthetic */ Object lambda$syncPlaceholders$6(Class videoRendererScreen) {
        return (Integer)StringUtils.getValidInteger((Object)StringUtils.getField((Class)videoRendererScreen, (Object)this.CURRENT_SCREEN, (String[])new String[]{"renderTimeTaken"})).getSecond() / 1000;
    }

    private /* synthetic */ PresenceData lambda$initPresence$5() {
        return this.isInUse() ? this.getPresenceData(new String[]{this.CURRENT_GUI_NAME}) : null;
    }

    private /* synthetic */ Object lambda$initPresence$4() {
        ModuleData defaultData = this.getDefaultData();
        ModuleData currentData = this.getData(this.CURRENT_GUI_NAME);
        String defaultIcon = Config.isValidProperty(defaultData, "iconOverride") ? defaultData.getIconOverride() : this.CURRENT_GUI_NAME;
        String currentIcon = Config.isValidProperty(currentData, "iconOverride") ? currentData.getIconOverride() : defaultIcon;
        return this.getResult(CraftPresence.CLIENT.imageOf(true, currentIcon, CraftPresence.CONFIG.advancedSettings.guiSettings.fallbackGuiIcon), new String[]{this.CURRENT_GUI_NAME});
    }

    private /* synthetic */ Object lambda$initPresence$3() {
        ModuleData defaultData = this.getDefaultData();
        ModuleData currentData = this.getData(this.CURRENT_GUI_NAME);
        String defaultMessage = Config.isValidProperty(defaultData, "textOverride") ? defaultData.getTextOverride() : "";
        return this.getResult(Config.isValidProperty(currentData, "textOverride") ? currentData.getTextOverride() : defaultMessage, new String[]{this.CURRENT_GUI_NAME});
    }

    private /* synthetic */ Object lambda$initPresence$2() {
        return this.CURRENT_GUI_NAME;
    }

    private /* synthetic */ Object lambda$initPresence$1() {
        return this.CURRENT_SCREEN;
    }

    private static /* synthetic */ Object lambda$initPresence$0() {
        return CraftPresence.CONFIG.advancedSettings.guiSettings.fallbackGuiIcon;
    }

    @Override
    public void setScannedConfig(boolean bl) {
        Module$jvmdg$StaticDefaults.setScannedConfig(this, bl);
    }

    @Override
    public boolean canBeLoaded() {
        return Module$jvmdg$StaticDefaults.canBeLoaded(this);
    }

    @Override
    public ModuleData getOrDefault(ModuleData[] moduleDataArray) {
        return ExtendedModule$jvmdg$StaticDefaults.getOrDefault((ExtendedModule)this, moduleDataArray);
    }

    @Override
    public void clearClientData() {
        Module$jvmdg$StaticDefaults.clearClientData(this);
    }

    @Override
    public boolean hasScannedConfig() {
        return Module$jvmdg$StaticDefaults.hasScannedConfig(this);
    }

    @Override
    public void postTick() {
        Module$jvmdg$StaticDefaults.postTick(this);
    }

    @Override
    public boolean canFetchConfig() {
        return Module$jvmdg$StaticDefaults.canFetchConfig(this);
    }

    @Override
    public void markInternalsScanned() {
        Module$jvmdg$StaticDefaults.markInternalsScanned(this);
    }

    public void syncArgument(String string, Supplier supplier, Supplier supplier2) {
        Module$jvmdg$StaticDefaults.syncArgument((Module)this, string, supplier, supplier2);
    }

    @Override
    public String getResult(String string, ModuleData moduleData) {
        return ExtendedModule$jvmdg$StaticDefaults.getResult((ExtendedModule)this, string, moduleData);
    }

    @Override
    public void markConfigScanned() {
        Module$jvmdg$StaticDefaults.markConfigScanned(this);
    }

    @Override
    public String getDefaultId() {
        return ExtendedModule$jvmdg$StaticDefaults.getDefaultId(this);
    }

    @Override
    public void clearActiveData() {
        Module$jvmdg$StaticDefaults.clearActiveData(this);
    }

    @Override
    public ModuleData getOrDefault(String[] stringArray) {
        return ExtendedModule$jvmdg$StaticDefaults.getOrDefault((ExtendedModule)this, stringArray);
    }

    @Override
    public void emptyData() {
        Module$jvmdg$StaticDefaults.emptyData(this);
    }

    public void syncArgument(String string, Supplier supplier, boolean bl) {
        Module$jvmdg$StaticDefaults.syncArgument((Module)this, string, supplier, bl);
    }

    @Override
    public void queueConfigScan() {
        Module$jvmdg$StaticDefaults.queueConfigScan(this);
    }

    @Override
    public void preTick() {
        Module$jvmdg$StaticDefaults.preTick(this);
    }

    @Override
    public String getResult(String string, String[] stringArray) {
        return ExtendedModule$jvmdg$StaticDefaults.getResult((ExtendedModule)this, string, stringArray);
    }

    @Override
    public void clearFieldData() {
        Module$jvmdg$StaticDefaults.clearFieldData(this);
    }

    @Override
    public PresenceData getPresenceData(ModuleData moduleData) {
        return ExtendedModule$jvmdg$StaticDefaults.getPresenceData((ExtendedModule)this, moduleData);
    }

    public void syncArgument(String string, Supplier supplier) {
        Module$jvmdg$StaticDefaults.syncArgument(this, string, supplier);
    }

    @Override
    public void printException(Throwable throwable) {
        Module$jvmdg$StaticDefaults.printException(this, throwable);
    }

    @Override
    public ModuleData getDefaultData() {
        return ExtendedModule$jvmdg$StaticDefaults.getDefaultData(this);
    }

    @Override
    public PresenceData getPresenceData(String[] stringArray) {
        return ExtendedModule$jvmdg$StaticDefaults.getPresenceData((ExtendedModule)this, stringArray);
    }

    @Override
    public String getOverrideText(String[] stringArray) {
        return ExtendedModule$jvmdg$StaticDefaults.getOverrideText(this, stringArray);
    }

    public Supplier getModuleFunction(Supplier supplier) {
        return Module$jvmdg$StaticDefaults.getModuleFunction(this, supplier);
    }

    @Override
    public void scanConfigData() {
        Module$jvmdg$StaticDefaults.scanConfigData(this);
    }

    @Override
    public void scanInternalData() {
        Module$jvmdg$StaticDefaults.scanInternalData(this);
    }

    @Override
    public void queueInternalScan() {
        Module$jvmdg$StaticDefaults.queueInternalScan(this);
    }

    public Supplier getModuleFunction(Supplier supplier, Supplier supplier2) {
        return Module$jvmdg$StaticDefaults.getModuleFunction(this, supplier, supplier2);
    }

    @Override
    public void onTick() {
        Module$jvmdg$StaticDefaults.onTick(this);
    }
}

