/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.config.gui;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.config.gui.PresenceEditorGui;
import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.Config;
import com.gitlab.cdagaming.craftpresence.core.config.category.Biome;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.config.element.PresenceData;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.DynamicScrollableList;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.ConfigurationGui;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicSelectorGui;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.TextWidget;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.Screen;

public class BiomeSettingsGui
extends ConfigurationGui<Biome> {
    private final Biome INSTANCE;
    private final Biome DEFAULTS = this.getCurrentData().getDefaults();
    private ExtendedButtonControl biomeMessagesButton;
    private TextWidget defaultMessage;
    private TextWidget defaultIcon;

    BiomeSettingsGui() {
        super(Constants.TRANSLATOR.translate("gui.config.title", new Object[0]), Constants.TRANSLATOR.translate("gui.config.title.biome_messages", new Object[0]));
        this.INSTANCE = this.getCurrentData().copy();
    }

    @Override
    public void constructElements() {
        super.constructElements();
        this.proceedButton.setOnHover((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$constructElements$0(), ()V)((BiomeSettingsGui)this));
    }

    public void appendElements() {
        super.appendElements();
        ModuleData defaultData = this.getInstanceData().biomeData.get("default");
        String defaultBiomeMessage = Config.getProperty(defaultData, "textOverride") != null ? defaultData.getTextOverride() : "";
        this.defaultMessage = (TextWidget)this.childFrame.addControl((Gui)new TextWidget(this.getFontRenderer(), this.getButtonY(0), 180, 20, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$appendElements$1(), ()V)((BiomeSettingsGui)this), Constants.TRANSLATOR.translate("gui.config.message.default.biome", new Object[0]), (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$appendElements$2(), ()V)((BiomeSettingsGui)this)));
        this.defaultMessage.setControlMessage(defaultBiomeMessage);
        this.defaultIcon = (TextWidget)this.childFrame.addControl((Gui)new TextWidget(this.getFontRenderer(), this.getButtonY(1), 147, 20, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$appendElements$3(), ()V)((BiomeSettingsGui)this), Constants.TRANSLATOR.translate("gui.config.name.biome_messages.biome_icon", new Object[0]), (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$appendElements$4(), ()V)((BiomeSettingsGui)this)));
        this.addIconSelector((ExtendedScreen)this.childFrame, (Supplier<TextWidget>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$appendElements$5(), ()Lcom/gitlab/cdagaming/unilib/utils/gui/widgets/TextWidget;)((BiomeSettingsGui)this), (BiConsumer<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$appendElements$6(java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)V)((BiomeSettingsGui)this));
        this.defaultIcon.setControlMessage(this.getInstanceData().fallbackBiomeIcon);
        this.biomeMessagesButton = (ExtendedButtonControl)this.childFrame.addControl((Gui)new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getButtonY(2), 180, 20, Constants.TRANSLATOR.translate("gui.config.name.biome_messages.biome_messages", new Object[0]), (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$appendElements$16(), ()V)((BiomeSettingsGui)this), (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$appendElements$17(), ()V)((BiomeSettingsGui)this), new String[0]));
    }

    @Override
    protected boolean allowedToReset() {
        return true;
    }

    @Override
    protected void syncRenderStates() {
        super.syncRenderStates();
        this.proceedButton.setControlEnabled(!StringUtils.isNullOrEmpty((String)this.defaultMessage.getControlMessage()));
        this.biomeMessagesButton.setControlEnabled(CraftPresence.BIOMES.isEnabled());
    }

    @Override
    protected Biome getInstanceData() {
        return this.INSTANCE;
    }

    @Override
    protected Biome getCurrentData() {
        return CraftPresence.CONFIG.biomeSettings;
    }

    @Override
    protected Biome getDefaultData() {
        return this.DEFAULTS;
    }

    private /* synthetic */ void lambda$appendElements$17() {
        if (!this.biomeMessagesButton.isControlEnabled()) {
            this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.hover.access", new Object[]{Constants.TRANSLATOR.translate("gui.config.name.general.detect_biome_data", new Object[0])})));
        } else {
            this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.biome_messages.biome_messages", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("biome.")})));
        }
    }

    private /* synthetic */ void lambda$appendElements$16() {
        this.openScreen((ExtendedScreen)new DynamicSelectorGui(Constants.TRANSLATOR.translate("gui.config.title.selector.biome", new Object[0]), CraftPresence.BIOMES.BIOME_NAMES, null, null, true, true, DynamicScrollableList.RenderType.None, (BiConsumer<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$appendElements$7(java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)V)((BiomeSettingsGui)this), (BiConsumer<String, Screen>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$appendElements$15(java.lang.String net.minecraft.client.gui.Screen ), (Ljava/lang/String;Lnet/minecraft/client/gui/Screen;)V)((BiomeSettingsGui)this)));
    }

    private /* synthetic */ void lambda$appendElements$15(String currentValue, Screen parentScreen) {
        this.openScreen(new DynamicEditorGui(currentValue, (BiConsumer<String, DynamicEditorGui>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$appendElements$8(java.lang.String com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui ), (Ljava/lang/String;Lcom/gitlab/cdagaming/craftpresence/utils/gui/impl/DynamicEditorGui;)V)((BiomeSettingsGui)this), (BiConsumer<String, DynamicEditorGui>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$appendElements$9(java.lang.String com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui ), (Ljava/lang/String;Lcom/gitlab/cdagaming/craftpresence/utils/gui/impl/DynamicEditorGui;)V)((BiomeSettingsGui)this), (Consumer<DynamicEditorGui>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$appendElements$10(com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui ), (Lcom/gitlab/cdagaming/craftpresence/utils/gui/impl/DynamicEditorGui;)V)((BiomeSettingsGui)this), (Consumer<DynamicEditorGui>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$appendElements$11(com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui ), (Lcom/gitlab/cdagaming/craftpresence/utils/gui/impl/DynamicEditorGui;)V)((BiomeSettingsGui)this), (BiConsumer<String, DynamicEditorGui>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$appendElements$13(java.lang.String com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui ), (Ljava/lang/String;Lcom/gitlab/cdagaming/craftpresence/utils/gui/impl/DynamicEditorGui;)V)(), (BiConsumer<String, DynamicEditorGui>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$appendElements$14(java.lang.String com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui ), (Ljava/lang/String;Lcom/gitlab/cdagaming/craftpresence/utils/gui/impl/DynamicEditorGui;)V)()), parentScreen);
    }

    private static /* synthetic */ void lambda$appendElements$14(String attributeName, DynamicEditorGui screenInstance) {
        screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.biome_messages.biome_messages", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("biome.")})));
    }

    private static /* synthetic */ void lambda$appendElements$13(String attributeName, DynamicEditorGui screenInstance) {
        if (screenInstance.isPresenceButton) {
            PresenceData defaultPresenceData = Config.getProperty(screenInstance.defaultData, "data") != null ? screenInstance.defaultData.getData() : new PresenceData();
            PresenceData currentPresenceData = Config.getProperty(screenInstance.currentData, "data") != null ? screenInstance.currentData.getData() : defaultPresenceData;
            screenInstance.openScreen(new PresenceEditorGui(currentPresenceData, defaultPresenceData, (Consumer<PresenceData>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$appendElements$12(com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui com.gitlab.cdagaming.craftpresence.core.config.element.PresenceData ), (Lcom/gitlab/cdagaming/craftpresence/core/config/element/PresenceData;)V)((DynamicEditorGui)screenInstance)));
        } else {
            screenInstance.currentData.setIconOverride(attributeName);
        }
    }

    private static /* synthetic */ void lambda$appendElements$12(DynamicEditorGui screenInstance, PresenceData output) {
        screenInstance.currentData.setData(output);
    }

    private /* synthetic */ void lambda$appendElements$11(DynamicEditorGui screenInstance) {
        String attributeName = screenInstance.getSecondaryEntry();
        this.getInstanceData().biomeData.remove(attributeName);
        if (!CraftPresence.BIOMES.DEFAULT_NAMES.contains(attributeName)) {
            CraftPresence.BIOMES.BIOME_NAMES.remove(attributeName);
        }
    }

    private /* synthetic */ void lambda$appendElements$10(DynamicEditorGui screenInstance) {
        String attributeName = screenInstance.getSecondaryEntry();
        String inputText = screenInstance.getPrimaryEntry();
        screenInstance.currentData.setTextOverride(inputText);
        this.getInstanceData().biomeData.put(attributeName, screenInstance.currentData);
        if (!CraftPresence.BIOMES.BIOME_NAMES.contains(attributeName)) {
            CraftPresence.BIOMES.BIOME_NAMES.add(attributeName);
        }
    }

    private /* synthetic */ void lambda$appendElements$9(String attributeName, DynamicEditorGui screenInstance) {
        screenInstance.isDefaultValue = "default".equals(attributeName);
        screenInstance.defaultData = this.getInstanceData().biomeData.get("default");
        screenInstance.currentData = this.getInstanceData().biomeData.get(attributeName);
        screenInstance.isPreliminaryData = screenInstance.currentData == null;
        screenInstance.setScreenTitle(Constants.TRANSLATOR.translate("gui.config.title.biome.edit_specific_biome", new Object[]{attributeName}));
        screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
        screenInstance.primaryMessage = Config.getProperty(screenInstance.currentData, "textOverride") != null ? screenInstance.currentData.getTextOverride() : screenInstance.originalPrimaryMessage;
    }

    private /* synthetic */ void lambda$appendElements$8(String attributeName, DynamicEditorGui screenInstance) {
        screenInstance.defaultData = this.getInstanceData().biomeData.get("default");
        screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
        screenInstance.primaryMessage = screenInstance.originalPrimaryMessage;
    }

    private /* synthetic */ void lambda$appendElements$7(String attributeName, String currentValue) {
        ModuleData defaultBiomeData = this.getInstanceData().biomeData.get("default");
        ModuleData currentBiomeData = this.getInstanceData().biomeData.get(attributeName);
        String defaultMessage = Config.getProperty(defaultBiomeData, "textOverride") != null ? defaultBiomeData.getTextOverride() : "";
        String currentMessage = Config.getProperty(currentBiomeData, "textOverride") != null ? currentBiomeData.getTextOverride() : "";
        ModuleData newData = new ModuleData();
        if (StringUtils.isNullOrEmpty((String)currentMessage) || currentMessage.equals(defaultMessage)) {
            newData.setTextOverride(defaultMessage);
        }
        newData.setIconOverride(currentValue);
        this.getInstanceData().biomeData.put(attributeName, newData);
    }

    private /* synthetic */ void lambda$appendElements$6(String attributeName, String currentValue) {
        this.getInstanceData().fallbackBiomeIcon = currentValue;
    }

    private /* synthetic */ TextWidget lambda$appendElements$5() {
        return this.defaultIcon;
    }

    private /* synthetic */ void lambda$appendElements$4() {
        this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.biome_messages.biome_icon", new Object[0])));
    }

    private /* synthetic */ void lambda$appendElements$3() {
        this.getInstanceData().fallbackBiomeIcon = this.defaultIcon.getControlMessage();
    }

    private /* synthetic */ void lambda$appendElements$2() {
        this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.biome_messages.biome_messages", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("biome.")})));
    }

    private /* synthetic */ void lambda$appendElements$1() {
        ModuleData defaultBiomeData = this.getInstanceData().biomeData.getOrDefault("default", new ModuleData());
        defaultBiomeData.setTextOverride(this.defaultMessage.getControlMessage());
        this.getInstanceData().biomeData.put("default", defaultBiomeData);
    }

    private /* synthetic */ void lambda$constructElements$0() {
        if (!this.proceedButton.isControlEnabled()) {
            this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.hover.empty.default", new Object[0])));
        }
    }
}

