/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.moonconfig.toml;

import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import me.hypherionmc.moonconfig.core.UnmodifiableConfig;
import me.hypherionmc.moonconfig.core.io.CharacterOutput;
import me.hypherionmc.moonconfig.core.io.ConfigWriter;
import me.hypherionmc.moonconfig.core.io.ConfigWriter$jvmdg$StaticDefaults;
import me.hypherionmc.moonconfig.core.io.IndentStyle;
import me.hypherionmc.moonconfig.core.io.NewlineStyle;
import me.hypherionmc.moonconfig.core.io.WriterOutput;
import me.hypherionmc.moonconfig.core.io.WritingMode;
import me.hypherionmc.moonconfig.core.utils.StringUtils;
import me.hypherionmc.moonconfig.toml.StringWriter;
import me.hypherionmc.moonconfig.toml.TableWriter;
import me.hypherionmc.moonconfig.toml.Toml;

public final class TomlWriter
implements ConfigWriter {
    private boolean lenientBareKeys = false;
    private Predicate<UnmodifiableConfig> writeTableInlinePredicate = (Predicate<UnmodifiableConfig>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isEmpty(), (Lme/hypherionmc/moonconfig/core/UnmodifiableConfig;)Z)();
    private Predicate<String> writeStringLiteralPredicate = (Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$new$0(java.lang.String ), (Ljava/lang/String;)Z)();
    private Predicate<List<?>> indentArrayElementsPredicate = (Predicate<List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$new$1(java.util.List ), (Ljava/util/List;)Z)();
    private char[] indent;
    private char[] newline;
    private int currentIndentLevel;

    public TomlWriter() {
        this.indent = IndentStyle.TABS.chars;
        this.newline = NewlineStyle.system().chars;
    }

    @Override
    public void write(UnmodifiableConfig config, Writer writer) {
        this.currentIndentLevel = -1;
        WriterOutput output = new WriterOutput(writer);
        TableWriter.writeNormal(config, new ArrayList<String>(), (CharacterOutput)output, this);
    }

    public boolean isLenientWithBareKeys() {
        return this.lenientBareKeys;
    }

    public void setLenientWithBareKeys(boolean lenientBareKeys) {
        this.lenientBareKeys = lenientBareKeys;
    }

    public void setWriteTableInlinePredicate(Predicate<UnmodifiableConfig> writeTableInlinePredicate) {
        this.writeTableInlinePredicate = writeTableInlinePredicate;
    }

    public void setWriteStringLiteralPredicate(Predicate<String> writeStringLiteralPredicate) {
        this.writeStringLiteralPredicate = writeStringLiteralPredicate;
    }

    public void setIndentArrayElementsPredicate(Predicate<List<?>> indentArrayElementsPredicate) {
        this.indentArrayElementsPredicate = indentArrayElementsPredicate;
    }

    public void setIndent(IndentStyle indentStyle) {
        this.indent = indentStyle.chars;
    }

    public void setIndent(String indentString) {
        this.indent = indentString.toCharArray();
    }

    public void setNewline(NewlineStyle newlineStyle) {
        this.newline = newlineStyle.chars;
    }

    public void setNewline(String newlineString) {
        this.newline = newlineString.toCharArray();
    }

    void increaseIndentLevel() {
        ++this.currentIndentLevel;
    }

    void decreaseIndentLevel() {
        --this.currentIndentLevel;
    }

    void writeIndent(CharacterOutput output) {
        for (int i = 0; i < this.currentIndentLevel; ++i) {
            output.write(this.indent);
        }
    }

    void writeNewline(CharacterOutput output) {
        output.write(this.newline);
    }

    void writeComment(String commentString, CharacterOutput output) {
        List<String> comments = StringUtils.splitLines(commentString);
        for (String comment : comments) {
            this.writeIndent(output);
            output.write('#');
            output.write(comment);
            output.write(this.newline);
        }
    }

    void writeKey(String key, CharacterOutput output) {
        if (Toml.isValidBareKey(key, this.lenientBareKeys)) {
            output.write(key);
        } else if (this.writeStringLiteralPredicate.test(key)) {
            StringWriter.writeLiteral(key, output);
        } else {
            StringWriter.writeBasic(key, output);
        }
    }

    boolean writesInline(UnmodifiableConfig config) {
        return this.writeTableInlinePredicate.test(config);
    }

    boolean writesLiteral(String string) {
        return this.writeStringLiteralPredicate.test(string);
    }

    boolean writesIndented(List<?> list) {
        return this.indentArrayElementsPredicate.test(list);
    }

    private static /* synthetic */ boolean lambda$new$1(List c) {
        return false;
    }

    private static /* synthetic */ boolean lambda$new$0(String c) {
        return false;
    }

    @Override
    public void write(UnmodifiableConfig unmodifiableConfig, Path path, WritingMode writingMode) {
        ConfigWriter$jvmdg$StaticDefaults.write((ConfigWriter)this, unmodifiableConfig, path, writingMode);
    }

    @Override
    public void write(UnmodifiableConfig unmodifiableConfig, OutputStream outputStream) {
        ConfigWriter$jvmdg$StaticDefaults.write((ConfigWriter)this, unmodifiableConfig, outputStream);
    }

    @Override
    public String writeToString(UnmodifiableConfig unmodifiableConfig) {
        return ConfigWriter$jvmdg$StaticDefaults.writeToString(this, unmodifiableConfig);
    }

    @Override
    public void write(UnmodifiableConfig unmodifiableConfig, OutputStream outputStream, Charset charset) {
        ConfigWriter$jvmdg$StaticDefaults.write((ConfigWriter)this, unmodifiableConfig, outputStream, charset);
    }

    @Override
    public void write(UnmodifiableConfig unmodifiableConfig, File file, WritingMode writingMode, Charset charset) {
        ConfigWriter$jvmdg$StaticDefaults.write((ConfigWriter)this, unmodifiableConfig, file, writingMode, charset);
    }

    @Override
    public void write(UnmodifiableConfig unmodifiableConfig, Path path, WritingMode writingMode, Charset charset) {
        ConfigWriter$jvmdg$StaticDefaults.write((ConfigWriter)this, unmodifiableConfig, path, writingMode, charset);
    }

    @Override
    public void write(UnmodifiableConfig unmodifiableConfig, File file, WritingMode writingMode) {
        ConfigWriter$jvmdg$StaticDefaults.write((ConfigWriter)this, unmodifiableConfig, file, writingMode);
    }

    @Override
    public void write(UnmodifiableConfig unmodifiableConfig, URL uRL) {
        ConfigWriter$jvmdg$StaticDefaults.write((ConfigWriter)this, unmodifiableConfig, uRL);
    }
}

