/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.entity;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.core.impl.Module;
import com.gitlab.cdagaming.craftpresence.core.impl.Module$jvmdg$StaticDefaults;
import com.gitlab.cdagaming.unilib.ModUtils;
import com.gitlab.cdagaming.unilib.utils.ItemUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_17;
import net.minecraft.class_31;

public class TileEntityUtils
implements Module {
    public final List<String> BLOCK_NAMES = StringUtils.newArrayList();
    public final List<String> ITEM_NAMES = StringUtils.newArrayList();
    private final List<String> BLOCK_CLASSES = StringUtils.newArrayList();
    private final List<String> ITEM_CLASSES = StringUtils.newArrayList();
    private final List<String> TILE_ENTITY_CLASSES = StringUtils.newArrayList();
    public List<String> TILE_ENTITY_NAMES = StringUtils.newArrayList();
    public Map<String, class_31> TILE_ENTITY_RESOURCES = StringUtils.newHashMap();
    private boolean enabled = false;
    private boolean isInUse = false;
    private boolean hasScannedConfig = false;
    private boolean hasScannedInternals = false;
    private boolean hasInitialized = false;
    private boolean hasInitializedMainHand = false;
    private boolean hasInitializedHelmet = false;
    private boolean hasInitializedChest = false;
    private boolean hasInitializedLegs = false;
    private boolean hasInitializedBoots = false;
    private class_31 CURRENT_MAIN_HAND_ITEM;
    private class_31 CURRENT_HELMET;
    private class_31 CURRENT_CHEST;
    private class_31 CURRENT_LEGS;
    private class_31 CURRENT_BOOTS;
    private String CURRENT_MAIN_HAND_ITEM_NAME;
    private String CURRENT_HELMET_NAME;
    private String CURRENT_CHEST_NAME;
    private String CURRENT_LEGS_NAME;
    private String CURRENT_BOOTS_NAME;

    @Override
    public void clearFieldData() {
        this.BLOCK_NAMES.clear();
        this.BLOCK_CLASSES.clear();
        this.ITEM_NAMES.clear();
        this.ITEM_CLASSES.clear();
        this.TILE_ENTITY_NAMES.clear();
        this.TILE_ENTITY_CLASSES.clear();
        this.TILE_ENTITY_RESOURCES.clear();
    }

    @Override
    public void clearAttributes() {
        this.CURRENT_MAIN_HAND_ITEM = ItemUtils.EMPTY_STACK;
        this.CURRENT_MAIN_HAND_ITEM_NAME = null;
        this.CURRENT_HELMET = ItemUtils.EMPTY_STACK;
        this.CURRENT_CHEST = ItemUtils.EMPTY_STACK;
        this.CURRENT_LEGS = ItemUtils.EMPTY_STACK;
        this.CURRENT_BOOTS = ItemUtils.EMPTY_STACK;
        this.CURRENT_HELMET_NAME = null;
        this.CURRENT_CHEST_NAME = null;
        this.CURRENT_LEGS_NAME = null;
        this.CURRENT_BOOTS_NAME = null;
        CraftPresence.CLIENT.removeArguments("item", "data.item");
        this.hasInitialized = false;
        this.hasInitializedMainHand = false;
        this.hasInitializedHelmet = false;
        this.hasInitializedChest = false;
        this.hasInitializedLegs = false;
        this.hasInitializedBoots = false;
    }

    @Override
    public void updateData() {
        boolean hasBootsChanged;
        class_31 NEW_CURRENT_MAIN_HAND_ITEM = CraftPresence.player.field_519.method_675();
        class_31 NEW_CURRENT_HELMET = CraftPresence.player.field_519.field_746[3];
        class_31 NEW_CURRENT_CHEST = CraftPresence.player.field_519.field_746[2];
        class_31 NEW_CURRENT_LEGS = CraftPresence.player.field_519.field_746[1];
        class_31 NEW_CURRENT_BOOTS = CraftPresence.player.field_519.field_746[0];
        boolean hasMainHandChanged = NEW_CURRENT_MAIN_HAND_ITEM != this.CURRENT_MAIN_HAND_ITEM;
        boolean hasHelmetChanged = NEW_CURRENT_HELMET != this.CURRENT_HELMET;
        boolean hasChestChanged = NEW_CURRENT_CHEST != this.CURRENT_CHEST;
        boolean hasLegsChanged = NEW_CURRENT_LEGS != this.CURRENT_LEGS;
        boolean bl = hasBootsChanged = NEW_CURRENT_BOOTS != this.CURRENT_BOOTS;
        if (hasMainHandChanged) {
            this.CURRENT_MAIN_HAND_ITEM = NEW_CURRENT_MAIN_HAND_ITEM;
            this.CURRENT_MAIN_HAND_ITEM_NAME = ItemUtils.getItemName((Object)this.CURRENT_MAIN_HAND_ITEM);
            if (!ItemUtils.isItemEmpty((Object)this.CURRENT_MAIN_HAND_ITEM)) {
                CraftPresence.CLIENT.syncTimestamp("data.item.main_hand.time");
            }
        }
        if (hasHelmetChanged) {
            this.CURRENT_HELMET = NEW_CURRENT_HELMET;
            this.CURRENT_HELMET_NAME = ItemUtils.getItemName((Object)this.CURRENT_HELMET);
            if (!ItemUtils.isItemEmpty((Object)this.CURRENT_HELMET)) {
                CraftPresence.CLIENT.syncTimestamp("data.item.helmet.time");
            }
        }
        if (hasChestChanged) {
            this.CURRENT_CHEST = NEW_CURRENT_CHEST;
            this.CURRENT_CHEST_NAME = ItemUtils.getItemName((Object)this.CURRENT_CHEST);
            if (!ItemUtils.isItemEmpty((Object)this.CURRENT_CHEST)) {
                CraftPresence.CLIENT.syncTimestamp("data.item.chestplate.time");
            }
        }
        if (hasLegsChanged) {
            this.CURRENT_LEGS = NEW_CURRENT_LEGS;
            this.CURRENT_LEGS_NAME = ItemUtils.getItemName((Object)this.CURRENT_LEGS);
            if (!ItemUtils.isItemEmpty((Object)this.CURRENT_LEGS)) {
                CraftPresence.CLIENT.syncTimestamp("data.item.leggings.time");
            }
        }
        if (hasBootsChanged) {
            this.CURRENT_BOOTS = NEW_CURRENT_BOOTS;
            this.CURRENT_BOOTS_NAME = ItemUtils.getItemName((Object)this.CURRENT_BOOTS);
            if (!ItemUtils.isItemEmpty((Object)this.CURRENT_BOOTS)) {
                CraftPresence.CLIENT.syncTimestamp("data.item.boots.time");
            }
        }
        if (hasMainHandChanged || hasHelmetChanged || hasChestChanged || hasLegsChanged || hasBootsChanged) {
            if (!this.hasInitialized) {
                this.initPresence();
                this.hasInitialized = true;
            }
            this.updatePresence();
        }
    }

    @Override
    public void initPresence() {
        this.syncArgument("item.message.default", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$0(), ()Ljava/lang/Object;)());
        this.syncArgument("item.message.holding", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$1(), ()Ljava/lang/Object;)((TileEntityUtils)this), true);
        this.syncArgument("item.message.equipped", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$2(), ()Ljava/lang/Object;)((TileEntityUtils)this), true);
    }

    @Override
    public void updatePresence() {
        if (!ItemUtils.isItemEmpty((Object)this.CURRENT_MAIN_HAND_ITEM)) {
            if (!this.hasInitializedMainHand) {
                this.syncArgument("data.item.main_hand.instance", (Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$3(), ()Ljava/lang/Boolean;)((TileEntityUtils)this), (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$4(), ()Ljava/lang/Object;)((TileEntityUtils)this), true);
                this.syncArgument("data.item.main_hand.class", (Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$5(), ()Ljava/lang/Boolean;)((TileEntityUtils)this), (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$6(), ()Ljava/lang/Object;)((TileEntityUtils)this), true);
                this.syncArgument("item.main_hand.name", (Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$7(), ()Ljava/lang/Boolean;)((TileEntityUtils)this), (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$8(), ()Ljava/lang/Object;)((TileEntityUtils)this), true);
                this.syncArgument("item.main_hand.message", (Supplier)(Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$9(), ()Ljava/lang/Boolean;)((TileEntityUtils)this), (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$10(), ()Ljava/lang/Object;)((TileEntityUtils)this));
                this.hasInitializedMainHand = true;
            }
        } else if (this.hasInitializedMainHand) {
            CraftPresence.CLIENT.removeArguments("item.main_hand", "data.item.main_hand");
            this.hasInitializedMainHand = false;
        }
        if (!ItemUtils.isItemEmpty((Object)this.CURRENT_HELMET)) {
            if (!this.hasInitializedHelmet) {
                this.syncArgument("data.item.helmet.instance", (Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$11(), ()Ljava/lang/Boolean;)((TileEntityUtils)this), (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$12(), ()Ljava/lang/Object;)((TileEntityUtils)this), true);
                this.syncArgument("data.item.helmet.class", (Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$13(), ()Ljava/lang/Boolean;)((TileEntityUtils)this), (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$14(), ()Ljava/lang/Object;)((TileEntityUtils)this), true);
                this.syncArgument("item.helmet.name", (Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$15(), ()Ljava/lang/Boolean;)((TileEntityUtils)this), (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$16(), ()Ljava/lang/Object;)((TileEntityUtils)this), true);
                this.syncArgument("item.helmet.message", (Supplier)(Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$17(), ()Ljava/lang/Boolean;)((TileEntityUtils)this), (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$18(), ()Ljava/lang/Object;)((TileEntityUtils)this));
                this.hasInitializedHelmet = true;
            }
        } else if (this.hasInitializedHelmet) {
            CraftPresence.CLIENT.removeArguments("item.helmet", "data.item.helmet");
            this.hasInitializedHelmet = false;
        }
        if (!ItemUtils.isItemEmpty((Object)this.CURRENT_CHEST)) {
            if (!this.hasInitializedChest) {
                this.syncArgument("data.item.chestplate.instance", (Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$19(), ()Ljava/lang/Boolean;)((TileEntityUtils)this), (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$20(), ()Ljava/lang/Object;)((TileEntityUtils)this), true);
                this.syncArgument("data.item.chestplate.class", (Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$21(), ()Ljava/lang/Boolean;)((TileEntityUtils)this), (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$22(), ()Ljava/lang/Object;)((TileEntityUtils)this), true);
                this.syncArgument("item.chestplate.name", (Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$23(), ()Ljava/lang/Boolean;)((TileEntityUtils)this), (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$24(), ()Ljava/lang/Object;)((TileEntityUtils)this), true);
                this.syncArgument("item.chestplate.message", (Supplier)(Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$25(), ()Ljava/lang/Boolean;)((TileEntityUtils)this), (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$26(), ()Ljava/lang/Object;)((TileEntityUtils)this));
                this.hasInitializedChest = true;
            }
        } else if (this.hasInitializedChest) {
            CraftPresence.CLIENT.removeArguments("item.chestplate", "data.item.chestplate");
            this.hasInitializedChest = false;
        }
        if (!ItemUtils.isItemEmpty((Object)this.CURRENT_LEGS)) {
            if (!this.hasInitializedLegs) {
                this.syncArgument("data.item.leggings.instance", (Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$27(), ()Ljava/lang/Boolean;)((TileEntityUtils)this), (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$28(), ()Ljava/lang/Object;)((TileEntityUtils)this), true);
                this.syncArgument("data.item.leggings.class", (Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$29(), ()Ljava/lang/Boolean;)((TileEntityUtils)this), (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$30(), ()Ljava/lang/Object;)((TileEntityUtils)this), true);
                this.syncArgument("item.leggings.name", (Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$31(), ()Ljava/lang/Boolean;)((TileEntityUtils)this), (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$32(), ()Ljava/lang/Object;)((TileEntityUtils)this), true);
                this.syncArgument("item.leggings.message", (Supplier)(Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$33(), ()Ljava/lang/Boolean;)((TileEntityUtils)this), (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$34(), ()Ljava/lang/Object;)((TileEntityUtils)this));
                this.hasInitializedLegs = true;
            }
        } else if (this.hasInitializedLegs) {
            CraftPresence.CLIENT.removeArguments("item.leggings", "data.item.leggings");
            this.hasInitializedLegs = false;
        }
        if (!ItemUtils.isItemEmpty((Object)this.CURRENT_BOOTS)) {
            if (!this.hasInitializedBoots) {
                this.syncArgument("data.item.boots.instance", (Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$35(), ()Ljava/lang/Boolean;)((TileEntityUtils)this), (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$36(), ()Ljava/lang/Object;)((TileEntityUtils)this), true);
                this.syncArgument("data.item.boots.class", (Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$37(), ()Ljava/lang/Boolean;)((TileEntityUtils)this), (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$38(), ()Ljava/lang/Object;)((TileEntityUtils)this), true);
                this.syncArgument("item.boots.name", (Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$39(), ()Ljava/lang/Boolean;)((TileEntityUtils)this), (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$40(), ()Ljava/lang/Object;)((TileEntityUtils)this), true);
                this.syncArgument("item.boots.message", (Supplier)(Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$41(), ()Ljava/lang/Boolean;)((TileEntityUtils)this), (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$updatePresence$42(), ()Ljava/lang/Object;)((TileEntityUtils)this));
                this.hasInitializedBoots = true;
            }
        } else if (this.hasInitializedBoots) {
            CraftPresence.CLIENT.removeArguments("item.boots", "data.item.boots");
            this.hasInitializedBoots = false;
        }
    }

    @Override
    public void getInternalData() {
        class_31 stack;
        for (class_17 class_172 : class_17.field_1937) {
            if (ItemUtils.isItemEmpty((Object)class_172)) continue;
            stack = ItemUtils.getStackFrom((Object)class_172);
            String blockName = ItemUtils.getItemName((Object)stack);
            if (!this.BLOCK_NAMES.contains(blockName)) {
                this.BLOCK_NAMES.add(blockName);
            }
            if (!this.BLOCK_CLASSES.contains(class_172.getClass().getName())) {
                this.BLOCK_CLASSES.add(class_172.getClass().getName());
            }
            if (this.TILE_ENTITY_RESOURCES.containsKey(blockName)) continue;
            this.TILE_ENTITY_RESOURCES.put(blockName, stack);
        }
        for (class_17 class_173 : class_124.field_468) {
            if (ItemUtils.isItemEmpty((Object)class_173)) continue;
            stack = ItemUtils.getStackFrom((Object)class_173);
            String itemName = ItemUtils.getItemName((Object)stack);
            if (!this.ITEM_NAMES.contains(itemName)) {
                this.ITEM_NAMES.add(itemName);
            }
            if (!this.ITEM_CLASSES.contains(class_173.getClass().getName())) {
                this.ITEM_CLASSES.add(class_173.getClass().getName());
            }
            if (this.TILE_ENTITY_RESOURCES.containsKey(itemName)) continue;
            this.TILE_ENTITY_RESOURCES.put(itemName, stack);
        }
        this.verifyEntities();
    }

    @Override
    public void getConfigData() {
        for (String itemEntry : CraftPresence.CONFIG.advancedSettings.itemMessages.keySet()) {
            if (StringUtils.isNullOrEmpty((String)itemEntry) || this.TILE_ENTITY_NAMES.contains(itemEntry)) continue;
            this.TILE_ENTITY_NAMES.add(itemEntry);
        }
    }

    @Override
    public void syncArgument(String argumentName, Supplier<Boolean> condition, Supplier<Object> event, boolean plain) {
        CraftPresence.CLIENT.syncArgument(argumentName, this.getModuleFunction((Supplier)condition, (Supplier)event), plain);
    }

    @Override
    public boolean hasScannedInternals() {
        return this.hasScannedInternals;
    }

    @Override
    public void setScannedInternals(boolean state) {
        this.hasScannedInternals = state;
    }

    @Override
    public boolean canFetchConfig() {
        return CraftPresence.CONFIG != null;
    }

    @Override
    public boolean hasScannedConfig() {
        return this.hasScannedConfig;
    }

    @Override
    public void setScannedConfig(boolean state) {
        this.hasScannedConfig = state;
    }

    @Override
    public boolean canBeEnabled() {
        return !CraftPresence.CONFIG.hasChanged() ? CraftPresence.CONFIG.advancedSettings.enablePerItem : this.isEnabled();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean canBeUsed() {
        return CraftPresence.player != null;
    }

    @Override
    public boolean isInUse() {
        return this.isInUse;
    }

    @Override
    public void setInUse(boolean state) {
        this.isInUse = state;
    }

    public void verifyEntities() {
        for (String item : StringUtils.newArrayList(this.ITEM_NAMES)) {
            if (!ItemUtils.isRawTE((String)item)) continue;
            this.ITEM_NAMES.remove(item);
            if (ModUtils.RAW_TRANSLATOR == null || !ModUtils.RAW_TRANSLATOR.hasTranslation(item)) continue;
            this.ITEM_NAMES.add(ModUtils.RAW_TRANSLATOR.translate(item, new Object[0]));
        }
        for (String item : StringUtils.newArrayList(this.BLOCK_NAMES)) {
            if (!ItemUtils.isRawTE((String)item)) continue;
            this.BLOCK_NAMES.remove(item);
            if (ModUtils.RAW_TRANSLATOR == null || !ModUtils.RAW_TRANSLATOR.hasTranslation(item)) continue;
            this.BLOCK_NAMES.add(ModUtils.RAW_TRANSLATOR.translate(item, new Object[0]));
        }
        StringUtils.addEntriesNotPresent(this.TILE_ENTITY_NAMES, this.BLOCK_NAMES);
        StringUtils.addEntriesNotPresent(this.TILE_ENTITY_NAMES, this.ITEM_NAMES);
        StringUtils.addEntriesNotPresent(this.TILE_ENTITY_CLASSES, this.BLOCK_CLASSES);
        StringUtils.addEntriesNotPresent(this.TILE_ENTITY_CLASSES, this.ITEM_CLASSES);
    }

    private /* synthetic */ Object lambda$updatePresence$42() {
        return CraftPresence.CONFIG.advancedSettings.itemMessages.getOrDefault(this.CURRENT_BOOTS_NAME, this.CURRENT_BOOTS_NAME);
    }

    private /* synthetic */ Boolean lambda$updatePresence$41() {
        return this.CURRENT_BOOTS != null;
    }

    private /* synthetic */ Object lambda$updatePresence$40() {
        return this.CURRENT_BOOTS_NAME;
    }

    private /* synthetic */ Boolean lambda$updatePresence$39() {
        return this.CURRENT_BOOTS != null;
    }

    private /* synthetic */ Object lambda$updatePresence$38() {
        return this.CURRENT_BOOTS.getClass();
    }

    private /* synthetic */ Boolean lambda$updatePresence$37() {
        return this.CURRENT_BOOTS != null;
    }

    private /* synthetic */ Object lambda$updatePresence$36() {
        return this.CURRENT_BOOTS;
    }

    private /* synthetic */ Boolean lambda$updatePresence$35() {
        return this.CURRENT_BOOTS != null;
    }

    private /* synthetic */ Object lambda$updatePresence$34() {
        return CraftPresence.CONFIG.advancedSettings.itemMessages.getOrDefault(this.CURRENT_LEGS_NAME, this.CURRENT_LEGS_NAME);
    }

    private /* synthetic */ Boolean lambda$updatePresence$33() {
        return this.CURRENT_LEGS != null;
    }

    private /* synthetic */ Object lambda$updatePresence$32() {
        return this.CURRENT_LEGS_NAME;
    }

    private /* synthetic */ Boolean lambda$updatePresence$31() {
        return this.CURRENT_LEGS != null;
    }

    private /* synthetic */ Object lambda$updatePresence$30() {
        return this.CURRENT_LEGS.getClass();
    }

    private /* synthetic */ Boolean lambda$updatePresence$29() {
        return this.CURRENT_LEGS != null;
    }

    private /* synthetic */ Object lambda$updatePresence$28() {
        return this.CURRENT_LEGS;
    }

    private /* synthetic */ Boolean lambda$updatePresence$27() {
        return this.CURRENT_LEGS != null;
    }

    private /* synthetic */ Object lambda$updatePresence$26() {
        return CraftPresence.CONFIG.advancedSettings.itemMessages.getOrDefault(this.CURRENT_CHEST_NAME, this.CURRENT_CHEST_NAME);
    }

    private /* synthetic */ Boolean lambda$updatePresence$25() {
        return this.CURRENT_CHEST != null;
    }

    private /* synthetic */ Object lambda$updatePresence$24() {
        return this.CURRENT_CHEST_NAME;
    }

    private /* synthetic */ Boolean lambda$updatePresence$23() {
        return this.CURRENT_CHEST != null;
    }

    private /* synthetic */ Object lambda$updatePresence$22() {
        return this.CURRENT_CHEST.getClass();
    }

    private /* synthetic */ Boolean lambda$updatePresence$21() {
        return this.CURRENT_CHEST != null;
    }

    private /* synthetic */ Object lambda$updatePresence$20() {
        return this.CURRENT_CHEST;
    }

    private /* synthetic */ Boolean lambda$updatePresence$19() {
        return this.CURRENT_CHEST != null;
    }

    private /* synthetic */ Object lambda$updatePresence$18() {
        return CraftPresence.CONFIG.advancedSettings.itemMessages.getOrDefault(this.CURRENT_HELMET_NAME, this.CURRENT_HELMET_NAME);
    }

    private /* synthetic */ Boolean lambda$updatePresence$17() {
        return this.CURRENT_HELMET != null;
    }

    private /* synthetic */ Object lambda$updatePresence$16() {
        return this.CURRENT_HELMET_NAME;
    }

    private /* synthetic */ Boolean lambda$updatePresence$15() {
        return this.CURRENT_HELMET != null;
    }

    private /* synthetic */ Object lambda$updatePresence$14() {
        return this.CURRENT_HELMET.getClass();
    }

    private /* synthetic */ Boolean lambda$updatePresence$13() {
        return this.CURRENT_HELMET != null;
    }

    private /* synthetic */ Object lambda$updatePresence$12() {
        return this.CURRENT_HELMET;
    }

    private /* synthetic */ Boolean lambda$updatePresence$11() {
        return this.CURRENT_HELMET != null;
    }

    private /* synthetic */ Object lambda$updatePresence$10() {
        return CraftPresence.CONFIG.advancedSettings.itemMessages.getOrDefault(this.CURRENT_MAIN_HAND_ITEM_NAME, this.CURRENT_MAIN_HAND_ITEM_NAME);
    }

    private /* synthetic */ Boolean lambda$updatePresence$9() {
        return this.CURRENT_MAIN_HAND_ITEM != null;
    }

    private /* synthetic */ Object lambda$updatePresence$8() {
        return this.CURRENT_MAIN_HAND_ITEM_NAME;
    }

    private /* synthetic */ Boolean lambda$updatePresence$7() {
        return this.CURRENT_MAIN_HAND_ITEM != null;
    }

    private /* synthetic */ Object lambda$updatePresence$6() {
        return this.CURRENT_MAIN_HAND_ITEM.getClass();
    }

    private /* synthetic */ Boolean lambda$updatePresence$5() {
        return this.CURRENT_MAIN_HAND_ITEM != null;
    }

    private /* synthetic */ Object lambda$updatePresence$4() {
        return this.CURRENT_MAIN_HAND_ITEM;
    }

    private /* synthetic */ Boolean lambda$updatePresence$3() {
        return this.CURRENT_MAIN_HAND_ITEM != null;
    }

    private /* synthetic */ Object lambda$initPresence$2() {
        return String.format("[%s, %s, %s, %s]", StringUtils.getOrDefault((String)this.CURRENT_HELMET_NAME, (String)"N/A"), StringUtils.getOrDefault((String)this.CURRENT_CHEST_NAME, (String)"N/A"), StringUtils.getOrDefault((String)this.CURRENT_LEGS_NAME, (String)"N/A"), StringUtils.getOrDefault((String)this.CURRENT_BOOTS_NAME, (String)"N/A"));
    }

    private /* synthetic */ Object lambda$initPresence$1() {
        return String.format("[%s, %s]", StringUtils.getOrDefault((String)this.CURRENT_MAIN_HAND_ITEM_NAME, (String)"N/A"), "N/A");
    }

    private static /* synthetic */ Object lambda$initPresence$0() {
        return CraftPresence.CONFIG.advancedSettings.itemMessages.getOrDefault("default", "");
    }

    public void syncArgument(String string, Supplier supplier) {
        Module$jvmdg$StaticDefaults.syncArgument(this, string, supplier);
    }

    @Override
    public void printException(Throwable throwable) {
        Module$jvmdg$StaticDefaults.printException(this, throwable);
    }

    @Override
    public boolean canBeLoaded() {
        return Module$jvmdg$StaticDefaults.canBeLoaded(this);
    }

    @Override
    public void clearClientData() {
        Module$jvmdg$StaticDefaults.clearClientData(this);
    }

    @Override
    public void postTick() {
        Module$jvmdg$StaticDefaults.postTick(this);
    }

    @Override
    public void markInternalsScanned() {
        Module$jvmdg$StaticDefaults.markInternalsScanned(this);
    }

    public void syncArgument(String string, Supplier supplier, Supplier supplier2) {
        Module$jvmdg$StaticDefaults.syncArgument((Module)this, string, supplier, supplier2);
    }

    @Override
    public void markConfigScanned() {
        Module$jvmdg$StaticDefaults.markConfigScanned(this);
    }

    @Override
    public void clearActiveData() {
        Module$jvmdg$StaticDefaults.clearActiveData(this);
    }

    @Override
    public void emptyData() {
        Module$jvmdg$StaticDefaults.emptyData(this);
    }

    public void syncArgument(String string, Supplier supplier, boolean bl) {
        Module$jvmdg$StaticDefaults.syncArgument((Module)this, string, supplier, bl);
    }

    @Override
    public void queueConfigScan() {
        Module$jvmdg$StaticDefaults.queueConfigScan(this);
    }

    public Supplier getModuleFunction(Supplier supplier) {
        return Module$jvmdg$StaticDefaults.getModuleFunction(this, supplier);
    }

    @Override
    public void preTick() {
        Module$jvmdg$StaticDefaults.preTick(this);
    }

    @Override
    public void scanConfigData() {
        Module$jvmdg$StaticDefaults.scanConfigData(this);
    }

    public Supplier getModuleFunction(Supplier supplier, Supplier supplier2) {
        return Module$jvmdg$StaticDefaults.getModuleFunction(this, supplier, supplier2);
    }

    @Override
    public void scanInternalData() {
        Module$jvmdg$StaticDefaults.scanInternalData(this);
    }

    @Override
    public void queueInternalScan() {
        Module$jvmdg$StaticDefaults.queueInternalScan(this);
    }

    @Override
    public void onTick() {
        Module$jvmdg$StaticDefaults.onTick(this);
    }

    @Override
    public boolean canFetchInternals() {
        return Module$jvmdg$StaticDefaults.canFetchInternals(this);
    }
}

