/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.server;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.Config;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.config.element.PresenceData;
import com.gitlab.cdagaming.craftpresence.core.impl.ExtendedModule;
import com.gitlab.cdagaming.craftpresence.core.impl.ExtendedModule$jvmdg$StaticDefaults;
import com.gitlab.cdagaming.craftpresence.core.impl.Module;
import com.gitlab.cdagaming.craftpresence.core.impl.Module$jvmdg$StaticDefaults;
import com.gitlab.cdagaming.craftpresence.core.impl.discord.DiscordStatus;
import com.gitlab.cdagaming.craftpresence.utils.server.ServerNBTStorage;
import com.gitlab.cdagaming.unilib.ModUtils;
import com.gitlab.cdagaming.unilib.utils.WorldUtils;
import com.gitlab.cdagaming.unilib.utils.gui.RenderUtils;
import io.github.cdagaming.unicore.impl.Pair;
import io.github.cdagaming.unicore.utils.MathUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import io.github.cdagaming.unicore.utils.TimeUtils;
import java.lang.invoke.LambdaMetafactory;
import java.net.Socket;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_117;
import net.minecraft.class_219;
import net.minecraft.class_32;
import net.minecraft.class_322;
import net.minecraft.class_57;
import net.minecraft.class_595;
import net.minecraft.client.Minecraft;

public class ServerUtils
implements ExtendedModule {
    private static final List<String> invalidMotds = StringUtils.newArrayList((Object[])new String[]{"multiplayer.status.cannot_connect", "multiplayer.status.cannot_resolve", "multiplayer.status.polling", "multiplayer.status.pinging"});
    private static final List<String> invalidNames = StringUtils.newArrayList((Object[])new String[]{"selectServer.defaultName"});
    public List<String> currentPlayerList = StringUtils.newArrayList();
    public List<String> knownAddresses = StringUtils.newArrayList();
    public List<String> defaultAddresses = StringUtils.newArrayList();
    public Map<String, ServerNBTStorage> knownServerData = StringUtils.newHashMap();
    private boolean enabled = false;
    private boolean isInUse = false;
    private boolean hasScannedConfig = false;
    private boolean hasScannedInternals = true;
    private boolean hasInitialized = false;
    private boolean hasInitializedServer = false;
    private boolean hasInitializedRealm = false;
    private boolean hasCheckedRealm = false;
    private String currentServer_IP;
    private String formattedServer_IP;
    private String currentServer_Name;
    private String currentServer_MOTD;
    private List<String> currentServer_MOTD_Lines = StringUtils.newArrayList();
    private int currentPlayers;
    private int maxPlayers;
    private ServerNBTStorage currentServerData;
    private class_219 currentConnection;
    private boolean queuedForUpdate = false;
    private boolean joinInProgress = false;
    private boolean isOnLAN = false;
    private boolean isOnSinglePlayer = false;
    private boolean isOnRealm = false;

    @Override
    public void clearFieldData() {
        this.currentPlayerList.clear();
        this.defaultAddresses.clear();
        this.knownAddresses.clear();
        this.knownServerData.clear();
    }

    @Override
    public void clearAttributes() {
        this.currentServer_IP = null;
        this.formattedServer_IP = null;
        this.currentServer_MOTD = null;
        this.currentServer_MOTD_Lines.clear();
        this.currentServer_Name = null;
        this.currentServerData = null;
        this.currentConnection = null;
        this.currentPlayers = 0;
        this.maxPlayers = 0;
        this.stopPingTask();
        this.queuedForUpdate = false;
        this.joinInProgress = false;
        this.isOnLAN = false;
        this.isOnSinglePlayer = false;
        this.isOnRealm = false;
        CraftPresence.CLIENT.removeArguments("server", "data.server", "world", "data.world", "player.position", "player.health", "player.mode");
        CraftPresence.CLIENT.clearForcedData("server");
        CraftPresence.CLIENT.clearPartyData();
        this.hasInitialized = false;
        this.hasInitializedServer = false;
        this.hasInitializedRealm = false;
        this.hasCheckedRealm = false;
    }

    @Override
    public void preTick() {
        this.joinInProgress = CraftPresence.CLIENT.STATUS == DiscordStatus.JoinGame || CraftPresence.CLIENT.STATUS == DiscordStatus.SpectateGame;
    }

    @Override
    public void updateData() {
        ServerNBTStorage newServerData;
        class_219 newConnection = CraftPresence.instance.method_2145();
        try {
            if (newConnection != null) {
                class_117 netManager = (class_117)StringUtils.getField(class_219.class, (Object)newConnection, (String[])new String[]{"netManager", "field_1971", "e"});
                Socket socket = (Socket)StringUtils.getField(class_117.class, (Object)netManager, (String[])new String[]{"networkSocket", "field_1281", "h"});
                String retrievedIP = socket.getInetAddress().getHostAddress();
                int retrievedPort = socket.getPort();
                newServerData = !StringUtils.isNullOrEmpty((String)retrievedIP) && retrievedPort != 0 ? new ServerNBTStorage(retrievedIP, retrievedPort) : null;
            } else {
                newServerData = null;
            }
        }
        catch (Exception ex) {
            newServerData = null;
        }
        if (!this.joinInProgress) {
            if (!this.hasCheckedRealm) {
                this.isOnRealm = false;
                this.hasCheckedRealm = true;
            }
            if (this.isOnRealm) {
                this.processRealmData(newServerData, newConnection);
            } else {
                this.processServerData(newServerData, newConnection);
            }
        }
        if (this.queuedForUpdate) {
            if (!this.hasInitialized) {
                this.initPresence();
                this.hasInitialized = true;
            }
            this.updatePresence();
            this.queuedForUpdate = false;
        }
    }

    private void processData(boolean newLANStatus, boolean newSinglePlayerStatus, ServerNBTStorage newServerData, class_219 newConnection, String newServer_IP, String newServer_MOTD, String newServer_Name, int newCurrentPlayers, int newMaxPlayers, List<String> newPlayerList) {
        boolean hasLeftServer;
        boolean isNewServer = newServerData != null && !newServerData.equals(this.currentServerData);
        boolean bl = hasLeftServer = newServerData == null && this.currentServerData != null;
        if (newLANStatus != this.isOnLAN || newSinglePlayerStatus != this.isOnSinglePlayer || isNewServer || hasLeftServer || newConnection != null && !newConnection.equals(this.currentConnection) || !newServer_IP.equals(this.currentServer_IP) || !StringUtils.isNullOrEmpty((String)newServer_MOTD) && !newServer_MOTD.equals(this.currentServer_MOTD) || !StringUtils.isNullOrEmpty((String)newServer_Name) && !newServer_Name.equals(this.currentServer_Name)) {
            this.currentServer_IP = newServer_IP;
            if (!newServer_MOTD.equals(this.currentServer_MOTD)) {
                this.currentServer_MOTD = newServer_MOTD;
                this.currentServer_MOTD_Lines = StringUtils.splitTextByNewLine((String)newServer_MOTD);
            }
            this.currentServer_Name = newServer_Name;
            this.currentServerData = newServerData;
            this.currentConnection = newConnection;
            this.isOnLAN = newLANStatus;
            this.isOnSinglePlayer = newSinglePlayerStatus;
            this.queuedForUpdate = true;
            if (isNewServer) {
                this.startPingTask(CraftPresence.CONFIG.serverSettings.pingRateInterval, CraftPresence.CONFIG.serverSettings.pingRateUnit);
            } else if (hasLeftServer) {
                this.stopPingTask();
            }
            if (!StringUtils.isNullOrEmpty((String)this.currentServer_IP)) {
                String string = this.formattedServer_IP = this.currentServer_IP.contains(":") ? StringUtils.formatAddress((String)this.currentServer_IP, (boolean)false) : this.currentServer_IP;
                if (!(this.isOnRealm || this.isOnSinglePlayer || this.isOnLAN)) {
                    if (!this.defaultAddresses.contains(this.formattedServer_IP)) {
                        this.defaultAddresses.add(this.formattedServer_IP);
                    }
                    if (!this.knownAddresses.contains(this.formattedServer_IP)) {
                        this.knownAddresses.add(this.formattedServer_IP);
                    }
                }
            }
        }
        if (newCurrentPlayers != this.currentPlayers || newMaxPlayers != this.maxPlayers) {
            this.currentPlayers = newCurrentPlayers;
            this.maxPlayers = newMaxPlayers;
            this.queuedForUpdate = true;
        }
        if (!newPlayerList.equals(this.currentPlayerList)) {
            this.currentPlayerList = newPlayerList;
            if (CraftPresence.ENTITIES.isEnabled()) {
                CraftPresence.ENTITIES.ENTITY_NAMES.removeAll(CraftPresence.ENTITIES.PLAYER_BINDINGS.keySet());
                CraftPresence.ENTITIES.queueInternalScan();
            }
        }
    }

    private String getServerAddress(ServerNBTStorage newServerData) {
        return newServerData != null && !StringUtils.isNullOrEmpty((String)newServerData.serverIP) ? newServerData.serverIP : "127.0.0.1";
    }

    private String getServerMotd(ServerNBTStorage newServerData) {
        String result = "";
        if (newServerData != null && newServerData.serverMOTD != null) {
            result = newServerData.serverMOTD;
        }
        return !this.isInvalidMotd(result) ? StringUtils.stripAllFormatting((String)result) : CraftPresence.CONFIG.serverSettings.fallbackServerMotd;
    }

    private void processRealmData(ServerNBTStorage newServerData, class_219 newConnection) {
        this.processServerData(newServerData, newConnection);
    }

    private void processServerData(ServerNBTStorage newServerData, class_219 newConnection) {
        List newPlayerList = StringUtils.newArrayList();
        boolean newCurrentPlayers = true;
        boolean newLANStatus = false;
        boolean newSinglePlayerStatus = !CraftPresence.instance.method_2138();
        int newMaxPlayers = 2;
        String newServer_IP = this.getServerAddress(newServerData);
        String newServer_Name = newServerData != null && !this.isInvalidName(newServerData.serverName) ? newServerData.serverName : CraftPresence.CONFIG.serverSettings.fallbackServerName;
        String newServer_MOTD = this.getServerMotd(newServerData);
        this.processData(false, newSinglePlayerStatus, newServerData, newConnection, newServer_IP, newServer_MOTD, newServer_Name, 1, 2, newPlayerList);
    }

    private boolean isInvalidData(String input, List<String> invalidItems) {
        if (!StringUtils.isNullOrEmpty((String)input)) {
            for (String item : invalidItems) {
                if (ModUtils.RAW_TRANSLATOR == null || !ModUtils.RAW_TRANSLATOR.hasTranslation(item) || !input.equalsIgnoreCase(ModUtils.RAW_TRANSLATOR.translate(item, new Object[0]))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isInvalidMotd(String serverMotd) {
        return this.isInvalidData(serverMotd, invalidMotds);
    }

    private boolean isInvalidName(String serverName) {
        return this.isInvalidData(serverName, invalidNames);
    }

    private String makeSecret() {
        String formattedKey = CraftPresence.CLIENT.CLIENT_ID;
        boolean containsServerName = false;
        boolean containsServerIP = false;
        if (!StringUtils.isNullOrEmpty((String)this.currentServer_Name)) {
            formattedKey = ServerUtils.jvmdowngrader$concat$makeSecret$1(formattedKey, this.currentServer_Name);
            containsServerName = true;
        }
        if (!StringUtils.isNullOrEmpty((String)this.currentServer_IP)) {
            formattedKey = ServerUtils.jvmdowngrader$concat$makeSecret$1(formattedKey, this.currentServer_IP);
            containsServerIP = true;
        }
        formattedKey = ServerUtils.jvmdowngrader$concat$makeSecret$1(formattedKey, containsServerName, containsServerIP);
        return formattedKey;
    }

    public void verifyAndJoin(String secret) {
        boolean isValidSecret;
        Object[] boolParts = secret.split(";");
        Object[] stringParts = boolParts[0].split("-");
        boolean containsValidClientID = StringUtils.elementExists((Object[])stringParts, (int)0) && ((String)stringParts[0]).length() >= 18 && (Boolean)StringUtils.getValidLong((String)stringParts[0]).getFirst() != false;
        boolean containsServerName = StringUtils.elementExists((Object[])boolParts, (int)1) && StringUtils.elementExists((Object[])stringParts, (int)1) && Boolean.parseBoolean((String)boolParts[1]);
        boolean containsServerIP = StringUtils.elementExists((Object[])boolParts, (int)2) && StringUtils.elementExists((Object[])stringParts, (int)2) && Boolean.parseBoolean((String)boolParts[2]);
        Object serverName = containsServerName ? stringParts[1] : CraftPresence.CONFIG.serverSettings.fallbackServerName;
        String serverIP = containsServerIP ? stringParts[2] : "";
        boolean bl = isValidSecret = boolParts.length <= 4 && stringParts.length <= 3 && containsValidClientID;
        if (isValidSecret) {
            ModUtils.executeOnMainThread((Minecraft)CraftPresence.instance, (Runnable)(Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$verifyAndJoin$0(java.lang.String java.lang.String ), ()V)((ServerUtils)this, (String)serverName, (String)serverIP));
        } else {
            Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.discord.join", new Object[]{secret}), new Object[0]);
        }
        CraftPresence.CLIENT.STATUS = DiscordStatus.Ready;
    }

    private void pingServer(ServerNBTStorage serverData, Runnable saver, Runnable callback) {
    }

    private void pingServer(Runnable saver, Runnable callback) {
        this.pingServer(this.currentServerData, saver, callback);
    }

    private void pingServer(ServerNBTStorage serverData, Runnable callback) {
        this.pingServer(serverData, null, callback);
    }

    private void pingServer(Runnable callback) {
        this.pingServer(this.currentServerData, callback);
    }

    private void pingServer(ServerNBTStorage serverData) {
        this.pingServer(serverData, null);
    }

    private void pingServer() {
        this.pingServer(this.currentServerData);
    }

    private void startPingTask(int interval, String unit) {
    }

    private void stopPingTask() {
    }

    private void joinServer(ServerNBTStorage serverData) {
        try {
            this.pingServer(serverData);
            if (CraftPresence.player != null) {
                CraftPresence.world.method_293();
                CraftPresence.instance.method_2113(null);
            }
            RenderUtils.openScreen((Minecraft)CraftPresence.instance, (class_32)new class_595(CraftPresence.instance, serverData.serverIP, serverData.serverPort));
        }
        catch (Throwable ex) {
            this.printException(ex);
        }
    }

    @Override
    public void initPresence() {
        this.syncArgument("player.position.x", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$1(), ()Ljava/lang/Object;)(), true);
        this.syncArgument("player.position.y", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$2(), ()Ljava/lang/Object;)(), true);
        this.syncArgument("player.position.z", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$3(), ()Ljava/lang/Object;)(), true);
        this.syncArgument("player.health.current", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$4(), ()Ljava/lang/Object;)(), true);
        this.syncArgument("player.health.max", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$5(), ()Ljava/lang/Object;)(), true);
        this.syncArgument("player.mode", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$6(), ()Ljava/lang/Object;)(), true);
        this.syncArgument("world.difficulty", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$7(), ()Ljava/lang/Object;)(), true);
        this.syncArgument("world.weather.name", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$8(), ()Ljava/lang/Object;)(), true);
        this.syncArgument("world.name", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$9(), ()Ljava/lang/Object;)(), true);
        this.syncArgument("world.type", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$10(), ()Ljava/lang/Object;)(), true);
        this.syncArgument("world.time.day", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$11(), ()Ljava/lang/Object;)(), true);
        this.syncArgument("world.time.format_24", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$12(), ()Ljava/lang/Object;)(), true);
        this.syncArgument("world.time.format_12", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$13(), ()Ljava/lang/Object;)(), true);
        this.syncArgument("data.world.time.instance", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$14(), ()Ljava/lang/Object;)(), true);
        this.syncArgument("server.default.icon", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$15(), ()Ljava/lang/Object;)());
        this.syncArgument("server.message", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$16(), ()Ljava/lang/Object;)((ServerUtils)this));
        this.syncArgument("server.icon", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$20(), ()Ljava/lang/Object;)((ServerUtils)this));
        CraftPresence.CLIENT.addForcedData("server", (Supplier<PresenceData>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$21(), ()Lcom/gitlab/cdagaming/craftpresence/core/config/element/PresenceData;)((ServerUtils)this));
        CraftPresence.CLIENT.syncTimestamp("data.server.time");
    }

    private void initServerArgs() {
        this.syncArgument("server.players.current", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initServerArgs$22(), ()Ljava/lang/Object;)((ServerUtils)this), true);
        this.syncArgument("server.players.max", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initServerArgs$23(), ()Ljava/lang/Object;)((ServerUtils)this), true);
        this.syncArgument("server.address.full", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initServerArgs$24(), ()Ljava/lang/Object;)((ServerUtils)this), true);
        this.syncArgument("server.address.short", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initServerArgs$25(), ()Ljava/lang/Object;)((ServerUtils)this), true);
        this.syncArgument("server.name", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initServerArgs$26(), ()Ljava/lang/Object;)((ServerUtils)this), true);
        this.syncArgument("server.motd.raw", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initServerArgs$27(), ()Ljava/lang/Object;)((ServerUtils)this), true);
        if (!this.currentServer_MOTD_Lines.isEmpty()) {
            for (int i = 0; i < this.currentServer_MOTD_Lines.size(); ++i) {
                int index = i + 1;
                this.syncArgument(ServerUtils.jvmdowngrader$concat$initServerArgs$1(index), (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initServerArgs$28(int ), ()Ljava/lang/Object;)((ServerUtils)this, (int)index), true);
            }
        }
    }

    private void initRealmArgs() {
        this.syncArgument("server.minigame", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initRealmArgs$29(), ()Ljava/lang/Object;)(), true);
        this.syncArgument("server.type", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initRealmArgs$30(), ()Ljava/lang/Object;)(), true);
    }

    @Override
    public void updatePresence() {
        if (!this.isOnSinglePlayer && (this.isOnLAN || this.currentServerData != null)) {
            if (!this.hasInitializedServer) {
                this.initServerArgs();
                this.hasInitializedServer = true;
            }
            if (this.isOnRealm && !this.hasInitializedRealm) {
                this.initRealmArgs();
                this.hasInitializedRealm = true;
            }
            if (!this.isOnRealm && !this.isOnLAN && CraftPresence.CONFIG.generalSettings.enableJoinRequests) {
                CraftPresence.CLIENT.PARTY_ID = !StringUtils.isNullOrEmpty((String)this.currentServer_Name) && !this.currentServer_Name.equalsIgnoreCase(CraftPresence.CONFIG.serverSettings.fallbackServerName) ? ServerUtils.jvmdowngrader$concat$updatePresence$1(this.currentServer_Name) : ServerUtils.jvmdowngrader$concat$updatePresence$1(this.currentServer_IP);
                CraftPresence.CLIENT.JOIN_SECRET = this.makeSecret();
                CraftPresence.CLIENT.PARTY_SIZE = this.currentPlayers;
                CraftPresence.CLIENT.PARTY_MAX = this.maxPlayers;
            }
        }
    }

    @Override
    public void getInternalData() {
    }

    @Override
    public void getConfigData() {
        for (String serverEntry : CraftPresence.CONFIG.serverSettings.serverData.keySet()) {
            if (StringUtils.isNullOrEmpty((String)serverEntry) || this.knownAddresses.contains(serverEntry)) continue;
            this.knownAddresses.add(serverEntry);
        }
    }

    @Override
    public void syncArgument(String argumentName, Supplier<Boolean> condition, Supplier<Object> event, boolean plain) {
        CraftPresence.CLIENT.syncArgument(argumentName, this.getModuleFunction((Supplier)condition, (Supplier)event), plain);
    }

    @Override
    public ModuleData getData(String key) {
        return CraftPresence.CONFIG.serverSettings.serverData.get(key);
    }

    @Override
    public String getOverrideText(ModuleData data) {
        return CraftPresence.CLIENT.getOverrideText(this.getPresenceData(data));
    }

    @Override
    public boolean hasScannedInternals() {
        return this.hasScannedInternals;
    }

    @Override
    public boolean canFetchConfig() {
        return CraftPresence.CONFIG != null;
    }

    @Override
    public boolean hasScannedConfig() {
        return this.hasScannedConfig;
    }

    @Override
    public void setScannedConfig(boolean state) {
        this.hasScannedConfig = state;
    }

    @Override
    public boolean canBeEnabled() {
        return !CraftPresence.CONFIG.hasChanged() ? CraftPresence.CONFIG.generalSettings.detectWorldData : this.isEnabled();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean canBeUsed() {
        return CraftPresence.player != null && !this.joinInProgress;
    }

    @Override
    public boolean isInUse() {
        return this.isInUse;
    }

    @Override
    public void setInUse(boolean state) {
        this.isInUse = state;
    }

    public ServerNBTStorage getDataFromName(String serverAddress) {
        return this.knownServerData.getOrDefault(serverAddress, null);
    }

    private static /* synthetic */ Object lambda$initRealmArgs$30() {
        return "";
    }

    private static /* synthetic */ Object lambda$initRealmArgs$29() {
        return "";
    }

    private /* synthetic */ Object lambda$initServerArgs$28(int index) {
        return this.currentServer_MOTD_Lines.get(index);
    }

    private /* synthetic */ Object lambda$initServerArgs$27() {
        return this.currentServer_MOTD;
    }

    private /* synthetic */ Object lambda$initServerArgs$26() {
        return this.currentServer_Name;
    }

    private /* synthetic */ Object lambda$initServerArgs$25() {
        return this.formattedServer_IP;
    }

    private /* synthetic */ Object lambda$initServerArgs$24() {
        return this.currentServer_IP;
    }

    private /* synthetic */ Object lambda$initServerArgs$23() {
        return this.maxPlayers;
    }

    private /* synthetic */ Object lambda$initServerArgs$22() {
        return this.currentPlayers;
    }

    private /* synthetic */ PresenceData lambda$initPresence$21() {
        if (!this.isInUse()) {
            return null;
        }
        ModuleData resultData = null;
        if (!(this.isOnRealm || this.isOnSinglePlayer || !this.isOnLAN && this.currentServerData == null)) {
            resultData = this.isOnLAN ? CraftPresence.CONFIG.statusMessages.lanData : this.getOrDefault(new String[]{this.formattedServer_IP, this.currentServer_Name});
        } else if (this.isOnSinglePlayer) {
            resultData = CraftPresence.CONFIG.statusMessages.singleplayerData;
        } else if (this.isOnRealm) {
            resultData = CraftPresence.CONFIG.statusMessages.realmData;
        }
        return this.getPresenceData(resultData);
    }

    private /* synthetic */ Object lambda$initPresence$20() {
        boolean inServer = !this.isOnRealm && !this.isOnSinglePlayer && (this.isOnLAN || this.currentServerData != null);
        String currentServerIcon = "";
        ModuleData resultData = null;
        if (inServer) {
            if (this.isOnLAN) {
                resultData = CraftPresence.CONFIG.statusMessages.lanData;
                currentServerIcon = Config.isValidProperty(resultData, "iconOverride") ? resultData.getIconOverride() : "";
            } else {
                ModuleData defaultData = this.getDefaultData();
                ModuleData alternateData = this.getData(this.currentServer_Name);
                ModuleData primaryData = this.getData(this.formattedServer_IP);
                resultData = this.getOrDefault(new ModuleData[]{primaryData, alternateData});
                String defaultIcon = Config.isValidProperty(defaultData, "iconOverride") ? defaultData.getIconOverride() : "";
                String alternateIcon = Config.isValidProperty(alternateData, "iconOverride") ? alternateData.getIconOverride() : defaultIcon;
                String string = currentServerIcon = Config.isValidProperty(primaryData, "iconOverride") ? primaryData.getIconOverride() : alternateIcon;
                if (StringUtils.isNullOrEmpty((String)currentServerIcon)) {
                    currentServerIcon = CraftPresence.CLIENT.addEndpointIcon(CraftPresence.CONFIG, CraftPresence.CONFIG.advancedSettings.serverIconEndpoint, this.formattedServer_IP, true) ? this.formattedServer_IP : this.currentServer_Name;
                }
            }
        } else if (this.isOnSinglePlayer) {
            resultData = CraftPresence.CONFIG.statusMessages.singleplayerData;
            currentServerIcon = Config.isValidProperty(resultData, "iconOverride") ? resultData.getIconOverride() : "";
        } else if (this.isOnRealm) {
            resultData = CraftPresence.CONFIG.statusMessages.realmData;
            String string = currentServerIcon = Config.isValidProperty(resultData, "iconOverride") ? resultData.getIconOverride() : "";
            if (StringUtils.isNullOrEmpty((String)currentServerIcon)) {
                String originalName = "";
                boolean isValidUuid = StringUtils.isValidUuid((String)"");
                if (!CraftPresence.CONFIG.hasChanged() && CraftPresence.CONFIG.advancedSettings.allowEndpointIcons && !StringUtils.isNullOrEmpty((String)CraftPresence.CONFIG.advancedSettings.playerSkinEndpoint)) {
                    return CraftPresence.CLIENT.compileData(String.format(CraftPresence.CONFIG.advancedSettings.playerSkinEndpoint, ""), new Pair((Object)"player.name", (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$17(), ()Ljava/lang/String;)()), new Pair((Object)"player.uuid.full", (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$18(boolean ), ()Ljava/lang/String;)((boolean)isValidUuid)), new Pair((Object)"player.uuid.short", (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$19(boolean ), ()Ljava/lang/String;)((boolean)isValidUuid))).get().toString();
                }
            }
        }
        return this.getResult(CraftPresence.CLIENT.imageOf(true, currentServerIcon, CraftPresence.CONFIG.serverSettings.fallbackServerIcon), resultData);
    }

    private static /* synthetic */ String lambda$initPresence$19(boolean isValidUuid) {
        return isValidUuid ? StringUtils.getFromUuid((String)"", (boolean)true) : "";
    }

    private static /* synthetic */ String lambda$initPresence$18(boolean isValidUuid) {
        return isValidUuid ? StringUtils.getFromUuid((String)"", (boolean)false) : "";
    }

    private static /* synthetic */ String lambda$initPresence$17() {
        return "";
    }

    private /* synthetic */ Object lambda$initPresence$16() {
        boolean inServer;
        boolean bl = inServer = !this.isOnRealm && !this.isOnSinglePlayer && (this.isOnLAN || this.currentServerData != null);
        if (inServer) {
            if (this.isOnLAN) {
                ModuleData primaryData = CraftPresence.CONFIG.statusMessages.lanData;
                return this.getResult(Config.isValidProperty(primaryData, "textOverride") ? primaryData.getTextOverride() : "", primaryData);
            }
            ModuleData defaultData = this.getDefaultData();
            ModuleData alternateData = this.getData(this.currentServer_Name);
            ModuleData primaryData = this.getData(this.formattedServer_IP);
            String defaultMessage = Config.isValidProperty(defaultData, "textOverride") ? defaultData.getTextOverride() : "";
            String alternateMessage = Config.isValidProperty(alternateData, "textOverride") ? alternateData.getTextOverride() : defaultMessage;
            return this.getResult(Config.isValidProperty(primaryData, "textOverride") ? primaryData.getTextOverride() : alternateMessage, new String[]{this.formattedServer_IP, this.currentServer_Name});
        }
        if (this.isOnSinglePlayer) {
            ModuleData primaryData = CraftPresence.CONFIG.statusMessages.singleplayerData;
            return this.getResult(Config.isValidProperty(primaryData, "textOverride") ? primaryData.getTextOverride() : "", primaryData);
        }
        if (this.isOnRealm) {
            ModuleData primaryData = CraftPresence.CONFIG.statusMessages.realmData;
            return this.getResult(Config.isValidProperty(primaryData, "textOverride") ? primaryData.getTextOverride() : "", primaryData);
        }
        return null;
    }

    private static /* synthetic */ Object lambda$initPresence$15() {
        return CraftPresence.CONFIG.serverSettings.fallbackServerIcon;
    }

    private static /* synthetic */ Object lambda$initPresence$14() {
        return TimeUtils.fromWorldTime((long)CraftPresence.world.method_256());
    }

    private static /* synthetic */ Object lambda$initPresence$13() {
        return TimeUtils.toString((TemporalAccessor)((TemporalAccessor)TimeUtils.fromWorldTime((long)CraftPresence.world.method_256()).getSecond()), (String)"HH:mm a");
    }

    private static /* synthetic */ Object lambda$initPresence$12() {
        return TimeUtils.toString((TemporalAccessor)((TemporalAccessor)TimeUtils.fromWorldTime((long)CraftPresence.world.method_256()).getSecond()), (String)"HH:mm");
    }

    private static /* synthetic */ Object lambda$initPresence$11() {
        return TimeUtils.fromWorldTime((long)CraftPresence.world.method_256()).getFirst();
    }

    private static /* synthetic */ Object lambda$initPresence$10() {
        return "Default";
    }

    private static /* synthetic */ Object lambda$initPresence$9() {
        String primaryWorldName = CraftPresence.world.method_262().method_32();
        String secondaryWorldName = Constants.TRANSLATOR.translate("craftpresence.defaults.world_name", new Object[0]);
        String newWorldName = StringUtils.getOrDefault((String)primaryWorldName, (String)secondaryWorldName);
        return StringUtils.getOrDefault((String)newWorldName);
    }

    private static /* synthetic */ Object lambda$initPresence$8() {
        String newWeatherData = WorldUtils.getWeather((class_57)CraftPresence.player);
        String newWeatherName = Constants.TRANSLATOR.translate(ServerUtils.jvmdowngrader$concat$lambda$initPresence$8$1(newWeatherData), new Object[0]);
        return StringUtils.getOrDefault((String)newWeatherName);
    }

    private static /* synthetic */ Object lambda$initPresence$7() {
        if (ModUtils.RAW_TRANSLATOR != null) {
            String[] DIFFICULTIES = (String[])StringUtils.getField(class_322.class, null, (String[])new String[]{"DIFFICULTIES", "field_1452", "K"});
            int difficulty = CraftPresence.world.field_213;
            if (difficulty < 0 || difficulty >= DIFFICULTIES.length) {
                difficulty = 0;
            }
            return ModUtils.RAW_TRANSLATOR.translate(DIFFICULTIES[difficulty], new Object[0]);
        }
        return Integer.toString(CraftPresence.world.field_213);
    }

    private static /* synthetic */ Object lambda$initPresence$6() {
        return "Survival";
    }

    private static /* synthetic */ Object lambda$initPresence$5() {
        return 20.0;
    }

    private static /* synthetic */ Object lambda$initPresence$4() {
        return MathUtils.roundDouble((double)CraftPresence.player.field_1036, (int)0);
    }

    private static /* synthetic */ Object lambda$initPresence$3() {
        return MathUtils.roundDouble((double)CraftPresence.player.field_1602, (int)3);
    }

    private static /* synthetic */ Object lambda$initPresence$2() {
        return MathUtils.roundDouble((double)CraftPresence.player.field_1601, (int)3);
    }

    private static /* synthetic */ Object lambda$initPresence$1() {
        return MathUtils.roundDouble((double)CraftPresence.player.field_1600, (int)3);
    }

    private /* synthetic */ void lambda$verifyAndJoin$0(String serverName, String serverIP) {
        this.joinServer(new ServerNBTStorage(serverName, serverIP));
    }

    private static String jvmdowngrader$concat$makeSecret$1(String string, String string2) {
        return string + "-" + string2;
    }

    private static String jvmdowngrader$concat$makeSecret$1(String string, boolean bl, boolean bl2) {
        return string + ";" + bl + ";" + bl2;
    }

    private static String jvmdowngrader$concat$initServerArgs$1(int n) {
        return "data.server.motd.line_" + n;
    }

    private static String jvmdowngrader$concat$updatePresence$1(String string) {
        return "Join Server: " + string;
    }

    private static String jvmdowngrader$concat$lambda$initPresence$8$1(String string) {
        return "craftpresence.defaults.weather." + string;
    }

    @Override
    public void setScannedInternals(boolean bl) {
        Module$jvmdg$StaticDefaults.setScannedInternals(this, bl);
    }

    @Override
    public boolean canBeLoaded() {
        return Module$jvmdg$StaticDefaults.canBeLoaded(this);
    }

    @Override
    public ModuleData getOrDefault(ModuleData[] moduleDataArray) {
        return ExtendedModule$jvmdg$StaticDefaults.getOrDefault((ExtendedModule)this, moduleDataArray);
    }

    @Override
    public void clearClientData() {
        Module$jvmdg$StaticDefaults.clearClientData(this);
    }

    @Override
    public void postTick() {
        Module$jvmdg$StaticDefaults.postTick(this);
    }

    @Override
    public void markInternalsScanned() {
        Module$jvmdg$StaticDefaults.markInternalsScanned(this);
    }

    public void syncArgument(String string, Supplier supplier, Supplier supplier2) {
        Module$jvmdg$StaticDefaults.syncArgument((Module)this, string, supplier, supplier2);
    }

    @Override
    public String getResult(String string, ModuleData moduleData) {
        return ExtendedModule$jvmdg$StaticDefaults.getResult((ExtendedModule)this, string, moduleData);
    }

    @Override
    public void markConfigScanned() {
        Module$jvmdg$StaticDefaults.markConfigScanned(this);
    }

    @Override
    public String getDefaultId() {
        return ExtendedModule$jvmdg$StaticDefaults.getDefaultId(this);
    }

    @Override
    public void clearActiveData() {
        Module$jvmdg$StaticDefaults.clearActiveData(this);
    }

    @Override
    public ModuleData getOrDefault(String[] stringArray) {
        return ExtendedModule$jvmdg$StaticDefaults.getOrDefault((ExtendedModule)this, stringArray);
    }

    @Override
    public void emptyData() {
        Module$jvmdg$StaticDefaults.emptyData(this);
    }

    public void syncArgument(String string, Supplier supplier, boolean bl) {
        Module$jvmdg$StaticDefaults.syncArgument((Module)this, string, supplier, bl);
    }

    @Override
    public void queueConfigScan() {
        Module$jvmdg$StaticDefaults.queueConfigScan(this);
    }

    @Override
    public String getResult(String string, String[] stringArray) {
        return ExtendedModule$jvmdg$StaticDefaults.getResult((ExtendedModule)this, string, stringArray);
    }

    @Override
    public PresenceData getPresenceData(ModuleData moduleData) {
        return ExtendedModule$jvmdg$StaticDefaults.getPresenceData((ExtendedModule)this, moduleData);
    }

    public void syncArgument(String string, Supplier supplier) {
        Module$jvmdg$StaticDefaults.syncArgument(this, string, supplier);
    }

    @Override
    public void printException(Throwable throwable) {
        Module$jvmdg$StaticDefaults.printException(this, throwable);
    }

    @Override
    public ModuleData getDefaultData() {
        return ExtendedModule$jvmdg$StaticDefaults.getDefaultData(this);
    }

    @Override
    public PresenceData getPresenceData(String[] stringArray) {
        return ExtendedModule$jvmdg$StaticDefaults.getPresenceData((ExtendedModule)this, stringArray);
    }

    @Override
    public String getOverrideText(String[] stringArray) {
        return ExtendedModule$jvmdg$StaticDefaults.getOverrideText(this, stringArray);
    }

    public Supplier getModuleFunction(Supplier supplier) {
        return Module$jvmdg$StaticDefaults.getModuleFunction(this, supplier);
    }

    @Override
    public void scanConfigData() {
        Module$jvmdg$StaticDefaults.scanConfigData(this);
    }

    @Override
    public void scanInternalData() {
        Module$jvmdg$StaticDefaults.scanInternalData(this);
    }

    @Override
    public void queueInternalScan() {
        Module$jvmdg$StaticDefaults.queueInternalScan(this);
    }

    public Supplier getModuleFunction(Supplier supplier, Supplier supplier2) {
        return Module$jvmdg$StaticDefaults.getModuleFunction(this, supplier, supplier2);
    }

    @Override
    public void onTick() {
        Module$jvmdg$StaticDefaults.onTick(this);
    }

    @Override
    public boolean canFetchInternals() {
        return Module$jvmdg$StaticDefaults.canFetchInternals(this);
    }
}

