/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.world;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.core.config.Config;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.config.element.PresenceData;
import com.gitlab.cdagaming.craftpresence.core.impl.ExtendedModule;
import com.gitlab.cdagaming.craftpresence.core.impl.ExtendedModule$jvmdg$StaticDefaults;
import com.gitlab.cdagaming.craftpresence.core.impl.Module;
import com.gitlab.cdagaming.craftpresence.core.impl.Module$jvmdg$StaticDefaults;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.function.Supplier;

public class BiomeUtils
implements ExtendedModule {
    public List<String> BIOME_NAMES = StringUtils.newArrayList();
    public List<String> DEFAULT_NAMES = StringUtils.newArrayList();
    private boolean enabled = false;
    private boolean isInUse = false;
    private boolean hasScannedConfig = false;
    private boolean hasScannedInternals = true;
    private boolean hasInitialized = false;
    private String RAW_BIOME_NAME;
    private String CURRENT_BIOME_NAME;
    private String RAW_BIOME_IDENTIFIER;
    private String CURRENT_BIOME_IDENTIFIER;

    @Override
    public void clearFieldData() {
        this.DEFAULT_NAMES.clear();
        this.BIOME_NAMES.clear();
    }

    @Override
    public void clearAttributes() {
        this.RAW_BIOME_NAME = null;
        this.RAW_BIOME_IDENTIFIER = null;
        this.CURRENT_BIOME_NAME = null;
        this.CURRENT_BIOME_IDENTIFIER = null;
        CraftPresence.CLIENT.removeArguments("biome", "data.biome");
        CraftPresence.CLIENT.clearForcedData("biome");
        this.hasInitialized = false;
    }

    @Override
    public void updateData() {
        String newBiomeName = "Plains";
        if (!"Plains".equals(this.RAW_BIOME_NAME) || !"Plains".equals(this.RAW_BIOME_IDENTIFIER)) {
            this.RAW_BIOME_NAME = "Plains";
            this.RAW_BIOME_IDENTIFIER = "Plains";
            this.CURRENT_BIOME_NAME = StringUtils.formatIdentifier((String)this.RAW_BIOME_NAME, (boolean)false, (!CraftPresence.CONFIG.advancedSettings.formatWords ? 1 : 0) != 0);
            this.CURRENT_BIOME_IDENTIFIER = StringUtils.formatIdentifier((String)this.RAW_BIOME_IDENTIFIER, (boolean)true, (!CraftPresence.CONFIG.advancedSettings.formatWords ? 1 : 0) != 0);
            if (!this.DEFAULT_NAMES.contains(this.CURRENT_BIOME_IDENTIFIER)) {
                this.DEFAULT_NAMES.add(this.CURRENT_BIOME_IDENTIFIER);
            }
            if (!this.BIOME_NAMES.contains(this.CURRENT_BIOME_IDENTIFIER)) {
                this.BIOME_NAMES.add(this.CURRENT_BIOME_IDENTIFIER);
            }
            if (!this.hasInitialized) {
                this.initPresence();
                this.hasInitialized = true;
            }
            this.updatePresence();
        }
    }

    @Override
    public void initPresence() {
        this.syncArgument("biome.default.icon", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$0(), ()Ljava/lang/Object;)());
        this.syncArgument("data.biome.name", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$1(), ()Ljava/lang/Object;)((BiomeUtils)this), true);
        this.syncArgument("data.biome.identifier", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$2(), ()Ljava/lang/Object;)((BiomeUtils)this), true);
        this.syncArgument("biome.identifier", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$3(), ()Ljava/lang/Object;)((BiomeUtils)this), true);
        this.syncArgument("biome.name", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$4(), ()Ljava/lang/Object;)((BiomeUtils)this), true);
        this.syncArgument("biome.message", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$5(), ()Ljava/lang/Object;)((BiomeUtils)this));
        this.syncArgument("biome.icon", (Supplier)(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$6(), ()Ljava/lang/Object;)((BiomeUtils)this));
        CraftPresence.CLIENT.addForcedData("biome", (Supplier<PresenceData>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$initPresence$7(), ()Lcom/gitlab/cdagaming/craftpresence/core/config/element/PresenceData;)((BiomeUtils)this));
        CraftPresence.CLIENT.syncTimestamp("data.biome.time");
    }

    @Override
    public void updatePresence() {
    }

    @Override
    public void getInternalData() {
    }

    @Override
    public void getConfigData() {
        for (String biomeEntry : CraftPresence.CONFIG.biomeSettings.biomeData.keySet()) {
            String name;
            if (StringUtils.isNullOrEmpty((String)biomeEntry) || this.BIOME_NAMES.contains(name = StringUtils.formatIdentifier((String)biomeEntry, (boolean)true, (!CraftPresence.CONFIG.advancedSettings.formatWords ? 1 : 0) != 0))) continue;
            this.BIOME_NAMES.add(name);
        }
    }

    @Override
    public void syncArgument(String argumentName, Supplier<Boolean> condition, Supplier<Object> event, boolean plain) {
        CraftPresence.CLIENT.syncArgument(argumentName, this.getModuleFunction((Supplier)condition, (Supplier)event), plain);
    }

    @Override
    public ModuleData getData(String key) {
        return CraftPresence.CONFIG.biomeSettings.biomeData.get(key);
    }

    @Override
    public String getOverrideText(ModuleData data) {
        return CraftPresence.CLIENT.getOverrideText(this.getPresenceData(data));
    }

    @Override
    public boolean hasScannedInternals() {
        return this.hasScannedInternals;
    }

    @Override
    public boolean canFetchConfig() {
        return CraftPresence.CONFIG != null;
    }

    @Override
    public boolean hasScannedConfig() {
        return this.hasScannedConfig;
    }

    @Override
    public void setScannedConfig(boolean state) {
        this.hasScannedConfig = state;
    }

    @Override
    public boolean canBeEnabled() {
        return !CraftPresence.CONFIG.hasChanged() ? CraftPresence.CONFIG.generalSettings.detectBiomeData : this.isEnabled();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean canBeUsed() {
        return CraftPresence.player != null;
    }

    @Override
    public boolean isInUse() {
        return this.isInUse;
    }

    @Override
    public void setInUse(boolean state) {
        this.isInUse = state;
    }

    private /* synthetic */ PresenceData lambda$initPresence$7() {
        return this.isInUse() ? this.getPresenceData(new String[]{this.CURRENT_BIOME_IDENTIFIER}) : null;
    }

    private /* synthetic */ Object lambda$initPresence$6() {
        ModuleData defaultData = this.getDefaultData();
        ModuleData currentData = this.getData(this.CURRENT_BIOME_IDENTIFIER);
        String defaultIcon = Config.isValidProperty(defaultData, "iconOverride") ? defaultData.getIconOverride() : this.CURRENT_BIOME_IDENTIFIER;
        String currentIcon = Config.isValidProperty(currentData, "iconOverride") ? currentData.getIconOverride() : defaultIcon;
        return this.getResult(CraftPresence.CLIENT.imageOf(true, currentIcon, CraftPresence.CONFIG.biomeSettings.fallbackBiomeIcon, this.CURRENT_BIOME_IDENTIFIER), new String[0]);
    }

    private /* synthetic */ Object lambda$initPresence$5() {
        ModuleData defaultData = this.getDefaultData();
        ModuleData currentData = this.getData(this.CURRENT_BIOME_IDENTIFIER);
        String defaultMessage = Config.isValidProperty(defaultData, "textOverride") ? defaultData.getTextOverride() : "";
        return this.getResult(Config.isValidProperty(currentData, "textOverride") ? currentData.getTextOverride() : defaultMessage, new String[]{this.CURRENT_BIOME_IDENTIFIER});
    }

    private /* synthetic */ Object lambda$initPresence$4() {
        return this.CURRENT_BIOME_NAME;
    }

    private /* synthetic */ Object lambda$initPresence$3() {
        return this.CURRENT_BIOME_IDENTIFIER;
    }

    private /* synthetic */ Object lambda$initPresence$2() {
        return this.RAW_BIOME_IDENTIFIER;
    }

    private /* synthetic */ Object lambda$initPresence$1() {
        return this.RAW_BIOME_NAME;
    }

    private static /* synthetic */ Object lambda$initPresence$0() {
        return CraftPresence.CONFIG.biomeSettings.fallbackBiomeIcon;
    }

    @Override
    public void setScannedInternals(boolean bl) {
        Module$jvmdg$StaticDefaults.setScannedInternals(this, bl);
    }

    @Override
    public boolean canBeLoaded() {
        return Module$jvmdg$StaticDefaults.canBeLoaded(this);
    }

    @Override
    public ModuleData getOrDefault(ModuleData[] moduleDataArray) {
        return ExtendedModule$jvmdg$StaticDefaults.getOrDefault((ExtendedModule)this, moduleDataArray);
    }

    @Override
    public void clearClientData() {
        Module$jvmdg$StaticDefaults.clearClientData(this);
    }

    @Override
    public void postTick() {
        Module$jvmdg$StaticDefaults.postTick(this);
    }

    @Override
    public void markInternalsScanned() {
        Module$jvmdg$StaticDefaults.markInternalsScanned(this);
    }

    public void syncArgument(String string, Supplier supplier, Supplier supplier2) {
        Module$jvmdg$StaticDefaults.syncArgument((Module)this, string, supplier, supplier2);
    }

    @Override
    public String getResult(String string, ModuleData moduleData) {
        return ExtendedModule$jvmdg$StaticDefaults.getResult((ExtendedModule)this, string, moduleData);
    }

    @Override
    public void markConfigScanned() {
        Module$jvmdg$StaticDefaults.markConfigScanned(this);
    }

    @Override
    public String getDefaultId() {
        return ExtendedModule$jvmdg$StaticDefaults.getDefaultId(this);
    }

    @Override
    public void clearActiveData() {
        Module$jvmdg$StaticDefaults.clearActiveData(this);
    }

    @Override
    public ModuleData getOrDefault(String[] stringArray) {
        return ExtendedModule$jvmdg$StaticDefaults.getOrDefault((ExtendedModule)this, stringArray);
    }

    @Override
    public void emptyData() {
        Module$jvmdg$StaticDefaults.emptyData(this);
    }

    public void syncArgument(String string, Supplier supplier, boolean bl) {
        Module$jvmdg$StaticDefaults.syncArgument((Module)this, string, supplier, bl);
    }

    @Override
    public void queueConfigScan() {
        Module$jvmdg$StaticDefaults.queueConfigScan(this);
    }

    @Override
    public void preTick() {
        Module$jvmdg$StaticDefaults.preTick(this);
    }

    @Override
    public String getResult(String string, String[] stringArray) {
        return ExtendedModule$jvmdg$StaticDefaults.getResult((ExtendedModule)this, string, stringArray);
    }

    @Override
    public PresenceData getPresenceData(ModuleData moduleData) {
        return ExtendedModule$jvmdg$StaticDefaults.getPresenceData((ExtendedModule)this, moduleData);
    }

    public void syncArgument(String string, Supplier supplier) {
        Module$jvmdg$StaticDefaults.syncArgument(this, string, supplier);
    }

    @Override
    public void printException(Throwable throwable) {
        Module$jvmdg$StaticDefaults.printException(this, throwable);
    }

    @Override
    public ModuleData getDefaultData() {
        return ExtendedModule$jvmdg$StaticDefaults.getDefaultData(this);
    }

    @Override
    public PresenceData getPresenceData(String[] stringArray) {
        return ExtendedModule$jvmdg$StaticDefaults.getPresenceData((ExtendedModule)this, stringArray);
    }

    @Override
    public String getOverrideText(String[] stringArray) {
        return ExtendedModule$jvmdg$StaticDefaults.getOverrideText(this, stringArray);
    }

    public Supplier getModuleFunction(Supplier supplier) {
        return Module$jvmdg$StaticDefaults.getModuleFunction(this, supplier);
    }

    @Override
    public void scanConfigData() {
        Module$jvmdg$StaticDefaults.scanConfigData(this);
    }

    @Override
    public void scanInternalData() {
        Module$jvmdg$StaticDefaults.scanInternalData(this);
    }

    @Override
    public void queueInternalScan() {
        Module$jvmdg$StaticDefaults.queueInternalScan(this);
    }

    public Supplier getModuleFunction(Supplier supplier, Supplier supplier2) {
        return Module$jvmdg$StaticDefaults.getModuleFunction(this, supplier, supplier2);
    }

    @Override
    public void onTick() {
        Module$jvmdg$StaticDefaults.onTick(this);
    }

    @Override
    public boolean canFetchInternals() {
        return Module$jvmdg$StaticDefaults.canFetchInternals(this);
    }
}

