/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.config.gui;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.config.gui.PresenceEditorGui;
import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.Config;
import com.gitlab.cdagaming.craftpresence.core.config.category.Dimension;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.config.element.PresenceData;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.DynamicScrollableList;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.ConfigurationGui;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicSelectorGui;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.TextWidget;
import io.github.cdagaming.unicore.utils.StringUtils;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;

public class DimensionSettingsGui
extends ConfigurationGui<Dimension> {
    private final Dimension INSTANCE;
    private final Dimension DEFAULTS = this.getCurrentData().getDefaults();
    private ExtendedButtonControl dimensionMessagesButton;
    private TextWidget defaultMessage;
    private TextWidget defaultIcon;

    DimensionSettingsGui() {
        super(Constants.TRANSLATOR.translate("gui.config.title", new Object[0]), Constants.TRANSLATOR.translate("gui.config.title.dimension_messages", new Object[0]));
        this.INSTANCE = this.getCurrentData().copy();
    }

    @Override
    protected void appendControls() {
        super.appendControls();
        ModuleData defaultData = this.getInstanceData().dimensionData.get("default");
        String defaultDimensionMessage = Config.getProperty(defaultData, "textOverride") != null ? defaultData.getTextOverride() : "";
        this.defaultMessage = (TextWidget)this.childFrame.addControl((IGuiEventListener)new TextWidget(this.getFontRenderer(), this.getButtonY(0), 180, 20, () -> {
            ModuleData defaultDimensionData = this.getInstanceData().dimensionData.getOrDefault("default", new ModuleData());
            defaultDimensionData.setTextOverride(this.defaultMessage.getControlMessage());
            this.getInstanceData().dimensionData.put("default", defaultDimensionData);
        }, Constants.TRANSLATOR.translate("gui.config.message.default.dimension", new Object[0]), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.dimension_messages.dimension_messages", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("dimension.")})))));
        this.defaultMessage.setControlMessage(defaultDimensionMessage);
        this.defaultIcon = (TextWidget)this.childFrame.addControl((IGuiEventListener)new TextWidget(this.getFontRenderer(), this.getButtonY(1), 147, 20, () -> {
            this.getInstanceData().fallbackDimensionIcon = this.defaultIcon.getControlMessage();
        }, Constants.TRANSLATOR.translate("gui.config.name.dimension_messages.dimension_icon", new Object[0]), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.dimension_messages.dimension_icon", new Object[0])))));
        this.addIconSelector((ExtendedScreen)this.childFrame, () -> this.defaultIcon, (attributeName, currentValue) -> {
            this.getInstanceData().fallbackDimensionIcon = currentValue;
        });
        this.defaultIcon.setControlMessage(this.getInstanceData().fallbackDimensionIcon);
        this.dimensionMessagesButton = (ExtendedButtonControl)this.childFrame.addControl((IGuiEventListener)new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getButtonY(2), 180, 20, Constants.TRANSLATOR.translate("gui.config.name.dimension_messages.dimension_messages", new Object[0]), () -> this.openScreen((ExtendedScreen)new DynamicSelectorGui(Constants.TRANSLATOR.translate("gui.config.title.selector.dimension", new Object[0]), CraftPresence.DIMENSIONS.DIMENSION_NAMES, null, null, true, true, DynamicScrollableList.RenderType.None, (attributeName, currentValue) -> {
            ModuleData defaultDimensionData = this.getInstanceData().dimensionData.get("default");
            ModuleData currentDimensionData = this.getInstanceData().dimensionData.get(attributeName);
            String defaultMessage = Config.getProperty(defaultDimensionData, "textOverride") != null ? defaultDimensionData.getTextOverride() : "";
            String currentMessage = Config.getProperty(currentDimensionData, "textOverride") != null ? currentDimensionData.getTextOverride() : "";
            ModuleData newData = new ModuleData();
            if (StringUtils.isNullOrEmpty((String)currentMessage) || currentMessage.equals(defaultMessage)) {
                newData.setTextOverride(defaultMessage);
            }
            newData.setIconOverride((String)currentValue);
            this.getInstanceData().dimensionData.put((String)attributeName, newData);
        }, (currentValue, parentScreen) -> this.openScreen(new DynamicEditorGui((String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.defaultData = this.getInstanceData().dimensionData.get("default");
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = screenInstance.originalPrimaryMessage;
        }, (attributeName, screenInstance) -> {
            screenInstance.isDefaultValue = "default".equals(attributeName);
            screenInstance.defaultData = this.getInstanceData().dimensionData.get("default");
            screenInstance.currentData = this.getInstanceData().dimensionData.get(attributeName);
            screenInstance.isPreliminaryData = screenInstance.currentData == null;
            screenInstance.setScreenTitle(Constants.TRANSLATOR.translate("gui.config.title.dimension.edit_specific_dimension", new Object[]{attributeName}));
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = Config.getProperty(screenInstance.currentData, "textOverride") != null ? screenInstance.currentData.getTextOverride() : screenInstance.originalPrimaryMessage;
        }, screenInstance -> {
            String attributeName = screenInstance.getSecondaryEntry();
            String inputText = screenInstance.getPrimaryEntry();
            screenInstance.currentData.setTextOverride(inputText);
            this.getInstanceData().dimensionData.put(attributeName, screenInstance.currentData);
            if (!CraftPresence.DIMENSIONS.DIMENSION_NAMES.contains(attributeName)) {
                CraftPresence.DIMENSIONS.DIMENSION_NAMES.add(attributeName);
            }
        }, screenInstance -> {
            String attributeName = screenInstance.getSecondaryEntry();
            this.getInstanceData().dimensionData.remove(attributeName);
            if (!CraftPresence.DIMENSIONS.DEFAULT_NAMES.contains(attributeName)) {
                CraftPresence.DIMENSIONS.DIMENSION_NAMES.remove(attributeName);
            }
        }, (attributeName, screenInstance) -> {
            if (screenInstance.isPresenceButton) {
                PresenceData defaultPresenceData = Config.getProperty(screenInstance.defaultData, "data") != null ? screenInstance.defaultData.getData() : new PresenceData();
                PresenceData currentPresenceData = Config.getProperty(screenInstance.currentData, "data") != null ? screenInstance.currentData.getData() : defaultPresenceData;
                screenInstance.openScreen(new PresenceEditorGui(currentPresenceData, defaultPresenceData, output -> screenInstance.currentData.setData((PresenceData)output)));
            } else {
                screenInstance.currentData.setIconOverride((String)attributeName);
            }
        }, (attributeName, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.dimension_messages.dimension_messages", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("dimension.")})))), (Screen)parentScreen))), () -> {
            if (!this.dimensionMessagesButton.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.hover.access", new Object[]{Constants.TRANSLATOR.translate("gui.config.name.general.detect_dimension_data", new Object[0])})));
            } else {
                this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.dimension_messages.dimension_messages", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("dimension.")})));
            }
        }, new String[0]));
        this.proceedButton.setOnHover(() -> {
            if (!this.proceedButton.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.hover.empty.default", new Object[0])));
            }
        });
    }

    @Override
    protected boolean allowedToReset() {
        return true;
    }

    @Override
    protected void syncRenderStates() {
        super.syncRenderStates();
        this.proceedButton.setControlEnabled(!StringUtils.isNullOrEmpty((String)this.defaultMessage.getControlMessage()));
        this.dimensionMessagesButton.setControlEnabled(CraftPresence.DIMENSIONS.isEnabled());
    }

    @Override
    protected Dimension getInstanceData() {
        return this.INSTANCE;
    }

    @Override
    protected Dimension getCurrentData() {
        return CraftPresence.CONFIG.dimensionSettings;
    }

    @Override
    protected Dimension getDefaultData() {
        return this.DEFAULTS;
    }
}

