/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.core.integrations.pack;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.io.FileNotFoundException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.NoSuchFileException;
import java.util.function.Supplier;

public abstract class Pack {
    private String packName;
    private String packIcon;
    private String packType;
    private Supplier<Boolean> enabled;

    public Pack(Supplier<Boolean> isEnabled) {
        this.setEnabled(isEnabled);
    }

    public Pack(boolean isEnabled) {
        this.setEnabled(isEnabled);
    }

    public Pack() {
        this(true);
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    public void setEnabled(Supplier<Boolean> enabled) {
        this.enabled = enabled;
    }

    public void setEnabled(boolean enabled) {
        this.setEnabled((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$setEnabled$0(boolean ), ()Ljava/lang/Boolean;)((boolean)enabled));
    }

    public abstract boolean load();

    public String getPackName() {
        return this.packName;
    }

    public void setPackName(String packName) {
        this.packName = packName;
    }

    public boolean hasPackName() {
        return !StringUtils.isNullOrEmpty((String)this.packName);
    }

    public String getPackIcon() {
        return this.hasPackIcon() ? StringUtils.formatAsIcon((String)this.packIcon) : "";
    }

    public void setPackIcon(String packIcon) {
        this.packIcon = packIcon;
    }

    public boolean hasPackIcon() {
        return !StringUtils.isNullOrEmpty((String)this.packIcon);
    }

    public void setPackData(String packName, String packIcon) {
        this.setPackName(packName);
        this.setPackIcon(packIcon);
    }

    public void setPackData(String packName) {
        this.setPackData(packName, packName);
    }

    public String getPackType() {
        return this.packType;
    }

    public void setPackType(String packType) {
        this.packType = packType;
    }

    public boolean hasPackType() {
        return !StringUtils.isNullOrEmpty((String)this.packType);
    }

    protected boolean showException(Throwable ex) {
        return Constants.LOG.isDebugMode() || ex.getClass() != FileNotFoundException.class && ex.getClass() != NoSuchFileException.class;
    }

    protected void printException(Throwable ex) {
        if (this.showException(ex)) {
            Constants.LOG.error(ex);
        }
    }

    private static /* synthetic */ Boolean lambda$setEnabled$0(boolean enabled) {
        return enabled;
    }
}

