/*
 * Decompiled with CFR 0.152.
 */
package craftpresence.external.net.lenni0451.reflect.stream.method;

import craftpresence.external.net.lenni0451.reflect.Methods;
import craftpresence.external.net.lenni0451.reflect.exceptions.MethodNotFoundException;
import craftpresence.external.net.lenni0451.reflect.stream.RStream;
import craftpresence.external.net.lenni0451.reflect.stream.method.MethodWrapper;
import java.lang.annotation.Annotation;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class MethodStream {
    private final RStream parent;
    private final List<MethodWrapper> methods;

    public MethodStream(RStream parent, boolean withSuper) {
        this.parent = parent;
        this.methods = new ArrayList<MethodWrapper>();
        Class<?> clazz = parent.clazz();
        do {
            for (Method method : Methods.getDeclaredMethods(clazz)) {
                this.methods.add(new MethodWrapper(this, method));
            }
        } while (withSuper && (clazz = clazz.getSuperclass()) != null);
    }

    private MethodStream(RStream parent, List<MethodWrapper> methods) {
        this.parent = parent;
        this.methods = methods;
    }

    public RStream parent() {
        return this.parent;
    }

    public int size() {
        return this.methods.size();
    }

    public Optional<MethodWrapper> opt(String name) {
        for (MethodWrapper method : this.methods) {
            if (!method.name().equals(name)) continue;
            return Optional.of(method);
        }
        return Optional.empty();
    }

    public Optional<MethodWrapper> opt(Class<?> ... parameterTypes) {
        if (parameterTypes == null || parameterTypes.length == 0) {
            for (MethodWrapper method : this.methods) {
                if (method.parameterCount() != 0) continue;
                return Optional.of(method);
            }
        } else {
            for (MethodWrapper method : this.methods) {
                if (!Arrays.equals(method.parameterTypes(), parameterTypes)) continue;
                return Optional.of(method);
            }
        }
        return Optional.empty();
    }

    public Optional<MethodWrapper> opt(String name, Class<?> ... parameterTypes) {
        if (parameterTypes == null || parameterTypes.length == 0) {
            for (MethodWrapper method : this.methods) {
                if (!method.name().equals(name) || method.parameterCount() != 0) continue;
                return Optional.of(method);
            }
        } else {
            for (MethodWrapper method : this.methods) {
                if (!method.name().equals(name) || !Arrays.equals(method.parameterTypes(), parameterTypes)) continue;
                return Optional.of(method);
            }
        }
        return Optional.empty();
    }

    public Optional<MethodWrapper> opt(int index) {
        if (index < 0 || index >= this.methods.size()) {
            return Optional.empty();
        }
        return Optional.of(this.methods.get(index));
    }

    public MethodWrapper by(String name) {
        return this.opt(name).orElseThrow((Supplier<MethodNotFoundException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$by$0(java.lang.String ), ()Lcraftpresence/external/net/lenni0451/reflect/exceptions/MethodNotFoundException;)((MethodStream)this, (String)name));
    }

    public MethodWrapper by(Class<?> ... parameterTypes) {
        return this.opt(parameterTypes).orElseThrow((Supplier<MethodNotFoundException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$by$1(java.lang.Class[] ), ()Lcraftpresence/external/net/lenni0451/reflect/exceptions/MethodNotFoundException;)((MethodStream)this, (Class[])parameterTypes));
    }

    public MethodWrapper by(String name, Class<?> ... parameterTypes) {
        return this.opt(name, parameterTypes).orElseThrow((Supplier<MethodNotFoundException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$by$2(java.lang.String java.lang.Class[] ), ()Lcraftpresence/external/net/lenni0451/reflect/exceptions/MethodNotFoundException;)((MethodStream)this, (String)name, (Class[])parameterTypes));
    }

    public MethodWrapper by(int index) {
        try {
            return this.methods.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MethodNotFoundException(this.parent.clazz().getName(), String.valueOf(index));
        }
    }

    public MethodStream filter(Predicate<MethodWrapper> filter) {
        this.methods.removeIf(filter.negate());
        return this;
    }

    public MethodStream filter(String name) {
        return this.filter((Predicate<MethodWrapper>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$filter$3(java.lang.String craftpresence.external.net.lenni0451.reflect.stream.method.MethodWrapper ), (Lcraftpresence/external/net/lenni0451/reflect/stream/method/MethodWrapper;)Z)((String)name));
    }

    public MethodStream filter(Collection<String> names) {
        return this.filter((Predicate<MethodWrapper>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$filter$4(java.util.Collection craftpresence.external.net.lenni0451.reflect.stream.method.MethodWrapper ), (Lcraftpresence/external/net/lenni0451/reflect/stream/method/MethodWrapper;)Z)(names));
    }

    public MethodStream filter(String ... names) {
        return this.filter(Arrays.asList(names));
    }

    public MethodStream filter(Class<?> ... parameterTypes) {
        if (parameterTypes == null || parameterTypes.length == 0) {
            return this.filter((Predicate<MethodWrapper>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$filter$5(craftpresence.external.net.lenni0451.reflect.stream.method.MethodWrapper ), (Lcraftpresence/external/net/lenni0451/reflect/stream/method/MethodWrapper;)Z)());
        }
        return this.filter((Predicate<MethodWrapper>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$filter$6(java.lang.Class[] craftpresence.external.net.lenni0451.reflect.stream.method.MethodWrapper ), (Lcraftpresence/external/net/lenni0451/reflect/stream/method/MethodWrapper;)Z)((Class[])parameterTypes));
    }

    public MethodStream filter(boolean isStatic) {
        return this.filter((Predicate<MethodWrapper>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$filter$7(boolean craftpresence.external.net.lenni0451.reflect.stream.method.MethodWrapper ), (Lcraftpresence/external/net/lenni0451/reflect/stream/method/MethodWrapper;)Z)((boolean)isStatic));
    }

    public MethodStream filterAnnotation(Class<?> annotation) {
        return this.filter((Predicate<MethodWrapper>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$filterAnnotation$9(java.lang.Class craftpresence.external.net.lenni0451.reflect.stream.method.MethodWrapper ), (Lcraftpresence/external/net/lenni0451/reflect/stream/method/MethodWrapper;)Z)(annotation));
    }

    public Iterator<MethodWrapper> iterator() {
        return this.methods.iterator();
    }

    public <T> Stream<T> map(Function<MethodWrapper, T> mapFunction) {
        return this.jstream().map(mapFunction);
    }

    public Stream<MethodWrapper> jstream() {
        return this.methods.stream();
    }

    public MethodStream forEach(Consumer<MethodWrapper> consumer) {
        this.methods.forEach(consumer);
        return this;
    }

    public MethodStream copy() {
        return new MethodStream(this.parent, new ArrayList<MethodWrapper>(this.methods));
    }

    private static /* synthetic */ boolean lambda$filterAnnotation$9(Class annotation, MethodWrapper method) {
        return method.annotations().anyMatch((Predicate<Annotation>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$null$8(java.lang.Class java.lang.annotation.Annotation ), (Ljava/lang/annotation/Annotation;)Z)((Class)annotation));
    }

    private static /* synthetic */ boolean lambda$null$8(Class annotation, Annotation a) {
        return a.annotationType().equals(annotation);
    }

    private static /* synthetic */ boolean lambda$filter$7(boolean isStatic, MethodWrapper method) {
        return method.modifier().isStatic() == isStatic;
    }

    private static /* synthetic */ boolean lambda$filter$6(Class[] parameterTypes, MethodWrapper method) {
        return Arrays.equals(method.parameterTypes(), parameterTypes);
    }

    private static /* synthetic */ boolean lambda$filter$5(MethodWrapper method) {
        return method.parameterCount() == 0;
    }

    private static /* synthetic */ boolean lambda$filter$4(Collection names, MethodWrapper method) {
        return names.contains(method.name());
    }

    private static /* synthetic */ boolean lambda$filter$3(String name, MethodWrapper method) {
        return method.name().equals(name);
    }

    private /* synthetic */ MethodNotFoundException lambda$by$2(String name, Class[] parameterTypes) {
        return new MethodNotFoundException(this.parent.clazz().getName(), name, parameterTypes);
    }

    private /* synthetic */ MethodNotFoundException lambda$by$1(Class[] parameterTypes) {
        return new MethodNotFoundException(this.parent.clazz().getName(), null, parameterTypes);
    }

    private /* synthetic */ MethodNotFoundException lambda$by$0(String name) {
        return new MethodNotFoundException(this.parent.clazz().getName(), name);
    }
}

