/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.gui.impl;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.ConfigurationGui;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedTextControl;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ScrollPane;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.TextWidget;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_364;

public class DynamicEditorGui
extends ExtendedScreen {
    private final Consumer<DynamicEditorGui> onAdjustEntry;
    private final Consumer<DynamicEditorGui> onRemoveEntry;
    private final BiConsumer<String, DynamicEditorGui> onAdjustInit;
    private final BiConsumer<String, DynamicEditorGui> onNewInit;
    private final BiConsumer<String, DynamicEditorGui> onHoverPrimaryCallback;
    private final BiConsumer<String, DynamicEditorGui> onHoverSecondaryCallback;
    private final BiConsumer<String, DynamicEditorGui> onSpecificCallback;
    public String attributeName;
    public String primaryMessage;
    public String secondaryMessage;
    public String originalPrimaryMessage;
    public String originalSecondaryMessage;
    public String primaryText;
    public String secondaryText;
    public boolean initialized = false;
    public boolean isNewValue;
    public boolean isDefaultValue;
    public boolean willRenderSecondaryInput;
    public boolean isModuleMode = false;
    public boolean hasChanged = false;
    public boolean overrideSecondaryRender = false;
    public boolean isPreliminaryData = false;
    public boolean isPresenceButton = false;
    public int maxPrimaryLength = -1;
    public int maxSecondaryLength = -1;
    public String resetText;
    public ModuleData defaultData;
    public ModuleData originalData;
    public ModuleData currentData;
    private ExtendedButtonControl proceedButton;
    private ExtendedTextControl primaryInput;
    private ExtendedTextControl secondaryInput;
    private TextWidget defaultIcon;

    public DynamicEditorGui(String attributeName, BiConsumer<String, DynamicEditorGui> onNewInit, BiConsumer<String, DynamicEditorGui> onAdjustInit, Consumer<DynamicEditorGui> onAdjustEntry, Consumer<DynamicEditorGui> onRemoveEntry, BiConsumer<String, DynamicEditorGui> onSpecificCallback, BiConsumer<String, DynamicEditorGui> onHoverPrimaryCallback, BiConsumer<String, DynamicEditorGui> onHoverSecondaryCallback) {
        this.attributeName = attributeName;
        this.isNewValue = StringUtils.isNullOrEmpty((String)attributeName);
        this.isDefaultValue = !StringUtils.isNullOrEmpty((String)attributeName) && "default".equals(attributeName);
        this.onNewInit = onNewInit;
        this.onAdjustInit = onAdjustInit;
        this.onAdjustEntry = onAdjustEntry;
        this.onRemoveEntry = onRemoveEntry;
        this.onSpecificCallback = onSpecificCallback;
        this.onHoverPrimaryCallback = onHoverPrimaryCallback;
        this.onHoverSecondaryCallback = onHoverSecondaryCallback;
    }

    public DynamicEditorGui(String attributeName, BiConsumer<String, DynamicEditorGui> onNewInit, BiConsumer<String, DynamicEditorGui> onAdjustInit, Consumer<DynamicEditorGui> onAdjustEntry, Consumer<DynamicEditorGui> onRemoveEntry, BiConsumer<String, DynamicEditorGui> onSpecificCallback, BiConsumer<String, DynamicEditorGui> onHoverPrimaryCallback) {
        this(attributeName, onNewInit, onAdjustInit, onAdjustEntry, onRemoveEntry, onSpecificCallback, onHoverPrimaryCallback, (name, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.hover.value.name", new Object[0]))));
    }

    public DynamicEditorGui(String attributeName, BiConsumer<String, DynamicEditorGui> onNewInit, BiConsumer<String, DynamicEditorGui> onAdjustInit, Consumer<DynamicEditorGui> onAdjustEntry, Consumer<DynamicEditorGui> onRemoveEntry, BiConsumer<String, DynamicEditorGui> onSpecificCallback) {
        this(attributeName, onNewInit, onAdjustInit, onAdjustEntry, onRemoveEntry, onSpecificCallback, (name, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.hover.value.message", new Object[0]))));
    }

    public void initializeUi() {
        int controlIndex = 0;
        if (!this.isLoaded() && !this.initialized) {
            this.resetText = Constants.TRANSLATOR.translate("gui.config.message.button.remove", new Object[0]);
            if (this.isNewValue) {
                this.setScreenTitle(Constants.TRANSLATOR.translate("gui.config.title.editor.add.new", new Object[0]));
                if (this.onNewInit != null) {
                    this.onNewInit.accept(this.attributeName, this);
                }
            } else if (this.onAdjustInit != null) {
                this.onAdjustInit.accept(this.attributeName, this);
            }
            this.initialized = true;
        }
        ScrollPane childFrame = (ScrollPane)this.addControl((class_364)new ScrollPane(0, 32, this.getScreenWidth(), this.getScreenHeight() - 64));
        this.isModuleMode = this.defaultData != null || this.currentData != null;
        boolean bl = this.willRenderSecondaryInput = this.isNewValue || this.overrideSecondaryRender;
        if (StringUtils.isNullOrEmpty((String)this.primaryText)) {
            this.primaryText = Constants.TRANSLATOR.translate("gui.config.message.editor.message", new Object[0]);
        }
        if (StringUtils.isNullOrEmpty((String)this.secondaryText)) {
            this.secondaryText = Constants.TRANSLATOR.translate("gui.config.message.editor.value.name", new Object[0]);
        }
        if (this.isNewValue || this.isPreliminaryData) {
            if (this.isPreliminaryData && !StringUtils.isNullOrEmpty((String)this.attributeName)) {
                this.setScreenTitle(Constants.TRANSLATOR.translate("gui.config.title.editor.add.new.prefilled", new Object[]{this.attributeName}));
            }
            if (this.isModuleMode && this.defaultData != null && this.currentData == null) {
                this.currentData = new ModuleData(this.defaultData);
            }
        } else if (!this.isDefaultValue) {
            this.addControl((class_364)new ExtendedButtonControl(6, this.getScreenHeight() - 26, 95, 20, this.resetText, () -> {
                if (this.onRemoveEntry != null) {
                    this.onRemoveEntry.accept(this);
                }
                this.openScreen(this.getParent());
            }, new String[0]));
        }
        if (this.isModuleMode && this.originalData == null) {
            this.originalData = new ModuleData(this.currentData);
        }
        this.primaryInput = (ExtendedTextControl)childFrame.addControl((class_364)new TextWidget(this.getFontRenderer(), this.getButtonY(controlIndex++), 180, 20, this.primaryText, () -> {
            if (this.onHoverPrimaryCallback != null) {
                this.onHoverPrimaryCallback.accept(this.attributeName, this);
            }
        }));
        if (this.maxPrimaryLength > 0) {
            this.primaryInput.setControlMaxLength(this.maxPrimaryLength);
        }
        if (!StringUtils.isNullOrEmpty((String)this.primaryMessage)) {
            this.primaryInput.setControlMessage(this.primaryMessage);
        }
        if (this.willRenderSecondaryInput) {
            this.secondaryInput = (ExtendedTextControl)childFrame.addControl((class_364)new TextWidget(this.getFontRenderer(), this.getButtonY(controlIndex++), 180, 20, this.secondaryText, () -> {
                if (this.onHoverSecondaryCallback != null) {
                    this.onHoverSecondaryCallback.accept(this.attributeName, this);
                }
            }));
            if (this.maxSecondaryLength > 0) {
                this.secondaryInput.setControlMaxLength(this.maxSecondaryLength);
            }
            if (!StringUtils.isNullOrEmpty((String)this.secondaryMessage)) {
                this.secondaryInput.setControlMessage(this.secondaryMessage);
            }
        }
        if (this.onSpecificCallback != null) {
            this.defaultIcon = (TextWidget)childFrame.addControl((class_364)new TextWidget(this.getFontRenderer(), this.getButtonY(controlIndex++), 147, 20, () -> {
                this.isPresenceButton = false;
                this.onSpecificCallback.accept(this.defaultIcon.getControlMessage(), this);
            }, Constants.TRANSLATOR.translate("gui.config.message.editor.icon.change", new Object[0])));
            ConfigurationGui.addIconSelector(this, (ExtendedScreen)childFrame, () -> this.defaultIcon, (attributeName, currentValue) -> {
                this.isPresenceButton = false;
                this.onSpecificCallback.accept((String)currentValue, this);
            });
            this.defaultIcon.setControlMessage(this.currentData.getIconOverride() != null ? this.currentData.getIconOverride() : "");
            childFrame.addControl((class_364)new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getButtonY(controlIndex++), 180, 20, Constants.TRANSLATOR.translate("gui.config.title.editor.presence", new Object[0]), () -> {
                this.isPresenceButton = true;
                this.onSpecificCallback.accept(this.attributeName, this);
            }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.hover.presence_editor", new Object[0]))), new String[0]));
        }
        this.proceedButton = (ExtendedButtonControl)this.addControl((class_364)new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getScreenHeight() - 26, 180, 20, Constants.TRANSLATOR.translate("gui.config.message.button.back", new Object[0]), () -> {
            if (StringUtils.isNullOrEmpty((String)this.attributeName) && this.willRenderSecondaryInput && !StringUtils.isNullOrEmpty((String)this.secondaryInput.getControlMessage())) {
                this.attributeName = this.secondaryInput.getControlMessage();
            }
            if (this.isAdjusting() && this.onAdjustEntry != null) {
                this.onAdjustEntry.accept(this);
            }
            this.openScreen(this.getParent());
        }, () -> {
            if (!this.proceedButton.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.hover.empty.default", new Object[0])));
            }
        }, new String[0]));
        super.initializeUi();
    }

    public void preRender() {
        this.proceedButton.setControlMessage(Constants.TRANSLATOR.translate(this.isAdjusting() ? "gui.config.message.button.continue" : "gui.config.message.button.back", new Object[0]));
        this.proceedButton.setControlEnabled(this.isValidEntries());
        super.preRender();
    }

    public String getPrimaryEntry() {
        return this.primaryInput.getControlMessage();
    }

    public String getSecondaryEntry() {
        return this.willRenderSecondaryInput ? this.secondaryInput.getControlMessage() : this.attributeName;
    }

    private boolean isAdjusting() {
        String primaryText = this.primaryInput != null ? this.getPrimaryEntry() : "";
        boolean isPrimaryEmpty = StringUtils.isNullOrEmpty((String)primaryText);
        String secondaryText = this.secondaryInput != null ? this.secondaryInput.getControlMessage() : "";
        boolean isSecondaryEmpty = StringUtils.isNullOrEmpty((String)secondaryText);
        if (this.isModuleMode) {
            boolean bl = this.hasChanged = this.currentData.getData() != null && !this.currentData.getData().equals(this.originalData.getData());
            if (!this.hasChanged) {
                String originalIcon = this.originalData.getIconOverride() != null ? this.originalData.getIconOverride() : "";
                String currentIcon = this.currentData.getIconOverride() != null ? this.currentData.getIconOverride() : "";
                boolean bl2 = this.hasChanged = this.hasChanged || !currentIcon.equals(originalIcon);
            }
        }
        if (this.hasChanged) {
            return true;
        }
        if (this.willRenderSecondaryInput) {
            return !isSecondaryEmpty && (!primaryText.equals(this.primaryMessage) || !secondaryText.equals(this.secondaryMessage));
        }
        if (this.isDefaultValue) {
            return !isPrimaryEmpty && !primaryText.equals(this.primaryMessage);
        }
        return !primaryText.equals(this.primaryMessage);
    }

    private boolean isValidEntries() {
        String primaryText = this.primaryInput != null ? this.getPrimaryEntry() : "";
        boolean isPrimaryEmpty = StringUtils.isNullOrEmpty((String)primaryText);
        if (this.isDefaultValue) {
            return !isPrimaryEmpty;
        }
        return true;
    }
}

