/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.config.gui.MainGui;
import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.Config;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.config.element.PresenceData;
import com.gitlab.cdagaming.craftpresence.core.impl.Module;
import com.gitlab.cdagaming.craftpresence.core.integrations.pack.Pack;
import com.gitlab.cdagaming.craftpresence.core.integrations.pack.atlauncher.ATLauncherUtils;
import com.gitlab.cdagaming.craftpresence.core.integrations.pack.curse.CurseUtils;
import com.gitlab.cdagaming.craftpresence.core.integrations.pack.mcupdater.MCUpdaterUtils;
import com.gitlab.cdagaming.craftpresence.core.integrations.pack.modrinth.ModrinthUtils;
import com.gitlab.cdagaming.craftpresence.core.integrations.pack.multimc.MultiMCUtils;
import com.gitlab.cdagaming.craftpresence.core.integrations.pack.technic.TechnicUtils;
import com.gitlab.cdagaming.craftpresence.integrations.discord.ModFunctionsLib;
import com.gitlab.cdagaming.craftpresence.integrations.discord.ModIPCListener;
import com.gitlab.cdagaming.craftpresence.integrations.replaymod.ReplayModUtils;
import com.gitlab.cdagaming.unilib.ModUtils;
import com.gitlab.cdagaming.unilib.impl.TranslationListener;
import com.gitlab.cdagaming.unilib.impl.TranslationManager;
import com.gitlab.cdagaming.unilib.utils.GameUtils;
import com.gitlab.cdagaming.unilib.utils.KeyUtils;
import com.gitlab.cdagaming.unilib.utils.ResourceUtils;
import com.gitlab.cdagaming.unilib.utils.gui.RenderUtils;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import craftpresence.external.com.jagrosh.discordipc.entities.DiscordBuild;
import io.github.cdagaming.unicore.impl.TreeMapBuilder;
import io.github.cdagaming.unicore.utils.FileUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.Map;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class CommandUtils {
    private static final Map<String, Module> modules = new TreeMapBuilder().put((Comparable)((Object)"_biome"), (Object)CraftPresence.BIOMES).put((Comparable)((Object)"_dimension"), (Object)CraftPresence.DIMENSIONS).put((Comparable)((Object)"_item"), (Object)CraftPresence.TILE_ENTITIES).put((Comparable)((Object)"_entity"), (Object)CraftPresence.ENTITIES).put((Comparable)((Object)"_server"), (Object)CraftPresence.SERVER).put((Comparable)((Object)"_screen"), (Object)CraftPresence.GUIS).build();
    private static final Map<String, Pack> packModules = new TreeMapBuilder().put((Comparable)((Object)"atlauncher"), (Object)new ATLauncherUtils(() -> CraftPresence.CONFIG.generalSettings.detectATLauncherInstance)).put((Comparable)((Object)"curse"), (Object)new CurseUtils(() -> CraftPresence.CONFIG.generalSettings.detectCurseManifest)).put((Comparable)((Object)"multimc"), (Object)new MultiMCUtils(() -> CraftPresence.CONFIG.generalSettings.detectMultiMCManifest)).put((Comparable)((Object)"mcupdater"), (Object)new MCUpdaterUtils(() -> CraftPresence.CONFIG.generalSettings.detectMCUpdaterInstance)).put((Comparable)((Object)"technic"), (Object)new TechnicUtils(() -> CraftPresence.CONFIG.generalSettings.detectTechnicPack)).put((Comparable)((Object)"modrinth"), (Object)new ModrinthUtils(() -> CraftPresence.CONFIG.generalSettings.detectModrinthPack)).build();
    private static Map.Entry<String, Pack> loadedPack = null;
    private static ModuleData loadedMenu = null;
    private static MenuStatus status = MenuStatus.None;

    public static MenuStatus getMenuState() {
        return status;
    }

    public static void setMenuState(MenuStatus newState) {
        MenuStatus oldState = status;
        status = newState;
        if (oldState != newState) {
            CommandUtils.updateMenuPresence();
        }
    }

    public static void clearMenuState() {
        CommandUtils.setMenuState(MenuStatus.None);
    }

    public static void updateMenuPresence() {
        switch (status.ordinal()) {
            case 1: {
                CommandUtils.syncMenuData(CraftPresence.CONFIG.statusMessages.loadingData);
                break;
            }
            case 0: {
                CommandUtils.syncMenuData(CraftPresence.CONFIG.statusMessages.mainMenuData);
                break;
            }
            default: {
                CommandUtils.clearMenuPresence();
            }
        }
    }

    public static boolean isDebugMode() {
        return CommandUtils.isVerboseMode() || CraftPresence.CONFIG != null && CraftPresence.CONFIG.advancedSettings.debugMode;
    }

    public static boolean isVerboseMode() {
        return CraftPresence.CONFIG != null && CraftPresence.CONFIG.advancedSettings.verboseMode;
    }

    public static void syncModuleArguments() {
        for (String key : modules.keySet()) {
            String name = (key.startsWith("_") ? "" : "_") + key;
            CraftPresence.CLIENT.syncArgument(name + ".instance", () -> modules.get(key), true);
        }
    }

    public static void syncPackArguments() {
        if (loadedPack == null) {
            return;
        }
        Map.Entry<String, Pack> pack = loadedPack;
        Pack data = pack.getValue();
        if (!data.hasPackType()) {
            data.setPackType(pack.getKey());
        }
        if (data.hasPackName()) {
            CraftPresence.CLIENT.syncArgument("pack.type", data::getPackType, true);
            CraftPresence.CLIENT.syncArgument("pack.name", data::getPackName, true);
            CraftPresence.CLIENT.syncArgument("pack.icon", () -> CraftPresence.CLIENT.imageOf(true, data.getPackIcon(), data.getPackType()), true);
        }
    }

    public static void addModule(String moduleId, Module instance) {
        if (!CraftPresence.isDataLoaded) {
            modules.put(moduleId, instance);
        }
    }

    public static void addModule(String moduleId, Pack instance) {
        if (!CraftPresence.isDataLoaded) {
            packModules.put(moduleId, instance);
        }
    }

    public static void addModule(String moduleId, TranslationManager instance) {
        TranslationListener.INSTANCE.addModule(moduleId, instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadData(boolean forceUpdateRPC) {
        CraftPresence.SCHEDULER.onTick();
        CraftPresence.SCHEDULER.TICK_LOCK.lock();
        try {
            for (Module module : modules.values()) {
                if (!module.canBeLoaded()) continue;
                module.onTick();
                if (!forceUpdateRPC || !module.isInUse()) continue;
                module.updatePresence();
            }
            if (forceUpdateRPC) {
                CommandUtils.updateMenuPresence();
            }
            CommandUtils.postReload();
        }
        catch (Throwable ex) {
            String messagePrefix = Constants.TRANSLATOR.translate("gui.config.message.editor.message", new Object[0]);
            String verbosePrefix = Constants.TRANSLATOR.translate("craftpresence.logger.error.verbose", new Object[0]);
            Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.module", new Object[0]), new Object[0]);
            Constants.LOG.printStackTrace(ex, messagePrefix, verbosePrefix, new Appendable[0]);
            CraftPresence.CLIENT.shutDown();
        }
        finally {
            CraftPresence.SCHEDULER.TICK_LOCK.unlock();
            CraftPresence.SCHEDULER.postTick();
        }
    }

    public static void postReload() {
        boolean isMenuActive;
        boolean bl = isMenuActive = CommandUtils.getMenuState() != MenuStatus.None;
        if (!Constants.HAS_GAME_LOADED) {
            CommandUtils.setMenuState(MenuStatus.Loading);
        } else if (CraftPresence.player == null) {
            CommandUtils.setMenuState(MenuStatus.MainMenu);
        } else if (isMenuActive) {
            CommandUtils.clearMenuState();
        }
        CraftPresence.CLIENT.onTick();
    }

    public static void applyData(Config current, Config old) {
        boolean needsReboot = false;
        if (!current.generalSettings.clientId.equals(old.generalSettings.clientId)) {
            needsReboot = true;
        } else if (current.generalSettings.preferredClientLevel != old.generalSettings.preferredClientLevel) {
            needsReboot = true;
        } else if (current.generalSettings.resetTimeOnInit != old.generalSettings.resetTimeOnInit) {
            needsReboot = true;
        } else if (current.generalSettings.autoRegister != old.generalSettings.autoRegister) {
            needsReboot = true;
        } else if (!current.accessibilitySettings.languageId.equals(old.accessibilitySettings.languageId)) {
            Constants.TRANSLATOR.syncTranslations();
        } else if (current.advancedSettings.allowDuplicatePackets != old.advancedSettings.allowDuplicatePackets) {
            needsReboot = true;
        } else if (current.advancedSettings.maxConnectionAttempts != old.advancedSettings.maxConnectionAttempts) {
            needsReboot = true;
        }
        if (current.advancedSettings.debugMode != old.advancedSettings.debugMode || current.advancedSettings.verboseMode != old.advancedSettings.verboseMode || current.advancedSettings.refreshRate != old.advancedSettings.refreshRate) {
            CommandUtils.updateModes();
        }
        if (current.advancedSettings.enableClassGraph != old.advancedSettings.enableClassGraph) {
            CommandUtils.setupClassScan(true);
        }
        if (current.displaySettings.dynamicVariables != old.displaySettings.dynamicVariables) {
            CommandUtils.syncDynamicVariables(old.displaySettings.dynamicVariables);
        }
        if (current.accessibilitySettings.stripTranslationColors != old.accessibilitySettings.stripTranslationColors) {
            Constants.TRANSLATOR.setStripColors(current.accessibilitySettings.stripTranslationColors);
        }
        if (current.accessibilitySettings.stripTranslationFormatting != old.accessibilitySettings.stripTranslationFormatting) {
            Constants.TRANSLATOR.setStripFormatting(current.accessibilitySettings.stripTranslationFormatting);
        }
        if (needsReboot) {
            CommandUtils.setupRPC();
        }
    }

    public static void setupRPC() {
        CraftPresence.CLIENT.shutDown();
        CraftPresence.CLIENT.SCHEDULER = CraftPresence.SCHEDULER;
        CraftPresence.CLIENT.canShowPreviews = () -> CraftPresence.CONFIG.advancedSettings.allowPlaceholderPreviews;
        CraftPresence.CLIENT.canFormatWords = () -> CraftPresence.CONFIG.advancedSettings.formatWords;
        CraftPresence.CLIENT.defaultPresence = () -> CraftPresence.CONFIG.displaySettings.presenceData;
        CraftPresence.CLIENT.defaultIconSupplier = () -> CraftPresence.CONFIG.generalSettings.defaultIcon;
        CraftPresence.CLIENT.CLIENT_ID = CraftPresence.CONFIG.generalSettings.clientId;
        CraftPresence.CLIENT.AUTO_REGISTER = CraftPresence.CONFIG.generalSettings.autoRegister;
        CraftPresence.CLIENT.PREFERRED_CLIENT = DiscordBuild.from(CraftPresence.CONFIG.generalSettings.preferredClientLevel);
        CraftPresence.CLIENT.UPDATE_TIMESTAMP = CraftPresence.CONFIG.generalSettings.resetTimeOnInit;
        CraftPresence.CLIENT.ALLOW_DUPLICATE_PACKETS = CraftPresence.CONFIG.advancedSettings.allowDuplicatePackets;
        CraftPresence.CLIENT.MAX_CONNECTION_ATTEMPTS = CraftPresence.CONFIG.advancedSettings.maxConnectionAttempts;
        CraftPresence.CLIENT.init(CommandUtils.isDebugMode(), CommandUtils.isVerboseMode(), new ModIPCListener(), CraftPresence.CONFIG.displaySettings.dynamicIcons);
    }

    public static void syncPlaceholders() {
        ModFunctionsLib.init(CraftPresence.CLIENT);
        CraftPresence.CLIENT.syncArgument("general.title", () -> Constants.TRANSLATOR.translate("craftpresence.defaults.state.mc.version", new Object[]{ModUtils.MCVersion}), true);
        CraftPresence.CLIENT.syncArgument("general.version", () -> ModUtils.MCVersion, true);
        CraftPresence.CLIENT.syncArgument("general.protocol", () -> ModUtils.MCProtocolID, true);
        CraftPresence.CLIENT.syncArgument("general.brand", () -> ModUtils.BRAND, true);
        CraftPresence.CLIENT.syncArgument("_general.instance", () -> CraftPresence.instance, true);
        CraftPresence.CLIENT.syncArgument("_general.player", () -> CraftPresence.player, true);
        CraftPresence.CLIENT.syncArgument("_general.world", () -> CraftPresence.world, true);
        CraftPresence.CLIENT.syncArgument("_config.instance", () -> CraftPresence.CONFIG, true);
        CommandUtils.syncDynamicVariables();
        CraftPresence.CLIENT.syncArgument("player.name", () -> CraftPresence.username, true);
        CraftPresence.CLIENT.syncArgument("player.uuid.short", () -> {
            String uniqueId = CraftPresence.uuid;
            return StringUtils.isValidUuid((String)uniqueId) ? StringUtils.getFromUuid((String)uniqueId, (boolean)true) : null;
        }, true);
        CraftPresence.CLIENT.syncArgument("player.uuid.full", () -> {
            String uniqueId = CraftPresence.uuid;
            return StringUtils.isValidUuid((String)uniqueId) ? StringUtils.getFromUuid((String)uniqueId, (boolean)false) : null;
        }, true);
        CraftPresence.CLIENT.syncArgument("player.icon", () -> {
            if (CraftPresence.CLIENT.addEndpointIcon(CraftPresence.CONFIG, CraftPresence.CONFIG.advancedSettings.playerSkinEndpoint, CraftPresence.username, CraftPresence.uuid, true)) {
                return CraftPresence.username;
            }
            return null;
        }, true);
        CraftPresence.CLIENT.syncArgument("general.icon", () -> CraftPresence.CONFIG.generalSettings.defaultIcon);
        CommandUtils.syncModuleArguments();
        CommandUtils.syncPackArguments();
    }

    public static Config preInit(Config config) {
        CommandUtils.setupClassScan(config, false);
        if (config.isNewFile()) {
            config.advancedSettings.guiSettings.appendReplayData();
        }
        return config;
    }

    public static void init() {
        CommandUtils.updateModes();
        CommandUtils.addModule("craftpresence", new TranslationManager(CraftPresence.instance, Constants.TRANSLATOR.setStripColors(CraftPresence.CONFIG.accessibilitySettings.stripTranslationColors).setStripFormatting(CraftPresence.CONFIG.accessibilitySettings.stripTranslationFormatting).setLanguageSupplier(defaultLanguage -> StringUtils.getOrDefault((String)ModUtils.getLanguage((String)CraftPresence.CONFIG.accessibilitySettings.languageId), (String)defaultLanguage))));
        for (Map.Entry<String, Pack> pack : packModules.entrySet()) {
            String type = pack.getKey();
            Pack data = pack.getValue();
            if (!data.isEnabled()) continue;
            Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.pack.init", new Object[]{type}), new Object[0]);
            if (data.load()) {
                Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.pack.loaded", new Object[]{type, data.getPackName(), data.getPackIcon()}), new Object[0]);
                loadedPack = pack;
                break;
            }
            Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.pack", new Object[]{type}), new Object[0]);
        }
        CommandUtils.registerKeybinds();
        if (Constants.hasReplayMod()) {
            CommandUtils.addModule("integration.replaymod", new ReplayModUtils());
        }
    }

    public static void registerKeybinds() {
        KeyUtils.INSTANCE.registerKey("configKeyCode", "key.craftpresence.config_keycode.name", x$0 -> Constants.TRANSLATOR.translate(x$0, new Object[0]), ResourceUtils.getResource((String)"craftpresence", (String)"controls"), x$0 -> Constants.TRANSLATOR.translate(x$0, new Object[0]), CraftPresence.CONFIG.accessibilitySettings.getDefaults().configKeyCode, CraftPresence.CONFIG.accessibilitySettings.configKeyCode, () -> Constants.TRANSLATOR.translate("key.craftpresence.config_keycode.description", new Object[0]), () -> CraftPresence.CONFIG != null, () -> !CraftPresence.CONFIG.hasChanged(), () -> {
            if (!GameUtils.isFocused((class_310)CraftPresence.instance) && !(GameUtils.getCurrentScreen((class_310)CraftPresence.instance) instanceof ExtendedScreen)) {
                RenderUtils.openScreen((class_310)CraftPresence.instance, (ExtendedScreen)new MainGui(), (class_437)GameUtils.getCurrentScreen((class_310)CraftPresence.instance));
            }
        }, (keyCode, shouldSave) -> {
            CraftPresence.CONFIG.accessibilitySettings.configKeyCode = keyCode;
            if (shouldSave.booleanValue()) {
                CraftPresence.CONFIG.save();
            }
        }, vanillaBind -> vanillaBind != CraftPresence.CONFIG.accessibilitySettings.configKeyCode, (ex, keyInfo) -> {
            Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.keycode", new Object[]{((KeyUtils.KeyBindData)keyInfo.getSecond()).description()}), new Object[0]);
            return false;
        });
    }

    public static void onTick() {
        if (!Constants.HAS_GAME_LOADED) {
            Constants.HAS_GAME_LOADED = GameUtils.isLoaded((class_310)CraftPresence.instance);
        }
        CraftPresence.CLIENT.updatePresence();
    }

    public static void updateModes() {
        Constants.LOG.setDebugMode(CommandUtils.isVerboseMode());
        if (CraftPresence.CLIENT.isAvailable()) {
            CraftPresence.CLIENT.ipcInstance.setDebugMode(CommandUtils.isDebugMode());
            CraftPresence.CLIENT.ipcInstance.setVerboseLogging(CommandUtils.isVerboseMode());
        }
        if (CraftPresence.CONFIG != null) {
            CraftPresence.SCHEDULER.setRefreshRate(CraftPresence.CONFIG.advancedSettings.refreshRate);
        }
    }

    public static void syncDynamicVariables(Map<String, String> oldData) {
        CraftPresence.CLIENT.syncDynamicVariables(oldData, CraftPresence.CONFIG.displaySettings.dynamicVariables, entry -> () -> CraftPresence.CONFIG.displaySettings.dynamicVariables.get(entry));
    }

    public static void syncDynamicVariables() {
        CommandUtils.syncDynamicVariables(null);
    }

    public static void setupClassScan(Config config, boolean postLaunch) {
        boolean newState;
        boolean oldState = FileUtils.isClassGraphEnabled();
        boolean hasStateChanged = oldState != (newState = config.advancedSettings.enableClassGraph);
        FileUtils.setClassGraphEnabled((boolean)newState);
        if (!postLaunch || hasStateChanged) {
            if (newState) {
                FileUtils.detectClasses();
                if (postLaunch) {
                    for (Module module : modules.values()) {
                        module.queueInternalScan();
                    }
                }
            } else if (FileUtils.hasScannedClasses()) {
                FileUtils.clearClassMap((boolean)true);
            }
        }
    }

    public static void setupClassScan(boolean postLaunch) {
        CommandUtils.setupClassScan(CraftPresence.CONFIG, postLaunch);
    }

    public static void syncMenuData(ModuleData currentData) {
        if (loadedMenu == null) {
            CraftPresence.CLIENT.syncArgument("menu.message", () -> Config.isValidProperty(loadedMenu, "textOverride") ? loadedMenu.getTextOverride() : "");
            CraftPresence.CLIENT.syncArgument("menu.icon", () -> {
                String currentIcon = Config.isValidProperty(loadedMenu, "iconOverride") ? loadedMenu.getIconOverride() : CraftPresence.CONFIG.generalSettings.defaultIcon;
                return CraftPresence.CLIENT.imageOf(true, currentIcon);
            });
            CraftPresence.CLIENT.addForcedData("menu", () -> (PresenceData)Config.getProperty(loadedMenu, "data"));
        }
        loadedMenu = currentData;
        CraftPresence.CLIENT.clearPartyData();
    }

    public static void clearMenuPresence() {
        if (loadedMenu != null) {
            CraftPresence.CLIENT.clearForcedData("menu");
            CraftPresence.CLIENT.removeArguments("menu");
            loadedMenu = null;
        }
    }

    public static enum MenuStatus {
        MainMenu,
        Loading,
        None;

    }
}

